/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.input.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.NameUtility;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowCommentDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.AttendanceCalcBeanInterface;
import jp.mosp.time.bean.AttendanceCardAddonBeanInterface;
import jp.mosp.time.bean.AttendanceListRegistBeanInterface;
import jp.mosp.time.bean.AttendanceRegistBeanInterface;
import jp.mosp.time.bean.AttendanceTransactionRegistBeanInterface;
import jp.mosp.time.bean.DifferenceRequestReferenceBeanInterface;
import jp.mosp.time.bean.GoOutReferenceBeanInterface;
import jp.mosp.time.bean.GoOutRegistBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.RestRegistBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.WorkTypeChangeRequestReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dto.settings.AllowanceDtoInterface;
import jp.mosp.time.dto.settings.AttendanceCorrectionDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.GoOutDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.RestDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.entity.RequestEntityInterface;
import jp.mosp.time.entity.WorkTypeEntityInterface;
import jp.mosp.time.input.action.DifferenceRequestAction;
import jp.mosp.time.input.action.HolidayRequestAction;
import jp.mosp.time.input.action.OvertimeRequestAction;
import jp.mosp.time.input.action.SubHolidayRequestAction;
import jp.mosp.time.input.action.WorkOnHolidayRequestAction;
import jp.mosp.time.input.action.WorkTypeChangeRequestAction;
import jp.mosp.time.input.vo.AttendanceCardVo;
import jp.mosp.time.utils.HolidayUtility;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeUtility;

public class AttendanceCardAction
extends TimeAction {
    public static final String CMD_SHOW = "TM1200";
    public static final String CMD_SELECT_SHOW = "TM1201";
    public static final String CMD_SEARCH = "TM1202";
    public static final String CMD_RE_SEARCH = "TM1203";
    public static final String CMD_DRAFT = "TM1204";
    public static final String CMD_APPLI = "TM1205";
    public static final String CMD_SELECT_SHOW_FROM_PORTAL = "TM1206";
    public static final String CMD_DELETE = "TM1207";
    public static final String CMD_TRANSFER = "TM1208";
    public static final String CMD_CALC = "TM1226";
    public static final String MENU_ATTENDANCE_CARD = "AttendanceCard";
    public static final String PRM_ATTENDANCE_EXTRA_JSP = "prmAttendanceExtraJsp";
    public static final String MODE_APPLICATION_COMPLETED_HOLIDAY = "completedHoliday";
    protected static final String CODE_KEY_ADDONS = "AttedanceCardAddons";

    public AttendanceCardAction() {
        this.topicPathCommand = CMD_RE_SEARCH;
    }

    protected BaseVo getSpecificVo() {
        return new AttendanceCardVo();
    }

    protected BaseVo prepareVo(boolean useStoredVo, boolean useParametersMapper) throws MospException {
        BaseVo vo = super.prepareVo(useStoredVo, useParametersMapper);
        if (!useParametersMapper) {
            return vo;
        }
        for (AttendanceCardAddonBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.mapping();
        }
        return vo;
    }

    public void action() throws MospException {
        this.setAttendanceExtraJsp();
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW)) {
            this.prepareVo(false, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_SELECT_SHOW_FROM_PORTAL)) {
            this.prepareVo(false, false);
            this.selectFromPortal();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_DRAFT)) {
            this.prepareVo();
            this.draft();
        } else if (this.mospParams.getCommand().equals(CMD_APPLI)) {
            this.prepareVo();
            this.appli(true);
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else if (this.mospParams.getCommand().equals(CMD_CALC)) {
            this.prepareVo();
            this.appli(false);
        }
    }

    protected void setAttendanceExtraJsp() {
    }

    protected void show() throws MospException {
        String personalId = this.mospParams.getUser().getPersonalId();
        Date targetDate = this.getSystemDate();
        this.setAttendaneCardInfo(personalId, targetDate);
        this.setPulldown();
    }

    protected void select() throws MospException {
        String personalId = this.getTargetPersonalId();
        Date targetDate = this.getTargetDate();
        if (personalId == null || personalId.isEmpty()) {
            personalId = this.mospParams.getUser().getPersonalId();
        }
        if (targetDate == null) {
            targetDate = this.getDate(this.getTransferredActivateDate());
        }
        this.setPulldown();
        this.setAttendaneCardInfo(personalId, targetDate);
    }

    protected void selectFromPortal() throws MospException {
        this.checkRangeMap(MENU_ATTENDANCE_CARD);
        List errorMessageList = this.mospParams.getErrorMessageList();
        ArrayList back = new ArrayList();
        back.addAll(errorMessageList);
        errorMessageList.clear();
        this.select();
        errorMessageList = this.mospParams.getErrorMessageList();
        errorMessageList.addAll(0, back);
    }

    protected void search() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        Date targetDate = vo.getTargetDate();
        if (this.getTransferredGenericCode() != null) {
            if (this.getTransferredGenericCode().equals("Decrement")) {
                targetDate = DateUtility.addDay((Date)targetDate, (int)-1);
            } else if (this.getTransferredGenericCode().equals("Increment")) {
                targetDate = DateUtility.addDay((Date)targetDate, (int)1);
            } else if (this.getTransferredGenericCode().equals("Reset")) {
                targetDate = DateUtility.getSystemDate();
            } else if (this.getTransferredGenericCode().equals("Calendar")) {
                targetDate = this.getDate(this.getTransferredDay());
            }
        }
        this.setAttendaneCardInfo(personalId, targetDate);
    }

    protected void draft() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        AttendanceCalcBeanInterface calc = this.time().attendanceCalc(vo.getTargetDate());
        AttendanceRegistBeanInterface regist = this.time().attendanceRegist();
        String personalId = vo.getPersonalId();
        Date date = vo.getTargetDate();
        AttendanceDtoInterface dto = this.timeReference().attendance().findForKey(personalId, date);
        if (dto == null) {
            dto = this.time().attendanceRegist().getInitDto();
        }
        this.setAttendanceDtoFields(dto);
        for (AttendanceCardAddonBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.draft();
        }
        calc.calcStartEndTime(dto, true);
        RequestEntityInterface requestEntity = this.timeReference().requestUtil().getRequestEntity(personalId, date);
        ArrayList restList = new ArrayList();
        this.setRestFields(restList, dto);
        ArrayList goOutPublicList = new ArrayList();
        ArrayList goOutPrivateList = new ArrayList();
        this.setGoOutDtoFields(goOutPublicList, goOutPrivateList, dto);
        this.chkPrivateGoOut(dto, requestEntity);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.chkDuplRest(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.setGeneralDtoFields();
        calc.attendanceCalc(dto, restList, goOutPublicList, goOutPrivateList);
        regist.checkValidate(dto);
        regist.checkDraft(dto);
        this.draft(dto, restList, goOutPublicList, goOutPrivateList);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        this.addDraftMessage();
        this.setAttendaneCardInfo(vo.getPersonalId(), vo.getTargetDate());
        vo.setModeCardEdit("draft");
    }

    protected void draft(AttendanceDtoInterface dto, List<RestDtoInterface> restList, List<GoOutDtoInterface> goOutPublicList, List<GoOutDtoInterface> goOutPrivateList) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        GoOutRegistBeanInterface goOutRegist = this.time().goOutRegist();
        AttendanceRegistBeanInterface regist = this.time().attendanceRegist();
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        if (workflowDto == null) {
            workflowDto = workflowRegist.getInitDto();
            workflowDto.setFunctionCode("1");
        }
        workflowRegist.setDtoApproverIds(workflowDto, this.getSelectApproverIds());
        workflowDto = workflowRegist.draft(workflowDto, dto.getPersonalId(), dto.getWorkDate(), 1);
        if (workflowDto != null) {
            this.platform().workflowCommentRegist().addComment(workflowDto, this.mospParams.getUser().getPersonalId(), PfMessageUtility.getDraftSucceed((MospParams)this.mospParams));
            dto.setWorkflow(workflowDto.getWorkflow());
            for (int i = 0; i < restList.size(); ++i) {
                this.time().restRegist().regist(restList.get(i));
            }
            goOutRegist.delete(vo.getPersonalId(), vo.getTargetDate(), 1);
            for (GoOutDtoInterface goOutDto : goOutPublicList) {
                goOutRegist.regist(goOutDto);
            }
            for (GoOutDtoInterface goOutDto : goOutPrivateList) {
                goOutRegist.regist(goOutDto);
            }
            regist.regist(dto);
        }
    }

    protected void appli(boolean checkCommand) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        AttendanceRegistBeanInterface regist = this.time().attendanceRegist();
        AttendanceListRegistBeanInterface listRegist = this.time().attendanceListRegist(vo.getTargetDate());
        WorkflowIntegrateBeanInterface workflowIntegrate = this.reference().workflowIntegrate();
        String personalId = vo.getPersonalId();
        Date date = vo.getTargetDate();
        AttendanceDtoInterface dto = this.timeReference().attendance().findForKey(personalId, date);
        if (dto == null) {
            dto = regist.getInitDto();
        }
        this.appli(dto, checkCommand);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (checkCommand) {
            this.commit();
            this.addAppliMessage();
            listRegist.checkOvertime(dto);
            this.setAttendaneCardInfo(vo.getPersonalId(), vo.getTargetDate());
            WorkflowDtoInterface workflowDto = workflowIntegrate.getLatestWorkflowInfo(dto.getWorkflow());
            if ("1".equals(workflowDto.getWorkflowStatus())) {
                vo.setModeCardEdit("apply");
                return;
            }
            vo.setModeCardEdit("applied");
        }
    }

    protected void appli(AttendanceDtoInterface dto, boolean checkCommand) throws MospException {
        ArrayList oldGoOutPrivateList;
        ArrayList oldGoOutPublicList;
        ArrayList oldRestList;
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        AttendanceCalcBeanInterface calc = this.time().attendanceCalc(vo.getTargetDate());
        AttendanceRegistBeanInterface regist = this.time().attendanceRegist();
        AttendanceListRegistBeanInterface listRegist = this.time().attendanceListRegist(vo.getTargetDate());
        GoOutRegistBeanInterface goOutRegist = this.time().goOutRegist();
        WorkflowRegistBeanInterface workflowRegist = this.platform().workflowRegist();
        GoOutReferenceBeanInterface goOut = this.timeReference().goOut();
        AttendanceTransactionRegistBeanInterface attendanceTransactionRegist = this.time().attendanceTransactionRegist();
        String personalId = vo.getPersonalId();
        Date date = vo.getTargetDate();
        AttendanceDtoInterface oldDto = this.timeReference().attendance().findForKey(personalId, date);
        if (oldDto == null) {
            oldDto = regist.getInitDto();
        }
        if ((oldRestList = this.timeReference().rest().getRestList(personalId, date)) == null) {
            oldRestList = new ArrayList();
        }
        if ((oldGoOutPublicList = goOut.getPublicGoOutList(personalId, date)) == null) {
            oldGoOutPublicList = new ArrayList();
        }
        if ((oldGoOutPrivateList = goOut.getPrivateGoOutList(personalId, date)) == null) {
            oldGoOutPrivateList = new ArrayList();
        }
        this.setAttendanceDtoFields(dto);
        for (AttendanceCardAddonBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.appli();
        }
        calc.calcStartEndTime(dto, true);
        RequestEntityInterface requestEntity = this.timeReference().requestUtil().getRequestEntity(personalId, date);
        ArrayList restList = new ArrayList();
        this.setRestFields(restList, dto);
        ArrayList goOutPublicList = new ArrayList();
        ArrayList goOutPrivateList = new ArrayList();
        this.setGoOutDtoFields(goOutPublicList, goOutPrivateList, dto);
        this.chkPrivateGoOut(dto, requestEntity);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.chkDuplRest(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.setGeneralDtoFields();
        calc.attendanceCalc(dto, restList, goOutPublicList, goOutPrivateList);
        regist.checkTimeExist(dto);
        regist.checkValidate(dto);
        regist.checkAppli(dto);
        regist.checkPrivateGoOut(dto, restList, goOutPrivateList);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        regist.checkHolidayTime(personalId, date, restList, goOutPublicList, goOutPrivateList);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        if (!checkCommand) {
            this.addCalcMessage();
            this.addUnregisteredNoticeMessage();
            this.setAttendance(dto, true);
            this.setRest(restList);
            this.setGoOut(goOutPublicList, goOutPrivateList);
            this.rollback();
            return;
        }
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        if (workflowDto == null) {
            workflowDto = workflowRegist.getInitDto();
            workflowDto.setFunctionCode("1");
            oldDto = regist.getInitDto();
            oldRestList = new ArrayList();
            oldGoOutPublicList = new ArrayList();
            oldGoOutPrivateList = new ArrayList();
        } else if (this.reference().workflowIntegrate().isDraft(workflowDto)) {
            oldDto = regist.getInitDto();
            oldRestList = new ArrayList();
            oldGoOutPublicList = new ArrayList();
            oldGoOutPrivateList = new ArrayList();
        }
        workflowRegist.setDtoApproverIds(workflowDto, this.getSelectApproverIds());
        workflowDto = workflowRegist.appli(workflowDto, dto.getPersonalId(), dto.getWorkDate(), 1, null);
        if (workflowDto != null) {
            for (RestDtoInterface restDto : restList) {
                this.time().restRegist().regist(restDto);
            }
            goOutRegist.delete(vo.getPersonalId(), vo.getTargetDate(), 1);
            for (GoOutDtoInterface goOutDto : goOutPublicList) {
                goOutRegist.regist(goOutDto);
            }
            for (GoOutDtoInterface goOutDto : goOutPrivateList) {
                goOutRegist.regist(goOutDto);
            }
            listRegist.registCorrection(dto, oldDto, oldRestList, oldGoOutPublicList, oldGoOutPrivateList);
            regist.checkApprover(dto, workflowDto);
            dto.setWorkflow(workflowDto.getWorkflow());
            regist.checkTimeExist(dto);
            regist.regist(dto);
            listRegist.registSubHoliday(dto);
            attendanceTransactionRegist.regist(dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.time().afterApplyAttendancesExecute().execute(dto);
    }

    protected void delete() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        AttendanceRegistBeanInterface regist = this.time().attendanceRegist();
        WorkflowIntegrateBeanInterface workflowIntegrate = this.reference().workflowIntegrate();
        String personalId = vo.getPersonalId();
        Date date = vo.getTargetDate();
        AttendanceDtoInterface dto = this.timeReference().attendance().findForKey(personalId, date);
        this.checkSelectedDataExist((Object)dto);
        regist.checkDelete(dto);
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        this.checkSelectedDataExist((Object)workflowDto);
        if (!("1".equals(workflowDto.getWorkflowStatus()) || workflowIntegrate.isDraft(workflowDto) || workflowIntegrate.isFirstReverted(workflowDto))) {
            PfMessageUtility.addMessageDeleteHistoryFailed((MospParams)this.mospParams);
            return;
        }
        regist.delete(personalId, date);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteHistoryFailed((MospParams)this.mospParams);
            return;
        }
        this.setGeneralDtoFields();
        for (AttendanceCardAddonBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.delete();
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageDeleteHistoryFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        PfMessageUtility.addMessageDeleteSucceed((MospParams)this.mospParams);
        this.search();
    }

    protected void transfer() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        WorkflowIntegrateBeanInterface workflowIntegrate = this.reference().workflowIntegrate();
        String actionName = this.getTransferredAction();
        this.setTargetPersonalId(vo.getPersonalId());
        this.setTargetDate(vo.getTargetDate());
        if (actionName.equals(OvertimeRequestAction.class.getName())) {
            if (this.getTransferredActivateDate() == null || this.getTransferredType() == null) {
                this.mospParams.setNextCommand("TM1401");
            } else {
                this.mospParams.setNextCommand("TM1492");
            }
        } else if (actionName.equals(HolidayRequestAction.class.getName())) {
            if (this.getTransferredActivateDate() == null || this.getTransferredHolidayType1() == null || this.getTransferredHolidayType2() == null || this.getTransferredHolidayRange() == null || this.getTransferredStartTime() == null) {
                this.mospParams.setNextCommand("TM1501");
            } else {
                this.mospParams.setNextCommand("TM1592");
            }
        } else if (actionName.equals(WorkOnHolidayRequestAction.class.getName())) {
            if (this.getTransferredActivateDate() == null) {
                this.mospParams.setNextCommand("TM1601");
            } else {
                this.mospParams.setNextCommand("TM1692");
            }
        } else if (actionName.equals(SubHolidayRequestAction.class.getName())) {
            if (this.getTransferredActivateDate() == null || this.getTransferredType() == null) {
                this.mospParams.setNextCommand("TM1701");
            } else {
                this.mospParams.setNextCommand("TM1792");
            }
        } else if (actionName.equals(WorkTypeChangeRequestAction.class.getName())) {
            WorkTypeChangeRequestDtoInterface workTypeChangeRequestDto = this.timeReference().workTypeChangeRequest().findForKeyOnWorkflow(vo.getPersonalId(), vo.getTargetDate());
            if (workTypeChangeRequestDto == null) {
                this.mospParams.setNextCommand("TM011101");
                return;
            }
            long workflow = workTypeChangeRequestDto.getWorkflow();
            if (workflowIntegrate.isDraft(workflow) || workflowIntegrate.isFirstReverted(workflow)) {
                this.mospParams.setNextCommand("TM011111");
                return;
            }
            this.mospParams.setNextCommand("TM011101");
        } else if (actionName.equals(DifferenceRequestAction.class.getName())) {
            if (this.getTransferredActivateDate() == null) {
                this.mospParams.setNextCommand("TM1001");
            } else {
                this.mospParams.setNextCommand("TM1092");
            }
        }
    }

    protected void setAttendaneCardInfo(String personalId, Date targetDate) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        this.setEmployeeInfo(personalId, targetDate);
        this.setDefaultValues();
        RequestUtilBeanInterface requestUtil = this.timeReference().requestUtil();
        requestUtil.setRequests(personalId, targetDate);
        this.setApplicationStatus(requestUtil);
        if (this.reference().retirement().isRetired(personalId, targetDate)) {
            this.addEmployeeRetiredMessage();
        }
        if (this.reference().suspension().isSuspended(personalId, targetDate)) {
            this.addEmployeeSuspendedMessage();
        }
        if (this.mospParams.hasErrorMessage()) {
            vo.setModeCardEdit(MODE_APPLICATION_COMPLETED_HOLIDAY);
            return;
        }
        RequestEntityInterface requestEntity = requestUtil.getRequestEntity(personalId, targetDate);
        ApplicationEntity applicationEntity = this.timeReference().application().getApplicationEntity(personalId, targetDate);
        this.setAttendance(requestUtil.getAttendance(), false);
        this.setRecordTime();
        this.setTransferredValues();
        this.setTargetTime(targetDate);
        this.setWorkType(requestUtil);
        this.setScheduledTime(applicationEntity, requestEntity);
        this.setUnpaidShortTime(requestEntity, requestUtil);
        this.attendanceCorrectInfo();
        this.setRest(requestUtil);
        this.setGoOut();
        this.tardinessLeaveearlyInfo();
        this.premiumInfo();
        this.allowanceInfo();
        this.attendanceInfoApprovalStatus();
        this.setApproverPullDown(personalId, targetDate, 1);
        for (AttendanceCardAddonBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.setVoFields();
        }
        if (this.mospParams.hasErrorMessage()) {
            vo.setModeCardEdit(MODE_APPLICATION_COMPLETED_HOLIDAY);
        }
    }

    protected boolean isAmPmHalfSubstitute(RequestUtilBeanInterface requestUtil) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        RequestEntityInterface entity = requestUtil.getRequestEntity(vo.getPersonalId(), vo.getTargetDate());
        if (!entity.isAmPmHalfSubstitute(true)) {
            return false;
        }
        return !entity.isHalfPostpone(true);
    }

    protected void setWorkType(RequestUtilBeanInterface requestUtil) throws MospException {
        boolean isWorkOnPrescribedDaysOff;
        boolean isWorkOnLegalDaysOff;
        boolean isPrescribedDaysOff;
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        ScheduleUtilBeanInterface scheduleUtil = this.timeReference().scheduleUtil();
        AttendanceDtoInterface attendanceDto = requestUtil.getApplicatedAttendance();
        DifferenceRequestDtoInterface differenceRequestDto = requestUtil.getDifferenceDto(true);
        if (attendanceDto != null) {
            this.setWorkTypeForApplicatedAttendance(attendanceDto, requestUtil, differenceRequestDto != null);
            return;
        }
        String workTypeCode = scheduleUtil.getScheduledWorkTypeCode(vo.getPersonalId(), vo.getTargetDate(), requestUtil);
        boolean isLegalDaysOff = TimeUtility.isLegalHoliday((String)workTypeCode);
        if (this.setWorkTypePulldownHoliday(requestUtil, isLegalDaysOff, isPrescribedDaysOff = TimeUtility.isPrescribedHoliday((String)workTypeCode), isWorkOnLegalDaysOff = TimeUtility.isWorkOnLegalHoliday((String)workTypeCode), isWorkOnPrescribedDaysOff = TimeUtility.isWorkOnPrescribedHoliday((String)workTypeCode))) {
            return;
        }
        SubHolidayRequestDtoInterface subHolidayRequestDto = requestUtil.getCompletedSubHolidayRangeAll();
        if (subHolidayRequestDto != null) {
            this.setWorkTypeForSubHolidayRequest(subHolidayRequestDto);
            return;
        }
        if (differenceRequestDto != null) {
            this.setWorkTypeForDifferenceRequest(differenceRequestDto, requestUtil);
            return;
        }
        WorkTypeChangeRequestDtoInterface workTypeChangeRequestDto = requestUtil.getWorkTypeChangeDto(true);
        if (workTypeChangeRequestDto != null) {
            this.setWorkTypeForWorkTypeChangeRequest(workTypeChangeRequestDto, requestUtil);
            return;
        }
        if (this.setWorkTypePulldownSubstitute(requestUtil, isLegalDaysOff, isPrescribedDaysOff, isWorkOnLegalDaysOff, isWorkOnPrescribedDaysOff)) {
            return;
        }
        if (this.setWorkTypeForWorkOnHolidayRequest(requestUtil)) {
            return;
        }
        this.setWorkTypeForSchedule(requestUtil);
    }

    protected boolean setWorkTypePulldownSubstitute(RequestUtilBeanInterface requestUtil, boolean isLegalDaysOff, boolean isPrescribedDaysOff, boolean isWorkOnLegalDaysOff, boolean isWorkOnPrescribedDaysOff) throws MospException {
        SubstituteDtoInterface subsutituteDto = requestUtil.getCompletedSubstituteRangeAll();
        if (subsutituteDto != null) {
            this.setWorkTypeForSubstitute(subsutituteDto, requestUtil);
            return true;
        }
        if (!(isLegalDaysOff || isPrescribedDaysOff || isWorkOnLegalDaysOff || isWorkOnPrescribedDaysOff || !this.isAmPmHalfSubstitute(requestUtil))) {
            this.setWorkTypeForHolidayAllDay();
            return true;
        }
        return false;
    }

    protected boolean setWorkTypePulldownHoliday(RequestUtilBeanInterface requestUtil, boolean isLegalDaysOff, boolean isPrescribedDaysOff, boolean isWorkOnLegalDaysOff, boolean isWorkOnPrescribedDaysOff) throws MospException {
        if (!(isLegalDaysOff || isPrescribedDaysOff || isWorkOnLegalDaysOff || isWorkOnPrescribedDaysOff)) {
            HolidayRequestDtoInterface holidayRequestDto = requestUtil.getCompletedHolidayRangeAll();
            if (holidayRequestDto != null) {
                this.setWorkTypeForHolidayRequest(holidayRequestDto);
                return true;
            }
            if (requestUtil.checkHolidayRangeHoliday(requestUtil.getHolidayList(true)) == 5) {
                this.setWorkTypeForHolidayAllDay();
                return true;
            }
        }
        return false;
    }

    protected void setTargetTime(Date targetDate) {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        Date targetTime = this.getTargetTime();
        if (targetTime == null) {
            return;
        }
        vo.setTxtEndTimeHour(DateUtility.getStringHour((Date)targetTime, (Date)targetDate));
        vo.setTxtEndTimeMinute(DateUtility.getStringMinute((Date)targetTime));
    }

    protected void setScheduledTime(ApplicationEntity applicationEntity, RequestEntityInterface requestEntity) throws MospException {
        if (requestEntity.hasAttendance()) {
            return;
        }
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        Date targetDate = vo.getTargetDate();
        String workTypeCode = vo.getPltWorkType();
        WorkTypeEntityInterface workTypeEntity = this.timeReference().workType().getWorkTypeEntity(workTypeCode, targetDate);
        if (applicationEntity.useScheduledTime()) {
            Date startWorkTime = workTypeEntity.getStartTime(requestEntity);
            Date endWorkTime = workTypeEntity.getEndTime(requestEntity);
            vo.setTxtStartTimeHour(DateUtility.getStringHour((Date)startWorkTime, (Date)targetDate));
            vo.setTxtStartTimeMinute(DateUtility.getStringMinute((Date)startWorkTime));
            vo.setTxtEndTimeHour(DateUtility.getStringHour((Date)endWorkTime, (Date)targetDate));
            vo.setTxtEndTimeMinute(DateUtility.getStringMinute((Date)endWorkTime));
        }
        if (workTypeEntity.isDirectStart()) {
            vo.setCkbDirectStart("1");
        }
        if (workTypeEntity.isDirectEnd()) {
            vo.setCkbDirectEnd("1");
        }
    }

    protected void setUnpaidShortTime(RequestEntityInterface requestEntity, RequestUtilBeanInterface requestUtil) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        WorkTypeReferenceBeanInterface workTypeReference = this.timeReference().workType();
        ScheduleUtilBeanInterface scheduleUtil = this.timeReference().scheduleUtil();
        if (!requestEntity.isAllHoliday(false)) {
            return;
        }
        String workTypeCode = scheduleUtil.getScheduledWorkTypeCode(vo.getPersonalId(), vo.getTargetDate(), requestUtil);
        if (workTypeCode == null || workTypeCode.isEmpty()) {
            return;
        }
        WorkTypeEntityInterface workTypeEntity = workTypeReference.getWorkTypeEntity(workTypeCode, vo.getTargetDate());
        if (workTypeEntity == null) {
            return;
        }
        int shortTime = 0;
        if (workTypeEntity.isShort1TimeSet() && !workTypeEntity.isShort1TypePay()) {
            shortTime += TimeUtility.getMinutes((Date)workTypeEntity.getShort1EndTime()) - TimeUtility.getMinutes((Date)workTypeEntity.getShort1StartTime());
        }
        if (workTypeEntity.isShort2TimeSet() && !workTypeEntity.isShort2TypePay()) {
            shortTime += TimeUtility.getMinutes((Date)workTypeEntity.getShort2EndTime()) - TimeUtility.getMinutes((Date)workTypeEntity.getShort2StartTime());
        }
        vo.setLblUnpaidShortTime(this.getTimeTimeFormat(shortTime));
    }

    protected void setWorkTypeForApplicatedAttendance(AttendanceDtoInterface attendanceDto, RequestUtilBeanInterface requestUtil, boolean isDifference) throws MospException {
        String workTypeCode;
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        Date targetDate = vo.getTargetDate();
        WorkTypeReferenceBeanInterface workTypeRefer = this.timeReference().workType();
        String workTypeName = workTypeRefer.getParticularWorkTypeName(workTypeCode = attendanceDto.getWorkTypeCode());
        if (workTypeName == null) {
            RequestEntityInterface entity = requestUtil.getRequestEntity(personalId, targetDate);
            String[][] aryWorkType = workTypeRefer.getTimeSelectArray(targetDate, entity.isAmHoliday(true), entity.isPmHoliday(true));
            workTypeName = MospUtility.getCodeName((String)workTypeCode, (String[][])aryWorkType);
        }
        this.setPltWorkType(workTypeCode, workTypeName);
        if (isDifference) {
            String differenceType = workTypeCode;
            vo.setPltWorkType(differenceType);
            vo.setAryPltWorkType(this.timeReference().differenceRequest(vo.getTargetDate()).getDifferenceSelectArray(differenceType));
        }
        this.doAdditionalLogic("ChangeWorkTypePulldown");
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(attendanceDto.getWorkflow());
        if (workflowDto == null || "1".equals(workflowDto.getWorkflowStatus())) {
            vo.setModeCardEdit("apply");
            return;
        }
        vo.setModeCardEdit("applied");
    }

    protected void setWorkTypeForHolidayRequest(HolidayRequestDtoInterface holidayRequestDto) {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        switch (holidayRequestDto.getHolidayType1()) {
            case 1: {
                this.setPltWorkType(this.mospParams.getName("PaidVacation"));
                break;
            }
            case 2: {
                this.setPltWorkType(this.mospParams.getName("Specially", new String[]{"Holiday"}));
                break;
            }
            case 3: {
                this.setPltWorkType(this.mospParams.getName("Others", new String[]{"Holiday"}));
                break;
            }
            case 4: {
                this.setPltWorkType(this.mospParams.getName("Absence"));
                break;
            }
            default: {
                this.setPltWorkType("");
            }
        }
        vo.setModeCardEdit(MODE_APPLICATION_COMPLETED_HOLIDAY);
    }

    protected void setWorkTypeForSubHolidayRequest(SubHolidayRequestDtoInterface subHolidayRequestDto) {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        switch (subHolidayRequestDto.getWorkDateSubHolidayType()) {
            case 1: {
                this.setPltWorkType(this.mospParams.getName("Prescribed", new String[]{"Generation", "Rest"}));
                break;
            }
            case 2: {
                this.setPltWorkType(this.mospParams.getName("Legal", new String[]{"Generation", "Rest"}));
                break;
            }
            case 3: {
                this.setPltWorkType(this.mospParams.getName("Midnight", new String[]{"Generation", "Rest"}));
                break;
            }
            default: {
                this.setPltWorkType("");
            }
        }
        vo.setModeCardEdit(MODE_APPLICATION_COMPLETED_HOLIDAY);
    }

    protected void setWorkTypeForHolidayAllDay() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        this.setPltWorkType(this.mospParams.getName("Application", new String[]{"In", "From", "Holiday", "Finish"}));
        vo.setModeCardEdit(MODE_APPLICATION_COMPLETED_HOLIDAY);
    }

    protected boolean setWorkTypeForWorkOnHolidayRequest(RequestUtilBeanInterface requestUtil) throws MospException {
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = requestUtil.getWorkOnHolidayDto(true);
        if (workOnHolidayRequestDto == null) {
            return false;
        }
        this.setWorkTypeForWorkOnHolidayRequest(workOnHolidayRequestDto, requestUtil);
        return true;
    }

    protected void setWorkTypeForWorkOnHolidayRequest(WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto, RequestUtilBeanInterface requestUtil) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        ScheduleUtilBeanInterface scheduleUtil = this.timeReference().scheduleUtil();
        int substitute = workOnHolidayRequestDto.getSubstitute();
        if (substitute == 2) {
            String workTypeCode = "";
            String workOnHolidayType = workOnHolidayRequestDto.getWorkOnHolidayType();
            if ("legal_holiday".equals(workOnHolidayType)) {
                workTypeCode = "work_on_legal";
            }
            if ("prescribed_holiday".equals(workOnHolidayType)) {
                workTypeCode = "work_on_prescribed";
            }
            this.setPltWorkType(workTypeCode, this.timeReference().workType().getParticularWorkTypeName(workTypeCode));
            vo.setModeCardEdit("new");
            this.setWorkTypeForNotApplicatedAttendance(requestUtil);
            this.doAdditionalLogic("ChangeWorkTypePulldown");
            return;
        }
        String personalId = vo.getPersonalId();
        Date targetDate = vo.getTargetDate();
        ScheduleDtoInterface scheduleDto = scheduleUtil.getSchedule(personalId, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        RequestEntityInterface entity = requestUtil.getRequestEntity(personalId, targetDate);
        boolean holidayAm = entity.isAmHoliday(true);
        boolean holidayPm = entity.isPmHoliday(true);
        String[][] aryWorkType = this.getWorkTypeArray(scheduleDto.getPatternCode(), holidayAm, holidayPm);
        String workTypeCode = workOnHolidayRequestDto.getWorkTypeCode();
        if (substitute != 5) {
            Date substituteDate = this.timeReference().substitute().getSubstituteDate(workOnHolidayRequestDto.getWorkflow());
            workTypeCode = this.timeReference().scheduleUtil().getScheduledWorkTypeCode(personalId, substituteDate);
        }
        if (this.mospParams.hasErrorMessage()) {
            vo.setModeCardEdit(MODE_APPLICATION_COMPLETED_HOLIDAY);
            return;
        }
        int workTypeChangeFlag = scheduleDto.getWorkTypeChangeFlag();
        if (workTypeChangeFlag == 0) {
            vo.setPltWorkType(workTypeCode);
            vo.setAryPltWorkType(aryWorkType);
        } else if (workTypeChangeFlag == 1) {
            this.setPltWorkType(workTypeCode, MospUtility.getCodeName((String)workTypeCode, (String[][])aryWorkType));
        }
        this.doAdditionalLogic("ChangeWorkTypePulldown");
        vo.setModeCardEdit("new");
        this.setWorkTypeForNotApplicatedAttendance(requestUtil);
    }

    protected void setWorkTypeForSubstitute(SubstituteDtoInterface subsutituteDto, RequestUtilBeanInterface requestUtil) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        String substituteType = subsutituteDto.getSubstituteType();
        if (substituteType.equals("prescribed_holiday")) {
            this.setPltWorkType(TimeNamingUtility.prescribedTransferHoliday((MospParams)this.mospParams));
        }
        if (substituteType.equals("legal_holiday")) {
            this.setPltWorkType(TimeNamingUtility.legalTransferHoliday((MospParams)this.mospParams));
        }
        vo.setModeCardEdit(MODE_APPLICATION_COMPLETED_HOLIDAY);
        this.setWorkTypeForWorkOnHolidayRequest(requestUtil);
    }

    protected void setWorkTypeForWorkTypeChangeRequest(WorkTypeChangeRequestDtoInterface workTypeChangeRequestDto, RequestUtilBeanInterface requestUtil) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        ScheduleUtilBeanInterface scheduleUtil = this.timeReference().scheduleUtil();
        ScheduleDtoInterface scheduleDto = scheduleUtil.getSchedule(vo.getPersonalId(), vo.getTargetDate());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        boolean holidayAm = false;
        boolean holidayPm = false;
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = requestUtil.getWorkOnHolidayDto(true);
        if (workOnHolidayRequestDto != null) {
            int substitute = workOnHolidayRequestDto.getSubstitute();
            holidayAm = substitute == 4;
            holidayPm = substitute == 3;
        }
        int rangeHoliday = requestUtil.checkHolidayRangeHoliday(requestUtil.getHolidayList(true));
        int rangeSubHoliday = requestUtil.checkHolidayRangeSubHoliday(requestUtil.getSubHolidayList(true));
        int rangeSubstitute = requestUtil.checkHolidayRangeSubstitute(requestUtil.getSubstituteList(true));
        if (rangeHoliday == 2 || rangeSubHoliday == 2 || rangeSubstitute == 2) {
            holidayAm = true;
        }
        if (rangeHoliday == 3 || rangeSubHoliday == 3 || rangeSubstitute == 3) {
            holidayPm = true;
        }
        String[][] aryWorkType = this.getWorkTypeArray(scheduleDto.getPatternCode(), holidayAm, holidayPm);
        int workTypeChangeFlag = scheduleDto.getWorkTypeChangeFlag();
        if (workTypeChangeFlag == 0) {
            vo.setPltWorkType(workTypeChangeRequestDto.getWorkTypeCode());
            vo.setAryPltWorkType(aryWorkType);
        } else if (workTypeChangeFlag == 1) {
            this.setPltWorkType(workTypeChangeRequestDto.getWorkTypeCode(), MospUtility.getCodeName((String)workTypeChangeRequestDto.getWorkTypeCode(), (String[][])aryWorkType));
        }
        WorkTypeEntityInterface workTypeEntity = this.timeReference().workType().getWorkTypeEntity(workTypeChangeRequestDto.getWorkTypeCode(), vo.getTargetDate());
        if (workTypeEntity != null) {
            if (workTypeEntity.isDirectStart()) {
                vo.setCkbDirectStart("1");
            }
            if (workTypeEntity.isDirectEnd()) {
                vo.setCkbDirectEnd("1");
            }
        }
        this.doAdditionalLogic("ChangeWorkTypePulldown");
        vo.setModeCardEdit("new");
        this.setWorkTypeForNotApplicatedAttendance(requestUtil);
    }

    protected void setWorkTypeForDifferenceRequest(DifferenceRequestDtoInterface differenceRequestDto, RequestUtilBeanInterface requestUtil) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        String differenceType = differenceRequestDto.getDifferenceType();
        vo.setPltWorkType(differenceType);
        vo.setAryPltWorkType(this.timeReference().differenceRequest(vo.getTargetDate()).getDifferenceSelectArray(differenceType));
        vo.setModeCardEdit("new");
        this.setWorkTypeForNotApplicatedAttendance(requestUtil);
    }

    protected void setWorkTypeForSchedule(RequestUtilBeanInterface requestUtil) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        ScheduleUtilBeanInterface scheduleUtil = this.timeReference().scheduleUtil();
        String personalId = vo.getPersonalId();
        Date targetDate = vo.getTargetDate();
        String workTypeCode = scheduleUtil.getScheduledWorkTypeCode(personalId, targetDate);
        if (this.mospParams.hasErrorMessage()) {
            vo.setModeCardEdit(MODE_APPLICATION_COMPLETED_HOLIDAY);
        }
        if ("prescribed_holiday".equals(workTypeCode) || "legal_holiday".equals(workTypeCode)) {
            this.setPltWorkType(workTypeCode, this.timeReference().workType().getParticularWorkTypeName(workTypeCode));
            vo.setModeCardEdit(MODE_APPLICATION_COMPLETED_HOLIDAY);
        } else {
            boolean holidayPm;
            ScheduleDtoInterface scheduleDto = scheduleUtil.getSchedule(personalId, targetDate);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            int rangeHoliday = requestUtil.checkHolidayRangeHoliday(requestUtil.getHolidayList(true));
            int rangeSubHoliday = requestUtil.checkHolidayRangeSubHoliday(requestUtil.getSubHolidayList(true));
            int rangeSubstitute = requestUtil.checkHolidayRangeSubstitute(requestUtil.getSubstituteList(true));
            boolean holidayAm = rangeHoliday == 2 || rangeSubHoliday == 2 || rangeSubstitute == 2;
            boolean bl = holidayPm = rangeHoliday == 3 || rangeSubHoliday == 3 || rangeSubstitute == 3;
            if (rangeHoliday == 5 || rangeSubHoliday == 5 || rangeSubstitute == 5 || holidayAm && holidayPm) {
                this.setWorkTypeForHolidayAllDay();
                return;
            }
            String[][] aryWorkType = this.getWorkTypeArray(scheduleDto.getPatternCode(), holidayAm, holidayPm);
            int workTypeChangeFlag = scheduleDto.getWorkTypeChangeFlag();
            if (workTypeChangeFlag == 0) {
                vo.setPltWorkType(workTypeCode);
                vo.setAryPltWorkType(aryWorkType);
            } else if (workTypeChangeFlag == 1) {
                this.setPltWorkType(workTypeCode, MospUtility.getCodeName((String)workTypeCode, (String[][])aryWorkType));
            }
            this.doAdditionalLogic("ChangeWorkTypePulldown");
            vo.setModeCardEdit("new");
        }
        this.setWorkTypeForNotApplicatedAttendance(requestUtil);
    }

    protected void setWorkTypeForNotApplicatedAttendance(RequestUtilBeanInterface requestUtil) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        AttendanceDtoInterface attendanceDto = requestUtil.getDraftAttendance();
        if (attendanceDto != null) {
            vo.setPltWorkType(attendanceDto.getWorkTypeCode());
            vo.setModeCardEdit("draft");
        }
        if ((attendanceDto = requestUtil.getFirstRevertedAttendance()) != null) {
            vo.setPltWorkType(attendanceDto.getWorkTypeCode());
            vo.setModeCardEdit("revert");
        }
        if (!this.timeReference().cutoffUtil().isNotTighten(vo.getPersonalId(), vo.getTargetDate())) {
            vo.setModeCardEdit("applied");
        }
    }

    protected void setAttendance(AttendanceDtoInterface dto, boolean isCalc) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        if (dto == null) {
            return;
        }
        vo.setTxtStartTimeHour(DateUtility.getStringHour((Date)dto.getActualStartTime(), (Date)dto.getWorkDate()));
        vo.setTxtStartTimeMinute(DateUtility.getStringMinute((Date)dto.getActualStartTime()));
        vo.setTxtEndTimeHour(DateUtility.getStringHour((Date)dto.getActualEndTime(), (Date)dto.getWorkDate()));
        vo.setTxtEndTimeMinute(DateUtility.getStringMinute((Date)dto.getActualEndTime()));
        if (isCalc) {
            vo.setTxtStartTimeHour(DateUtility.getStringHour((Date)dto.getStartTime(), (Date)dto.getWorkDate()));
            vo.setTxtStartTimeMinute(DateUtility.getStringMinute((Date)dto.getStartTime()));
            vo.setTxtEndTimeHour(DateUtility.getStringHour((Date)dto.getEndTime(), (Date)dto.getWorkDate()));
            vo.setTxtEndTimeMinute(DateUtility.getStringMinute((Date)dto.getEndTime()));
        }
        vo.setLblWorkTime(this.getTimeTimeFormat(dto.getWorkTime()));
        vo.setLblGeneralWorkTime(this.getTimeTimeFormat(dto.getGeneralWorkTime()));
        vo.setCkbDirectStart(String.valueOf(dto.getDirectStart()));
        vo.setCkbDirectEnd(String.valueOf(dto.getDirectEnd()));
        vo.setCkbForgotRecordWorkStart(String.valueOf(dto.getForgotRecordWorkStart()));
        vo.setCkbNotRecordWorkStart(String.valueOf(dto.getNotRecordWorkStart()));
        vo.setLblUnpaidShortTime(this.getTimeTimeFormat(dto.getShortUnpaid()));
        vo.setTxtTimeComment(dto.getTimeComment());
        if ("1".equals(Integer.toString(dto.getDirectStart())) || "1".equals(Integer.toString(dto.getDirectEnd())) || "1".equals(Integer.toString(dto.getForgotRecordWorkStart())) || "1".equals(Integer.toString(dto.getNotRecordWorkStart()))) {
            vo.setTxtRemarks(dto.getRemarks());
        }
        vo.setTmdAttendanceId(String.valueOf(dto.getTmdAttendanceId()));
        vo.setPltLateReason(dto.getLateReason());
        vo.setPltLateCertificate(String.valueOf(dto.getLateCertificate()));
        vo.setTxtLateComment(dto.getLateComment());
        vo.setPltLeaveEarlyReason(dto.getLeaveEarlyReason());
        vo.setPltLeaveEarlyCertificate(String.valueOf(dto.getLeaveEarlyCertificate()));
        vo.setTxtLeaveEarlyComment(dto.getLeaveEarlyComment());
        vo.setLblLateTime(this.getTimeTimeFormat(dto.getLateTime()));
        vo.setLblLeaveEarlyTime(this.getTimeTimeFormat(dto.getLeaveEarlyTime()));
        vo.setLblOvertime(this.getTimeTimeFormat(dto.getOvertime()));
        vo.setLblOvertimeIn(this.getTimeTimeFormat(dto.getOvertimeIn()));
        vo.setLblOvertimeOut(this.getTimeTimeFormat(dto.getOvertimeOut()));
        vo.setLblLateNightTime(this.getTimeTimeFormat(dto.getLateNightTime()));
        vo.setLblSpecificWorkTimeIn(this.getTimeTimeFormat(dto.getSpecificWorkTime()));
        vo.setLblLegalWorkTime(this.getTimeTimeFormat(dto.getLegalWorkTime()));
        vo.setLblHolidayWorkTime(this.getTimeTimeFormat(dto.getSpecificWorkTime() + dto.getLegalWorkTime()));
        vo.setLblDecreaseTime(this.getTimeTimeFormat(dto.getDecreaseTime()));
        vo.setLblRestTime(this.getTimeTimeFormat(dto.getRestTime()));
        vo.setLblOverRestTime(this.getTimeTimeFormat(dto.getOverRestTime()));
        vo.setLblNightRestTime(this.getTimeTimeFormat(dto.getNightRestTime()));
        vo.setLblPublicTime(this.getTimeTimeFormat(dto.getPublicTime()));
        vo.setLblPrivateTime(this.getTimeTimeFormat(dto.getPrivateTime()));
        this.doAdditionalLogic("Add_AttendanceCardAction_setAttendance", new Object[]{dto, vo});
    }

    protected void setRecordTime() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        Date workDate = vo.getTargetDate();
        Map rerocdTimes = this.timeReference().timeRecord().getRecordTimes(personalId, workDate);
        vo.setLblStartTime(this.getRecordTimeString((Date)rerocdTimes.get("StartWork"), workDate));
        vo.setLblEndTime(this.getRecordTimeString((Date)rerocdTimes.get("EndWork"), workDate));
    }

    protected String getRecordTimeString(Date recordTime, Date workDate) {
        if (MospUtility.isEmpty((Object[])new Object[]{recordTime, workDate})) {
            return "";
        }
        if (recordTime.before(workDate)) {
            StringBuilder sb = new StringBuilder();
            sb.append(PfNameUtility.hyphen((MospParams)this.mospParams));
            sb.append(DateUtility.getStringTimeAndSecond((Date)recordTime, (Date)DateUtility.getDate((Date)recordTime)));
            return NameUtility.cornerParentheses((MospParams)this.mospParams, (String)sb.toString());
        }
        return NameUtility.cornerParentheses((MospParams)this.mospParams, (String)DateUtility.getStringTimeAndSecond((Date)recordTime, (Date)workDate));
    }

    protected void attendanceCorrectInfo() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        AttendanceCorrectionDtoInterface dto = this.timeReference().attendanceCorrection().getLatestAttendanceCorrectionInfo(vo.getPersonalId(), vo.getTargetDate(), 1);
        if (dto == null) {
            return;
        }
        vo.setTxtCorrectionReason(dto.getCorrectionReason());
        StringBuffer sb = new StringBuffer();
        sb.append(this.mospParams.getName("Corrector"));
        sb.append(this.mospParams.getName("Colon"));
        sb.append(this.reference().human().getHumanName(dto.getCorrectionPersonalId(), dto.getCorrectionDate()));
        sb.append(" ");
        sb.append(this.mospParams.getName("Day"));
        sb.append(this.mospParams.getName("Hour"));
        sb.append(this.mospParams.getName("Colon"));
        sb.append(DateUtility.getStringDateAndDayAndTime((Date)dto.getCorrectionDate()));
        vo.setLblCorrectionHistory(sb.toString());
    }

    protected void setRest(RequestUtilBeanInterface requestUtil) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        Date workDate = vo.getTargetDate();
        AttendanceDtoInterface dto = requestUtil.getAttendance();
        if (dto == null) {
            this.setScheduledRest(requestUtil);
            return;
        }
        List rests = this.timeReference().rest().getRestList(personalId, workDate, 1);
        if (!(dto.getStartTime() != null && dto.getEndTime() != null || TimeUtility.isRestRegistered((Collection)rests, (Date)workDate))) {
            this.setScheduledRest(requestUtil);
            return;
        }
        this.setRest((Collection)rests);
    }

    protected void setScheduledRest(RequestUtilBeanInterface requestUtil) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        Date targetDate = vo.getTargetDate();
        if (vo.getModeCardEdit().equals(MODE_APPLICATION_COMPLETED_HOLIDAY)) {
            return;
        }
        RequestEntityInterface entity = requestUtil.getRequestEntity(personalId, targetDate);
        if (entity.isAllHoliday(true) || entity.isAmHoliday(true) || entity.isPmHoliday(true)) {
            return;
        }
        DifferenceRequestDtoInterface differenceRequestDto = requestUtil.getDifferenceDto(true);
        if (differenceRequestDto != null) {
            DifferenceRequestReferenceBeanInterface differenceRequest = this.timeReference().differenceRequest(vo.getTargetDate());
            Date restStartTime = null;
            Date restEndTime = null;
            Date startTime = null;
            Date endTime = null;
            boolean isHalfHoliday = false;
            if (differenceRequest.isDifferenceTypeA(differenceRequestDto)) {
                restStartTime = differenceRequest.getDifferenceRestStartTimeTypeA(vo.getTargetDate(), startTime, endTime, isHalfHoliday);
                restEndTime = differenceRequest.getDifferenceRestEndTimeTypeA(vo.getTargetDate(), startTime, endTime, isHalfHoliday);
            } else if (differenceRequest.isDifferenceTypeB(differenceRequestDto)) {
                restStartTime = differenceRequest.getDifferenceRestStartTimeTypeB(vo.getTargetDate(), startTime, endTime, isHalfHoliday);
                restEndTime = differenceRequest.getDifferenceRestEndTimeTypeB(vo.getTargetDate(), startTime, endTime, isHalfHoliday);
            } else if (differenceRequest.isDifferenceTypeC(differenceRequestDto)) {
                restStartTime = differenceRequest.getDifferenceRestStartTimeTypeC(vo.getTargetDate(), startTime, endTime, isHalfHoliday);
                restEndTime = differenceRequest.getDifferenceRestEndTimeTypeC(vo.getTargetDate(), startTime, endTime, isHalfHoliday);
            } else if (differenceRequest.isDifferenceTypeD(differenceRequestDto)) {
                restStartTime = differenceRequest.getDifferenceRestStartTimeTypeD(vo.getTargetDate(), startTime, endTime, isHalfHoliday);
                restEndTime = differenceRequest.getDifferenceRestEndTimeTypeD(vo.getTargetDate(), startTime, endTime, isHalfHoliday);
            } else if (differenceRequest.isDifferenceTypeS(differenceRequestDto)) {
                restStartTime = differenceRequest.getDifferenceRestStartTimeTypeS(startTime, endTime, differenceRequestDto.getRequestStart(), isHalfHoliday);
                restEndTime = differenceRequest.getDifferenceRestEndTimeTypeS(startTime, endTime, differenceRequestDto.getRequestStart(), isHalfHoliday);
            }
            vo.setTxtRestStartHour1(DateUtility.getStringHour((Date)restStartTime, (Date)vo.getTargetDate()));
            vo.setTxtRestStartMinute1(DateUtility.getStringMinute((Date)restStartTime));
            vo.setTxtRestEndHour1(DateUtility.getStringHour((Date)restEndTime, (Date)vo.getTargetDate()));
            vo.setTxtRestEndMinute1(DateUtility.getStringMinute((Date)restEndTime));
            return;
        }
        String workTypeCode = entity.getWorkType(false);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        Date defaultDate = DateUtility.getDefaultTime();
        WorkTypeItemDtoInterface restStart1Dto = this.timeReference().workTypeItem().getWorkTypeItemInfo(workTypeCode, targetDate, "RestStart1");
        WorkTypeItemDtoInterface restEnd1Dto = this.timeReference().workTypeItem().getWorkTypeItemInfo(workTypeCode, targetDate, "RestEnd1");
        if (restStart1Dto != null && restEnd1Dto != null) {
            vo.setTxtRestStartHour1(DateUtility.getStringHour((Date)restStart1Dto.getWorkTypeItemValue(), (Date)defaultDate));
            vo.setTxtRestStartMinute1(DateUtility.getStringMinute((Date)restStart1Dto.getWorkTypeItemValue()));
            vo.setTxtRestEndHour1(DateUtility.getStringHour((Date)restEnd1Dto.getWorkTypeItemValue(), (Date)defaultDate));
            vo.setTxtRestEndMinute1(DateUtility.getStringMinute((Date)restEnd1Dto.getWorkTypeItemValue()));
        }
        WorkTypeItemDtoInterface restStart2Dto = this.timeReference().workTypeItem().getWorkTypeItemInfo(workTypeCode, targetDate, "RestStart2");
        WorkTypeItemDtoInterface restEnd2Dto = this.timeReference().workTypeItem().getWorkTypeItemInfo(workTypeCode, targetDate, "RestEnd2");
        if (restStart2Dto != null && restEnd2Dto != null) {
            vo.setTxtRestStartHour2(DateUtility.getStringHour((Date)restStart2Dto.getWorkTypeItemValue(), (Date)defaultDate));
            vo.setTxtRestStartMinute2(DateUtility.getStringMinute((Date)restStart2Dto.getWorkTypeItemValue()));
            vo.setTxtRestEndHour2(DateUtility.getStringHour((Date)restEnd2Dto.getWorkTypeItemValue(), (Date)defaultDate));
            vo.setTxtRestEndMinute2(DateUtility.getStringMinute((Date)restEnd2Dto.getWorkTypeItemValue()));
        }
        WorkTypeItemDtoInterface restStart3Dto = this.timeReference().workTypeItem().getWorkTypeItemInfo(workTypeCode, targetDate, "RestStart3");
        WorkTypeItemDtoInterface restEnd3Dto = this.timeReference().workTypeItem().getWorkTypeItemInfo(workTypeCode, targetDate, "RestEnd3");
        if (restStart3Dto != null && restEnd3Dto != null) {
            vo.setTxtRestStartHour3(DateUtility.getStringHour((Date)restStart3Dto.getWorkTypeItemValue(), (Date)defaultDate));
            vo.setTxtRestStartMinute3(DateUtility.getStringMinute((Date)restStart3Dto.getWorkTypeItemValue()));
            vo.setTxtRestEndHour3(DateUtility.getStringHour((Date)restEnd3Dto.getWorkTypeItemValue(), (Date)defaultDate));
            vo.setTxtRestEndMinute3(DateUtility.getStringMinute((Date)restEnd3Dto.getWorkTypeItemValue()));
        }
        WorkTypeItemDtoInterface restStart4Dto = this.timeReference().workTypeItem().getWorkTypeItemInfo(workTypeCode, targetDate, "RestStart4");
        WorkTypeItemDtoInterface restEnd4Dto = this.timeReference().workTypeItem().getWorkTypeItemInfo(workTypeCode, targetDate, "RestEnd4");
        if (restStart4Dto != null && restEnd4Dto != null) {
            vo.setTxtRestStartHour4(DateUtility.getStringHour((Date)restStart4Dto.getWorkTypeItemValue(), (Date)defaultDate));
            vo.setTxtRestStartMinute4(DateUtility.getStringMinute((Date)restStart4Dto.getWorkTypeItemValue()));
            vo.setTxtRestEndHour4(DateUtility.getStringHour((Date)restEnd4Dto.getWorkTypeItemValue(), (Date)defaultDate));
            vo.setTxtRestEndMinute4(DateUtility.getStringMinute((Date)restEnd4Dto.getWorkTypeItemValue()));
        }
    }

    protected void setRest(Collection<RestDtoInterface> rests) {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        Date workDate = vo.getTargetDate();
        for (RestDtoInterface dto : rests) {
            String startHour = DateUtility.getStringHour((Date)dto.getRestStart(), (Date)workDate);
            String startMinute = DateUtility.getStringMinute((Date)dto.getRestStart());
            String endHour = DateUtility.getStringHour((Date)dto.getRestEnd(), (Date)workDate);
            String endMinute = DateUtility.getStringMinute((Date)dto.getRestEnd());
            if (dto.getRest() == 1) {
                vo.setTxtRestStartHour1(startHour);
                vo.setTxtRestStartMinute1(startMinute);
                vo.setTxtRestEndHour1(endHour);
                vo.setTxtRestEndMinute1(endMinute);
            }
            if (dto.getRest() == 2) {
                vo.setTxtRestStartHour2(startHour);
                vo.setTxtRestStartMinute2(startMinute);
                vo.setTxtRestEndHour2(endHour);
                vo.setTxtRestEndMinute2(endMinute);
            }
            if (dto.getRest() == 3) {
                vo.setTxtRestStartHour3(startHour);
                vo.setTxtRestStartMinute3(startMinute);
                vo.setTxtRestEndHour3(endHour);
                vo.setTxtRestEndMinute3(endMinute);
            }
            if (dto.getRest() == 4) {
                vo.setTxtRestStartHour4(startHour);
                vo.setTxtRestStartMinute4(startMinute);
                vo.setTxtRestEndHour4(endHour);
                vo.setTxtRestEndMinute4(endMinute);
            }
            if (dto.getRest() == 5) {
                vo.setTxtRestStartHour5(startHour);
                vo.setTxtRestStartMinute5(startMinute);
                vo.setTxtRestEndHour5(endHour);
                vo.setTxtRestEndMinute5(endMinute);
            }
            if (dto.getRest() != 6) continue;
            vo.setTxtRestStartHour6(startHour);
            vo.setTxtRestStartMinute6(startMinute);
            vo.setTxtRestEndHour6(endHour);
            vo.setTxtRestEndMinute6(endMinute);
        }
    }

    protected void setGoOut() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        GoOutReferenceBeanInterface goOut = this.timeReference().goOut();
        String personalId = vo.getPersonalId();
        Date workDate = vo.getTargetDate();
        List publics = goOut.getPublicGoOutList(personalId, workDate);
        List privates = goOut.getPrivateGoOutList(personalId, workDate);
        this.setGoOut((Collection)publics, (Collection)privates);
    }

    protected void setGoOut(Collection<GoOutDtoInterface> publics, Collection<GoOutDtoInterface> privates) {
        String endMinute;
        String endHour;
        String startMinute;
        String startHour;
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        Date workDate = vo.getTargetDate();
        for (GoOutDtoInterface publicDto : publics) {
            startHour = DateUtility.getStringHour((Date)publicDto.getGoOutStart(), (Date)workDate);
            startMinute = DateUtility.getStringMinute((Date)publicDto.getGoOutStart());
            endHour = DateUtility.getStringHour((Date)publicDto.getGoOutEnd(), (Date)workDate);
            endMinute = DateUtility.getStringMinute((Date)publicDto.getGoOutEnd());
            if (publicDto.getTimesGoOut() == 1) {
                vo.setTxtPublicStartHour1(startHour);
                vo.setTxtPublicStartMinute1(startMinute);
                vo.setTxtPublicEndHour1(endHour);
                vo.setTxtPublicEndMinute1(endMinute);
            }
            if (publicDto.getTimesGoOut() != 2) continue;
            vo.setTxtPublicStartHour2(startHour);
            vo.setTxtPublicStartMinute2(startMinute);
            vo.setTxtPublicEndHour2(endHour);
            vo.setTxtPublicEndMinute2(endMinute);
        }
        for (GoOutDtoInterface privateDto : privates) {
            startHour = DateUtility.getStringHour((Date)privateDto.getGoOutStart(), (Date)workDate);
            startMinute = DateUtility.getStringMinute((Date)privateDto.getGoOutStart());
            endHour = DateUtility.getStringHour((Date)privateDto.getGoOutEnd(), (Date)workDate);
            endMinute = DateUtility.getStringMinute((Date)privateDto.getGoOutEnd());
            if (privateDto.getTimesGoOut() == 1) {
                vo.setTxtPrivateStartHour1(startHour);
                vo.setTxtPrivateStartMinute1(startMinute);
                vo.setTxtPrivateEndHour1(endHour);
                vo.setTxtPrivateEndMinute1(endMinute);
            }
            if (privateDto.getTimesGoOut() != 2) continue;
            vo.setTxtPrivateStartHour2(startHour);
            vo.setTxtPrivateStartMinute2(startMinute);
            vo.setTxtPrivateEndHour2(endHour);
            vo.setTxtPrivateEndMinute2(endMinute);
        }
    }

    protected void tardinessLeaveearlyInfo() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        AttendanceDtoInterface dto = this.timeReference().attendance().findForKey(vo.getLblEmployeeCode(), vo.getTargetDate());
        if (dto != null) {
            vo.setLblLateTime(this.getTimeTimeFormat(dto.getLateTime()));
            vo.setPltLateReason(dto.getLateReason());
            vo.setPltLateCertificate(String.valueOf(dto.getLateCertificate()));
            vo.setTxtLateComment(dto.getLateComment());
            vo.setLblLeaveEarlyTime(this.getTimeTimeFormat(dto.getLeaveEarlyTime()));
            vo.setPltLeaveEarlyReason(dto.getLeaveEarlyReason());
            vo.setPltLeaveEarlyCertificate(String.valueOf(dto.getLeaveEarlyCertificate()));
            vo.setTxtLeaveEarlyComment(dto.getLeaveEarlyComment());
        }
    }

    protected void premiumInfo() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        AttendanceDtoInterface dto = this.timeReference().attendance().findForKey(vo.getLblEmployeeCode(), vo.getTargetDate());
        if (dto != null) {
            vo.setLblOvertime(this.getTimeTimeFormat(dto.getOvertime()));
            vo.setLblOvertimeIn(this.getTimeTimeFormat(dto.getOvertimeIn()));
            vo.setLblOvertimeOut(this.getTimeTimeFormat(dto.getOvertimeOut()));
            vo.setLblLateNightTime(this.getTimeTimeFormat(dto.getLateNightTime()));
            vo.setLblSpecificWorkTimeIn(this.getTimeTimeFormat(dto.getSpecificWorkTime()));
            vo.setLblSpecificWorkTimeOver("");
            vo.setLblLegalWorkTime(this.getTimeTimeFormat(dto.getLegalWorkTime()));
            vo.setLblDecreaseTime(this.getTimeTimeFormat(dto.getDecreaseTime()));
        }
    }

    protected void allowanceInfo() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        AllowanceDtoInterface dto = null;
        dto = this.timeReference().allowance().findForKey(vo.getPersonalId(), vo.getTargetDate(), 1, "1");
        if (dto != null) {
            vo.setPltAllowance1(String.valueOf(dto.getAllowance()));
        }
        if ((dto = this.timeReference().allowance().findForKey(vo.getPersonalId(), vo.getTargetDate(), 1, "2")) != null) {
            vo.setPltAllowance2(String.valueOf(dto.getAllowance()));
        }
        if ((dto = this.timeReference().allowance().findForKey(vo.getPersonalId(), vo.getTargetDate(), 1, "3")) != null) {
            vo.setPltAllowance3(String.valueOf(dto.getAllowance()));
        }
        if ((dto = this.timeReference().allowance().findForKey(vo.getPersonalId(), vo.getTargetDate(), 1, "4")) != null) {
            vo.setPltAllowance4(String.valueOf(dto.getAllowance()));
        }
        if ((dto = this.timeReference().allowance().findForKey(vo.getPersonalId(), vo.getTargetDate(), 1, "5")) != null) {
            vo.setPltAllowance5(String.valueOf(dto.getAllowance()));
        }
        if ((dto = this.timeReference().allowance().findForKey(vo.getPersonalId(), vo.getTargetDate(), 1, "6")) != null) {
            vo.setPltAllowance6(String.valueOf(dto.getAllowance()));
        }
        if ((dto = this.timeReference().allowance().findForKey(vo.getPersonalId(), vo.getTargetDate(), 1, "7")) != null) {
            vo.setPltAllowance7(String.valueOf(dto.getAllowance()));
        }
        if ((dto = this.timeReference().allowance().findForKey(vo.getPersonalId(), vo.getTargetDate(), 1, "8")) != null) {
            vo.setPltAllowance8(String.valueOf(dto.getAllowance()));
        }
        if ((dto = this.timeReference().allowance().findForKey(vo.getPersonalId(), vo.getTargetDate(), 1, "9")) != null) {
            vo.setPltAllowance9(String.valueOf(dto.getAllowance()));
        }
        if ((dto = this.timeReference().allowance().findForKey(vo.getPersonalId(), vo.getTargetDate(), 1, "10")) != null) {
            vo.setPltAllowance10(String.valueOf(dto.getAllowance()));
        }
    }

    protected void attendanceInfoApprovalStatus() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        AttendanceDtoInterface dto = this.timeReference().attendance().findForKey(vo.getPersonalId(), vo.getTargetDate());
        if (dto == null) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
        WorkflowCommentDtoInterface commentDto = this.reference().workflowComment().getLatestWorkflowCommentInfo(dto.getWorkflow());
        if (workflowDto == null) {
            return;
        }
        vo.setLblAttendanceState(this.getStatusStageValueView(workflowDto.getWorkflowStatus(), workflowDto.getWorkflowStage()));
        if (commentDto == null) {
            vo.setLblAttendanceApprover(this.reference().human().getHumanName(workflowDto.getPersonalId(), workflowDto.getWorkflowDate()));
            return;
        }
        vo.setLblAttendanceComment(this.getWorkflowCommentDtoComment(workflowDto, commentDto));
        vo.setLblAttendanceApprover(this.getWorkflowCommentDtoLastFirstName(workflowDto, commentDto));
    }

    protected void overtimeApplicationStatus() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        StringBuffer transferParams = new StringBuffer();
        transferParams.append("'");
        transferParams.append("transferredAction");
        transferParams.append("', '");
        transferParams.append(OvertimeRequestAction.class.getName());
        transferParams.append("'");
        vo.setLblOvertimeTransferParams(transferParams.toString());
        vo.setLblOvertimeCmd(CMD_TRANSFER);
        AttendanceDtoInterface attendanceDto = this.timeReference().attendance().findForKey(vo.getPersonalId(), vo.getTargetDate());
        List list = this.timeReference().overtimeRequest().getOvertimeRequestList(vo.getPersonalId(), vo.getTargetDate(), vo.getTargetDate());
        ArrayList<OvertimeRequestDtoInterface> overRequestList = new ArrayList<OvertimeRequestDtoInterface>();
        for (OvertimeRequestDtoInterface dto : list) {
            WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
            if (workflowDto == null || "5".equals(workflowDto.getWorkflowStatus())) continue;
            overRequestList.add(dto);
        }
        int size = overRequestList.size();
        String[] aryLblOvertimeType = new String[size];
        String[] aryLblOvertimeSchedule = new String[size];
        String[] aryLblOvertimeResult = new String[size];
        String[] aryLblOvertimeReason = new String[size];
        String[] aryLblOvertimeState = new String[size];
        String[] aryLblOvertimeComment = new String[size];
        String[] aryLblOvertimeApprover = new String[size];
        for (int i = 0; i < overRequestList.size(); ++i) {
            OvertimeRequestDtoInterface dto = (OvertimeRequestDtoInterface)overRequestList.get(i);
            long workflow = dto.getWorkflow();
            WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(workflow);
            WorkflowCommentDtoInterface commentDto = this.reference().workflowComment().getLatestWorkflowCommentInfo(workflow);
            int overtimeType = dto.getOvertimeType();
            aryLblOvertimeType[i] = this.getOvertimeTypeName(overtimeType);
            aryLblOvertimeSchedule[i] = this.getTimeTimeFormat(dto.getRequestTime());
            aryLblOvertimeResult[i] = this.mospParams.getName("Hyphen");
            if (attendanceDto != null) {
                int result = 0;
                if (overtimeType == 1) {
                    result = attendanceDto.getOvertimeBefore();
                } else if (overtimeType == 2) {
                    result = attendanceDto.getOvertimeAfter();
                }
                aryLblOvertimeResult[i] = this.getTimeTimeFormat(result);
            }
            aryLblOvertimeReason[i] = dto.getRequestReason();
            aryLblOvertimeState[i] = this.getStatusStageValueView(workflowDto.getWorkflowStatus(), workflowDto.getWorkflowStage());
            aryLblOvertimeComment[i] = this.getWorkflowCommentDtoComment(workflowDto, commentDto);
            aryLblOvertimeApprover[i] = this.getWorkflowCommentDtoLastFirstName(workflowDto, commentDto);
            if (i != 0 || !"0".equals(workflowDto.getWorkflowStatus()) && !"3".equals(workflowDto.getWorkflowStatus())) continue;
            StringBuffer params = new StringBuffer();
            params.append("'");
            params.append("transferredAction");
            params.append("', '");
            params.append(OvertimeRequestAction.class.getName());
            params.append("', '");
            params.append("transferredActivateDate");
            params.append("', '");
            params.append(DateUtility.getStringDate((Date)dto.getRequestDate()));
            params.append("', '");
            params.append("transferredType");
            params.append("', '");
            params.append(dto.getOvertimeType());
            params.append("'");
            vo.setLblOvertimeTransferParams(params.toString());
            vo.setLblOvertimeCmd(CMD_TRANSFER);
        }
        vo.setLblOvertimeType(aryLblOvertimeType);
        vo.setLblOvertimeSchedule(aryLblOvertimeSchedule);
        vo.setLblOvertimeResult(aryLblOvertimeResult);
        vo.setLblOvertimeReason(aryLblOvertimeReason);
        vo.setLblOvertimeState(aryLblOvertimeState);
        vo.setLblOvertimeComment(aryLblOvertimeComment);
        vo.setLblOvertimeApprover(aryLblOvertimeApprover);
    }

    protected void vacationApplicationStatus(RequestUtilBeanInterface requestUtil) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        ScheduleUtilBeanInterface scheduleUtil = this.timeReference().scheduleUtil();
        StringBuffer transferParams = new StringBuffer();
        transferParams.append("'");
        transferParams.append("transferredAction");
        transferParams.append("', '");
        transferParams.append(HolidayRequestAction.class.getName());
        transferParams.append("'");
        vo.setLblHolidayTransferParams(transferParams.toString());
        vo.setLblHolidayCmd(CMD_TRANSFER);
        String workTypeCode = scheduleUtil.getScheduledWorkTypeCode(vo.getPersonalId(), vo.getTargetDate(), requestUtil);
        if ("legal_holiday".equals(workTypeCode) || "prescribed_holiday".equals(workTypeCode) || "work_on_legal".equals(workTypeCode) || "work_on_prescribed".equals(workTypeCode)) {
            return;
        }
        String workTypeAbbr = MospUtility.getCodeName((String)workTypeCode, (String[][])this.getWorkTypeArray("", false, false));
        List list = this.timeReference().holidayRequest().getHolidayRequestList(vo.getPersonalId(), vo.getTargetDate());
        ArrayList<HolidayRequestDtoInterface> holidayRequestList = new ArrayList<HolidayRequestDtoInterface>();
        for (HolidayRequestDtoInterface dto : list) {
            WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
            if (workflowDto == null || "5".equals(workflowDto.getWorkflowStatus())) continue;
            holidayRequestList.add(dto);
        }
        int size = holidayRequestList.size();
        String[] aryLblHolidayType = new String[size];
        String[] aryLblHolidayLength = new String[size];
        String[] aryLblHolidayTime = new String[size];
        String[] aryLblHolidayReason = new String[size];
        String[] aryLblHolidayWorkType = new String[size];
        String[] aryLblHolidayState = new String[size];
        String[] aryLblHolidayApprover = new String[size];
        String[] aryLblHolidayComment = new String[size];
        for (int i = 0; i < holidayRequestList.size(); ++i) {
            HolidayRequestDtoInterface dto = (HolidayRequestDtoInterface)holidayRequestList.get(i);
            long workflow = dto.getWorkflow();
            WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(workflow);
            WorkflowCommentDtoInterface commentDto = this.reference().workflowComment().getLatestWorkflowCommentInfo(workflow);
            aryLblHolidayType[i] = this.getHolidayTypeName(dto.getHolidayType1(), dto.getHolidayType2(), dto.getRequestStartDate());
            aryLblHolidayLength[i] = this.getHolidayRange(dto.getHolidayRange());
            aryLblHolidayTime[i] = this.getTimeWaveFormat(dto.getStartTime(), dto.getEndTime(), dto.getRequestStartDate());
            aryLblHolidayReason[i] = dto.getRequestReason();
            aryLblHolidayWorkType[i] = workTypeAbbr;
            aryLblHolidayState[i] = this.getStatusStageValueView(workflowDto.getWorkflowStatus(), workflowDto.getWorkflowStage());
            aryLblHolidayApprover[i] = this.getWorkflowCommentDtoLastFirstName(workflowDto, commentDto);
            aryLblHolidayComment[i] = this.getWorkflowCommentDtoComment(workflowDto, commentDto);
            if (i != 0 || !"0".equals(workflowDto.getWorkflowStatus()) && !"3".equals(workflowDto.getWorkflowStatus())) continue;
            StringBuffer params = new StringBuffer();
            params.append("'");
            params.append("transferredAction");
            params.append("', '");
            params.append(HolidayRequestAction.class.getName());
            params.append("', '");
            params.append("transferredActivateDate");
            params.append("', '");
            params.append(DateUtility.getStringDate((Date)dto.getRequestStartDate()));
            params.append("', '");
            params.append("holidayType1");
            params.append("', '");
            params.append(dto.getHolidayType1());
            params.append("', '");
            params.append("holidayType2");
            params.append("', '");
            params.append(dto.getHolidayType2());
            params.append("', '");
            params.append("holidayRange");
            params.append("', '");
            params.append(dto.getHolidayRange());
            params.append("', '");
            params.append("StartTime");
            params.append("', '");
            params.append(DateUtility.getStringTime((Date)dto.getStartTime(), (Date)dto.getRequestStartDate()));
            params.append("'");
            vo.setLblHolidayTransferParams(params.toString());
            vo.setLblHolidayCmd(CMD_TRANSFER);
        }
        vo.setLblHolidayType(aryLblHolidayType);
        vo.setLblHolidayLength(aryLblHolidayLength);
        vo.setLblHolidayTime(aryLblHolidayTime);
        vo.setLblHolidayReason(aryLblHolidayReason);
        vo.setLblHolidayWorkType(aryLblHolidayWorkType);
        vo.setLblHolidayState(aryLblHolidayState);
        vo.setLblHolidayComment(aryLblHolidayComment);
        vo.setLblHolidayApprover(aryLblHolidayApprover);
    }

    protected void holidayWorkApplicationStatus() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        StringBuffer transferParams = new StringBuffer();
        transferParams.append("'");
        transferParams.append("transferredAction");
        transferParams.append("', '");
        transferParams.append(WorkOnHolidayRequestAction.class.getName());
        transferParams.append("'");
        vo.setLblWorkOnHolidayTransferParams(transferParams.toString());
        vo.setLblWorkOnHolidayCmd(CMD_TRANSFER);
        WorkOnHolidayRequestDtoInterface dto = this.timeReference().workOnHolidayRequest().findForKeyOnWorkflow(vo.getPersonalId(), vo.getTargetDate());
        if (dto == null) {
            return;
        }
        long workflow = dto.getWorkflow();
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(workflow);
        if (workflowDto == null) {
            return;
        }
        if ("5".equals(workflowDto.getWorkflowStatus())) {
            return;
        }
        WorkflowCommentDtoInterface commentDto = this.reference().workflowComment().getLatestWorkflowCommentInfo(dto.getWorkflow());
        List list = this.timeReference().substitute().getSubstituteList(workflow);
        String workRange = "";
        int substitute = dto.getSubstitute();
        if (substitute == 3) {
            workRange = this.mospParams.getName("AnteMeridiem");
        } else if (substitute == 4) {
            workRange = this.mospParams.getName("PostMeridiem");
        }
        vo.setLblWorkOnHolidayDate(this.getStringDateAndDay(dto.getRequestDate()) + workRange);
        vo.setLblWorkOnHolidayTime(this.getWorkOnHolidaySchedule(dto));
        vo.setLblSubStituteDate("");
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            SubstituteDtoInterface substituteDto = (SubstituteDtoInterface)iterator.next();
            StringBuffer sb = new StringBuffer();
            sb.append(this.getStringDateAndDay(substituteDto.getSubstituteDate()));
            int substituteRange = substituteDto.getSubstituteRange();
            if (substituteRange == 2) {
                sb.append(this.mospParams.getName("AnteMeridiem"));
            } else if (substituteRange == 3) {
                sb.append(this.mospParams.getName("PostMeridiem"));
            }
            vo.setLblSubStituteDate(sb.toString());
        }
        vo.setLblWorkOnHolidayReason(dto.getRequestReason());
        vo.setLblWorkOnHolidayState(this.getStatusStageValueView(workflowDto.getWorkflowStatus(), workflowDto.getWorkflowStage()));
        vo.setLblWorkOnHolidayComment(this.getWorkflowCommentDtoComment(workflowDto, commentDto));
        vo.setLblWorkOnHolidayApprover(this.getWorkflowCommentDtoLastFirstName(workflowDto, commentDto));
        if ("0".equals(workflowDto.getWorkflowStatus()) || "3".equals(workflowDto.getWorkflowStatus())) {
            StringBuffer params = new StringBuffer();
            params.append("'");
            params.append("transferredAction");
            params.append("', '");
            params.append(WorkOnHolidayRequestAction.class.getName());
            params.append("', '");
            params.append("transferredActivateDate");
            params.append("', '");
            params.append(DateUtility.getStringDate((Date)dto.getRequestDate()));
            params.append("'");
            vo.setLblWorkOnHolidayTransferParams(params.toString());
            vo.setLblWorkOnHolidayCmd(CMD_TRANSFER);
        }
    }

    protected void compensatoryleaveApplicationStatus() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        StringBuffer transferParams = new StringBuffer();
        transferParams.append("'");
        transferParams.append("transferredAction");
        transferParams.append("', '");
        transferParams.append(SubHolidayRequestAction.class.getName());
        transferParams.append("'");
        vo.setLblSubHolidayTransferParams(transferParams.toString());
        vo.setLblSubHolidayCmd(CMD_TRANSFER);
        List list = this.timeReference().subHolidayRequest().getSubHolidayRequestList(vo.getPersonalId(), vo.getTargetDate());
        ArrayList<SubHolidayRequestDtoInterface> subHolidayRequestList = new ArrayList<SubHolidayRequestDtoInterface>();
        for (SubHolidayRequestDtoInterface dto : list) {
            WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(dto.getWorkflow());
            if (workflowDto == null || "5".equals(workflowDto.getWorkflowStatus())) continue;
            subHolidayRequestList.add(dto);
        }
        int size = subHolidayRequestList.size();
        String[] aryLblSubHolidayDate = new String[size];
        String[] aryLblSubHolidayWorkDate = new String[size];
        String[] aryLblSubHolidayState = new String[size];
        String[] aryLblSubHolidayLength = new String[size];
        String[] aryLblSubHolidayComment = new String[size];
        String[] aryLblSubHolidayApprover = new String[size];
        for (int i = 0; i < subHolidayRequestList.size(); ++i) {
            SubHolidayRequestDtoInterface dto = (SubHolidayRequestDtoInterface)subHolidayRequestList.get(i);
            long workflow = dto.getWorkflow();
            WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(workflow);
            WorkflowCommentDtoInterface commentDto = this.reference().workflowComment().getLatestWorkflowCommentInfo(workflow);
            aryLblSubHolidayDate[i] = DateUtility.getStringDateAndDay((Date)dto.getRequestDate());
            aryLblSubHolidayLength[i] = this.getHolidayRange(dto.getHolidayRange());
            aryLblSubHolidayWorkDate[i] = DateUtility.getStringDateAndDay((Date)dto.getWorkDate());
            aryLblSubHolidayState[i] = this.getStatusStageValueView(workflowDto.getWorkflowStatus(), workflowDto.getWorkflowStage());
            aryLblSubHolidayComment[i] = this.getWorkflowCommentDtoComment(workflowDto, commentDto);
            aryLblSubHolidayApprover[i] = this.getWorkflowCommentDtoLastFirstName(workflowDto, commentDto);
            if (i != 0 || !"0".equals(workflowDto.getWorkflowStatus()) && !"3".equals(workflowDto.getWorkflowStatus())) continue;
            StringBuffer params = new StringBuffer();
            params.append("'");
            params.append("transferredAction");
            params.append("', '");
            params.append(SubHolidayRequestAction.class.getName());
            params.append("', '");
            params.append("transferredActivateDate");
            params.append("', '");
            params.append(DateUtility.getStringDate((Date)dto.getRequestDate()));
            params.append("', '");
            params.append("transferredType");
            params.append("', '");
            params.append(dto.getHolidayRange());
            params.append("'");
            vo.setLblSubHolidayTransferParams(params.toString());
            vo.setLblSubHolidayCmd(CMD_TRANSFER);
        }
        vo.setLblSubHolidayDate(aryLblSubHolidayDate);
        vo.setLblSubHolidayLength(aryLblSubHolidayLength);
        vo.setLblSubHolidayWorkDate(aryLblSubHolidayWorkDate);
        vo.setLblSubHolidayState(aryLblSubHolidayState);
        vo.setLblSubHolidayComment(aryLblSubHolidayComment);
        vo.setLblSubHolidayApprover(aryLblSubHolidayApprover);
    }

    protected void workTypeChangeApplicationStatus() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        WorkTypeChangeRequestReferenceBeanInterface workTypeChangeRequest = this.timeReference().workTypeChangeRequest();
        WorkTypeChangeRequestDtoInterface workTypeChangeRequestDto = workTypeChangeRequest.findForKeyOnWorkflow(vo.getPersonalId(), vo.getTargetDate());
        if (workTypeChangeRequestDto == null) {
            return;
        }
        long workflow = workTypeChangeRequestDto.getWorkflow();
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(workflow);
        if (workflowDto == null) {
            return;
        }
        if (this.reference().workflowIntegrate().isWithDrawn(workflowDto)) {
            return;
        }
        WorkflowCommentDtoInterface commentDto = this.reference().workflowComment().getLatestWorkflowCommentInfo(workflow);
        vo.setLblWorkTypeChangeDate(this.getStringDateAndDay(workTypeChangeRequestDto.getRequestDate()));
        vo.setLblWorkTypeChangeBeforeWorkType(this.time().workTypeChangeRequestRegist().getScheduledWorkTypeName(workTypeChangeRequestDto));
        vo.setLblWorkTypeChangeAfterWorkType(this.timeReference().workType().getWorkTypeAbbrAndTime(workTypeChangeRequestDto.getWorkTypeCode(), workTypeChangeRequestDto.getRequestDate()));
        vo.setLblWorkTypeChangeReason(workTypeChangeRequestDto.getRequestReason());
        vo.setLblWorkTypeChangeState(this.getStatusStageValueView(workflowDto.getWorkflowStatus(), workflowDto.getWorkflowStage()));
        vo.setLblWorkTypeChangeComment(this.getWorkflowCommentDtoComment(workflowDto, commentDto));
        vo.setLblWorkTypeChangeApprover(this.getWorkflowCommentDtoLastFirstName(workflowDto, commentDto));
    }

    protected void timedifferenceWorkApplicationStatus() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        DifferenceRequestReferenceBeanInterface differenceRequest = this.timeReference().differenceRequest();
        StringBuffer transferParams = new StringBuffer();
        transferParams.append("'");
        transferParams.append("transferredAction");
        transferParams.append("', '");
        transferParams.append(DifferenceRequestAction.class.getName());
        transferParams.append("'");
        vo.setLblDifferenceTransferParams(transferParams.toString());
        vo.setLblDifferenceCmd(CMD_TRANSFER);
        DifferenceRequestDtoInterface dto = differenceRequest.findForKeyOnWorkflow(vo.getPersonalId(), vo.getTargetDate());
        if (dto == null) {
            return;
        }
        long workflow = dto.getWorkflow();
        WorkflowDtoInterface workflowDto = this.reference().workflow().getLatestWorkflowInfo(workflow);
        if (workflowDto == null) {
            return;
        }
        if ("5".equals(workflowDto.getWorkflowStatus())) {
            return;
        }
        WorkflowCommentDtoInterface commentDto = this.reference().workflowComment().getLatestWorkflowCommentInfo(workflow);
        vo.setLblDifferenceDate(DateUtility.getStringDateAndDay((Date)dto.getRequestDate()));
        vo.setLblDifferenceWorkType(this.getBeforeDifferenceRequestWorkTypeAbbr());
        vo.setLblDifferenceWorkTime(differenceRequest.getDifferenceTime(dto));
        vo.setLblDifferenceReason(dto.getRequestReason());
        vo.setLblDifferenceState(this.getStatusStageValueView(workflowDto.getWorkflowStatus(), workflowDto.getWorkflowStage()));
        vo.setLblDifferenceComment(this.getWorkflowCommentDtoComment(workflowDto, commentDto));
        vo.setLblDifferenceApprover(this.getWorkflowCommentDtoLastFirstName(workflowDto, commentDto));
        if ("0".equals(workflowDto.getWorkflowStatus()) || "3".equals(workflowDto.getWorkflowStatus())) {
            StringBuffer params = new StringBuffer();
            params.append("'");
            params.append("transferredAction");
            params.append("', '");
            params.append(DifferenceRequestAction.class.getName());
            params.append("', '");
            params.append("transferredActivateDate");
            params.append("', '");
            params.append(DateUtility.getStringDate((Date)dto.getRequestDate()));
            params.append("'");
            vo.setLblDifferenceTransferParams(params.toString());
            vo.setLblDifferenceCmd(CMD_TRANSFER);
        }
    }

    protected void setDefaultValues() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        vo.setModeCardEdit("applied");
        Date targetDate = vo.getTargetDate();
        vo.setLblYear(String.valueOf(DateUtility.getYear((Date)targetDate)));
        vo.setLblMonth(String.valueOf(DateUtility.getMonth((Date)targetDate)));
        vo.setLblDay(String.valueOf(DateUtility.getDay((Date)targetDate)));
        vo.setLblDayOfTheWeek(DateUtility.getStringDayOfWeek((Date)targetDate));
        vo.setLblWorkDayOfWeekStyle(HolidayUtility.getWorkDayOfWeekStyle((Date)targetDate, (MospParams)this.mospParams));
        vo.setCkbDirectStart("0");
        vo.setCkbDirectEnd("0");
        vo.setCkbForgotRecordWorkStart("0");
        vo.setCkbNotRecordWorkStart("0");
        vo.setTmdAttendanceId("0");
        vo.setTxtCorrectionReason("");
        vo.setLblCorrectionHistory("");
        vo.setTxtStartTimeHour("");
        vo.setTxtStartTimeMinute("");
        vo.setLblStartTime("");
        vo.setTxtEndTimeHour("");
        vo.setTxtEndTimeMinute("");
        vo.setLblEndTime("");
        vo.setLblWorkTime("");
        vo.setLblUnpaidShortTime("");
        vo.setLblRestTime("");
        vo.setLblOverRestTime("");
        vo.setLblNightRestTime("");
        vo.setLblPublicTime("");
        vo.setLblPrivateTime("");
        vo.setTxtRestStartHour1("");
        vo.setTxtRestStartMinute1("");
        vo.setTxtRestEndHour1("");
        vo.setTxtRestEndMinute1("");
        vo.setTxtRestStartHour2("");
        vo.setTxtRestStartMinute2("");
        vo.setTxtRestEndHour2("");
        vo.setTxtRestEndMinute2("");
        vo.setTxtRestStartHour3("");
        vo.setTxtRestStartMinute3("");
        vo.setTxtRestEndHour3("");
        vo.setTxtRestEndMinute3("");
        vo.setTxtRestStartHour4("");
        vo.setTxtRestStartMinute4("");
        vo.setTxtRestEndHour4("");
        vo.setTxtRestEndMinute4("");
        vo.setTxtRestStartHour5("");
        vo.setTxtRestStartMinute5("");
        vo.setTxtRestEndHour5("");
        vo.setTxtRestEndMinute5("");
        vo.setTxtRestStartHour6("");
        vo.setTxtRestStartMinute6("");
        vo.setTxtRestEndHour6("");
        vo.setTxtRestEndMinute6("");
        vo.setTxtPublicStartHour1("");
        vo.setTxtPublicStartMinute1("");
        vo.setTxtPublicEndHour1("");
        vo.setTxtPublicEndMinute1("");
        vo.setTxtPublicStartHour2("");
        vo.setTxtPublicStartMinute2("");
        vo.setTxtPublicEndHour2("");
        vo.setTxtPublicEndMinute2("");
        vo.setTxtPrivateStartHour1("");
        vo.setTxtPrivateStartMinute1("");
        vo.setTxtPrivateEndHour1("");
        vo.setTxtPrivateEndMinute1("");
        vo.setTxtPrivateStartHour2("");
        vo.setTxtPrivateStartMinute2("");
        vo.setTxtPrivateEndHour2("");
        vo.setTxtPrivateEndMinute2("");
        vo.setLblLateTime("");
        vo.setPltLateReason("");
        vo.setPltLateCertificate("");
        vo.setTxtLateComment("");
        vo.setLblLeaveEarlyTime("");
        vo.setPltLeaveEarlyReason("");
        vo.setPltLeaveEarlyCertificate("");
        vo.setTxtLeaveEarlyComment("");
        vo.setLblOvertime("");
        vo.setLblOvertimeIn("");
        vo.setLblOvertimeOut("");
        vo.setLblLateNightTime("");
        vo.setLblSpecificWorkTimeIn("");
        vo.setLblSpecificWorkTimeOver("");
        vo.setLblLegalWorkTime("");
        vo.setLblHolidayWorkTime("");
        vo.setLblDecreaseTime("");
        vo.setLblAttendanceComment("");
        vo.setLblAttendanceState("");
        vo.setLblAttendanceApprover("");
        vo.setLblOvertimeType(new String[0]);
        vo.setLblOvertimeSchedule(new String[0]);
        vo.setLblOvertimeResult(new String[0]);
        vo.setLblOvertimeReason(new String[0]);
        vo.setLblOvertimeState(new String[0]);
        vo.setLblOvertimeComment(new String[0]);
        vo.setLblOvertimeApprover(new String[0]);
        vo.setLblHolidayType(new String[0]);
        vo.setLblHolidayLength(new String[0]);
        vo.setLblHolidayTime(new String[0]);
        vo.setLblHolidayReason(new String[0]);
        vo.setLblHolidayWorkType(new String[0]);
        vo.setLblHolidayState(new String[0]);
        vo.setLblHolidayComment(new String[0]);
        vo.setLblHolidayApprover(new String[0]);
        vo.setLblWorkOnHolidayDate("");
        vo.setLblWorkOnHolidayTime("");
        vo.setLblSubStituteDate("");
        vo.setLblWorkOnHolidayReason("");
        vo.setLblWorkOnHolidayState("");
        vo.setLblWorkOnHolidayComment("");
        vo.setLblWorkOnHolidayApprover("");
        vo.setLblSubHolidayDate(new String[0]);
        vo.setLblSubHolidayLength(new String[0]);
        vo.setLblSubHolidayWorkDate(new String[0]);
        vo.setLblSubHolidayState(new String[0]);
        vo.setLblSubHolidayComment(new String[0]);
        vo.setLblSubHolidayApprover(new String[0]);
        vo.setLblWorkTypeChangeDate("");
        vo.setLblWorkTypeChangeBeforeWorkType("");
        vo.setLblWorkTypeChangeAfterWorkType("");
        vo.setLblWorkTypeChangeReason("");
        vo.setLblWorkTypeChangeState("");
        vo.setLblWorkTypeChangeComment("");
        vo.setLblWorkTypeChangeApprover("");
        vo.setLblDifferenceDate("");
        vo.setLblDifferenceWorkType("");
        vo.setLblDifferenceWorkTime("");
        vo.setLblDifferenceReason("");
        vo.setLblDifferenceState("");
        vo.setLblDifferenceComment("");
        vo.setLblDifferenceApprover("");
        vo.setLblGeneralWorkTime("");
        vo.setTxtTimeComment("");
        vo.setTxtRemarks("");
        vo.setPltAllowance1("0");
        vo.setPltAllowance2("0");
        vo.setPltAllowance3("0");
        vo.setPltAllowance4("0");
        vo.setPltAllowance5("0");
        vo.setPltAllowance6("0");
        vo.setPltAllowance7("0");
        vo.setPltAllowance8("0");
        vo.setPltAllowance9("0");
        vo.setPltAllowance10("0");
        vo.setPltWorkType("");
        vo.setModeCardEdit("");
        vo.setAryPltLblApproverSetting(new String[0]);
        vo.setPltApproverSetting1("");
        vo.setPltApproverSetting2("");
        vo.setPltApproverSetting3("");
        vo.setPltApproverSetting4("");
        vo.setPltApproverSetting5("");
        vo.setPltApproverSetting6("");
        vo.setPltApproverSetting7("");
        vo.setPltApproverSetting8("");
        vo.setPltApproverSetting9("");
        vo.setPltApproverSetting10("");
        vo.setAddonJsps(this.getAddonJsps());
        vo.setAddonParameters(new HashMap());
        for (AttendanceCardAddonBeanInterface addonBean : this.getAddonBeans()) {
            addonBean.initVoFields();
        }
    }

    protected void setApplicationStatus(RequestUtilBeanInterface requestUtil) throws MospException {
        this.overtimeApplicationStatus();
        this.vacationApplicationStatus(requestUtil);
        this.holidayWorkApplicationStatus();
        this.compensatoryleaveApplicationStatus();
        this.workTypeChangeApplicationStatus();
        this.timedifferenceWorkApplicationStatus();
    }

    protected void setTransferredValues() {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        if (this.getTransferredStartHour() != null) {
            vo.setTxtStartTimeHour(this.getTransferredStartHour());
            vo.setTxtStartTimeMinute(this.getTransferredStartMinute());
        }
        if (this.getTransferredEndHour() != null) {
            vo.setTxtEndTimeHour(this.getTransferredEndHour());
            vo.setTxtEndTimeMinute(this.getTransferredEndMinute());
        }
        if (this.getTransferredDirectStart() != null) {
            vo.setCkbDirectStart(this.getTransferredDirectStart());
        } else if (this.getTimeRecordDirectStart() != null) {
            vo.setCkbDirectStart(this.getTimeRecordDirectStart());
        }
        if (this.getTransferredDirectEnd() != null) {
            vo.setCkbDirectEnd(this.getTransferredDirectEnd());
        } else if (this.getTimeRecordDirectEnd() != null) {
            vo.setCkbDirectEnd(this.getTimeRecordDirectEnd());
        }
        if (this.getTransferredTimeComment() != null) {
            vo.setTxtTimeComment(this.getTransferredTimeComment());
        }
    }

    protected void setPulldown() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        vo.setAryPltAllowance(this.mospParams.getProperties().getCodeArray("Allowance", false));
        vo.setAryPltLateReason(this.mospParams.getProperties().getCodeArray("ReasonOfLate", true));
        vo.setAryPltLeaveEarlyReason(this.mospParams.getProperties().getCodeArray("ReasonOfLeaveEarly", true));
        vo.setAryPltLateCertificate(this.mospParams.getProperties().getCodeArray("Allowance", true));
    }

    protected void setAttendanceDtoFields(AttendanceDtoInterface dto) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        dto.setTmdAttendanceId(this.getLong(vo.getTmdAttendanceId()));
        dto.setPersonalId(vo.getPersonalId());
        dto.setWorkTypeCode(vo.getPltWorkType());
        dto.setWorkDate(vo.getTargetDate());
        dto.setTimesWork(1);
        Date startTime = this.getAttendanceTime(vo.getTxtStartTimeHour(), vo.getTxtStartTimeMinute());
        Date endTime = this.getAttendanceTime(vo.getTxtEndTimeHour(), vo.getTxtEndTimeMinute());
        dto.setActualStartTime(startTime);
        dto.setStartTime(startTime);
        dto.setActualEndTime(endTime);
        dto.setEndTime(endTime);
        dto.setDirectStart(this.getInt(vo.getCkbDirectStart()));
        dto.setDirectEnd(this.getInt(vo.getCkbDirectEnd()));
        dto.setForgotRecordWorkStart(this.getInt(vo.getCkbForgotRecordWorkStart()));
        dto.setNotRecordWorkStart(this.getInt(vo.getCkbNotRecordWorkStart()));
        dto.setTimeComment(vo.getTxtTimeComment());
        dto.setRemarks("");
        if ("1".equals(vo.getCkbDirectStart()) || "1".equals(vo.getCkbDirectEnd()) || "1".equals(vo.getCkbForgotRecordWorkStart()) || "1".equals(vo.getCkbNotRecordWorkStart())) {
            dto.setRemarks(vo.getTxtRemarks());
        }
        dto.setLateReason(vo.getPltLateReason());
        dto.setLateCertificate(vo.getPltLateCertificate());
        dto.setLateComment(vo.getTxtLateComment());
        dto.setLeaveEarlyReason(vo.getPltLeaveEarlyReason());
        dto.setLeaveEarlyCertificate(vo.getPltLeaveEarlyCertificate());
        dto.setLeaveEarlyComment(vo.getTxtLeaveEarlyComment());
    }

    protected void setAllowanceDtoFields(AllowanceDtoInterface dto, int num) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        dto.setPersonalId(vo.getPersonalId());
        dto.setWorkDate(vo.getTargetDate());
        dto.setWorks(1);
        dto.setAllowanceCode(String.valueOf(num));
        if (num == this.getInt("1")) {
            dto.setAllowance(Integer.parseInt(vo.getPltAllowance1()));
        }
        if (num == this.getInt("2")) {
            dto.setAllowance(Integer.parseInt(vo.getPltAllowance2()));
        }
        if (num == this.getInt("3")) {
            dto.setAllowance(Integer.parseInt(vo.getPltAllowance3()));
        }
        if (num == this.getInt("4")) {
            dto.setAllowance(Integer.parseInt(vo.getPltAllowance4()));
        }
        if (num == this.getInt("5")) {
            dto.setAllowance(Integer.parseInt(vo.getPltAllowance5()));
        }
        if (num == this.getInt("6")) {
            dto.setAllowance(Integer.parseInt(vo.getPltAllowance6()));
        }
        if (num == this.getInt("7")) {
            dto.setAllowance(Integer.parseInt(vo.getPltAllowance7()));
        }
        if (num == this.getInt("8")) {
            dto.setAllowance(Integer.parseInt(vo.getPltAllowance8()));
        }
        if (num == this.getInt("9")) {
            dto.setAllowance(Integer.parseInt(vo.getPltAllowance9()));
        }
        if (num == this.getInt("10")) {
            dto.setAllowance(Integer.parseInt(vo.getPltAllowance10()));
        }
    }

    protected void setRestFields(List<RestDtoInterface> restList, AttendanceDtoInterface dto) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        RestRegistBeanInterface regist = this.time().restRegist();
        String personalId = vo.getPersonalId();
        Date targetDate = vo.getTargetDate();
        ApplicationEntity application = this.timeReference().master().getApplicationEntity(personalId, targetDate);
        if (!application.isValid(this.mospParams)) {
            return;
        }
        TimeSettingDtoInterface timeSettingDto = application.getTimeSettingDto();
        Date defaultTime = DateUtility.getDateTime((int)DateUtility.getYear((Date)targetDate), (int)DateUtility.getMonth((Date)targetDate), (int)DateUtility.getDay((Date)targetDate), (int)0, (int)0);
        Date[] startArray = new Date[]{this.getRest1Start(), this.getRest2Start(), this.getRest3Start(), this.getRest4Start(), this.getRest5Start(), this.getRest6Start()};
        Date[] endArray = new Date[]{this.getRest1End(), this.getRest2End(), this.getRest3End(), this.getRest4End(), this.getRest5End(), this.getRest6End()};
        for (int i = 0; i < startArray.length; ++i) {
            RestDtoInterface restDto = regist.getInitDto();
            RestDtoInterface oldRestDto = this.timeReference().rest().findForKey(personalId, targetDate, 1, i + 1);
            if (oldRestDto != null) {
                restDto.setTmdRestId(oldRestDto.getTmdRestId());
            }
            restDto.setPersonalId(personalId);
            restDto.setWorkDate(targetDate);
            restDto.setTimesWork(1);
            restDto.setRest(i + 1);
            restDto.setRestStart(defaultTime);
            restDto.setRestEnd(defaultTime);
            Date restStartTime = startArray[i];
            Date restEndTime = endArray[i];
            regist.setRestStartEndTime(restStartTime, restEndTime, dto, restDto);
            restDto.setRestTime(regist.getCalcRestTime(restDto.getRestStart(), restDto.getRestEnd(), timeSettingDto));
            restList.add(restDto);
        }
    }

    protected void setGoOutDtoFields(List<GoOutDtoInterface> publicList, List<GoOutDtoInterface> privateList, AttendanceDtoInterface attendanceDto) throws MospException {
        Date goOutEndTime;
        Date goOutStartTime;
        GoOutDtoInterface goOutDto;
        int i;
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        String personalId = vo.getPersonalId();
        Date targetDate = vo.getTargetDate();
        Date[] publicStartArray = new Date[]{this.getPublic1Start(), this.getPublic2Start()};
        Date[] publicEndArray = new Date[]{this.getPublic1End(), this.getPublic2End()};
        Date[] privateStartArray = new Date[]{this.getPrivate1Start(), this.getPrivate2Start()};
        Date[] privateEndArray = new Date[]{this.getPrivate1End(), this.getPrivate2End()};
        Date defaultTime = DateUtility.getDateTime((int)DateUtility.getYear((Date)targetDate), (int)DateUtility.getMonth((Date)targetDate), (int)DateUtility.getDay((Date)targetDate), (int)0, (int)0);
        GoOutRegistBeanInterface regist = this.time().goOutRegist();
        ApplicationEntity application = this.timeReference().master().getApplicationEntity(personalId, targetDate);
        if (!application.isValid(this.mospParams)) {
            return;
        }
        TimeSettingDtoInterface timeSettingDto = application.getTimeSettingDto();
        for (i = 0; i < publicStartArray.length; ++i) {
            goOutDto = regist.getInitDto();
            goOutDto.setPersonalId(personalId);
            goOutDto.setWorkDate(targetDate);
            goOutDto.setTimesWork(1);
            goOutDto.setGoOutType(1);
            goOutDto.setTimesGoOut(i + 1);
            goOutDto.setGoOutStart(defaultTime);
            goOutDto.setGoOutEnd(defaultTime);
            goOutStartTime = publicStartArray[i];
            goOutEndTime = publicEndArray[i];
            regist.setGoOutStartEnd(goOutStartTime, goOutEndTime, attendanceDto, goOutDto);
            goOutDto.setGoOutTime(regist.getCalcPublicGoOutTime(goOutDto.getGoOutStart(), goOutDto.getGoOutEnd(), timeSettingDto));
            publicList.add(goOutDto);
        }
        for (i = 0; i < privateStartArray.length; ++i) {
            goOutDto = regist.getInitDto();
            goOutDto.setPersonalId(personalId);
            goOutDto.setWorkDate(targetDate);
            goOutDto.setTimesWork(1);
            goOutDto.setGoOutType(2);
            goOutDto.setTimesGoOut(i + 1);
            goOutDto.setGoOutStart(defaultTime);
            goOutDto.setGoOutEnd(defaultTime);
            goOutStartTime = privateStartArray[i];
            goOutEndTime = privateEndArray[i];
            regist.setGoOutStartEnd(goOutStartTime, goOutEndTime, attendanceDto, goOutDto);
            goOutDto.setGoOutTime(regist.getCalcPrivateGoOutTime(goOutDto.getGoOutStart(), goOutDto.getGoOutEnd(), timeSettingDto));
            privateList.add(goOutDto);
        }
    }

    protected void chkPrivateGoOut(AttendanceDtoInterface dto, RequestEntityInterface requestEntity) throws MospException {
        Date[][] privateTimeArray;
        DifferenceRequestDtoInterface differenceRequestDto;
        Date private2End;
        Date private2Start;
        Date private1End;
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        Date targetDate = vo.getTargetDate();
        DifferenceRequestReferenceBeanInterface differenceRequest = this.timeReference().differenceRequest(targetDate);
        boolean isHolidayAm = requestEntity.isAmHoliday(true);
        boolean isHolidayPm = requestEntity.isPmHoliday(true);
        if (dto.getWorkTypeCode() == null || dto.getWorkTypeCode().isEmpty()) {
            return;
        }
        String goingOut = TimeNamingUtility.getPrivateGoOut((MospParams)this.mospParams);
        String prescribedWorkTime = TimeNamingUtility.getPrescribedWorkTime((MospParams)this.mospParams);
        Date private1Start = this.getPrivate1Start();
        if (this.doAdditionalLogic("Add_AttendanceCardAction_ChkPrivateGoOut", new Object[]{dto, private1Start, private1End = this.getPrivate1End(), private2Start = this.getPrivate2Start(), private2End = this.getPrivate2End(), targetDate})) {
            return;
        }
        Date defaultTime = DateUtility.getDateTime((int)DateUtility.getYear((Date)dto.getWorkDate()), (int)DateUtility.getMonth((Date)dto.getWorkDate()), (int)DateUtility.getDay((Date)dto.getWorkDate()), (int)0, (int)0);
        if (private1Start == null) {
            private1Start = defaultTime;
        }
        if (private1End == null) {
            private1End = defaultTime;
        }
        if (private2Start == null) {
            private2Start = defaultTime;
        }
        if (private2End == null) {
            private2End = defaultTime;
        }
        if (!(!"work_on_legal".equals(dto.getWorkTypeCode()) && !"work_on_prescribed".equals(dto.getWorkTypeCode()) || defaultTime.equals(private1Start) && defaultTime.equals(private1End) && defaultTime.equals(private2Start) && defaultTime.equals(private2End))) {
            TimeMessageUtility.addErrorTimeOutOfRange((MospParams)this.mospParams, (String)goingOut, (String)prescribedWorkTime);
            return;
        }
        Date workStartTime = null;
        Date workEndTime = null;
        if ((differenceRequest.isDifferenceTypeA(dto.getWorkTypeCode()) || differenceRequest.isDifferenceTypeB(dto.getWorkTypeCode()) || differenceRequest.isDifferenceTypeC(dto.getWorkTypeCode()) || differenceRequest.isDifferenceTypeD(dto.getWorkTypeCode()) || differenceRequest.isDifferenceTypeS(dto.getWorkTypeCode())) && (differenceRequestDto = requestEntity.getDifferenceRequestDto(true)) != null) {
            workStartTime = differenceRequestDto.getRequestStart();
            workEndTime = differenceRequestDto.getRequestEnd();
            if (isHolidayAm) {
                workStartTime = differenceRequest.getDifferenceStartTimeMorningOff(differenceRequestDto.getRequestStart());
            }
            if (isHolidayPm) {
                workEndTime = differenceRequest.getDifferenceEndTimeAfternoonOff(differenceRequestDto.getRequestEnd());
            }
        }
        if (workStartTime == null || workEndTime == null) {
            WorkTypeDtoInterface workTypeDto = this.timeReference().workType().findForInfo(dto.getWorkTypeCode(), dto.getWorkDate());
            if (workTypeDto == null) {
                return;
            }
            WorkTypeItemDtoInterface workStart = this.timeReference().workTypeItem().getWorkTypeItemInfo(workTypeDto.getWorkTypeCode(), workTypeDto.getActivateDate(), "WorkStart");
            WorkTypeItemDtoInterface workEnd = this.timeReference().workTypeItem().getWorkTypeItemInfo(workTypeDto.getWorkTypeCode(), workTypeDto.getActivateDate(), "WorkEnd");
            if (isHolidayAm) {
                workStart = this.timeReference().workTypeItem().getWorkTypeItemInfo(workTypeDto.getWorkTypeCode(), workTypeDto.getActivateDate(), "BackStart");
                workEnd = this.timeReference().workTypeItem().getWorkTypeItemInfo(workTypeDto.getWorkTypeCode(), workTypeDto.getActivateDate(), "BackEnd");
            }
            if (isHolidayPm) {
                workStart = this.timeReference().workTypeItem().getWorkTypeItemInfo(workTypeDto.getWorkTypeCode(), workTypeDto.getActivateDate(), "FrontStart");
                workEnd = this.timeReference().workTypeItem().getWorkTypeItemInfo(workTypeDto.getWorkTypeCode(), workTypeDto.getActivateDate(), "FrontEnd");
            }
            Date standardDate = DateUtility.getTime((int)0, (int)0);
            workStartTime = this.getAttendanceTime(DateUtility.getHour((Date)workStart.getWorkTypeItemValue(), (Date)standardDate), DateUtility.getMinute((Date)workStart.getWorkTypeItemValue()));
            workEndTime = this.getAttendanceTime(DateUtility.getHour((Date)workEnd.getWorkTypeItemValue(), (Date)standardDate), DateUtility.getMinute((Date)workEnd.getWorkTypeItemValue()));
        }
        for (Date[] timeArray : privateTimeArray = new Date[][]{{private1Start, private1End}, {private2Start, private2End}}) {
            Date start = timeArray[0];
            Date end = timeArray[1];
            if (start == null || end == null || defaultTime.equals(start) && defaultTime.equals(end) || !start.before(workStartTime) && !end.after(workEndTime)) continue;
            TimeMessageUtility.addErrorTimeOutOfRange((MospParams)this.mospParams, (String)goingOut, (String)prescribedWorkTime);
            return;
        }
    }

    protected Date getAttendanceTime(String hour, String minute) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        if (hour.isEmpty() || minute.isEmpty()) {
            return null;
        }
        return TimeUtility.getAttendanceTime((Date)vo.getTargetDate(), (String)hour, (String)minute, (MospParams)this.mospParams);
    }

    protected Date getAttendanceTime(int hour, int minute) throws MospException {
        return this.getAttendanceTime(Integer.toString(hour), Integer.toString(minute));
    }

    protected Date getRest1Start() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getAttendanceTime(vo.getTxtRestStartHour1(), vo.getTxtRestStartMinute1());
    }

    protected Date getRest1End() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getAttendanceTime(vo.getTxtRestEndHour1(), vo.getTxtRestEndMinute1());
    }

    protected Date getRest2Start() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getAttendanceTime(vo.getTxtRestStartHour2(), vo.getTxtRestStartMinute2());
    }

    protected Date getRest2End() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getAttendanceTime(vo.getTxtRestEndHour2(), vo.getTxtRestEndMinute2());
    }

    protected Date getRest3Start() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getAttendanceTime(vo.getTxtRestStartHour3(), vo.getTxtRestStartMinute3());
    }

    protected Date getRest3End() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getAttendanceTime(vo.getTxtRestEndHour3(), vo.getTxtRestEndMinute3());
    }

    protected Date getRest4Start() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getAttendanceTime(vo.getTxtRestStartHour4(), vo.getTxtRestStartMinute4());
    }

    protected Date getRest4End() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getAttendanceTime(vo.getTxtRestEndHour4(), vo.getTxtRestEndMinute4());
    }

    protected Date getRest5Start() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getAttendanceTime(vo.getTxtRestStartHour5(), vo.getTxtRestStartMinute5());
    }

    protected Date getRest5End() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getAttendanceTime(vo.getTxtRestEndHour5(), vo.getTxtRestEndMinute5());
    }

    protected Date getRest6Start() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getAttendanceTime(vo.getTxtRestStartHour6(), vo.getTxtRestStartMinute6());
    }

    protected Date getRest6End() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getAttendanceTime(vo.getTxtRestEndHour6(), vo.getTxtRestEndMinute6());
    }

    protected Date getPrivate1Start() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getAttendanceTime(vo.getTxtPrivateStartHour1(), vo.getTxtPrivateStartMinute1());
    }

    protected Date getPrivate1End() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getAttendanceTime(vo.getTxtPrivateEndHour1(), vo.getTxtPrivateEndMinute1());
    }

    protected Date getPrivate2Start() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getAttendanceTime(vo.getTxtPrivateStartHour2(), vo.getTxtPrivateStartMinute2());
    }

    protected Date getPrivate2End() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getAttendanceTime(vo.getTxtPrivateEndHour2(), vo.getTxtPrivateEndMinute2());
    }

    protected Date getPublic1Start() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getAttendanceTime(vo.getTxtPublicStartHour1(), vo.getTxtPublicStartMinute1());
    }

    protected Date getPublic1End() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getAttendanceTime(vo.getTxtPublicEndHour1(), vo.getTxtPublicEndMinute1());
    }

    protected Date getPublic2Start() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getAttendanceTime(vo.getTxtPublicStartHour2(), vo.getTxtPublicStartMinute2());
    }

    protected Date getPublic2End() throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getAttendanceTime(vo.getTxtPublicEndHour2(), vo.getTxtPublicEndMinute2());
    }

    protected void setPltWorkType(String workTypeCode, String workTypeName) {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        vo.setPltWorkType(workTypeCode);
        String[][] aryPltWorkType = new String[][]{{workTypeCode, workTypeName}};
        vo.setAryPltWorkType(aryPltWorkType);
    }

    protected void setPltWorkType(String workTypeName) {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        vo.setPltWorkType("");
        String[][] aryPltWorkType = new String[][]{{"", workTypeName}};
        vo.setAryPltWorkType(aryPltWorkType);
    }

    protected String[][] getWorkTypeArray(String patternCode, boolean amHoliday, boolean pmHoliday) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        return this.getWorkTypeArray(patternCode, vo.getTargetDate(), false, true, amHoliday, pmHoliday);
    }

    protected void setGeneralDtoFields() throws MospException {
    }

    protected void chkDuplRest(AttendanceDtoInterface dto) throws MospException {
        Date baseDateStart = null;
        Date baseDateEnd = null;
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        boolean isDirect = vo.getCkbDirectStart().equals("1") || vo.getCkbDirectEnd().equals("1");
        Date startTime = dto.getStartTime();
        Date endTime = dto.getEndTime();
        String rest1 = this.mospParams.getName("Rest1");
        String rest2 = this.mospParams.getName("Rest2");
        String rest3 = this.mospParams.getName("Rest3");
        String rest4 = this.mospParams.getName("Rest4");
        String rest5 = this.mospParams.getName("Rest5");
        String rest6 = this.mospParams.getName("Rest6");
        String public1 = this.mospParams.getName("Official", new String[]{"GoingOut", "No1"});
        String public2 = this.mospParams.getName("Official", new String[]{"GoingOut", "No2"});
        String private1 = this.mospParams.getName("PrivateGoingOut1");
        String private2 = this.mospParams.getName("PrivateGoingOut2");
        baseDateStart = this.getRest1Start();
        baseDateEnd = this.getRest1End();
        if (baseDateStart != null && baseDateEnd != null) {
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getRest2Start(), this.getRest2End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest1, rest2};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getRest3Start(), this.getRest3End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest1, rest3};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getRest4Start(), this.getRest4End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest1, rest4};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getRest5Start(), this.getRest5End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest1, rest5};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getRest6Start(), this.getRest6End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest1, rest6};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPublic1Start(), this.getPublic1End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest1, public1};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPublic2Start(), this.getPublic2End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest1, public2};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPrivate1Start(), this.getPrivate1End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest1, private1};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPrivate2Start(), this.getPrivate2End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest1, private2};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (isDirect && !this.chkTimeValidate(startTime, endTime, vo.getTxtRestStartHour1(), vo.getTxtRestStartMinute1(), vo.getTxtRestEndHour1(), vo.getTxtRestEndMinute1(), rest1)) {
                return;
            }
        }
        baseDateStart = this.getRest2Start();
        baseDateEnd = this.getRest2End();
        if (baseDateStart != null && baseDateEnd != null) {
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getRest3Start(), this.getRest3End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest2, rest3};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getRest4Start(), this.getRest4End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest2, rest4};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getRest5Start(), this.getRest5End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest2, rest5};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getRest6Start(), this.getRest6End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest2, rest6};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPublic1Start(), this.getPublic1End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest2, public1};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPublic2Start(), this.getPublic2End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest2, public2};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPrivate1Start(), this.getPrivate1End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest2, private1};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPrivate2Start(), this.getPrivate2End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest2, private2};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (isDirect && !this.chkTimeValidate(startTime, endTime, vo.getTxtRestStartHour2(), vo.getTxtRestStartMinute2(), vo.getTxtRestEndHour2(), vo.getTxtRestEndMinute2(), rest2)) {
                return;
            }
        }
        baseDateStart = this.getRest3Start();
        baseDateEnd = this.getRest3End();
        if (baseDateStart != null && baseDateEnd != null) {
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getRest4Start(), this.getRest4End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest3, rest4};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getRest5Start(), this.getRest5End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest3, rest5};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getRest6Start(), this.getRest6End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest3, rest6};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPublic1Start(), this.getPublic1End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest3, public1};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPublic2Start(), this.getPublic2End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest3, public2};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPrivate1Start(), this.getPrivate1End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest3, private1};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPrivate2Start(), this.getPrivate2End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest3, private2};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (isDirect && !this.chkTimeValidate(startTime, endTime, vo.getTxtRestStartHour3(), vo.getTxtRestStartMinute3(), vo.getTxtRestEndHour3(), vo.getTxtRestEndMinute3(), rest3)) {
                return;
            }
        }
        baseDateStart = this.getRest4Start();
        baseDateEnd = this.getRest4End();
        if (baseDateStart != null && baseDateEnd != null) {
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getRest5Start(), this.getRest5End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest4, rest5};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getRest6Start(), this.getRest6End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest4, rest6};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPublic1Start(), this.getPublic1End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest4, public1};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPublic2Start(), this.getPublic2End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest4, public2};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPrivate1Start(), this.getPrivate1End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest4, private1};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPrivate2Start(), this.getPrivate2End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest4, private2};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (isDirect && !this.chkTimeValidate(startTime, endTime, vo.getTxtRestStartHour4(), vo.getTxtRestStartMinute4(), vo.getTxtRestEndHour4(), vo.getTxtRestEndMinute4(), rest4)) {
                return;
            }
        }
        baseDateStart = this.getRest5Start();
        baseDateEnd = this.getRest5End();
        if (baseDateStart != null && baseDateEnd != null) {
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getRest6Start(), this.getRest6End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest5, rest6};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPublic1Start(), this.getPublic1End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest5, public1};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPublic2Start(), this.getPublic2End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest5, public2};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPrivate1Start(), this.getPrivate1End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest5, private1};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPrivate2Start(), this.getPrivate2End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest5, private2};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (isDirect && !this.chkTimeValidate(startTime, endTime, vo.getTxtRestStartHour5(), vo.getTxtRestStartMinute5(), vo.getTxtRestEndHour5(), vo.getTxtRestEndMinute5(), rest5)) {
                return;
            }
        }
        baseDateStart = this.getRest6Start();
        baseDateEnd = this.getRest6End();
        if (baseDateStart != null && baseDateEnd != null) {
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPublic1Start(), this.getPublic1End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest6, public1};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPublic2Start(), this.getPublic2End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest6, public2};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPrivate1Start(), this.getPrivate1End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest6, private1};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPrivate2Start(), this.getPrivate2End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), rest6, private2};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (isDirect && !this.chkTimeValidate(startTime, endTime, vo.getTxtRestStartHour6(), vo.getTxtRestStartMinute6(), vo.getTxtRestEndHour6(), vo.getTxtRestEndMinute6(), rest6)) {
                return;
            }
        }
        baseDateStart = this.getPublic1Start();
        baseDateEnd = this.getPublic1End();
        if (baseDateStart != null && baseDateEnd != null) {
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPublic2Start(), this.getPublic2End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), public1, public2};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPrivate1Start(), this.getPrivate1End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), public1, private1};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPrivate2Start(), this.getPrivate2End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), public1, private2};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (isDirect && !this.chkTimeValidate(startTime, endTime, vo.getTxtPublicStartHour1(), vo.getTxtPublicStartMinute1(), vo.getTxtPublicEndHour1(), vo.getTxtPublicEndMinute1(), public1)) {
                return;
            }
        }
        baseDateStart = this.getPublic2Start();
        baseDateEnd = this.getPublic2End();
        if (baseDateStart != null && baseDateEnd != null) {
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPrivate1Start(), this.getPrivate1End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), public2, private1};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPrivate2Start(), this.getPrivate2End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), public2, private2};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (isDirect && !this.chkTimeValidate(startTime, endTime, vo.getTxtPublicStartHour2(), vo.getTxtPublicStartMinute2(), vo.getTxtPublicEndHour2(), vo.getTxtPublicEndMinute2(), public2)) {
                return;
            }
        }
        baseDateStart = this.getPrivate1Start();
        baseDateEnd = this.getPrivate1End();
        if (baseDateStart != null && baseDateEnd != null) {
            if (this.chkDuplTime(baseDateStart, baseDateEnd, this.getPrivate2Start(), this.getPrivate2End())) {
                String[] rep = new String[]{DateUtility.getStringDateAndDay((Date)baseDateStart), private1, private2};
                this.mospParams.addErrorMessage("TMW0312", rep);
                return;
            }
            if (isDirect && !this.chkTimeValidate(startTime, endTime, vo.getTxtPrivateStartHour1(), vo.getTxtPrivateStartMinute1(), vo.getTxtPrivateEndHour1(), vo.getTxtPrivateEndMinute1(), private1)) {
                return;
            }
        }
        baseDateStart = this.getPrivate2Start();
        baseDateEnd = this.getPrivate2End();
        if (baseDateStart != null && baseDateEnd != null && isDirect && !this.chkTimeValidate(startTime, endTime, vo.getTxtPrivateStartHour2(), vo.getTxtPrivateStartMinute2(), vo.getTxtPrivateEndHour2(), vo.getTxtPrivateEndMinute2(), private2)) {
            return;
        }
    }

    protected boolean chkDuplTime(Date bStart, Date bEnd, Date aStart, Date aEnd) {
        if (aStart != null && aEnd != null) {
            return bEnd.after(aStart) && bStart.before(aEnd);
        }
        return false;
    }

    protected boolean chkTimeValidate(Date startTime, Date endTime, String startHour, String startMinute, String endHour, String endMinute, String itemName) throws MospException {
        AttendanceCardVo vo = (AttendanceCardVo)this.mospParams.getVo();
        if (startTime == null || endTime == null) {
            return false;
        }
        int startTimeHour = DateUtility.getHour((Date)startTime, (Date)vo.getTargetDate());
        int startTimeMinute = DateUtility.getMinute((Date)startTime);
        int endTimeHour = DateUtility.getHour((Date)endTime, (Date)vo.getTargetDate());
        int endTimeMinute = DateUtility.getMinute((Date)endTime);
        int startTimeTime = startTimeHour * 60 + startTimeMinute;
        int endTimeTime = endTimeHour * 60 + endTimeMinute;
        int startTimeTime2 = this.getInt(startHour) * 60 + this.getInt(startMinute);
        int endTimeTime2 = this.getInt(endHour) * 60 + this.getInt(endMinute);
        if (startTimeTime2 != 0 || endTimeTime2 != 0) {
            if (startTimeTime2 < startTimeTime) {
                this.mospParams.addErrorMessage("TMW0247", new String[]{itemName});
                return false;
            }
            if (endTimeTime2 > endTimeTime) {
                this.mospParams.addErrorMessage("TMW0247", new String[]{itemName});
                return false;
            }
            if (startTimeTime2 > endTimeTime2) {
                String[] rep = new String[]{itemName, itemName};
                this.mospParams.addErrorMessage("TMW0280", rep);
                return false;
            }
        }
        return true;
    }

    protected List<AttendanceCardAddonBeanInterface> getAddonBeans() throws MospException {
        ArrayList<AttendanceCardAddonBeanInterface> addonBeans = new ArrayList<AttendanceCardAddonBeanInterface>();
        for (String[] addon : this.getCodeArray(CODE_KEY_ADDONS, false)) {
            String addonBean = addon[0];
            if (MospUtility.isEmpty((String[])new String[]{addonBean})) continue;
            AttendanceCardAddonBeanInterface bean = (AttendanceCardAddonBeanInterface)this.platform().createBean(addonBean);
            addonBeans.add(bean);
        }
        return addonBeans;
    }

    protected List<String> getAddonJsps() {
        ArrayList<String> addonJsps = new ArrayList<String>();
        for (String[] addon : this.getCodeArray(CODE_KEY_ADDONS, false)) {
            String addonJsp = addon[1];
            if (MospUtility.isEmpty((String[])new String[]{addonJsp})) continue;
            addonJsps.add(addonJsp);
        }
        return addonJsps;
    }

    protected String getTimeRecordDirectStart() {
        return (String)this.mospParams.getGeneralParam("transferredDirectStart");
    }

    protected String getTimeRecordDirectEnd() {
        return (String)this.mospParams.getGeneralParam("transferredDirectEnd");
    }

    protected void addUnregisteredNoticeMessage() {
        this.mospParams.addMessage("TMI0005", new String[0]);
    }
}

