/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.entity;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.entity.RequestEntityInterface;
import jp.mosp.time.entity.TimeDuration;
import jp.mosp.time.entity.TimeSettingEntityInterface;
import jp.mosp.time.entity.WorkTypeEntityInterface;
import jp.mosp.time.utils.TimeUtility;

public class WorkTypeEntity
implements WorkTypeEntityInterface {
    public static final String CODE_PAY_TYPE_PAY = "0";
    protected WorkTypeDtoInterface workTypeDto;
    protected List<WorkTypeItemDtoInterface> itemDtoList;

    public WorkTypeDtoInterface getWorkType() {
        return this.workTypeDto;
    }

    public void setWorkTypeDto(WorkTypeDtoInterface workTypeDto) {
        this.workTypeDto = workTypeDto;
    }

    public List<WorkTypeItemDtoInterface> getWorkTypeItemList() {
        return this.itemDtoList;
    }

    public void setWorkTypeItemList(List<WorkTypeItemDtoInterface> itemDtoList) {
        this.itemDtoList = itemDtoList;
    }

    public boolean isExist() {
        if (this.workTypeDto == null) {
            return false;
        }
        return this.workTypeDto.getWorkTypeAbbr() != null;
    }

    public String getWorkTypeAbbr() {
        if (!this.isExist()) {
            return "";
        }
        return this.workTypeDto.getWorkTypeAbbr();
    }

    public Date getStartWorkTime() throws MospException {
        return this.getItemValue("WorkStart");
    }

    public Date getEndWorkTime() throws MospException {
        return this.getItemValue("WorkEnd");
    }

    public int getWorkTime() throws MospException {
        return this.getItemMinutes("WorkTime");
    }

    public int getRestTime() throws MospException {
        return this.getItemMinutes("RestTime");
    }

    public Map<Integer, TimeDuration> getRestTimes() throws MospException {
        TreeMap<Integer, TimeDuration> restTimes = new TreeMap<Integer, TimeDuration>();
        TimeDuration rest1 = this.getTimeDuration("RestStart1", "RestEnd1");
        TimeDuration rest2 = this.getTimeDuration("RestStart2", "RestEnd2");
        TimeDuration rest3 = this.getTimeDuration("RestStart3", "RestEnd3");
        TimeDuration rest4 = this.getTimeDuration("RestStart4", "RestEnd4");
        if (rest1.isValid()) {
            restTimes.put(rest1.getStartTime(), rest1);
        }
        if (rest2.isValid()) {
            restTimes.put(rest2.getStartTime(), rest2);
        }
        if (rest3.isValid()) {
            restTimes.put(rest3.getStartTime(), rest3);
        }
        if (rest4.isValid()) {
            restTimes.put(rest4.getStartTime(), rest4);
        }
        return restTimes;
    }

    public TimeDuration getRest1Time() throws MospException {
        return this.getTimeDuration("RestStart1", "RestEnd1");
    }

    public Map<Integer, TimeDuration> getRestTimes(int startTime, int endTime, RequestEntityInterface requestEntity, Set<String> statuses) throws MospException {
        TreeMap<Integer, TimeDuration> restTimes = new TreeMap<Integer, TimeDuration>();
        if (requestEntity.isWorkOnHolidaySubstituteOff(statuses)) {
            return restTimes;
        }
        if (requestEntity.isAllHoliday(statuses) || requestEntity.isPmHoliday(statuses)) {
            return restTimes;
        }
        if (requestEntity.isAmHoliday(statuses)) {
            TimeDuration duration = this.getTimeDuration("HalfRestStart", "HalfRestEnd");
            int condition = this.getItemMinutes("HalfRest");
            if (!duration.isValid()) {
                return restTimes;
            }
            if (condition <= startTime || endTime < condition) {
                return restTimes;
            }
            restTimes.put(duration.getStartTime(), duration);
            return restTimes;
        }
        return this.getRestTimes();
    }

    public Map<Integer, TimeDuration> getRestTimes(int startTime, int endTime, RequestEntityInterface requestEntity, boolean isCompleted) throws MospException {
        Set statuses = WorkflowUtility.getCompletedOrAppliedStatuses((boolean)isCompleted);
        return this.getRestTimes(startTime, endTime, requestEntity, statuses);
    }

    public Date getRest1StartTime() throws MospException {
        return this.getItemValue("RestStart1");
    }

    public Date getRest1EndTime() throws MospException {
        return this.getItemValue("RestEnd1");
    }

    public Date getFrontStartTime() throws MospException {
        return this.getItemValue("FrontStart");
    }

    public Date getFrontEndTime() throws MospException {
        return this.getItemValue("FrontEnd");
    }

    public Date getBackStartTime() throws MospException {
        return this.getItemValue("BackStart");
    }

    public Date getBackEndTime() throws MospException {
        return this.getItemValue("BackEnd");
    }

    public boolean isDirectStart() {
        return this.isChecked("DirectStart");
    }

    public boolean isDirectEnd() {
        return this.isChecked("DirectEnd");
    }

    public boolean isNightRestExclude() {
        return this.isPreliminaryTheValue("ExcludeNightRest", String.valueOf(0));
    }

    public Date getShort1StartTime() throws MospException {
        return this.getItemValue("Short1Start");
    }

    public Date getShort1EndTime() throws MospException {
        return this.getItemValue("Short1End");
    }

    public boolean isShort1TypePay() {
        return this.isPreliminaryTheValue("Short1Start", CODE_PAY_TYPE_PAY);
    }

    public boolean isShort1TimeSet() throws MospException {
        return this.isItemValueSet("Short1Start", "Short1End");
    }

    public Date getShort2StartTime() throws MospException {
        return this.getItemValue("Short2Start");
    }

    public Date getShort2EndTime() throws MospException {
        return this.getItemValue("Short2End");
    }

    public boolean isShort2TypePay() throws MospException {
        return this.isPreliminaryTheValue("Short2Start", CODE_PAY_TYPE_PAY);
    }

    public boolean isShort2TimeSet() throws MospException {
        return this.isItemValueSet("Short2Start", "Short2End");
    }

    public boolean isWorkTypeForWork() {
        return !this.getWorkTypeCode().isEmpty() && !TimeUtility.isHoliday((String)this.getWorkTypeCode());
    }

    public boolean isAutoBeforeOvertimeAvailable() {
        return this.isPreliminaryTheValue("AutoBefOverWork", 0);
    }

    public TimeDuration getRegularTime(RequestEntityInterface requestEntity, boolean isCompleted) throws MospException {
        if (requestEntity.isAllHoliday(isCompleted)) {
            return TimeDuration.getInvalid();
        }
        if (requestEntity.isAmHoliday(isCompleted)) {
            return this.getFirstHalfOffRegularTime();
        }
        if (requestEntity.isPmHoliday(isCompleted)) {
            return this.getSecondHalfOffRegularTime();
        }
        if (requestEntity.isWorkOnHolidaySubstituteOff(isCompleted)) {
            return requestEntity.getWorkOnHolidayTime(isCompleted);
        }
        return this.getRegularTime();
    }

    public TimeDuration getRegularAndHourlyHolidayTime(RequestEntityInterface requestEntity, boolean isCompleted) throws MospException {
        TimeDuration regularAndHourlyHoliday;
        TimeDuration regularTime = this.getRegularTime(requestEntity, isCompleted);
        int startTime = regularTime.getStartTime();
        int endTime = regularTime.getEndTime();
        TimeDuration firstTime = requestEntity.getHourlyHolidayFirstSequence();
        TimeDuration lastTime = requestEntity.getHourlyHolidayLastSequence();
        if (firstTime.isValid() && firstTime.getStartTime() == startTime) {
            startTime = firstTime.getEndTime();
        }
        if (lastTime.isValid() && lastTime.getEndTime() == endTime) {
            endTime = lastTime.getStartTime();
        }
        if ((regularAndHourlyHoliday = TimeDuration.getInstance((int)startTime, (int)endTime)).isValid()) {
            return regularAndHourlyHoliday;
        }
        return regularTime;
    }

    public TimeDuration getRegularAndShortTime(RequestEntityInterface requestEntity, boolean isCompleted) throws MospException {
        TimeDuration regularTime = this.getRegularTime(requestEntity, isCompleted);
        TimeDuration short1Time = this.getShort1Time(requestEntity, isCompleted);
        TimeDuration short2Time = this.getShort2Time(requestEntity, isCompleted);
        int startTime = regularTime.getStartTime();
        int endTime = regularTime.getEndTime();
        if (short1Time.isValid()) {
            startTime = short1Time.getEndTime();
        }
        if (short2Time.isValid()) {
            endTime = short2Time.getStartTime();
        }
        return TimeDuration.getInstance((int)startTime, (int)endTime);
    }

    public TimeDuration getRegularTime() throws MospException {
        return this.getTimeDuration("WorkStart", "WorkEnd");
    }

    protected TimeDuration getFirstHalfOffRegularTime() throws MospException {
        return this.getTimeDuration("BackStart", "BackEnd");
    }

    protected TimeDuration getSecondHalfOffRegularTime() throws MospException {
        return this.getTimeDuration("FrontStart", "FrontEnd");
    }

    protected TimeDuration getBitweenTime() throws MospException {
        return this.getTimeDuration("FrontEnd", "BackStart");
    }

    protected TimeDuration getShort1Time() throws MospException {
        return this.getTimeDuration("Short1Start", "Short1End");
    }

    protected TimeDuration getShort2Time() throws MospException {
        return this.getTimeDuration("Short2Start", "Short2End");
    }

    protected TimeDuration getShort1Time(RequestEntityInterface requestEntity, boolean isCompleted) throws MospException {
        if (!requestEntity.isAmHoliday(isCompleted)) {
            return this.getShort1Time();
        }
        return TimeDuration.getInvalid();
    }

    public TimeDuration getShort1PayTime(RequestEntityInterface requestEntity, boolean isCompleted) throws MospException {
        if (this.isShort1TypePay()) {
            return this.getShort1Time(requestEntity, isCompleted);
        }
        return TimeDuration.getInvalid();
    }

    public TimeDuration getShort1UnpayTime(RequestEntityInterface requestEntity, boolean isCompleted) throws MospException {
        if (this.isShort1TypePay()) {
            return TimeDuration.getInvalid();
        }
        return this.getShort1Time(requestEntity, isCompleted);
    }

    protected TimeDuration getShort2Time(RequestEntityInterface requestEntity, boolean isCompleted) throws MospException {
        if (!requestEntity.isPmHoliday(isCompleted)) {
            return this.getShort2Time();
        }
        return TimeDuration.getInvalid();
    }

    public TimeDuration getShort2PayTime(RequestEntityInterface requestEntity, boolean isCompleted) throws MospException {
        if (this.isShort2TypePay()) {
            return this.getShort2Time(requestEntity, isCompleted);
        }
        return TimeDuration.getInvalid();
    }

    public TimeDuration getShort2UnpayTime(RequestEntityInterface requestEntity, boolean isCompleted) throws MospException {
        if (this.isShort2TypePay()) {
            return TimeDuration.getInvalid();
        }
        return this.getShort2Time(requestEntity, isCompleted);
    }

    public Map<Integer, TimeDuration> getShortUnpayTimes() throws MospException {
        TimeDuration short1Unpay = this.getShort1Time();
        if (this.isShort1TypePay()) {
            short1Unpay = TimeDuration.getInvalid();
        }
        TimeDuration short2Unpay = this.getShort2Time();
        if (this.isShort2TypePay()) {
            short2Unpay = TimeDuration.getInvalid();
        }
        TreeMap<Integer, TimeDuration> shortUnpayTimes = new TreeMap();
        shortUnpayTimes = TimeUtility.mergeDurations(shortUnpayTimes, (TimeDuration)short1Unpay);
        shortUnpayTimes = TimeUtility.mergeDurations(shortUnpayTimes, (TimeDuration)short2Unpay);
        return shortUnpayTimes;
    }

    public TimeDuration getBeforeOvertime(TimeSettingEntityInterface timeSettingEntity, RequestEntityInterface requestEntity, boolean isCompleted) throws MospException {
        if (this.isShort1TimeSet() && !this.isShort1TypePay() && !requestEntity.isAmHoliday(isCompleted)) {
            return TimeDuration.getInvalid();
        }
        int beforeOvertime = requestEntity.getOvertimeMinutesBeforeWork(isCompleted);
        if (requestEntity.isAmHoliday(isCompleted)) {
            return this.getBitweenOvertime(beforeOvertime, true);
        }
        if (this.isAutoBeforeOvertimeAvailable() && timeSettingEntity.isActualBeforeOvertimeAvailable()) {
            beforeOvertime = Integer.MAX_VALUE;
        }
        if (beforeOvertime == 0) {
            return TimeDuration.getInvalid();
        }
        int regularStartTime = this.getRegularTime(requestEntity, isCompleted).getStartTime();
        int startTime = TimeUtility.getAttendanceMinutes((int)(regularStartTime - beforeOvertime));
        return TimeDuration.getInstance((int)startTime, (int)regularStartTime);
    }

    public TimeDuration getBitweenAfterOvertime(RequestEntityInterface requestEntity, boolean isCompleted) throws MospException {
        if (!requestEntity.isPmHoliday(isCompleted)) {
            return TimeDuration.getInvalid();
        }
        int afterOvertime = requestEntity.getOvertimeMinutesAfterWork(isCompleted);
        return this.getBitweenOvertime(afterOvertime, false);
    }

    protected TimeDuration getBitweenOvertime(int overtime, boolean isAmHoliday) throws MospException {
        if (overtime == 0) {
            return TimeDuration.getInvalid();
        }
        TimeDuration bitweenTime = this.getBitweenTime();
        if (bitweenTime.getMinutes() < overtime) {
            return bitweenTime;
        }
        int startTime = bitweenTime.getStartTime();
        int endTime = bitweenTime.getEndTime();
        if (isAmHoliday) {
            startTime = TimeUtility.getAttendanceMinutes((int)(endTime - overtime));
        } else {
            endTime = TimeUtility.getAttendanceMinutes((int)(startTime + overtime));
        }
        return TimeDuration.getInstance((int)startTime, (int)endTime);
    }

    public int getOvertimeBeforeRest() throws MospException {
        return this.getItemMinutes("OverBefore");
    }

    public int getWorkTimeBeforeOvertimeBeforeRest(RequestEntityInterface requestEntity, int legalWorkTime, boolean isCompleted) throws MospException {
        int restStart = this.getWorkTime();
        if (requestEntity.isAmHoliday(isCompleted)) {
            restStart = this.getFirstHalfOffRegularTime().getMinutes();
        }
        return restStart < legalWorkTime ? restStart : legalWorkTime;
    }

    public int getWorkTimeBeforeOvertime(RequestEntityInterface requestEntity, int legalWorkTime, boolean isCompleted) throws MospException {
        int restStart = this.getWorkTime();
        if (requestEntity.isAmHoliday(isCompleted)) {
            restStart = this.getFirstHalfOffRegularTime().getMinutes();
        }
        if (requestEntity.isPmHoliday(isCompleted)) {
            restStart = this.getSecondHalfOffRegularTime().getMinutes();
        }
        return restStart < legalWorkTime ? restStart : legalWorkTime;
    }

    public boolean isOvertimeRestValid() throws MospException {
        return this.getOvertimeRestPer() > 0 && this.getOvertimeRest() > 0;
    }

    public int getOvertimeRestPer() throws MospException {
        return this.getItemMinutes("OverPer");
    }

    public int getOvertimeRest() throws MospException {
        return this.getItemMinutes("OverRest");
    }

    public Date getStartTime(RequestEntityInterface requestEntity, Set<String> statuses) throws MospException {
        Date targetDate = requestEntity.getTargetDate();
        int overtimeMinutes = requestEntity.getOvertimeMinutesBeforeWork(statuses);
        Date workOnHolidayStartTime = requestEntity.getWorkOnHolidayStartTime(statuses);
        if (requestEntity.isAllHoliday(statuses)) {
            return null;
        }
        if (requestEntity.isAmHoliday(statuses)) {
            Date frontEndTime;
            Date startTime = this.getBackStartTime();
            if ((startTime = DateUtility.addMinute((Date)startTime, (int)(-overtimeMinutes))).before(frontEndTime = this.getFrontEndTime())) {
                startTime = frontEndTime;
            }
            return TimeUtility.getDateTime((Date)targetDate, (Date)startTime);
        }
        if (workOnHolidayStartTime != null) {
            return workOnHolidayStartTime;
        }
        List holidayTimeList = requestEntity.getHourlyHolidayFirstSequenceTimes(statuses);
        if (this.isShort1TimeSet()) {
            Date short1EndTime = TimeUtility.getDateTime((Date)targetDate, (Date)this.getShort1EndTime());
            if (!holidayTimeList.isEmpty() && ((Date)holidayTimeList.get(0)).compareTo(short1EndTime) == 0) {
                return (Date)holidayTimeList.get(1);
            }
            if (!this.isShort1TypePay()) {
                return short1EndTime;
            }
        }
        Date startTime = TimeUtility.getDateTime((Date)targetDate, (Date)this.getStartWorkTime());
        if (!holidayTimeList.isEmpty() && ((Date)holidayTimeList.get(0)).compareTo(startTime) == 0) {
            return (Date)holidayTimeList.get(1);
        }
        return startTime;
    }

    public Date getStartTime(RequestEntityInterface requestEntity) throws MospException {
        return this.getStartTime(requestEntity, WorkflowUtility.getAppliedStatuses());
    }

    public Date getEndTime(RequestEntityInterface requestEntity, Set<String> statuses) throws MospException {
        Date targetDate = requestEntity.getTargetDate();
        int overtimeMinutes = requestEntity.getOvertimeMinutesAfterWork(statuses);
        Date workOnHolidayEndTime = requestEntity.getWorkOnHolidayEndTime(statuses);
        if (requestEntity.isAllHoliday(statuses)) {
            return null;
        }
        if (requestEntity.isPmHoliday(statuses)) {
            Date backStartTime;
            Date endTime = this.getFrontEndTime();
            if ((endTime = DateUtility.addMinute((Date)endTime, (int)overtimeMinutes)).after(backStartTime = this.getBackStartTime())) {
                endTime = backStartTime;
            }
            return TimeUtility.getDateTime((Date)targetDate, (Date)endTime);
        }
        if (workOnHolidayEndTime != null) {
            return workOnHolidayEndTime;
        }
        List holidayTimeList = requestEntity.getHourlyHolidayLastSequenceTimes(statuses);
        if (this.isShort2TimeSet()) {
            Date short2StartTime = TimeUtility.getDateTime((Date)targetDate, (Date)this.getShort2StartTime());
            if (!holidayTimeList.isEmpty() && ((Date)holidayTimeList.get(1)).compareTo(short2StartTime) == 0) {
                return (Date)holidayTimeList.get(0);
            }
            if (!this.isShort2TypePay()) {
                return short2StartTime;
            }
        }
        Date endTime = TimeUtility.getDateTime((Date)targetDate, (Date)this.getEndWorkTime());
        if (!holidayTimeList.isEmpty() && ((Date)holidayTimeList.get(1)).compareTo(endTime) == 0) {
            return (Date)holidayTimeList.get(0);
        }
        return endTime;
    }

    public Date getEndTime(RequestEntityInterface requestEntity) throws MospException {
        return this.getEndTime(requestEntity, WorkflowUtility.getAppliedStatuses());
    }

    protected String getWorkTypeCode() {
        if (!this.isExist()) {
            return "";
        }
        return this.workTypeDto.getWorkTypeCode();
    }

    public boolean isWorkOnLegal() {
        return TimeUtility.isWorkOnLegalHoliday((String)this.getWorkTypeCode());
    }

    public boolean isWorkOnPrescribed() {
        return TimeUtility.isWorkOnPrescribedHoliday((String)this.getWorkTypeCode());
    }

    public boolean isWorkOnHoliday() {
        return this.isWorkOnLegal() || this.isWorkOnPrescribed();
    }

    public boolean isLegal() {
        return TimeUtility.isLegalHoliday((String)this.getWorkTypeCode()) || this.isWorkOnLegal();
    }

    public boolean isPrescribed() {
        return TimeUtility.isPrescribedHoliday((String)this.getWorkTypeCode()) || this.isWorkOnPrescribed();
    }

    public boolean isLegalOrPrescribed() {
        return this.isLegal() || this.isPrescribed();
    }

    public boolean isWorkDay() {
        return !this.isLegalOrPrescribed();
    }

    public Date getActivateDate() {
        if (!this.isExist()) {
            return null;
        }
        return this.workTypeDto.getActivateDate();
    }

    public void setActivateDate(Date activateDate) {
    }

    public Date getItemValue(String workTypeItemCode) throws MospException {
        return this.getItemValue(workTypeItemCode, false);
    }

    public Date getItemValue(String workTypeItemCode, boolean isNullAvailable) throws MospException {
        WorkTypeItemDtoInterface dto = this.getWorkTypeItem(workTypeItemCode);
        if (dto == null) {
            return DateUtility.getDefaultTimeOrNull((boolean)isNullAvailable);
        }
        if (dto.getWorkTypeItemValue() == null) {
            return DateUtility.getDefaultTimeOrNull((boolean)isNullAvailable);
        }
        return new Date(dto.getWorkTypeItemValue().getTime());
    }

    protected int getItemMinutes(String workTypeItemCode) throws MospException {
        WorkTypeItemDtoInterface dto = this.getWorkTypeItem(workTypeItemCode);
        if (dto == null) {
            return 0;
        }
        if (dto.getWorkTypeItemValue() == null) {
            return 0;
        }
        return TimeUtility.getMinutes((Date)dto.getWorkTypeItemValue());
    }

    public String getItemPreliminary(String workTypeItemCode) {
        WorkTypeItemDtoInterface dto = this.getWorkTypeItem(workTypeItemCode);
        if (dto == null) {
            return "";
        }
        return dto.getPreliminary();
    }

    public WorkTypeItemDtoInterface getWorkTypeItem(String workTypeItemCode) {
        for (WorkTypeItemDtoInterface dto : this.itemDtoList) {
            if (!dto.getWorkTypeItemCode().equals(workTypeItemCode)) continue;
            return dto;
        }
        return null;
    }

    protected boolean isChecked(String workTypeItemCode) {
        return this.isPreliminaryTheValue(workTypeItemCode, "1");
    }

    protected boolean isPreliminaryTheValue(String workTypeItemCode, String theValue) {
        String preliminary = this.getItemPreliminary(workTypeItemCode);
        if (preliminary.isEmpty()) {
            return false;
        }
        return preliminary.equals(theValue);
    }

    protected boolean isPreliminaryTheValue(String workTypeItemCode, int theValue) {
        return this.isPreliminaryTheValue(workTypeItemCode, String.valueOf(theValue));
    }

    protected boolean isItemValueSet(String fromItemCode, String toItemCode) throws MospException {
        Date defaultTime = DateUtility.getDefaultTime();
        return !this.getItemValue(fromItemCode).equals(defaultTime) || !this.getItemValue(toItemCode).equals(defaultTime);
    }

    protected TimeDuration getTimeDuration(String startItemCode, String endItemCode) throws MospException {
        int endTime;
        int startTime = this.getItemMinutes(startItemCode);
        TimeDuration duration = TimeDuration.getInstance((int)startTime, (int)(endTime = this.getItemMinutes(endItemCode)));
        if (!duration.isValid()) {
            return TimeDuration.getInvalid();
        }
        return duration;
    }
}

