/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.entity;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.time.dto.settings.LimitStandardDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.entity.TimeSettingEntityInterface;
import jp.mosp.time.utils.TimeUtility;

public class TimeSettingEntity
implements TimeSettingEntityInterface {
    protected TimeSettingDtoInterface dto;
    protected Map<String, LimitStandardDtoInterface> limits = new HashMap();

    public TimeSettingDtoInterface getTimeSettingDto() {
        return this.dto;
    }

    public LimitStandardDtoInterface getLimitStandardDto(String term) {
        return (LimitStandardDtoInterface)this.limits.get(term);
    }

    public void setTimeSettingDto(TimeSettingDtoInterface dto) {
        this.dto = dto;
    }

    public void setLimitStandardDtos(Map<String, LimitStandardDtoInterface> limits) {
        this.limits = limits;
    }

    public String getWorkSettingCode() {
        if (!this.isExist()) {
            return "";
        }
        return this.dto.getWorkSettingCode();
    }

    public Date getActivateDate() {
        if (!this.isExist()) {
            return null;
        }
        return this.dto.getActivateDate();
    }

    public boolean isExist() {
        return this.dto != null;
    }

    public boolean isLimitStandardExist(String term) {
        return this.getLimitStandardDto(term) != null;
    }

    public int getPrescribedWorkTime() throws MospException {
        if (!this.isExist()) {
            return 0;
        }
        return TimeUtility.getMinutes((Date)this.dto.getGeneralWorkTime());
    }

    public int getStartWeek() {
        if (!this.isExist()) {
            return 0;
        }
        return this.dto.getStartWeek();
    }

    public int getStartMonthOfYear() {
        if (!this.isExist()) {
            return 1;
        }
        int startMonth = this.dto.getStartYear();
        if (startMonth == 0) {
            return 1;
        }
        return startMonth;
    }

    public Date getStartDayTime() throws MospException {
        if (!this.isExist()) {
            return DateUtility.getDefaultTime();
        }
        return this.dto.getStartDayTime();
    }

    public int getSubHolidayLimitMonth() {
        if (!this.isExist()) {
            return 0;
        }
        return this.dto.getSubHolidayLimitMonth();
    }

    public int getSubHolidayLimitDay() {
        if (!this.isExist()) {
            return 0;
        }
        return this.dto.getSubHolidayLimitDate();
    }

    public Date getSubHolidayLimitDate(SubHolidayDtoInterface subHolidayDto) throws MospException {
        if (MospUtility.isEmpty((Object[])new Object[]{subHolidayDto})) {
            return null;
        }
        return DateUtility.addMonthAndDay((Date)subHolidayDto.getWorkDate(), (int)this.getSubHolidayLimitMonth(), (int)this.getSubHolidayLimitDay());
    }

    public int roundDailyStart(int start) {
        return this.getRoundMinute(start, this.dto.getRoundDailyStart(), this.dto.getRoundDailyStartUnit());
    }

    public int roundDailyEnd(int end) {
        return this.getRoundMinute(end, this.dto.getRoundDailyEnd(), this.dto.getRoundDailyEndUnit());
    }

    public int roundDailyWork(int work) {
        return this.getRoundMinute(work, this.dto.getRoundDailyWork(), this.dto.getRoundDailyTimeWork());
    }

    public int roundDailyRestStart(int restStart) {
        return this.getRoundMinute(restStart, this.dto.getRoundDailyRestStart(), this.dto.getRoundDailyRestStartUnit());
    }

    public int roundDailyRestEnd(int restEnd) {
        return this.getRoundMinute(restEnd, this.dto.getRoundDailyRestEnd(), this.dto.getRoundDailyRestEndUnit());
    }

    public int roundDailyRest(int rest) {
        return this.getRoundMinute(rest, this.dto.getRoundDailyRestTime(), this.dto.getRoundDailyRestTimeUnit());
    }

    public int roundDailyGoOutStart(int goOutStart, int goOutType) {
        if (MospUtility.isEqual((Object)goOutType, (Object)1)) {
            return this.getRoundMinute(goOutStart, this.dto.getRoundDailyPublicStart(), this.dto.getRoundDailyPublicStartUnit());
        }
        if (MospUtility.isEqual((Object)goOutType, (Object)2)) {
            return this.getRoundMinute(goOutStart, this.dto.getRoundDailyPrivateStart(), this.dto.getRoundDailyPrivateStartUnit());
        }
        return goOutStart;
    }

    public int roundDailyGoOutEnd(int goOutEnd, int goOutType) {
        if (MospUtility.isEqual((Object)goOutType, (Object)1)) {
            return this.getRoundMinute(goOutEnd, this.dto.getRoundDailyPublicEnd(), this.dto.getRoundDailyPublicEndUnit());
        }
        if (MospUtility.isEqual((Object)goOutType, (Object)2)) {
            return this.getRoundMinute(goOutEnd, this.dto.getRoundDailyPrivateEnd(), this.dto.getRoundDailyPrivateEndUnit());
        }
        return goOutEnd;
    }

    public int roundDailyLate(int late) {
        return this.getRoundMinute(late, this.dto.getRoundDailyLate(), this.dto.getRoundDailyLateUnit());
    }

    public int roundDailyLeaveEarly(int leaveEarly) {
        return this.getRoundMinute(leaveEarly, this.dto.getRoundDailyLeaveEarly(), this.dto.getRoundDailyLeaveEarlyUnit());
    }

    public int roundDailyDecrease(int decrease) {
        return this.getRoundMinute(decrease, this.dto.getRoundDailyDecreaseTime(), this.dto.getRoundDailyDecreaseTimeUnit());
    }

    public int roundDailyShortUnpaid(int decrease) {
        return this.getRoundMinute(decrease, this.dto.getRoundDailyShortUnpaid(), this.dto.getRoundDailyShortUnpaidUnit());
    }

    public boolean isOneWeekExist() {
        return this.isLimitStandardExist("week1");
    }

    public boolean isOneMonthExist() {
        return this.isLimitStandardExist("month1");
    }

    public int getOneWeekLimit() {
        return this.getLimit("week1");
    }

    public int getOneMonthLimit() {
        return this.getLimit("month1");
    }

    public int getOneMonthAttention() {
        return this.getAttention("month1");
    }

    public int getOneMonthWarning() {
        return this.getWarning("month1");
    }

    public String getOneWeekLimitHours() {
        return this.getLimitHours("week1");
    }

    public String getOneWeekLimitMinutes() {
        return this.getLimitMinutes("week1");
    }

    public String getOneMonthLimitHours() {
        return this.getLimitHours("month1");
    }

    public String getOneMonthLimitMinutes() {
        return this.getLimitMinutes("month1");
    }

    public String getOneMonthAttentionHours() {
        return this.getAttentionHours("month1");
    }

    public String getOneMonthAttentionMinutes() {
        return this.getAttentionMinutes("month1");
    }

    public String getOneMonthWarningHours() {
        return this.getWarningHours("month1");
    }

    public String getOneMonthWarningMinutes() {
        return this.getWarningMinutes("month1");
    }

    public int getLimit(String term) {
        return this.getLimit(term, 0);
    }

    public int getLimit(String term, int defaultValue) {
        LimitStandardDtoInterface dto = this.getLimitStandardDto(term);
        if (dto == null) {
            return defaultValue;
        }
        return dto.getLimitTime();
    }

    public String getLimitHours(String term) {
        return this.getHours(this.getLimit(term));
    }

    public String getLimitMinutes(String term) {
        return this.getMinutes(this.getLimit(term));
    }

    public int getAttention(String term) {
        LimitStandardDtoInterface dto = this.getLimitStandardDto(term);
        if (dto == null) {
            return 0;
        }
        return dto.getAttentionTime();
    }

    public String getAttentionHours(String term) {
        return this.getHours(this.getAttention(term));
    }

    public String getAttentionMinutes(String term) {
        return this.getMinutes(this.getAttention(term));
    }

    public int getWarning(String term) {
        LimitStandardDtoInterface dto = this.getLimitStandardDto(term);
        if (dto == null) {
            return 0;
        }
        return dto.getWarningTime();
    }

    public String getWarningHours(String term) {
        return this.getHours(this.getWarning(term));
    }

    public String getWarningMinutes(String term) {
        return this.getMinutes(this.getWarning(term));
    }

    public int getOverLimit(String term, int value) {
        int limit = this.getLimit(term);
        if (limit == 0) {
            return 0;
        }
        int overLimit = value - limit;
        return overLimit < 0 ? 0 : overLimit;
    }

    public boolean isOverLimit(String term, int value) {
        return this.getOverLimit(term, value) > 0;
    }

    public int getOverAttention(String term, int value) {
        int attention = this.getAttention(term);
        if (attention == 0) {
            return 0;
        }
        int overAttention = value - attention;
        return overAttention < 0 ? 0 : overAttention;
    }

    public boolean isOverAttention(String term, int value) {
        return this.getOverAttention(term, value) > 0;
    }

    public int getOverWarning(String term, int value) {
        int warning = this.getWarning(term);
        if (warning == 0) {
            return 0;
        }
        int overWarning = value - warning;
        return overWarning < 0 ? 0 : overWarning;
    }

    public boolean isOverWarning(String term, int value) {
        return this.getOverWarning(term, value) > 0;
    }

    public String getStyle(String term, int value) {
        if (!this.isLimitStandardExist(term)) {
            return "\u3000";
        }
        if (this.isOverWarning(term, value)) {
            return this.getWarningStyle();
        }
        if (this.isOverAttention(term, value)) {
            return this.getAttentionStyle();
        }
        return "\u3000";
    }

    public String getOneMonthStyle(int value) {
        return this.getStyle("month1", value);
    }

    public boolean isScheduledTimeAvailable() {
        return this.isExist() && PlatformUtility.isActivate((int)this.dto.getUseScheduledTime());
    }

    public boolean isActualBeforeOvertimeAvailable() {
        return this.isExist() && PlatformUtility.isActivate((int)this.dto.getBeforeOvertimeFlag());
    }

    public boolean isPrescribedHolidayBasedOnCalendar() {
        return this.isExist() && this.dto.getSpecificHolidayHandling() == 2;
    }

    public int getSubHolidayAllNorm() throws MospException {
        if (!this.isExist()) {
            return Integer.MAX_VALUE;
        }
        return TimeUtility.getMinutes((Date)this.dto.getSubHolidayAllNorm());
    }

    public int getSubHolidayHalfNorm() throws MospException {
        if (!this.isExist()) {
            return Integer.MAX_VALUE;
        }
        return TimeUtility.getMinutes((Date)this.dto.getSubHolidayHalfNorm());
    }

    protected String getHours(int time) {
        if (time == 0) {
            return "";
        }
        return String.valueOf(TimeUtility.getHours((int)time));
    }

    protected String getMinutes(int time) {
        if (time == 0) {
            return "";
        }
        return String.valueOf(TimeUtility.getMinutes((int)time));
    }

    protected String getAttentionStyle() {
        return "style=\"color: darkorange\"";
    }

    protected String getWarningStyle() {
        return "style=\"color: red\"";
    }

    protected int getRoundMinute(int time, int type, int unit) {
        return TimeUtility.getRoundMinute((int)time, (int)type, (int)unit);
    }
}

