/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.entity;

import java.text.NumberFormat;
import java.util.Map;
import java.util.TreeMap;
import jp.mosp.time.utils.TimeUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class TimeDuration
implements Cloneable {
    private int startTime;
    private int endTime;

    private TimeDuration() {
    }

    private TimeDuration(int startTime, int endTime) {
        this.startTime = startTime < 0 ? 0 : startTime;
        this.endTime = endTime < 0 ? 0 : endTime;
    }

    public static TimeDuration getInstance(int startTime, int endTime) {
        TimeDuration duration = new TimeDuration(startTime, endTime);
        if (!duration.isValid()) {
            return TimeDuration.getInvalid();
        }
        return duration;
    }

    public static TimeDuration getInvalid() {
        return new TimeDuration(0, 0);
    }

    public boolean isValid() {
        return this.startTime < this.endTime;
    }

    public boolean isEqual(TimeDuration duration) {
        if (duration == null) {
            return false;
        }
        return this.startTime == duration.startTime && this.endTime == duration.getEndTime();
    }

    public boolean isBefore(int time) {
        return this.endTime < time;
    }

    public boolean isAfter(int time) {
        return time < this.startTime;
    }

    public boolean isContain(int time) {
        return this.isContain(time, true, true);
    }

    public boolean isContain(int time, boolean isStartInclude, boolean isEndInclude) {
        if (!this.isValid()) {
            return false;
        }
        if (time == this.startTime && isStartInclude) {
            return true;
        }
        if (time == this.endTime && isEndInclude) {
            return true;
        }
        return this.startTime < time && time < this.endTime;
    }

    public boolean isContain(TimeDuration duration) {
        TimeDuration overlap = this.getOverlap(duration);
        if (!overlap.isValid()) {
            return false;
        }
        return overlap.isEqual(duration);
    }

    public TimeDuration getBeforeTime(int time) {
        if (this.isBefore(time)) {
            return TimeDuration.getInstance((int)this.startTime, (int)this.endTime);
        }
        if (this.isContain(time)) {
            return TimeDuration.getInstance((int)this.startTime, (int)time);
        }
        return TimeDuration.getInvalid();
    }

    public TimeDuration getAfterTime(int time) {
        if (this.isBefore(time)) {
            return TimeDuration.getInvalid();
        }
        if (this.isContain(time)) {
            return TimeDuration.getInstance((int)time, (int)this.endTime);
        }
        return TimeDuration.getInstance((int)this.startTime, (int)this.endTime);
    }

    public TimeDuration getOverlap(TimeDuration duration) {
        if (!this.isValid() || !duration.isValid()) {
            return TimeDuration.getInvalid();
        }
        int overlapStart = this.startTime;
        int overlapEnd = this.endTime;
        if (overlapStart < duration.getStartTime()) {
            overlapStart = duration.getStartTime();
        }
        if (duration.getEndTime() < overlapEnd) {
            overlapEnd = duration.getEndTime();
        }
        return TimeDuration.getInstance((int)overlapStart, (int)overlapEnd);
    }

    public boolean isOverlap(TimeDuration duration) {
        return this.getOverlap(duration).isValid();
    }

    public Map<Integer, TimeDuration> getOverlap(Map<Integer, TimeDuration> durations) {
        TreeMap<Integer, TimeDuration> overlaps = new TreeMap<Integer, TimeDuration>();
        for (TimeDuration duration : TimeUtility.combineDurations(durations).values()) {
            TimeDuration overlap = this.getOverlap(duration);
            if (!overlap.isValid()) continue;
            overlaps.put(overlap.startTime, overlap);
        }
        return TimeUtility.combineDurations(overlaps);
    }

    public int getOverlapMinutes(Map<Integer, TimeDuration> durations) {
        int overlap = 0;
        for (TimeDuration duration : durations.values()) {
            overlap += this.getOverlap(duration).getMinutes();
        }
        return overlap;
    }

    public Map<Integer, TimeDuration> getNotOverlap(Map<Integer, TimeDuration> durations) {
        TreeMap<Integer, TimeDuration> notOverlaps = new TreeMap<Integer, TimeDuration>();
        int currentStart = this.startTime;
        for (TimeDuration duration : TimeUtility.combineDurations(durations).values()) {
            int targetStart = duration.getStartTime();
            int targetEnd = duration.getEndTime();
            if (targetEnd <= currentStart || this.endTime <= targetStart) continue;
            if (targetStart <= currentStart && this.endTime <= targetEnd) {
                currentStart = targetEnd;
                break;
            }
            if (targetStart <= currentStart && targetEnd < this.endTime) {
                currentStart = targetEnd;
                continue;
            }
            if (currentStart < targetStart && targetEnd < this.endTime) {
                notOverlaps.put(currentStart, TimeDuration.getInstance((int)currentStart, (int)targetStart));
                currentStart = targetEnd;
                continue;
            }
            if (currentStart >= targetStart || this.endTime > targetEnd) continue;
            notOverlaps.put(currentStart, TimeDuration.getInstance((int)currentStart, (int)targetStart));
            currentStart = targetEnd;
            break;
        }
        notOverlaps.put(currentStart, TimeDuration.getInstance((int)currentStart, (int)this.endTime));
        return TimeUtility.combineDurations(notOverlaps);
    }

    public Map<Integer, TimeDuration> getNotOverlap(TimeDuration duration) {
        TreeMap<Integer, TimeDuration> durations = new TreeMap<Integer, TimeDuration>();
        durations.put(duration.getStartTime(), duration);
        return this.getNotOverlap(durations);
    }

    public boolean isLink(TimeDuration duration) {
        return this.startTime == duration.endTime || this.endTime == duration.startTime;
    }

    public Map<Integer, TimeDuration> getPostponed(Map<Integer, TimeDuration> durations) {
        TreeMap<Integer, TimeDuration> postponed = new TreeMap<Integer, TimeDuration>();
        postponed.putAll(this.getNotOverlap(durations));
        int remainTime = this.getMinutes() - TimeUtility.getMinutes(postponed);
        if (remainTime == 0) {
            return postponed;
        }
        int overlap = TimeUtility.getMinutes((Map)this.getOverlap(durations));
        int durationsEndTime = TimeUtility.getDuration(durations).getEndTime();
        if (durationsEndTime < this.endTime) {
            return TimeUtility.mergeDurations(postponed, (TimeDuration)TimeDuration.getInstance((int)this.endTime, (int)(this.endTime + remainTime)));
        }
        Map gaps = TimeUtility.getGap(durations);
        postponed.putAll(TimeUtility.getReachTimes((Map)gaps, (int)overlap));
        remainTime = this.getMinutes() - TimeUtility.getMinutes(postponed);
        if (remainTime == 0) {
            return postponed;
        }
        int startTime = TimeUtility.getDuration(durations).getEndTime();
        int endTime = startTime + remainTime;
        postponed.put(startTime, TimeDuration.getInstance((int)startTime, (int)endTime));
        return postponed;
    }

    public int getMinutes() {
        if (!this.isValid()) {
            return 0;
        }
        return this.endTime - this.startTime;
    }

    public int getStartTime() {
        return this.startTime;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public TimeDuration clone() {
        TimeDuration clone = null;
        try {
            clone = (TimeDuration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            clone = TimeDuration.getInstance((int)this.startTime, (int)this.endTime);
        }
        return clone;
    }

    public String toString() {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMinimumIntegerDigits(2);
        StringBuilder sb = new StringBuilder();
        sb.append(format.format(TimeUtility.getHours((int)this.startTime)));
        sb.append(":");
        sb.append(format.format(TimeUtility.getMinutes((int)this.startTime)));
        sb.append("-");
        sb.append(format.format(TimeUtility.getHours((int)this.endTime)));
        sb.append(":");
        sb.append(format.format(TimeUtility.getMinutes((int)this.endTime)));
        return sb.toString();
    }
}

