/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.mosp.framework.utils.CapsuleUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.dto.base.WorkflowNumberDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.dto.base.HolidayRangeDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.entity.RequestEntityInterface;
import jp.mosp.time.entity.TimeDuration;
import jp.mosp.time.utils.TimeRequestUtility;
import jp.mosp.time.utils.TimeUtility;

public class RequestEntity
implements RequestEntityInterface {
    protected String personalId;
    protected Date targetDate;
    protected List<HolidayRequestDtoInterface> holidayRequestList;
    protected List<OvertimeRequestDtoInterface> overtimeRequestList;
    protected List<SubstituteDtoInterface> substituteList;
    protected List<SubHolidayRequestDtoInterface> subHolidayRequestList;
    protected WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto;
    protected DifferenceRequestDtoInterface differenceRequestDto;
    protected WorkTypeChangeRequestDtoInterface workTypeChangeRequestDto;
    protected AttendanceDtoInterface attendanceDto;
    protected Map<Long, WorkflowDtoInterface> workflowMap;
    protected String scheduledWorkTypeCode;
    protected String substitutedWorkTypeCode;

    public void setPersonalId(String personalId) {
        this.personalId = personalId;
    }

    public void setTargetDate(Date targetDate) {
        this.targetDate = CapsuleUtility.getDateClone((Date)targetDate);
    }

    public boolean hasAttendance() {
        return this.attendanceDto != null;
    }

    public boolean isAttendanceApplied() {
        if (!this.hasAttendance()) {
            return false;
        }
        return WorkflowUtility.isApplied((WorkflowDtoInterface)((WorkflowDtoInterface)this.workflowMap.get(this.attendanceDto.getWorkflow())));
    }

    public boolean isAttendanceDirectStart() {
        if (!this.hasAttendance()) {
            return false;
        }
        return MospUtility.isChecked((int)this.attendanceDto.getDirectStart());
    }

    public boolean isAttendanceDirectEnd() {
        if (!this.hasAttendance()) {
            return false;
        }
        return MospUtility.isChecked((int)this.attendanceDto.getDirectEnd());
    }

    public String getWorkType(boolean isAttendanceConsidered, Set<String> statuses) {
        if (this.attendanceDto != null && isAttendanceConsidered) {
            return this.attendanceDto.getWorkTypeCode();
        }
        if (this.isAllHoliday(statuses)) {
            return this.getHolidayWorkType(statuses);
        }
        if (this.getWorkTypeChangeRequestDto(statuses) != null) {
            return this.getChangeWorkType(statuses);
        }
        if (this.getWorkOnHolidayRequestDto(statuses) != null) {
            return this.getWorkOnHolidayWorkType(statuses);
        }
        return this.scheduledWorkTypeCode;
    }

    public String getWorkType(boolean isAttendanceConsidered, boolean isCompleted) {
        return this.getWorkType(isAttendanceConsidered, this.getCompletedOrAppliedStatuses(isCompleted));
    }

    public String getWorkType(boolean isAttendanceConsidered) {
        return this.getWorkType(isAttendanceConsidered, false);
    }

    public String getWorkType() {
        return this.getWorkType(true);
    }

    public boolean isWorkDay() {
        boolean isCompleted = false;
        if (this.isAllHoliday(isCompleted)) {
            return false;
        }
        if (this.getWorkOnHolidayRequestDto(true) != null) {
            return true;
        }
        return !TimeUtility.isHoliday((String)this.scheduledWorkTypeCode);
    }

    protected String getWorkOnHolidayWorkType(Set<String> statuses) {
        WorkOnHolidayRequestDtoInterface dto = this.getWorkOnHolidayRequestDto(statuses);
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return "";
        }
        String workType = TimeUtility.getWorkOnHolidayWorkType((WorkOnHolidayRequestDtoInterface)dto);
        if (MospUtility.isEmpty((String[])new String[]{workType})) {
            workType = MospUtility.getString((Object)this.substitutedWorkTypeCode);
        }
        return workType;
    }

    public Date getWorkOnHolidayStartTime(Set<String> statuses) {
        WorkOnHolidayRequestDtoInterface dto = this.getWorkOnHolidayRequestDto(statuses);
        if (dto == null) {
            return null;
        }
        if (dto.getSubstitute() != 2) {
            return null;
        }
        return dto.getStartTime();
    }

    public Date getWorkOnHolidayStartTime(boolean isCompleted) {
        return this.getWorkOnHolidayStartTime(this.getCompletedOrAppliedStatuses(isCompleted));
    }

    public Date getWorkOnHolidayEndTime(Set<String> statuses) {
        WorkOnHolidayRequestDtoInterface dto = this.getWorkOnHolidayRequestDto(statuses);
        if (dto == null) {
            return null;
        }
        if (dto.getSubstitute() != 2) {
            return null;
        }
        return dto.getEndTime();
    }

    public TimeDuration getWorkOnHolidayTime(boolean isCompleted) {
        if (!this.isWorkOnHolidaySubstituteOff(isCompleted)) {
            return TimeDuration.getInvalid();
        }
        WorkOnHolidayRequestDtoInterface dto = this.getWorkOnHolidayRequestDto(isCompleted);
        int startTime = TimeUtility.getMinutes((Date)dto.getStartTime(), (Date)dto.getRequestDate());
        int endTime = TimeUtility.getMinutes((Date)dto.getEndTime(), (Date)dto.getRequestDate());
        return TimeDuration.getInstance((int)startTime, (int)endTime);
    }

    public int getOvertimeMinutesBeforeWork(Set<String> statuses) {
        List list = this.getOvertimeRequestList(statuses);
        for (OvertimeRequestDtoInterface dto : list) {
            if (dto.getOvertimeType() != 1) continue;
            return dto.getRequestTime();
        }
        return 0;
    }

    public int getOvertimeMinutesBeforeWork(boolean isCompleted) {
        return this.getOvertimeMinutesBeforeWork(WorkflowUtility.getCompletedOrAppliedStatuses((boolean)isCompleted));
    }

    public int getOvertimeMinutesAfterWork(Set<String> statuses) {
        List list = this.getOvertimeRequestList(statuses);
        for (OvertimeRequestDtoInterface dto : list) {
            if (dto.getOvertimeType() != 2) continue;
            return dto.getRequestTime();
        }
        return 0;
    }

    public int getOvertimeMinutesAfterWork(boolean isCompleted) {
        return this.getOvertimeMinutesAfterWork(WorkflowUtility.getCompletedOrAppliedStatuses((boolean)isCompleted));
    }

    public boolean isAllHoliday(Set<String> statuses) {
        boolean hasAllHoliday = this.hasAllHoliday(statuses);
        boolean hasAmHoliday = this.hasAmHoliday(statuses);
        boolean hasPmHoliday = this.hasPmHoliday(statuses);
        return hasAllHoliday || hasAmHoliday && hasPmHoliday;
    }

    public boolean isAllHoliday(boolean isCompleted) {
        return this.isAllHoliday(this.getCompletedOrAppliedStatuses(isCompleted));
    }

    public boolean isAmHoliday(Set<String> statuses) {
        if (this.hasAllHoliday(statuses)) {
            return false;
        }
        if (this.hasPmHoliday(statuses)) {
            return false;
        }
        return this.hasAmHoliday(statuses);
    }

    public boolean isAmHoliday(boolean isCompleted) {
        return this.isAmHoliday(this.getCompletedOrAppliedStatuses(isCompleted));
    }

    public boolean isPmHoliday(Set<String> statuses) {
        if (this.hasAllHoliday(statuses)) {
            return false;
        }
        if (this.hasAmHoliday(statuses)) {
            return false;
        }
        return this.hasPmHoliday(statuses);
    }

    public boolean isPmHoliday(boolean isCompleted) {
        return this.isPmHoliday(this.getCompletedOrAppliedStatuses(isCompleted));
    }

    public boolean isHalfHoliday(Set<String> statuses) {
        return this.isAmHoliday(statuses) || this.isPmHoliday(statuses);
    }

    protected boolean hasAllHoliday(Set<String> statuses) {
        if (this.hasAllHoliday((Collection)this.getHolidayRequestList(statuses)) && !this.isWorkOnHolidaySubstituteOff(statuses)) {
            return true;
        }
        if (this.hasAllHoliday((Collection)this.getSubHolidayRequestList(statuses))) {
            return true;
        }
        return this.hasAllHoliday((Collection)this.getSubstituteList(statuses)) && !this.hasWorkOnHoliday(statuses);
    }

    protected boolean hasAmHoliday(Set<String> statuses) {
        if (this.hasAmHoliday((Collection)this.getHolidayRequestList(statuses))) {
            return true;
        }
        if (this.hasAmHoliday((Collection)this.getSubHolidayRequestList(statuses))) {
            return true;
        }
        if (this.hasAmHoliday((Collection)this.getSubstituteList(statuses)) && !this.hasAmWorkOnHoliday(statuses)) {
            return true;
        }
        return this.hasPmWorkOnHoliday(statuses) && !this.hasPmHoliday((Collection)this.getSubstituteList(statuses));
    }

    protected boolean hasPmHoliday(Set<String> statuses) {
        if (this.hasPmHoliday((Collection)this.getHolidayRequestList(statuses))) {
            return true;
        }
        if (this.hasPmHoliday((Collection)this.getSubHolidayRequestList(statuses))) {
            return true;
        }
        if (this.hasPmHoliday((Collection)this.getSubstituteList(statuses)) && !this.hasPmWorkOnHoliday(statuses)) {
            return true;
        }
        return this.hasAmWorkOnHoliday(statuses) && !this.hasAmHoliday((Collection)this.getSubstituteList(statuses));
    }

    public boolean hasWorkOnHoliday(Set<String> statuses) {
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.getWorkOnHolidayRequestDto(statuses);
        return !MospUtility.isEmpty((Object[])new Object[]{workOnHolidayRequestDto});
    }

    public boolean hasWorkOnHoliday(boolean isCompleted) {
        return this.hasWorkOnHoliday(this.getCompletedOrAppliedStatuses(isCompleted));
    }

    public boolean hasAmWorkOnHoliday(boolean isCompleted) {
        return this.hasAmWorkOnHoliday(this.getCompletedOrAppliedStatuses(isCompleted));
    }

    public boolean hasAmWorkOnHoliday(Set<String> statuses) {
        if (!this.hasWorkOnHoliday(statuses)) {
            return false;
        }
        WorkOnHolidayRequestDtoInterface dto = this.getWorkOnHolidayRequestDto(statuses);
        return dto.getSubstitute() == 3;
    }

    public boolean hasPmWorkOnHoliday(boolean isCompleted) {
        return this.hasPmWorkOnHoliday(this.getCompletedOrAppliedStatuses(isCompleted));
    }

    public boolean hasPmWorkOnHoliday(Set<String> statuses) {
        if (!this.hasWorkOnHoliday(statuses)) {
            return false;
        }
        WorkOnHolidayRequestDtoInterface dto = this.getWorkOnHolidayRequestDto(statuses);
        return dto.getSubstitute() == 4;
    }

    public boolean hasWorkOnHolidayNotHalf(Set<String> statuses) {
        return this.hasWorkOnHoliday(statuses) && !this.hasAmWorkOnHoliday(statuses) && !this.hasPmWorkOnHoliday(statuses);
    }

    public boolean hasSubstitute(Set<String> statuses) {
        List substitutes = this.getSubstituteList(statuses);
        return !MospUtility.isEmpty((Collection)substitutes);
    }

    public boolean isWorkOnLegal(boolean isCompleted) {
        if (!this.isWorkOnHolidaySubstituteOff(isCompleted)) {
            return false;
        }
        WorkOnHolidayRequestDtoInterface dto = this.getWorkOnHolidayRequestDto(isCompleted);
        return dto.getWorkOnHolidayType().equals("legal_holiday");
    }

    public boolean isWorkOnPrescribed(boolean isCompleted) {
        if (!this.isWorkOnHolidaySubstituteOff(isCompleted)) {
            return false;
        }
        WorkOnHolidayRequestDtoInterface dto = this.getWorkOnHolidayRequestDto(isCompleted);
        return dto.getWorkOnHolidayType().equals("prescribed_holiday");
    }

    public boolean isWorkOnHolidaySubstitute(boolean isCompleted) {
        if (!this.hasWorkOnHoliday(isCompleted)) {
            return false;
        }
        return !this.isWorkOnHolidaySubstituteOff(isCompleted);
    }

    public boolean isWorkOnHolidaySubstituteOff(boolean isCompleted) {
        return this.isWorkOnHolidaySubstituteOff(this.getCompletedOrAppliedStatuses(isCompleted));
    }

    public boolean isWorkOnHolidaySubstituteOff(Set<String> statuses) {
        return TimeRequestUtility.isWorkOnHolidaySubstituteOff((WorkOnHolidayRequestDtoInterface)this.getWorkOnHolidayRequestDto(statuses));
    }

    public WorkflowDtoInterface getHolidayWorkflow(Set<String> statuses) {
        WorkflowDtoInterface dto = this.getTheHolidayRangeWorkflow(statuses, 1);
        if (!MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return dto;
        }
        WorkflowDtoInterface am = this.getTheHolidayRangeWorkflow(statuses, 2);
        WorkflowDtoInterface pm = this.getTheHolidayRangeWorkflow(statuses, 3);
        return WorkflowUtility.getLowestWorkflow((WorkflowDtoInterface[])new WorkflowDtoInterface[]{am, pm});
    }

    protected <T extends HolidayRangeDtoInterface & WorkflowNumberDtoInterface> WorkflowDtoInterface getTheHolidayRangeWorkflow(Set<String> statuses, int holidayRange) {
        if (!this.hasTheRangeHoliday(statuses, holidayRange)) {
            return null;
        }
        WorkflowDtoInterface dto = this.getTheHolidayRangeWorkflow((Collection)this.getHolidayRequestList(statuses), holidayRange);
        if (!MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return dto;
        }
        dto = this.getTheHolidayRangeWorkflow((Collection)this.getSubHolidayRequestList(statuses), holidayRange);
        if (!MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return dto;
        }
        return this.getTheHolidayRangeWorkflow((Collection)this.getSubstituteList(statuses), holidayRange);
    }

    protected <T extends HolidayRangeDtoInterface & WorkflowNumberDtoInterface> WorkflowDtoInterface getTheHolidayRangeWorkflow(Collection<T> dtos, int holidayRange) {
        return (WorkflowDtoInterface)this.workflowMap.get(TimeRequestUtility.getTheHolidayRangeWorkflow(dtos, (int)holidayRange));
    }

    protected boolean hasTheRangeHoliday(Set<String> statuses, int holidayRange) {
        switch (holidayRange) {
            case 1: {
                return this.hasAllHoliday(statuses);
            }
            case 2: {
                return this.hasAmHoliday(statuses);
            }
            case 3: {
                return this.hasPmHoliday(statuses);
            }
        }
        return false;
    }

    public List<Date> getHourlyHolidayFirstSequenceTimes(Set<String> statuses) {
        ArrayList<Date> hourlyHolidayFirstSequenceTimes = new ArrayList<Date>();
        Map map = this.getHourlyHolidayMap(statuses);
        if (map.isEmpty()) {
            return hourlyHolidayFirstSequenceTimes;
        }
        ArrayList startTimeList = new ArrayList(map.keySet());
        Collections.sort(startTimeList);
        hourlyHolidayFirstSequenceTimes.add(new Date(((Date)startTimeList.get(0)).getTime()));
        Date endTime = null;
        for (Date startTime : startTimeList) {
            if (endTime != null && startTime.compareTo(endTime) != 0) break;
            HolidayRequestDtoInterface dto = (HolidayRequestDtoInterface)map.get(startTime);
            endTime = dto.getEndTime();
        }
        hourlyHolidayFirstSequenceTimes.add(new Date(endTime.getTime()));
        return hourlyHolidayFirstSequenceTimes;
    }

    public List<Date> getHourlyHolidayFirstSequenceTimes() {
        return this.getHourlyHolidayFirstSequenceTimes(WorkflowUtility.getAppliedStatuses());
    }

    public List<Integer> getHourlyHolidayFirstSequenceMinutes() {
        List holidayTimeList = this.getHourlyHolidayFirstSequenceTimes();
        return this.getHourlyHolidaySequenceMinutes(holidayTimeList);
    }

    public TimeDuration getHourlyHolidayFirstSequence() {
        List list = this.getHourlyHolidayFirstSequenceMinutes();
        if (list.isEmpty()) {
            return TimeDuration.getInvalid();
        }
        return TimeDuration.getInstance((int)((Integer)list.get(0)), (int)((Integer)list.get(1)));
    }

    public List<Date> getHourlyHolidayLastSequenceTimes(Set<String> statuses) {
        ArrayList<Date> hourlyHolidayFirstSequenceTimes = new ArrayList<Date>();
        Map map = this.getHourlyHolidayMap(statuses);
        if (map.isEmpty()) {
            return hourlyHolidayFirstSequenceTimes;
        }
        ArrayList startTimeList = new ArrayList(map.keySet());
        Collections.sort(startTimeList);
        Collections.reverse(startTimeList);
        hourlyHolidayFirstSequenceTimes.add(new Date(((HolidayRequestDtoInterface)map.get(startTimeList.get(0))).getEndTime().getTime()));
        Date sequenceStartTime = null;
        for (Date startTime : startTimeList) {
            HolidayRequestDtoInterface dto = (HolidayRequestDtoInterface)map.get(startTime);
            if (sequenceStartTime != null && dto.getEndTime().compareTo(sequenceStartTime) != 0) break;
            sequenceStartTime = startTime;
        }
        hourlyHolidayFirstSequenceTimes.add(0, new Date(sequenceStartTime.getTime()));
        return hourlyHolidayFirstSequenceTimes;
    }

    public List<Date> getHourlyHolidayLastSequenceTimes() {
        return this.getHourlyHolidayLastSequenceTimes(WorkflowUtility.getAppliedStatuses());
    }

    public List<Integer> getHourlyHolidayLastSequenceMinutes() {
        List holidayTimeList = this.getHourlyHolidayLastSequenceTimes();
        return this.getHourlyHolidaySequenceMinutes(holidayTimeList);
    }

    public TimeDuration getHourlyHolidayLastSequence() {
        List list = this.getHourlyHolidayLastSequenceMinutes();
        if (list.isEmpty()) {
            return TimeDuration.getInvalid();
        }
        return TimeDuration.getInstance((int)((Integer)list.get(0)), (int)((Integer)list.get(1)));
    }

    public List<Integer> getHourlyHolidaySequenceMinutes(List<Date> holidayTimeList) {
        ArrayList<Integer> holidayMinuteList = new ArrayList<Integer>();
        if (holidayTimeList.isEmpty()) {
            return holidayMinuteList;
        }
        holidayMinuteList.add(TimeUtility.getMinutes((Date)holidayTimeList.get(0), (Date)this.targetDate));
        holidayMinuteList.add(TimeUtility.getMinutes((Date)holidayTimeList.get(1), (Date)this.targetDate));
        return holidayMinuteList;
    }

    protected Map<Date, HolidayRequestDtoInterface> getHourlyHolidayMap(Set<String> statuses) {
        TreeMap<Date, HolidayRequestDtoInterface> map = new TreeMap<Date, HolidayRequestDtoInterface>();
        List list = this.getHolidayRequestList(statuses);
        for (HolidayRequestDtoInterface dto : list) {
            if (!TimeRequestUtility.isHolidayRangeHour((HolidayRangeDtoInterface)dto)) continue;
            map.put(dto.getStartTime(), dto);
        }
        return map;
    }

    public Map<Date, HolidayRequestDtoInterface> getHourlyHolidayMap(boolean isCompleted) {
        return this.getHourlyHolidayMap(WorkflowUtility.getCompletedOrAppliedStatuses((boolean)isCompleted));
    }

    public Map<Integer, TimeDuration> getHourlyHolidayTimes(boolean isCompleted) {
        Map hourlyHolidays = new LinkedHashMap();
        for (HolidayRequestDtoInterface dto : this.getHourlyHolidayMap(isCompleted).values()) {
            int startTime = TimeUtility.getMinutes((Date)dto.getStartTime(), (Date)dto.getRequestStartDate());
            int endTime = TimeUtility.getMinutes((Date)dto.getEndTime(), (Date)dto.getRequestEndDate());
            hourlyHolidays = TimeUtility.mergeDurations(hourlyHolidays, (TimeDuration)TimeDuration.getInstance((int)startTime, (int)endTime));
        }
        return TimeUtility.combineDurations(hourlyHolidays);
    }

    public int getHourlyHolidayMinutes(boolean isCompleted) {
        int minutes = 0;
        for (TimeDuration duration : this.getHourlyHolidayTimes(isCompleted).values()) {
            minutes += duration.getMinutes();
        }
        return minutes;
    }

    public String getSubstituteType(boolean isCompleted) {
        return this.getSubstituteType(this.getCompletedOrAppliedStatuses(isCompleted));
    }

    public String getSubstituteType(Set<String> statuses) {
        List list = this.getSubstituteList(statuses);
        for (SubstituteDtoInterface dto : list) {
            if (!TimeRequestUtility.isHolidayRangeAll((HolidayRangeDtoInterface)dto)) continue;
            return dto.getSubstituteType();
        }
        if (this.hasAmHoliday((Collection)list) && this.hasPmHoliday((Collection)list)) {
            for (SubstituteDtoInterface dto : list) {
                if (!TimeUtility.isLegalHoliday((String)dto.getSubstituteType())) continue;
                return "legal_holiday";
            }
            return "prescribed_holiday";
        }
        return "";
    }

    protected String getHolidayWorkType(Set<String> statuses) {
        if (!TimeRequestUtility.isConsecutiveHolidaysExist((Collection)this.getHolidayRequestList(statuses))) {
            return this.getSubstituteType(statuses);
        }
        WorkOnHolidayRequestDtoInterface workOnHolidayRequest = this.getWorkOnHolidayRequestDto(statuses);
        if (TimeRequestUtility.isWorkOnHolidaySubstituteOff((WorkOnHolidayRequestDtoInterface)workOnHolidayRequest)) {
            return this.getWorkOnHolidayWorkType(statuses);
        }
        if (!MospUtility.isEmpty((Object[])new Object[]{workOnHolidayRequest})) {
            return "";
        }
        if (TimeUtility.isHoliday((String)this.scheduledWorkTypeCode)) {
            return this.scheduledWorkTypeCode;
        }
        return this.getSubstituteType(statuses);
    }

    protected String getChangeWorkType(Set<String> statuses) {
        WorkTypeChangeRequestDtoInterface dto = this.getWorkTypeChangeRequestDto(statuses);
        if (dto == null) {
            return "";
        }
        return dto.getWorkTypeCode();
    }

    public boolean isAmPmHalfSubstitute(boolean isCompleted) {
        return this.isAmPmHalfSubstitute(this.getCompletedOrAppliedStatuses(isCompleted));
    }

    public boolean isAmPmHalfSubstitute(Set<String> statuses) {
        List list = this.getSubstituteList(statuses);
        return this.hasAmHoliday((Collection)list) && this.hasPmHoliday((Collection)list);
    }

    public boolean isHalfPostpone(boolean isCompleted) {
        if (!this.hasAmWorkOnHoliday(isCompleted) && !this.hasPmWorkOnHoliday(isCompleted)) {
            return false;
        }
        List list = this.getSubstituteList(isCompleted);
        return this.hasAmHoliday((Collection)list) || this.hasPmHoliday((Collection)list);
    }

    public boolean isAttendanceAppliable() {
        if (!this.isWorkDay()) {
            return false;
        }
        if (this.isAttendanceApplied()) {
            return false;
        }
        if (this.isOvertimeApplied(false)) {
            return false;
        }
        if (this.isHolidayApplied(false)) {
            return false;
        }
        if (this.isSubHolidayApplied(false)) {
            return false;
        }
        if (this.isWorkOnHolidayHolidayApplied(false)) {
            return false;
        }
        if (this.isSubstituteApplied(false)) {
            return false;
        }
        if (this.isDifferenceApplied(false)) {
            return false;
        }
        return !this.isWorkTypeChangeApplied(false);
    }

    public boolean isOvertimeApplied(boolean isContainCompleted) {
        for (OvertimeRequestDtoInterface dto : this.overtimeRequestList) {
            WorkflowDtoInterface workflowDto = (WorkflowDtoInterface)this.workflowMap.get(dto.getWorkflow());
            if (WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto) && isContainCompleted) {
                return true;
            }
            if (WorkflowUtility.isCancelApply((WorkflowDtoInterface)workflowDto)) {
                return true;
            }
            if (WorkflowUtility.isCancelWithDrawnApply((WorkflowDtoInterface)workflowDto)) {
                return true;
            }
            if (!WorkflowUtility.isApprovable((WorkflowDtoInterface)workflowDto)) continue;
            return true;
        }
        return false;
    }

    public boolean isHolidayApplied(boolean isContainCompleted) {
        for (HolidayRequestDtoInterface dto : this.holidayRequestList) {
            WorkflowDtoInterface workflowDto = (WorkflowDtoInterface)this.workflowMap.get(dto.getWorkflow());
            if (WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto) && isContainCompleted) {
                return true;
            }
            if (WorkflowUtility.isCancelApply((WorkflowDtoInterface)workflowDto)) {
                return true;
            }
            if (WorkflowUtility.isCancelWithDrawnApply((WorkflowDtoInterface)workflowDto)) {
                return true;
            }
            if (!WorkflowUtility.isApprovable((WorkflowDtoInterface)workflowDto)) continue;
            return true;
        }
        return false;
    }

    public boolean isSubHolidayApplied(boolean isContainCompleted) {
        for (SubHolidayRequestDtoInterface dto : this.subHolidayRequestList) {
            WorkflowDtoInterface workflowDto = (WorkflowDtoInterface)this.workflowMap.get(dto.getWorkflow());
            if (WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto) && isContainCompleted) {
                return true;
            }
            if (WorkflowUtility.isCancelApply((WorkflowDtoInterface)workflowDto)) {
                return true;
            }
            if (WorkflowUtility.isCancelWithDrawnApply((WorkflowDtoInterface)workflowDto)) {
                return true;
            }
            if (!WorkflowUtility.isApprovable((WorkflowDtoInterface)workflowDto)) continue;
            return true;
        }
        return false;
    }

    public boolean isWorkOnHolidayHolidayApplied(boolean isContainCompleted) {
        if (this.workOnHolidayRequestDto == null) {
            return false;
        }
        WorkflowDtoInterface workflowDto = (WorkflowDtoInterface)this.workflowMap.get(this.workOnHolidayRequestDto.getWorkflow());
        if (WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto) && isContainCompleted) {
            return true;
        }
        if (WorkflowUtility.isCancelApply((WorkflowDtoInterface)workflowDto)) {
            return true;
        }
        if (WorkflowUtility.isCancelWithDrawnApply((WorkflowDtoInterface)workflowDto)) {
            return true;
        }
        return WorkflowUtility.isApprovable((WorkflowDtoInterface)workflowDto);
    }

    public boolean isSubstituteApplied(boolean isContainCompleted) {
        for (SubstituteDtoInterface dto : this.substituteList) {
            WorkflowDtoInterface workflowDto = (WorkflowDtoInterface)this.workflowMap.get(dto.getWorkflow());
            if (WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto) && isContainCompleted) {
                return true;
            }
            if (WorkflowUtility.isCancelApply((WorkflowDtoInterface)workflowDto)) {
                return true;
            }
            if (WorkflowUtility.isCancelWithDrawnApply((WorkflowDtoInterface)workflowDto)) {
                return true;
            }
            if (!WorkflowUtility.isApprovable((WorkflowDtoInterface)workflowDto)) continue;
            return true;
        }
        return false;
    }

    public boolean isDifferenceApplied(boolean isContainCompleted) {
        if (this.differenceRequestDto == null) {
            return false;
        }
        WorkflowDtoInterface workflowDto = (WorkflowDtoInterface)this.workflowMap.get(this.differenceRequestDto.getWorkflow());
        if (WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto) && isContainCompleted) {
            return true;
        }
        if (WorkflowUtility.isCancelApply((WorkflowDtoInterface)workflowDto)) {
            return true;
        }
        if (WorkflowUtility.isCancelWithDrawnApply((WorkflowDtoInterface)workflowDto)) {
            return true;
        }
        return WorkflowUtility.isApprovable((WorkflowDtoInterface)workflowDto);
    }

    public boolean isWorkTypeChangeApplied(boolean isContainCompleted) {
        if (this.workTypeChangeRequestDto == null) {
            return false;
        }
        WorkflowDtoInterface workflowDto = (WorkflowDtoInterface)this.workflowMap.get(this.workTypeChangeRequestDto.getWorkflow());
        if (WorkflowUtility.isCompleted((WorkflowDtoInterface)workflowDto) && isContainCompleted) {
            return true;
        }
        if (WorkflowUtility.isCancelApply((WorkflowDtoInterface)workflowDto)) {
            return true;
        }
        return WorkflowUtility.isApprovable((WorkflowDtoInterface)workflowDto);
    }

    public AttendanceDtoInterface getAttendanceDto(Set<String> statuses) {
        return (AttendanceDtoInterface)this.getRequestDto((WorkflowNumberDtoInterface)this.attendanceDto, statuses);
    }

    public List<HolidayRequestDtoInterface> getHolidayRequestList(boolean isCompleted) {
        return this.getHolidayRequestList(this.getCompletedOrAppliedStatuses(isCompleted));
    }

    public List<HolidayRequestDtoInterface> getHolidayRequestList(Set<String> statuses) {
        return WorkflowUtility.getStatusMatchedList((Collection)this.holidayRequestList, (Map)this.workflowMap, statuses);
    }

    public List<SubHolidayRequestDtoInterface> getSubHolidayRequestList(boolean isCompleted) {
        return this.getSubHolidayRequestList(this.getCompletedOrAppliedStatuses(isCompleted));
    }

    public List<SubHolidayRequestDtoInterface> getSubHolidayRequestList(Set<String> statuses) {
        return WorkflowUtility.getStatusMatchedList((Collection)this.subHolidayRequestList, (Map)this.workflowMap, statuses);
    }

    public List<SubstituteDtoInterface> getSubstituteList(boolean isCompleted) {
        return this.getSubstituteList(this.getCompletedOrAppliedStatuses(isCompleted));
    }

    public List<SubstituteDtoInterface> getSubstituteList(Set<String> statuses) {
        return WorkflowUtility.getStatusMatchedList((Collection)this.substituteList, (Map)this.workflowMap, statuses);
    }

    public WorkOnHolidayRequestDtoInterface getWorkOnHolidayRequestDto(boolean isCompleted) {
        return this.getWorkOnHolidayRequestDto(this.getCompletedOrAppliedStatuses(isCompleted));
    }

    public WorkOnHolidayRequestDtoInterface getWorkOnHolidayRequestDto(Set<String> statuses) {
        return (WorkOnHolidayRequestDtoInterface)this.getRequestDto((WorkflowNumberDtoInterface)this.workOnHolidayRequestDto, statuses);
    }

    public List<OvertimeRequestDtoInterface> getOvertimeRequestList(boolean isCompleted) {
        return this.getOvertimeRequestList(this.getCompletedOrAppliedStatuses(isCompleted));
    }

    public List<OvertimeRequestDtoInterface> getOvertimeRequestList(Set<String> statuses) {
        return WorkflowUtility.getStatusMatchedList((Collection)this.overtimeRequestList, (Map)this.workflowMap, statuses);
    }

    public WorkTypeChangeRequestDtoInterface getWorkTypeChangeRequestDto(boolean isCompleted) {
        return this.getWorkTypeChangeRequestDto(this.getCompletedOrAppliedStatuses(isCompleted));
    }

    public WorkTypeChangeRequestDtoInterface getWorkTypeChangeRequestDto(Set<String> statuses) {
        return (WorkTypeChangeRequestDtoInterface)this.getRequestDto((WorkflowNumberDtoInterface)this.workTypeChangeRequestDto, statuses);
    }

    public DifferenceRequestDtoInterface getDifferenceRequestDto(boolean isCompleted) {
        return this.getDifferenceRequestDto(this.getCompletedOrAppliedStatuses(isCompleted));
    }

    public DifferenceRequestDtoInterface getDifferenceRequestDto(Set<String> statuses) {
        return (DifferenceRequestDtoInterface)this.getRequestDto((WorkflowNumberDtoInterface)this.differenceRequestDto, statuses);
    }

    protected <T extends WorkflowNumberDtoInterface> T getRequestDto(T dto, Set<String> statuses) {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return null;
        }
        if (WorkflowUtility.isMatch((WorkflowDtoInterface)((WorkflowDtoInterface)this.workflowMap.get(dto.getWorkflow())), statuses)) {
            return dto;
        }
        return null;
    }

    public float calcWorkDays(boolean isCompleted) {
        if (this.isAllHoliday(isCompleted)) {
            return 0.0f;
        }
        if (this.isAmHoliday(isCompleted) || this.isPmHoliday(isCompleted)) {
            return 0.5f;
        }
        return 1.0f;
    }

    public int calcWorkDaysForPaidHoliday(boolean isCompleted) {
        if (this.isWorkOnHolidaySubstituteOff(isCompleted)) {
            return 0;
        }
        return 1;
    }

    public int calcWorkOnHolidayTimes(boolean isCompleted) {
        if (this.isWorkOnHolidaySubstituteOff(isCompleted)) {
            return 1;
        }
        return 0;
    }

    public int calcWorkOnLegalHolidayTimes(boolean isCompleted) {
        if (this.isWorkOnLegal(isCompleted)) {
            return 1;
        }
        return 0;
    }

    public int calcWorkOnPrescribedHolidayTimes(boolean isCompleted) {
        if (this.isWorkOnPrescribed(isCompleted)) {
            return 1;
        }
        return 0;
    }

    public float calcPaidHolidayDays(boolean isCompleted) {
        if (this.isWorkOnHolidaySubstituteOff(isCompleted)) {
            return 0.0f;
        }
        return TimeRequestUtility.totalPaidHolidayDays((Collection)this.getHolidayRequestList(isCompleted));
    }

    public int calcPaidHolidayHours(boolean isCompleted) {
        return TimeRequestUtility.totalPaidHolidayHours((Collection)this.getHolidayRequestList(isCompleted));
    }

    public float calcStockHolidayDays(boolean isCompleted) {
        if (this.isWorkOnHolidaySubstituteOff(isCompleted)) {
            return 0.0f;
        }
        return TimeRequestUtility.totalStockHolidayDays((Collection)this.getHolidayRequestList(isCompleted));
    }

    public float calcSubHolidayDays(boolean isCompleted) {
        return TimeRequestUtility.totalSubHolidayDays((Collection)this.getSubHolidayRequestList(isCompleted));
    }

    public float calcLegalSubHolidayDays(boolean isCompleted) {
        return TimeRequestUtility.totalLegalSubHolidayDays((Collection)this.getSubHolidayRequestList(isCompleted));
    }

    public float calcPrescribedSubHolidayDays(boolean isCompleted) {
        return TimeRequestUtility.totalPrescribedSubHolidayDays((Collection)this.getSubHolidayRequestList(isCompleted));
    }

    public float calcNightSubHolidayDays(boolean isCompleted) {
        return TimeRequestUtility.totalNightSubHolidayDays((Collection)this.getSubHolidayRequestList(isCompleted));
    }

    public float calcSpecialHolidayDays(boolean isCompleted) {
        if (this.isWorkOnHolidaySubstituteOff(isCompleted)) {
            return 0.0f;
        }
        return TimeRequestUtility.totalSpecialHolidayDays((Collection)this.getHolidayRequestList(isCompleted));
    }

    public int calcSpecialHolidayHours(boolean isCompleted) {
        return TimeRequestUtility.totalSpecialHolidayHours((Collection)this.getHolidayRequestList(isCompleted));
    }

    public float calcOtherHolidayDays(boolean isCompleted) {
        if (this.isWorkOnHolidaySubstituteOff(isCompleted)) {
            return 0.0f;
        }
        return TimeRequestUtility.totalOtherHolidayDays((Collection)this.getHolidayRequestList(isCompleted));
    }

    public int calcOtherHolidayHours(boolean isCompleted) {
        return TimeRequestUtility.totalOtherHolidayHours((Collection)this.getHolidayRequestList(isCompleted));
    }

    public float calcAbsenceDays(boolean isCompleted) {
        if (this.isWorkOnHolidaySubstituteOff(isCompleted)) {
            return 0.0f;
        }
        return TimeRequestUtility.totalAbsenceDays((Collection)this.getHolidayRequestList(isCompleted));
    }

    public int calcAbsenceHours(boolean isCompleted) {
        return TimeRequestUtility.totalAbsenceHolidayHours((Collection)this.getHolidayRequestList(isCompleted));
    }

    protected boolean hasAllHoliday(Collection<? extends HolidayRangeDtoInterface> dtos) {
        return TimeRequestUtility.hasHolidayRangeAll(dtos);
    }

    protected boolean hasAmHoliday(Collection<? extends HolidayRangeDtoInterface> dtos) {
        return TimeRequestUtility.hasHolidayRangeAm(dtos);
    }

    protected boolean hasPmHoliday(Collection<? extends HolidayRangeDtoInterface> dtos) {
        return TimeRequestUtility.hasHolidayRangePm(dtos);
    }

    protected Set<String> getCompletedOrAppliedStatuses(boolean isCompleted) {
        return WorkflowUtility.getCompletedOrAppliedStatuses((boolean)isCompleted);
    }

    public String getPersonalId() {
        return this.personalId;
    }

    public Date getTargetDate() {
        return CapsuleUtility.getDateClone((Date)this.targetDate);
    }

    public void setHolidayRequestList(List<HolidayRequestDtoInterface> holidayRequestList) {
        this.holidayRequestList = holidayRequestList;
    }

    public void setOverTimeRequestList(List<OvertimeRequestDtoInterface> overtimeRequestList) {
        this.overtimeRequestList = overtimeRequestList;
    }

    public void setSubstituteList(List<SubstituteDtoInterface> substituteList) {
        this.substituteList = substituteList;
    }

    public void setSubHolidayRequestList(List<SubHolidayRequestDtoInterface> subHolidayRequestList) {
        this.subHolidayRequestList = subHolidayRequestList;
    }

    public void setWorkOnHolidayRequestDto(WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto) {
        this.workOnHolidayRequestDto = workOnHolidayRequestDto;
    }

    public void setDifferenceRequestDto(DifferenceRequestDtoInterface differenceRequestDto) {
        this.differenceRequestDto = differenceRequestDto;
    }

    public void setWorkTypeChangeRequestDto(WorkTypeChangeRequestDtoInterface workTypeChangeRequestDto) {
        this.workTypeChangeRequestDto = workTypeChangeRequestDto;
    }

    public AttendanceDtoInterface getAttendanceDto() {
        return this.attendanceDto;
    }

    public void setAttendanceDto(AttendanceDtoInterface attendanceDto) {
        this.attendanceDto = attendanceDto;
    }

    public Map<Long, WorkflowDtoInterface> getWorkflowMap() {
        return this.workflowMap;
    }

    public void setWorkflowMap(Map<Long, WorkflowDtoInterface> workflowMap) {
        this.workflowMap = workflowMap;
    }

    public void setScheduledWorkTypeCode(String scheduledWorkTypeCode) {
        this.scheduledWorkTypeCode = scheduledWorkTypeCode;
    }

    public void setSubstitutedWorkTypeCode(String substitutedWorkTypeCode) {
        this.substitutedWorkTypeCode = substitutedWorkTypeCode;
    }
}

