/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.AdditionalLogicExecutor;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.SuspensionDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.human.utils.HumanUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.CutoffErrorListDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.CutoffErrorListDto;
import jp.mosp.time.entity.RequestDetectEntityInterface;
import jp.mosp.time.entity.RequestEntity;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeUtility;
import jp.mosp.time.utils.TotalTimeUtility;

public class RequestDetectEntity
extends AdditionalLogicExecutor
implements RequestDetectEntityInterface {
    protected String personalId;
    protected List<Date> targetDateList;
    protected List<SuspensionDtoInterface> suspensionList;
    protected Map<Date, String> scheduleMap;
    protected List<AttendanceDtoInterface> attendanceList;
    protected List<WorkOnHolidayRequestDtoInterface> workOnHolidayRequestList;
    protected List<HolidayRequestDtoInterface> holidayRequestList;
    protected List<SubHolidayRequestDtoInterface> subHolidayRequestList;
    protected List<OvertimeRequestDtoInterface> overtimeRequestList;
    protected List<WorkTypeChangeRequestDtoInterface> workTypeChangeRequestList;
    protected List<DifferenceRequestDtoInterface> differenceRequestList;
    protected List<SubstituteDtoInterface> substituteList;
    protected Map<Long, WorkflowDtoInterface> workflowMap;
    protected List<WorkflowDtoInterface> approvableList = new ArrayList();
    protected List<Date> appliableList = new ArrayList();
    protected List<Date> overtimeNotAppliedList = new ArrayList();

    public boolean isApprovableExist(MospParams mospParamsm, boolean isImmediately) throws MospException {
        if (this.targetDateList.isEmpty()) {
            return false;
        }
        Date firstDate = (Date)MospUtility.getFirstValue((Collection)this.targetDateList);
        Date lastDate = (Date)MospUtility.getLastValue((Collection)this.targetDateList);
        for (WorkflowDtoInterface dto : this.getRequestedWorkflows(mospParamsm)) {
            if (!this.isApprovable(dto.getWorkflowDate(), firstDate, lastDate, dto)) continue;
            this.approvableList.add(dto);
            if (!isImmediately) continue;
            return true;
        }
        return !this.approvableList.isEmpty();
    }

    public boolean isAppliableExist(boolean isImmediately) {
        if (this.targetDateList == null || this.targetDateList.isEmpty()) {
            return false;
        }
        ArrayList list = new ArrayList();
        list.addAll(this.targetDateList);
        Collections.reverse(list);
        for (Date targetDate : list) {
            if (HumanUtility.isSuspension((Collection)this.suspensionList, (Date)targetDate) || !this.isAppliable(targetDate)) continue;
            this.appliableList.add(targetDate);
            if (!isImmediately) continue;
            return true;
        }
        return !this.appliableList.isEmpty();
    }

    public boolean isAppliableExistContainRequests() {
        if (this.targetDateList == null || this.targetDateList.isEmpty()) {
            return false;
        }
        ArrayList list = new ArrayList();
        list.addAll(this.targetDateList);
        Collections.reverse(list);
        for (Date targetDate : list) {
            RequestEntity requestEntity;
            if (HumanUtility.isSuspension((Collection)this.suspensionList, (Date)targetDate) || !(requestEntity = this.getRequestEntity(targetDate)).isAttendanceAppliable()) continue;
            this.appliableList.add(targetDate);
        }
        return !this.appliableList.isEmpty();
    }

    public boolean isOvertimeNotAppliedExist(boolean isImmediately) {
        for (AttendanceDtoInterface attendanceDto : this.attendanceList) {
            if (!this.isOvertimeNotApplied(attendanceDto)) continue;
            this.overtimeNotAppliedList.add(attendanceDto.getWorkDate());
            if (!isImmediately) continue;
            return true;
        }
        return !this.overtimeNotAppliedList.isEmpty();
    }

    public void setBeforeDay(Date targetDate) {
        if (this.targetDateList.isEmpty()) {
            return;
        }
        Date firstDate = (Date)MospUtility.getFirstValue((Collection)this.targetDateList);
        Date lastDate = (Date)MospUtility.getLastValue((Collection)this.targetDateList);
        if (DateUtility.isSame((Date)targetDate, (Date)firstDate)) {
            this.setTargetDateList(TimeUtility.getDateList(null, null));
            return;
        }
        Date beforeDay = DateUtility.addDay((Date)targetDate, (int)-1);
        if (!DateUtility.isTermContain((Date)beforeDay, (Date)firstDate, (Date)lastDate)) {
            return;
        }
        this.setTargetDateList(TimeUtility.getDateList((Date)firstDate, (Date)beforeDay));
    }

    protected Collection<WorkflowDtoInterface> getRequestedWorkflows(MospParams mospParams) throws MospException {
        LinkedHashSet<WorkflowDtoInterface> workflows = new LinkedHashSet<WorkflowDtoInterface>();
        for (AttendanceDtoInterface dto : this.attendanceList) {
            workflows.add((WorkflowDtoInterface)this.workflowMap.get(dto.getWorkflow()));
        }
        for (AttendanceDtoInterface dto : this.overtimeRequestList) {
            workflows.add((WorkflowDtoInterface)this.workflowMap.get(dto.getWorkflow()));
        }
        for (AttendanceDtoInterface dto : this.holidayRequestList) {
            workflows.add((WorkflowDtoInterface)this.workflowMap.get(dto.getWorkflow()));
        }
        for (AttendanceDtoInterface dto : this.workOnHolidayRequestList) {
            workflows.add((WorkflowDtoInterface)this.workflowMap.get(dto.getWorkflow()));
        }
        for (AttendanceDtoInterface dto : this.subHolidayRequestList) {
            workflows.add((WorkflowDtoInterface)this.workflowMap.get(dto.getWorkflow()));
        }
        for (AttendanceDtoInterface dto : this.workTypeChangeRequestList) {
            workflows.add((WorkflowDtoInterface)this.workflowMap.get(dto.getWorkflow()));
        }
        for (AttendanceDtoInterface dto : this.differenceRequestList) {
            workflows.add((WorkflowDtoInterface)this.workflowMap.get(dto.getWorkflow()));
        }
        workflows.remove(null);
        this.doStoredLogics(mospParams, new Object[]{"RequestDetectGetWorkflowsAddons", this.workflowMap, workflows});
        return workflows;
    }

    protected boolean isOvertimeNotApplied(AttendanceDtoInterface attendanceDto) {
        Date targetDate = attendanceDto.getWorkDate();
        if (!this.targetDateList.contains(targetDate)) {
            return false;
        }
        RequestEntity entity = this.getRequestEntity(targetDate);
        if (!entity.isAttendanceApplied()) {
            return false;
        }
        if (entity.isWorkOnHolidaySubstituteOff(false)) {
            return false;
        }
        if (attendanceDto.getOvertimeBefore() > 0 && !this.isOvertimeApplied(targetDate, 1, this.workflowMap)) {
            return true;
        }
        return attendanceDto.getOvertimeAfter() > 0 && !this.isOvertimeApplied(targetDate, 2, this.workflowMap);
    }

    protected boolean isOvertimeApplied(Date targetDate, int overtimeType, Map<Long, WorkflowDtoInterface> workflowMap) {
        List list = TotalTimeUtility.getOvertimeRequestList((List)this.overtimeRequestList, workflowMap, (Date)targetDate);
        for (OvertimeRequestDtoInterface dto : list) {
            if (overtimeType != dto.getOvertimeType() || !WorkflowUtility.isApplied((WorkflowDtoInterface)workflowMap.get(dto.getWorkflow()))) continue;
            return true;
        }
        return false;
    }

    protected boolean isApprovable(Date targetDate, Date firstDate, Date lastDate, WorkflowDtoInterface workflowDto) {
        if (!DateUtility.isTermContain((Date)targetDate, (Date)firstDate, (Date)lastDate)) {
            return false;
        }
        return WorkflowUtility.isNotApproved((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isFirstReverted((WorkflowDtoInterface)workflowDto);
    }

    protected boolean isAppliable(Date targetDate) {
        RequestEntity entity = this.getRequestEntity(targetDate);
        if (!entity.isWorkDay()) {
            return false;
        }
        return !entity.isAttendanceApplied();
    }

    protected RequestEntity getRequestEntity(Date targetDate) {
        RequestEntity entity = new RequestEntity();
        entity.setPersonalId(this.personalId);
        entity.setTargetDate(targetDate);
        entity.setAttendanceDto(TotalTimeUtility.getAttendanceDto((List)this.attendanceList, (Date)targetDate));
        entity.setWorkOnHolidayRequestDto(TotalTimeUtility.getWorkOnHolidayRequestDto((List)this.workOnHolidayRequestList, (Map)this.workflowMap, (Date)targetDate));
        entity.setHolidayRequestList(TotalTimeUtility.getHolidayRequestList((List)this.holidayRequestList, (Map)this.workflowMap, (Date)targetDate));
        entity.setSubHolidayRequestList(TotalTimeUtility.getSubHolidayRequestList((List)this.subHolidayRequestList, (Map)this.workflowMap, (Date)targetDate));
        entity.setOverTimeRequestList(TotalTimeUtility.getOvertimeRequestList((List)this.overtimeRequestList, (Map)this.workflowMap, (Date)targetDate));
        entity.setDifferenceRequestDto(TotalTimeUtility.getDifferenceRequestDto((List)this.differenceRequestList, (Map)this.workflowMap, (Date)targetDate));
        entity.setSubstituteList(TotalTimeUtility.getSubstitutList((List)this.substituteList, (Map)this.workflowMap, (Date)targetDate));
        entity.setWorkflowMap(this.workflowMap);
        entity.setScheduledWorkTypeCode((String)this.scheduleMap.get(targetDate));
        return entity;
    }

    public List<CutoffErrorListDtoInterface> getCutoffErrorList(MospParams mospParams, HumanDtoInterface humanDto) {
        CutoffErrorListDtoInterface dto;
        ArrayList<CutoffErrorListDtoInterface> list = new ArrayList<CutoffErrorListDtoInterface>();
        for (WorkflowDtoInterface workflowDto : this.approvableList) {
            dto = this.getInitCutoffErrorListDto(workflowDto.getWorkflowDate(), humanDto);
            String functionCode = workflowDto.getFunctionCode();
            dto.setType(this.getRequestName(mospParams, functionCode));
            dto.setState(TimeNamingUtility.getNotApproved((MospParams)mospParams));
            if (WorkflowUtility.isFirstReverted((WorkflowDtoInterface)workflowDto)) {
                if (functionCode.equals("1")) continue;
                dto.setState(TimeNamingUtility.getFirstReverted((MospParams)mospParams));
            }
            list.add(dto);
        }
        Collections.sort(this.appliableList);
        for (Date targetDate : this.appliableList) {
            dto = this.getInitCutoffErrorListDto(targetDate, humanDto);
            dto.setType(TimeNamingUtility.getWorkManage((MospParams)mospParams));
            dto.setState(TimeNamingUtility.getNotApplied((MospParams)mospParams));
            list.add(dto);
        }
        for (Date targetDate : this.overtimeNotAppliedList) {
            dto = this.getInitCutoffErrorListDto(targetDate, humanDto);
            dto.setType(TimeNamingUtility.getOvertimeWork((MospParams)mospParams));
            dto.setState(TimeNamingUtility.getNotApplied((MospParams)mospParams));
            list.add(dto);
        }
        return list;
    }

    protected CutoffErrorListDtoInterface getInitCutoffErrorListDto(Date targetDate, HumanDtoInterface humanDto) {
        CutoffErrorListDto dto = new CutoffErrorListDto();
        dto.setDate(targetDate);
        dto.setEmployeeCode(humanDto.getEmployeeCode());
        dto.setPersonalId(humanDto.getPersonalId());
        dto.setLastName(humanDto.getLastName());
        dto.setFirstName(humanDto.getFirstName());
        dto.setWorkPlaceCode(humanDto.getWorkPlaceCode());
        dto.setEmploymentCode(humanDto.getEmploymentContractCode());
        dto.setSectionCode(humanDto.getSectionCode());
        dto.setPositionCode(humanDto.getPositionCode());
        return dto;
    }

    protected String getRequestName(MospParams mospParams, String functionCode) {
        if (functionCode.equals("1")) {
            return TimeNamingUtility.getWorkManage((MospParams)mospParams);
        }
        if (functionCode.equals("7")) {
            return TimeNamingUtility.workType((MospParams)mospParams);
        }
        if (functionCode.equals("6")) {
            return TimeNamingUtility.getTimeDifference((MospParams)mospParams);
        }
        String requestName = TimeUtility.getFunctionName((MospParams)mospParams, (String)functionCode);
        return requestName.replaceAll(PfNameUtility.application((MospParams)mospParams), "");
    }

    public void setPersonalId(String personalId) {
        this.personalId = personalId;
    }

    public void setTargetDateList(List<Date> targetDateList) {
        this.targetDateList = targetDateList;
    }

    public void setSuspensionList(List<SuspensionDtoInterface> suspensionList) {
        this.suspensionList = suspensionList;
    }

    public void setScheduleMap(Map<Date, String> scheduleMap) {
        this.scheduleMap = scheduleMap;
    }

    public void setAttendanceList(List<AttendanceDtoInterface> attendanceList) {
        this.attendanceList = attendanceList;
    }

    public void setWorkOnHolidayRequestList(List<WorkOnHolidayRequestDtoInterface> workOnHolidayRequestList) {
        this.workOnHolidayRequestList = workOnHolidayRequestList;
    }

    public void setHolidayRequestList(List<HolidayRequestDtoInterface> holidayRequestList) {
        this.holidayRequestList = holidayRequestList;
    }

    public void setSubHolidayRequestList(List<SubHolidayRequestDtoInterface> subHolidayRequestList) {
        this.subHolidayRequestList = subHolidayRequestList;
    }

    public void setOvertimeRequestList(List<OvertimeRequestDtoInterface> overtimeRequestList) {
        this.overtimeRequestList = overtimeRequestList;
    }

    public void setWorkTypeChangeRequestList(List<WorkTypeChangeRequestDtoInterface> workTypeChangeRequestList) {
        this.workTypeChangeRequestList = workTypeChangeRequestList;
    }

    public void setDifferenceRequestList(List<DifferenceRequestDtoInterface> differenceRequestList) {
        this.differenceRequestList = differenceRequestList;
    }

    public void setSubstituteList(List<SubstituteDtoInterface> substituteList) {
        this.substituteList = substituteList;
    }

    public void setWorkflowMap(Map<Long, WorkflowDtoInterface> workflowMap) {
        this.workflowMap = workflowMap;
    }
}

