/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.entity;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.entity.CutoffEntityInterface;
import jp.mosp.time.utils.TimeUtility;

public class CutoffEntity
implements CutoffEntityInterface {
    protected CutoffDtoInterface dto;

    public CutoffDtoInterface getCutoffDto() {
        return this.dto;
    }

    public void setCutoffDto(CutoffDtoInterface dto) {
        this.dto = dto;
    }

    public boolean isExist() {
        return this.dto != null;
    }

    public String getCode() {
        if (!this.isExist()) {
            return "";
        }
        return this.dto.getCutoffCode();
    }

    public String getCutoffName() {
        if (!this.isExist()) {
            return "";
        }
        return this.dto.getCutoffName();
    }

    public int getCutoffDate() {
        if (!this.isExist()) {
            return 0;
        }
        return this.dto.getCutoffDate();
    }

    public int getNoApproval() {
        if (!this.isExist()) {
            return 0;
        }
        return this.dto.getNoApproval();
    }

    public boolean isSelfTightening() {
        if (!this.isExist()) {
            return false;
        }
        return this.dto.getSelfTightening() == 0;
    }

    public Date getCutoffFirstDate(int targetYear, int targetMonth, MospParams mospParams) throws MospException {
        return TimeUtility.getCutoffFirstDate((int)this.getCutoffDate(), (int)targetYear, (int)targetMonth, (MospParams)mospParams);
    }

    public Date getCutoffFirstDate(Date targetDate, MospParams mospParams) throws MospException {
        return TimeUtility.getCutoffFirstDate((int)this.getCutoffDate(), (Date)targetDate, (MospParams)mospParams);
    }

    public Date getCutoffLastDate(int targetYear, int targetMonth, MospParams mospParams) throws MospException {
        return TimeUtility.getCutoffLastDate((int)this.getCutoffDate(), (int)targetYear, (int)targetMonth, (MospParams)mospParams);
    }

    public Date getCutoffLastDate(Date targetDate, MospParams mospParams) throws MospException {
        return TimeUtility.getCutoffLastDate((int)this.getCutoffDate(), (Date)targetDate, (MospParams)mospParams);
    }

    public Date getCutoffTermTargetDate(int targetYear, int targetMonth, MospParams mospParams) throws MospException {
        return TimeUtility.getCutoffTermTargetDate((int)this.getCutoffDate(), (int)targetYear, (int)targetMonth, (MospParams)mospParams);
    }

    public Date getCutoffCalculationDate(int targetYear, int targetMonth, MospParams mospParams) throws MospException {
        return TimeUtility.getCutoffCalculationDate((int)this.getCutoffDate(), (int)targetYear, (int)targetMonth, (MospParams)mospParams);
    }

    public Date getCutoffMonth(Date targetDate, MospParams mospParams) throws MospException {
        return TimeUtility.getCutoffMonth((int)this.getCutoffDate(), (Date)targetDate, (MospParams)mospParams);
    }

    public List<Date> getCutoffTerm(int targetYear, int targetMonth, MospParams mospParams) throws MospException {
        return TimeUtility.getCutoffTerm((int)this.getCutoffDate(), (int)targetYear, (int)targetMonth, (MospParams)mospParams);
    }

    public List<Date> getCutoffTerm(Date targetDate, MospParams mospParams) throws MospException {
        return TimeUtility.getCutoffTerm((int)this.getCutoffDate(), (Date)targetDate, (MospParams)mospParams);
    }
}

