/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.entity;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.GoOutDtoInterface;
import jp.mosp.time.dto.settings.RestDtoInterface;
import jp.mosp.time.entity.AttendanceEntityInterface;
import jp.mosp.time.entity.TimeDuration;
import jp.mosp.time.entity.TimeSettingEntityInterface;
import jp.mosp.time.utils.TimeUtility;

public class AttendanceEntity
implements AttendanceEntityInterface {
    protected AttendanceDtoInterface attendanceDto;
    protected Collection<RestDtoInterface> restDtos;
    protected Collection<GoOutDtoInterface> goOutDtos;

    public boolean hasAttendance() {
        return this.attendanceDto != null;
    }

    public String getPersonalId() {
        if (!this.hasAttendance()) {
            return "";
        }
        return this.attendanceDto.getPersonalId();
    }

    public Date getWorkDate() {
        if (!this.hasAttendance()) {
            return null;
        }
        return this.attendanceDto.getWorkDate();
    }

    public String getWorkTypeCode() {
        if (!this.hasAttendance()) {
            return "";
        }
        return this.attendanceDto.getWorkTypeCode();
    }

    public Date getStartTime() {
        if (!this.hasAttendance()) {
            return null;
        }
        return this.attendanceDto.getStartTime();
    }

    public Date getEndTime() {
        if (!this.hasAttendance()) {
            return null;
        }
        return this.attendanceDto.getEndTime();
    }

    public boolean isAttendanceDirectStart() {
        if (!this.hasAttendance()) {
            return false;
        }
        return this.isChecked(this.attendanceDto.getDirectStart());
    }

    public boolean isAttendanceDirectEnd() {
        if (!this.hasAttendance()) {
            return false;
        }
        return this.isChecked(this.attendanceDto.getDirectEnd());
    }

    public boolean isLateReasonTrain() {
        if (!this.hasAttendance()) {
            return false;
        }
        return MospUtility.isEqual((Object)this.attendanceDto.getLateReason(), (Object)"train");
    }

    public boolean isLateReasonCompany() {
        if (!this.hasAttendance()) {
            return false;
        }
        return MospUtility.isEqual((Object)this.attendanceDto.getLateReason(), (Object)"company");
    }

    public boolean isLeaveEarlyReasonCompany() {
        if (!this.hasAttendance()) {
            return false;
        }
        return MospUtility.isEqual((Object)this.attendanceDto.getLeaveEarlyReason(), (Object)"company");
    }

    public Map<Integer, TimeDuration> getRestTimes(TimeSettingEntityInterface timeSetting) {
        Map restTimes = new LinkedHashMap();
        for (RestDtoInterface dto : this.restDtos) {
            int startTime = timeSetting.roundDailyRestStart(TimeUtility.getMinutes((Date)dto.getRestStart(), (Date)this.getWorkDate()));
            int endTime = timeSetting.roundDailyRestEnd(TimeUtility.getMinutes((Date)dto.getRestEnd(), (Date)this.getWorkDate()));
            restTimes = TimeUtility.mergeDurations(restTimes, (TimeDuration)TimeDuration.getInstance((int)startTime, (int)endTime));
        }
        return TimeUtility.combineDurations(restTimes);
    }

    public Map<Integer, TimeDuration> getAllGoOutTimes(TimeSettingEntityInterface timeSetting) {
        return this.getGoOutTimes(this.goOutDtos, null, timeSetting);
    }

    public Map<Integer, TimeDuration> getPublicGoOutTimes(TimeSettingEntityInterface timeSetting) {
        return this.getGoOutTimes(this.goOutDtos, Integer.valueOf(1), timeSetting);
    }

    public Map<Integer, TimeDuration> getPrivateGoOutTimes(TimeSettingEntityInterface timeSetting) {
        return this.getGoOutTimes(this.goOutDtos, Integer.valueOf(2), timeSetting);
    }

    protected Map<Integer, TimeDuration> getGoOutTimes(Collection<GoOutDtoInterface> dtos, Integer goOutType, TimeSettingEntityInterface timeSetting) {
        Map goOutTimes = new LinkedHashMap();
        for (GoOutDtoInterface dto : dtos) {
            int startTime = TimeUtility.getMinutes((Date)dto.getGoOutStart(), (Date)this.getWorkDate());
            int endTime = TimeUtility.getMinutes((Date)dto.getGoOutEnd(), (Date)this.getWorkDate());
            TimeDuration duration = TimeDuration.getInstance((int)(startTime = timeSetting.roundDailyGoOutStart(startTime, dto.getGoOutType())), (int)(endTime = timeSetting.roundDailyGoOutEnd(endTime, dto.getGoOutType())));
            if (!duration.isValid() || goOutType != null && !MospUtility.isEqual((Object)dto.getGoOutType(), (Object)goOutType)) continue;
            goOutTimes = TimeUtility.mergeDurations(goOutTimes, (TimeDuration)duration);
        }
        return TimeUtility.combineDurations(goOutTimes);
    }

    protected boolean isChecked(int value) {
        return MospUtility.isChecked((int)value);
    }

    public void setAttendanceDto(AttendanceDtoInterface attendanceDto) {
        this.attendanceDto = attendanceDto;
    }

    public void setRestDtos(Collection<RestDtoInterface> restDtos) {
        this.restDtos = restDtos;
    }

    public void setGoOutDtos(Collection<GoOutDtoInterface> goOutDtos) {
        this.goOutDtos = goOutDtos;
    }

    public AttendanceDtoInterface getAttendanceDto() {
        return this.attendanceDto;
    }

    public Collection<RestDtoInterface> getRestDtos() {
        return this.restDtos;
    }

    public Collection<GoOutDtoInterface> getGoOutDtos() {
        return this.goOutDtos;
    }
}

