/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.entity;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.CapsuleUtility;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.dto.human.SuspensionDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.human.utils.HumanUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.platform.utils.TransStringUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.dto.settings.AttendanceCorrectionDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.AttendanceListDto;
import jp.mosp.time.entity.AttendListEntityInterface;
import jp.mosp.time.entity.RequestEntity;
import jp.mosp.time.entity.RequestEntityInterface;
import jp.mosp.time.entity.TimeDuration;
import jp.mosp.time.entity.WorkTypeEntityInterface;
import jp.mosp.time.utils.AttendanceUtility;
import jp.mosp.time.utils.DifferenceUtility;
import jp.mosp.time.utils.HolidayUtility;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeRequestUtility;
import jp.mosp.time.utils.TimeUtility;
import jp.mosp.time.utils.WorkTypeUtility;

public class AttendListEntity
implements AttendListEntityInterface {
    public static final int TYPE_LIST_ATTENDANCE = 1;
    public static final int TYPE_LIST_ACTUAL = 2;
    public static final int TYPE_LIST_SCHEDULE = 3;
    public static final int TYPE_LIST_APPROVAL = 4;
    protected MospParams mospParams;
    protected List<AttendanceListDto> attendList;
    protected Date retireDate;
    protected Collection<SuspensionDtoInterface> suspensions;
    protected Map<Date, ScheduleDateDtoInterface> scheduleDates;
    protected Map<String, List<WorkTypeEntityInterface>> workTypeEntities;
    protected Map<Date, AttendanceDtoInterface> attendances;
    protected Map<Date, List<OvertimeRequestDtoInterface>> overtimeRequests;
    protected Map<Date, List<HolidayRequestDtoInterface>> holidayRequests;
    protected Map<Date, WorkOnHolidayRequestDtoInterface> workOnHolidayRequests;
    protected Map<Date, ScheduleDateDtoInterface> substitutedSchedules;
    protected Map<Date, List<SubstituteDtoInterface>> substitutes;
    protected Map<Date, List<SubHolidayRequestDtoInterface>> subHolidayRequests;
    protected Map<Integer, List<SubHolidayDtoInterface>> subHolidays;
    protected Map<Date, WorkTypeChangeRequestDtoInterface> workTypeChangeRequests;
    protected Map<Date, DifferenceRequestDtoInterface> differenceRequests;
    protected Map<Long, WorkflowDtoInterface> workflows;
    protected Map<Date, List<AttendanceCorrectionDtoInterface>> corrections;
    protected Set<HolidayDtoInterface> holidays;

    public void fillInAttendList(int listType) throws MospException {
        Set statuses = AttendanceUtility.getStatusesForListType((int)listType);
        for (AttendanceListDto dto : this.attendList) {
            dto.setListType(listType);
            this.addScheduleAndRequests(dto, statuses);
            this.addAttendance(dto, statuses);
            this.addWorkflow(dto);
        }
        this.totalHolidays(statuses);
        this.totalAttendanceList();
        this.setStringFields();
    }

    protected void addScheduleAndRequests(AttendanceListDto dto, Set<String> statuses) throws MospException {
        RequestEntityInterface requestEntity = this.getRequestEntity(dto);
        Date workDate = dto.getWorkDate();
        String workTypeCode = requestEntity.getWorkType(false, statuses);
        if (requestEntity.isAllHoliday(statuses)) {
            dto.setWorkTypeCode(workTypeCode);
            dto.setWorkTypeAbbr(this.getWorkTypeAbbr(dto, statuses));
            return;
        }
        if (this.isRetireOrSusoension(workDate) || MospUtility.isEmpty((String[])new String[]{workTypeCode})) {
            return;
        }
        if (TimeUtility.isHoliday((String)workTypeCode)) {
            dto.setWorkTypeCode(workTypeCode);
            dto.setWorkTypeAbbr(this.getWorkTypeAbbr(dto, statuses));
            return;
        }
        if (this.isTheListType(dto, new int[]{2, 4})) {
            return;
        }
        dto.setWorkTypeCode(workTypeCode);
        dto.setWorkTypeAbbr(this.getWorkTypeAbbr(dto, statuses));
        WorkTypeEntityInterface workTypeEntity = this.getWorkTypeEntity(workTypeCode, workDate);
        dto.setStartTime(workTypeEntity.getStartTime(requestEntity, statuses));
        dto.setEndTime(workTypeEntity.getEndTime(requestEntity, statuses));
        if (this.isTheListType(dto, new int[]{3})) {
            Date startTime = dto.getStartTime();
            Date endTime = dto.getEndTime();
            TimeDuration duration = TimeUtility.getDuration((Date)startTime, (Date)endTime);
            Map rests = workTypeEntity.getRestTimes(duration.getStartTime(), duration.getEndTime(), requestEntity, statuses);
            int restMinutes = TimeUtility.getMinutes((Map)rests);
            dto.setWorkTime(Integer.valueOf(duration.getMinutes() - restMinutes));
            dto.setRestTime(Integer.valueOf(restMinutes));
        }
    }

    protected void addAttendance(AttendanceListDto dto, Set<String> statuses) throws MospException {
        Date workDate = dto.getWorkDate();
        AttendanceDtoInterface attendance = this.getAttendance(workDate);
        if (MospUtility.isEmpty((Object[])new Object[]{attendance})) {
            return;
        }
        WorkflowDtoInterface workflow = (WorkflowDtoInterface)this.workflows.get(attendance.getWorkflow());
        if (!AttendanceUtility.isAttendanceConsideredForAttendList((AttendanceListDto)dto, (WorkflowDtoInterface)workflow)) {
            return;
        }
        this.addAttendance(dto, attendance, statuses);
        dto.setCorrectionInfo(AttendanceUtility.getCorrectionMark((MospParams)this.mospParams, (List)((List)this.corrections.get(workDate))));
    }

    protected void addWorkflow(AttendanceListDto dto) throws MospException {
        dto.setWorkflow(0L);
        dto.setApplicationInfo("");
        dto.setNeedStatusLink(false);
        dto.setStartTimeStyle("");
        dto.setEndTimeStyle("");
        RequestEntityInterface requestEntity = this.getRequestEntity(dto);
        Set statuses = WorkflowUtility.getEffectiveStatuses();
        Date workDate = dto.getWorkDate();
        String workTypeCode = requestEntity.getWorkType(false, statuses);
        WorkflowDtoInterface workflow = null;
        if (requestEntity.hasAttendance()) {
            workflow = (WorkflowDtoInterface)this.workflows.get(requestEntity.getAttendanceDto().getWorkflow());
            if (this.isTheListType(dto, new int[]{4}) && WorkflowUtility.isDraft((WorkflowDtoInterface)workflow)) {
                return;
            }
            dto.setNeedStatusLink(!WorkflowUtility.isDraft((WorkflowDtoInterface)workflow));
        }
        if (requestEntity.isAllHoliday(statuses) && !TimeUtility.isHoliday((String)workTypeCode)) {
            workflow = requestEntity.getHolidayWorkflow(statuses);
        }
        if (!MospUtility.isEmpty((Object[])new Object[]{workflow})) {
            dto.setWorkflow(workflow.getWorkflow());
            dto.setApplicationInfo(WorkflowUtility.getWorkflowStatus((MospParams)this.mospParams, (WorkflowDtoInterface)workflow));
            return;
        }
        if (this.isRetireOrSusoension(workDate) || MospUtility.isEmpty((String[])new String[]{workTypeCode})) {
            dto.setApplicationInfo("");
            return;
        }
        if (TimeUtility.isHoliday((String)workTypeCode)) {
            dto.setApplicationInfo(PfNameUtility.completed((MospParams)this.mospParams));
            return;
        }
        if (this.isTheListType(dto, new int[]{4})) {
            return;
        }
        dto.setApplicationInfo(PfNameUtility.schedule((MospParams)this.mospParams));
        dto.setStartTimeStyle("style=\"color: gray\"");
        dto.setEndTimeStyle("style=\"color: gray\"");
    }

    public void totalAttendanceList() {
        int workTimeTotal = 0;
        int restTimeTotal = 0;
        int privateTimeTotal = 0;
        int publicTimeTotal = 0;
        int minutelyHolidayATimeTotal = 0;
        int minutelyHolidayBTimeTotal = 0;
        int lateTimeTotal = 0;
        int leaveEarlyTimeTotal = 0;
        int lateLeaveEarlyTimeTotal = 0;
        int overtimeTotal = 0;
        int overtimeInTotal = 0;
        int overtimeOutTotal = 0;
        int holidayWorkTimeTotal = 0;
        int shortUnpaidTotal = 0;
        int lateNightTimeTotal = 0;
        int workDays = 0;
        int lateDays = 0;
        int leaveEarlyDays = 0;
        int overtimeDays = 0;
        int lateNightDays = 0;
        for (AttendanceListDto dto : this.attendList) {
            workTimeTotal += MospUtility.getInt((Object)dto.getWorkTime());
            restTimeTotal += MospUtility.getInt((Object)dto.getRestTime());
            privateTimeTotal += MospUtility.getInt((Object)dto.getPrivateTime());
            publicTimeTotal += MospUtility.getInt((Object)dto.getPublicTime());
            minutelyHolidayATimeTotal += MospUtility.getInt((Object)dto.getMinutelyHolidayATime());
            minutelyHolidayBTimeTotal += MospUtility.getInt((Object)dto.getMinutelyHolidayBTime());
            lateTimeTotal += MospUtility.getInt((Object)dto.getLateTime());
            leaveEarlyTimeTotal += MospUtility.getInt((Object)dto.getLeaveEarlyTime());
            lateLeaveEarlyTimeTotal += MospUtility.getInt((Object)dto.getLateLeaveEarlyTime());
            overtimeTotal += MospUtility.getInt((Object)dto.getOvertime());
            overtimeInTotal += MospUtility.getInt((Object)dto.getOvertimeIn());
            overtimeOutTotal += MospUtility.getInt((Object)dto.getOvertimeOut());
            holidayWorkTimeTotal += MospUtility.getInt((Object)dto.getHolidayWorkTime());
            shortUnpaidTotal += MospUtility.getInt((Object)dto.getShortUnpaid());
            lateNightTimeTotal += MospUtility.getInt((Object)dto.getLateNightTime());
            workDays += dto.getGoingWork();
            lateDays += this.count(dto.getLateTime());
            leaveEarlyDays += this.count(dto.getLeaveEarlyTime());
            overtimeDays += this.count(dto.getOvertime());
            lateNightDays += this.count(dto.getLateNightTime());
        }
        AttendanceListDto dto = (AttendanceListDto)MospUtility.getLastValue((Collection)this.attendList);
        dto.setWorkTimeTotal(Integer.valueOf(workTimeTotal));
        dto.setRestTimeTotal(Integer.valueOf(restTimeTotal));
        dto.setPrivateTimeTotal(Integer.valueOf(privateTimeTotal));
        dto.setPublicTimeTotal(Integer.valueOf(publicTimeTotal));
        dto.setMinutelyHolidayATimeTotal(Integer.valueOf(minutelyHolidayATimeTotal));
        dto.setMinutelyHolidayBTimeTotal(Integer.valueOf(minutelyHolidayBTimeTotal));
        dto.setLateTimeTotal(Integer.valueOf(lateTimeTotal));
        dto.setLeaveEarlyTimeTotal(Integer.valueOf(leaveEarlyTimeTotal));
        dto.setLateLeaveEarlyTimeTotal(Integer.valueOf(lateLeaveEarlyTimeTotal));
        dto.setOvertimeTotal(Integer.valueOf(overtimeTotal));
        dto.setOvertimeInTotal(Integer.valueOf(overtimeInTotal));
        dto.setOvertimeOutTotal(Integer.valueOf(overtimeOutTotal));
        dto.setHolidayWorkTimeTotal(Integer.valueOf(holidayWorkTimeTotal));
        dto.setShortUnpaidTotal(Integer.valueOf(shortUnpaidTotal));
        dto.setLateNightTimeTotal(Integer.valueOf(lateNightTimeTotal));
        dto.setWorkDays(Integer.valueOf(workDays));
        dto.setLateDays(Integer.valueOf(lateDays));
        dto.setLeaveEarlyDays(Integer.valueOf(leaveEarlyDays));
        dto.setOvertimeDays(Integer.valueOf(overtimeDays));
        dto.setLateNightDays(Integer.valueOf(lateNightDays));
    }

    protected void totalHolidays(Set<String> statuses) throws MospException {
        float paidHolidays = 0.0f;
        float paidHolidayTime = 0.0f;
        float specialHolidays = 0.0f;
        float specialHolidayTimes = 0.0f;
        float otherHolidays = 0.0f;
        float otherHolidayTimes = 0.0f;
        float absenceDays = 0.0f;
        float absenceTimes = 0.0f;
        float subHolidayDays = 0.0f;
        float substituteDays = 0.0f;
        int holidayWorkDays = 0;
        int prescribedHolidays = 0;
        int legalHolidays = 0;
        for (AttendanceListDto dto : this.attendList) {
            HolidayRequestDtoInterface holiday;
            RequestEntityInterface requestEntity = this.getRequestEntity(dto);
            String workTypeCode = dto.getWorkTypeCode();
            Iterator iterator = requestEntity.getHolidayRequestList(statuses).iterator();
            while (iterator.hasNext() && (!TimeRequestUtility.isConsecutiveHolidays((HolidayRequestDtoInterface)(holiday = (HolidayRequestDtoInterface)iterator.next())) || MospUtility.isEmpty((String[])new String[]{workTypeCode}))) {
                double useDay = holiday.getUseDay();
                if (TimeRequestUtility.isConsecutiveHolidays((HolidayRequestDtoInterface)holiday)) {
                    useDay = 1.0;
                }
                switch (holiday.getHolidayType1()) {
                    case 1: {
                        paidHolidays = (float)((double)paidHolidays + useDay);
                        paidHolidayTime += (float)holiday.getUseHour();
                        break;
                    }
                    case 2: {
                        specialHolidays = (float)((double)specialHolidays + useDay);
                        specialHolidayTimes += (float)holiday.getUseHour();
                        break;
                    }
                    case 3: {
                        otherHolidays = (float)((double)otherHolidays + useDay);
                        otherHolidayTimes += (float)holiday.getUseHour();
                        break;
                    }
                    case 4: {
                        absenceDays = (float)((double)absenceDays + useDay);
                        absenceTimes += (float)holiday.getUseHour();
                        break;
                    }
                }
            }
            for (SubHolidayRequestDtoInterface subHoliday : requestEntity.getSubHolidayRequestList(statuses)) {
                subHolidayDays += TimeUtility.getHolidayTimes((int)subHoliday.getHolidayRange());
            }
            if (TimeUtility.isWorkOnLegalOrPrescribedHoliday((String)workTypeCode)) {
                ++holidayWorkDays;
            }
            if (requestEntity.hasWorkOnHoliday(statuses)) continue;
            List substitutes = requestEntity.getSubstituteList(statuses);
            for (SubstituteDtoInterface substitute : substitutes) {
                substituteDays += TimeUtility.getHolidayTimes((int)substitute.getHolidayRange());
            }
            if (!MospUtility.isEmpty((Collection)substitutes)) continue;
            if (TimeUtility.isPrescribedHoliday((String)workTypeCode)) {
                ++prescribedHolidays;
            }
            if (!TimeUtility.isLegalHoliday((String)workTypeCode)) continue;
            ++legalHolidays;
        }
        AttendanceListDto dto = (AttendanceListDto)MospUtility.getLastValue((Collection)this.attendList);
        dto.setPaidHolidays(Float.valueOf(paidHolidays));
        dto.setPaidHolidayTime(Float.valueOf(paidHolidayTime));
        dto.setSpecialHolidays(Float.valueOf(specialHolidays));
        dto.setSpecialHolidayHours(Float.valueOf(specialHolidayTimes));
        dto.setOtherHolidays(Float.valueOf(otherHolidays));
        dto.setOtherHolidayHours(Float.valueOf(otherHolidayTimes));
        dto.setAbsenceDays(Float.valueOf(absenceDays));
        dto.setAbsenceHours(Float.valueOf(absenceTimes));
        dto.setSubHolidays(Float.valueOf(subHolidayDays));
        dto.setSubstituteHolidays(Float.valueOf(substituteDays));
        dto.setHolidayWorkDays(Integer.valueOf(holidayWorkDays));
        dto.setPrescribedHolidays(Integer.valueOf(prescribedHolidays));
        dto.setLegalHolidays(Integer.valueOf(legalHolidays));
        dto.setHolidays(Integer.valueOf(prescribedHolidays + legalHolidays));
        dto.setBirthPrescribedSubHoliday(Float.valueOf(this.getSubHolidayDays(1)));
        dto.setBirthLegalSubHoliday(Float.valueOf(this.getSubHolidayDays(2)));
        dto.setBirthMidnightSubHolidaydays(Float.valueOf(this.getSubHolidayDays(3)));
    }

    public void setStringFields() throws MospException {
        for (AttendanceListDto dto : this.attendList) {
            this.setStringFields(dto);
        }
    }

    protected void setStringFields(AttendanceListDto dto) throws MospException {
        Date standardDate = dto.getWorkDate();
        Date targetDate = dto.getWorkDate();
        dto.setWorkDateString(DateUtility.getStringMonthAndDate((Date)targetDate));
        dto.setWorkDayOfWeek(DateUtility.getStringDayOfWeek((Date)targetDate));
        dto.setWorkDayOfWeekStyle(HolidayUtility.getWorkDayOfWeekStyle((Date)targetDate, (MospParams)this.mospParams));
        dto.setStartTimeString(this.getHourColonMinute(dto.getStartTime(), standardDate));
        dto.setEndTimeString(this.getHourColonMinute(dto.getEndTime(), standardDate));
        dto.setStartRecordTimeString(this.getHourColonMinute(dto.getStartRecordTime(), standardDate));
        dto.setEndRecordTimeString(this.getHourColonMinute(dto.getEndRecordTime(), standardDate));
        dto.setWorkTimeString(this.getStringHours(dto.getWorkTime(), true));
        dto.setRestTimeString(this.getStringHours(dto.getRestTime(), true));
        dto.setPrivateTimeString(this.getStringHours(dto.getPrivateTime(), true));
        dto.setPublicTimeString(this.getStringHours(dto.getPublicTime(), true));
        dto.setLateTimeString(this.getStringHours(dto.getLateTime(), true));
        dto.setLeaveEarlyTimeString(this.getStringHours(dto.getLeaveEarlyTime(), true));
        dto.setLateLeaveEarlyTimeString(this.getStringHours(dto.getLateLeaveEarlyTime(), true));
        dto.setOvertimeString(this.getStringHours(dto.getOvertime(), true));
        dto.setOvertimeInString(this.getStringHours(dto.getOvertimeIn(), true));
        dto.setOvertimeOutString(this.getStringHours(dto.getOvertimeOut(), true));
        dto.setHolidayWorkTimeString(this.getStringHours(dto.getHolidayWorkTime(), true));
        dto.setLateNightTimeString(this.getStringHours(dto.getLateNightTime(), true));
        dto.setShortUnpaidString(this.getStringHours(dto.getShortUnpaid(), true));
        dto.setWorkTimeTotalString(this.getStringHours(dto.getWorkTimeTotal(), false));
        dto.setRestTimeTotalString(this.getStringHours(dto.getRestTimeTotal(), false));
        dto.setPrivateTimeTotalString(this.getStringHours(dto.getPrivateTimeTotal(), false));
        dto.setPublicTimeTotalString(this.getStringHours(dto.getPublicTimeTotal(), false));
        dto.setLateTimeTotalString(this.getStringHours(dto.getLateTimeTotal(), false));
        dto.setLeaveEarlyTimeTotalString(this.getStringHours(dto.getLeaveEarlyTimeTotal(), false));
        dto.setLateLeaveEarlyTimeTotalString(this.getStringHours(dto.getLateLeaveEarlyTimeTotal(), false));
        dto.setOvertimeTotalString(this.getStringHours(dto.getOvertimeTotal(), false));
        dto.setOvertimeInTotalString(this.getStringHours(dto.getOvertimeInTotal(), false));
        dto.setOvertimeOutTotalString(this.getStringHours(dto.getOvertimeOutTotal(), false));
        dto.setHolidayWorkTimeTotalString(this.getStringHours(dto.getHolidayWorkTimeTotal(), false));
        dto.setLateNightTimeTotalString(this.getStringHours(dto.getLateNightTimeTotal(), false));
        dto.setShortUnpaidTotalString(this.getStringHours(dto.getShortUnpaidTotal(), false));
        dto.setWorkDaysString(this.getIntegerTimes(dto.getWorkDays()));
        dto.setLateDaysString(this.getIntegerTimes(dto.getLateDays()));
        dto.setLeaveEarlyDaysString(this.getIntegerTimes(dto.getLeaveEarlyDays()));
        dto.setOvertimeDaysString(this.getIntegerTimes(dto.getOvertimeDays()));
        dto.setHolidayWorkDaysString(this.getIntegerTimes(dto.getHolidayWorkDays()));
        dto.setBirthPrescribedSubHolidayString(this.getFloatTimes(dto.getBirthPrescribedSubHoliday(), true));
        dto.setBirthLegalSubHolidayString(this.getFloatTimes(dto.getBirthLegalSubHoliday(), true));
        dto.setBirthMidnightSubHolidayString(this.getFloatTimes(dto.getBirthMidnightSubHoliday(), true));
        dto.setLateNightDaysString(this.getIntegerTimes(dto.getLateNightDays()));
        dto.setPrescribedHolidaysString(this.getIntegerTimes(dto.getPrescribedHolidays()));
        dto.setLegalHolidaysString(this.getIntegerTimes(dto.getLegalHolidays()));
        dto.setHolidayString(this.getIntegerTimes(dto.getHolidays()));
        dto.setSubstituteHolidaysString(this.getFloatTimes(dto.getSubstituteHolidays(), false));
        dto.setPaidHolidaysString(this.getFloatTimes(dto.getPaidHolidays(), false));
        dto.setPaidHolidayTimeString(this.getFloatTimes(dto.getPaidHolidayTime(), false));
        dto.setSpecialHolidaysString(this.getDaysAndHours(dto.getSpecialHolidays(), dto.getSpecialHolidayHours()));
        dto.setOtherHolidaysString(this.getDaysAndHours(dto.getOtherHolidays(), dto.getOtherHolidayHours()));
        dto.setSubHolidaysString(this.getFloatTimes(dto.getSubHolidays(), false));
        dto.setAbsenceDaysString(this.getDaysAndHours(dto.getAbsenceDays(), dto.getAbsenceHours()));
        dto.setMinutelyHolidayATimeString(this.getStringHours(dto.getMinutelyHolidayATimeTotal(), false));
        dto.setMinutelyHolidayBTimeString(this.getStringHours(dto.getMinutelyHolidayBTimeTotal(), false));
        dto.setEmployeeCodeTitle(PfNameUtility.employeeCode((MospParams)this.mospParams));
        dto.setOvertimeTitle(TimeNamingUtility.overtimeOutAbbr((MospParams)this.mospParams));
        dto.setHourlyPaidHolidayValid(true);
        dto.setSpecialHolidaysTitle(TimeNamingUtility.specialHolidayAbbr((MospParams)this.mospParams));
    }

    protected void addAttendance(AttendanceListDto dto, AttendanceDtoInterface attendance, Set<String> statuses) throws MospException {
        dto.setGoingWork(1);
        dto.setWorkTypeCode(attendance.getWorkTypeCode());
        dto.setWorkTypeAbbr(this.getWorkTypeAbbr(dto, statuses));
        dto.setStartTime(attendance.getActualStartTime());
        dto.setEndTime(attendance.getActualEndTime());
        dto.setWorkTime(Integer.valueOf(attendance.getWorkTime()));
        dto.setRestTime(Integer.valueOf(attendance.getRestTime()));
        dto.setPrivateTime(Integer.valueOf(attendance.getPrivateTime()));
        dto.setPublicTime(Integer.valueOf(attendance.getPublicTime()));
        dto.setMinutelyHolidayATime(Integer.valueOf(attendance.getMinutelyHolidayATime()));
        dto.setMinutelyHolidayA(attendance.getMinutelyHolidayA());
        dto.setMinutelyHolidayBTime(Integer.valueOf(attendance.getMinutelyHolidayBTime()));
        dto.setMinutelyHolidayB(attendance.getMinutelyHolidayB());
        dto.setLateTime(Integer.valueOf(attendance.getLateTime()));
        dto.setLeaveEarlyTime(Integer.valueOf(attendance.getLeaveEarlyTime()));
        dto.setLateLeaveEarlyTime(Integer.valueOf(attendance.getLateTime() + attendance.getLeaveEarlyTime()));
        dto.setOvertime(Integer.valueOf(attendance.getOvertime()));
        dto.setOvertimeIn(Integer.valueOf(attendance.getOvertimeIn()));
        dto.setOvertimeOut(Integer.valueOf(attendance.getOvertimeOut()));
        dto.setHolidayWorkTime(Integer.valueOf(attendance.getLegalWorkTime()));
        dto.setLateNightTime(Integer.valueOf(attendance.getLateNightTime()));
        dto.setShortUnpaid(Integer.valueOf(attendance.getShortUnpaid()));
    }

    protected WorkTypeEntityInterface getWorkTypeEntity(String workTypeCode, Date workDate) throws MospException {
        WorkTypeEntityInterface workType = (WorkTypeEntityInterface)PlatformUtility.getLatestDto((List)((List)this.workTypeEntities.get(workTypeCode)), (Date)workDate);
        DifferenceRequestDtoInterface differenceRequest = (DifferenceRequestDtoInterface)this.differenceRequests.get(workDate);
        if (!MospUtility.isEmpty((Object[])new Object[]{differenceRequest})) {
            String differenceWorkTypeCode = differenceRequest.getWorkTypeCode();
            workType = (WorkTypeEntityInterface)PlatformUtility.getLatestDto((List)((List)this.workTypeEntities.get(differenceWorkTypeCode)), (Date)workDate);
            workType = DifferenceUtility.makeDifferenceWorkType((MospParams)this.mospParams, (DifferenceRequestDtoInterface)differenceRequest, (WorkTypeEntityInterface)workType);
        }
        if (MospUtility.isEmpty((Object[])new Object[]{workType})) {
            workType = WorkTypeUtility.emptyWorkType((MospParams)this.mospParams);
        }
        return workType;
    }

    protected float getSubHolidayDays(int subHolidayType) throws MospException {
        float subHolidayDays = 0.0f;
        List dtos = MospUtility.getListValue((Map)this.subHolidays, (Object)subHolidayType);
        for (SubHolidayDtoInterface dto : dtos) {
            if (!this.isAttendCompleted(dto.getWorkDate())) continue;
            subHolidayDays = (float)((double)subHolidayDays + dto.getSubHolidayDays());
        }
        return subHolidayDays;
    }

    protected boolean isAttendCompleted(Date workDate) {
        AttendanceDtoInterface dto = this.getAttendance(workDate);
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return false;
        }
        return WorkflowUtility.isCompleted((WorkflowDtoInterface)((WorkflowDtoInterface)this.workflows.get(dto.getWorkflow())));
    }

    protected String getScheduledWorkTypeCode(Date workDate) {
        ScheduleDateDtoInterface scheduleDateDto = (ScheduleDateDtoInterface)this.scheduleDates.get(workDate);
        if (MospUtility.isEmpty((Object[])new Object[]{scheduleDateDto})) {
            return "";
        }
        return scheduleDateDto.getWorkTypeCode();
    }

    public RequestEntityInterface getRequestEntity(AttendanceListDto dto) throws MospException {
        Date targetDate = dto.getWorkDate();
        RequestEntity requestEntity = (RequestEntity)MospUtility.createObject(RequestEntityInterface.class, (MospParams)this.mospParams);
        requestEntity.setTargetDate(targetDate);
        requestEntity.setScheduledWorkTypeCode(this.getScheduledWorkTypeCode(targetDate));
        if (this.isTheListType(dto, new int[]{3}) && !this.isScheduleApplyRequest()) {
            return requestEntity;
        }
        if (!this.isTheListType(dto, new int[]{3})) {
            requestEntity.setAttendanceDto(this.getAttendance(targetDate));
        }
        requestEntity.setOverTimeRequestList(MospUtility.getListValue((Map)this.overtimeRequests, (Object)targetDate));
        requestEntity.setHolidayRequestList(MospUtility.getListValue((Map)this.holidayRequests, (Object)targetDate));
        requestEntity.setWorkOnHolidayRequestDto((WorkOnHolidayRequestDtoInterface)this.workOnHolidayRequests.get(targetDate));
        requestEntity.setSubstituteList(MospUtility.getListValue((Map)this.substitutes, (Object)targetDate));
        requestEntity.setSubHolidayRequestList(MospUtility.getListValue((Map)this.subHolidayRequests, (Object)targetDate));
        requestEntity.setWorkTypeChangeRequestDto((WorkTypeChangeRequestDtoInterface)this.workTypeChangeRequests.get(targetDate));
        requestEntity.setDifferenceRequestDto((DifferenceRequestDtoInterface)this.differenceRequests.get(targetDate));
        requestEntity.setSubstitutedWorkTypeCode(this.getSubstitutedWorkTypeCode(targetDate, this.substitutedSchedules));
        requestEntity.setWorkflowMap(this.workflows);
        return requestEntity;
    }

    protected String getSubstitutedWorkTypeCode(Date workDate, Map<Date, ScheduleDateDtoInterface> substitutedSchedules) {
        ScheduleDateDtoInterface dto = substitutedSchedules.get(workDate);
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return "";
        }
        return dto.getWorkTypeCode();
    }

    protected String getWorkTypeAbbr(AttendanceListDto dto, Set<String> statuses) throws MospException {
        String workTypeCode = MospUtility.getString((Object)dto.getWorkTypeCode());
        Date workDate = dto.getWorkDate();
        RequestEntityInterface requestEntity = this.getRequestEntity(dto);
        List holidayRequests = requestEntity.getHolidayRequestList(statuses);
        List subHolidayRequests = requestEntity.getSubHolidayRequestList(statuses);
        List substitutes = requestEntity.getSubstituteList(statuses);
        if (TimeRequestUtility.hasHolidayRangeAll((Collection)holidayRequests) && MospUtility.isEmpty((String[])new String[]{workTypeCode})) {
            return TimeRequestUtility.getAllHolidayAbbr((Collection)holidayRequests, (Collection)this.holidays, (MospParams)this.mospParams);
        }
        if (TimeRequestUtility.hasHolidayRangeAll((Collection)subHolidayRequests)) {
            return TimeRequestUtility.getAllSubHolidayAbbr((Collection)subHolidayRequests, (MospParams)this.mospParams);
        }
        if (requestEntity.hasWorkOnHolidayNotHalf(statuses) && !requestEntity.isHalfHoliday(statuses)) {
            return this.getWorkTypeEntity(workTypeCode, workDate).getWorkTypeAbbr();
        }
        if (requestEntity.hasAmWorkOnHoliday(statuses) || requestEntity.hasPmWorkOnHoliday(statuses)) {
            if (requestEntity.hasSubstitute(statuses)) {
                return this.getWorkTypeEntity(workTypeCode, workDate).getWorkTypeAbbr();
            }
            return TimeNamingUtility.halfSubstituteWorkAbbr((MospParams)this.mospParams);
        }
        if (TimeRequestUtility.hasHolidayRangeAll((Collection)substitutes)) {
            return TimeRequestUtility.getSubstituteAbbr((String)requestEntity.getSubstituteType(statuses), (MospParams)this.mospParams);
        }
        if (requestEntity.isAmPmHalfSubstitute(statuses)) {
            return TimeNamingUtility.substituteHolidayAbbr((MospParams)this.mospParams);
        }
        String ante = "";
        String post = "";
        if (TimeRequestUtility.hasHolidayRangeAm((Collection)holidayRequests)) {
            ante = this.getHalfWorkTypeAbbr(TimeRequestUtility.getAmHolidayAbbr((Collection)holidayRequests, (Collection)this.holidays, (MospParams)this.mospParams));
        }
        if (TimeRequestUtility.hasHolidayRangePm((Collection)holidayRequests)) {
            post = this.getHalfWorkTypeAbbr(TimeRequestUtility.getPmHolidayAbbr((Collection)holidayRequests, (Collection)this.holidays, (MospParams)this.mospParams));
        }
        if (TimeRequestUtility.hasHolidayRangeAm((Collection)subHolidayRequests)) {
            ante = this.getHalfWorkTypeAbbr(TimeNamingUtility.getSubHoliday((MospParams)this.mospParams));
        }
        if (TimeRequestUtility.hasHolidayRangePm((Collection)subHolidayRequests)) {
            post = this.getHalfWorkTypeAbbr(TimeNamingUtility.getSubHoliday((MospParams)this.mospParams));
        }
        if (TimeRequestUtility.hasHolidayRangeAm((Collection)substitutes)) {
            if (MospUtility.isEmpty((String[])new String[]{post})) {
                return TimeNamingUtility.halfSubstituteHolidayAbbr((MospParams)this.mospParams);
            }
            ante = TimeNamingUtility.anteSubstituteHolidayAbbr((MospParams)this.mospParams);
        }
        if (TimeRequestUtility.hasHolidayRangePm((Collection)substitutes)) {
            if (MospUtility.isEmpty((String[])new String[]{ante})) {
                return TimeNamingUtility.halfSubstituteHolidayAbbr((MospParams)this.mospParams);
            }
            post = TimeNamingUtility.postSubstituteHolidayAbbr((MospParams)this.mospParams);
        }
        String workTypeAbbr = this.getWorkTypeEntity(workTypeCode, workDate).getWorkTypeAbbr();
        if (MospUtility.isAllEmpty((String[])new String[]{ante, post})) {
            return workTypeAbbr;
        }
        if (MospUtility.isEmpty((String[])new String[]{ante})) {
            ante = this.getHalfWorkTypeAbbr(workTypeAbbr);
        }
        if (MospUtility.isEmpty((String[])new String[]{post})) {
            post = this.getHalfWorkTypeAbbr(workTypeAbbr);
        }
        if (MospUtility.isEmpty((String[])new String[]{ante, post})) {
            return "";
        }
        return MospUtility.concat((Object)Character.valueOf(PfNameUtility.slash((MospParams)this.mospParams).charAt(0)), (String[])new String[]{ante, post});
    }

    protected String getHalfWorkTypeAbbr(String workTypeAbbr) {
        return MospUtility.substring((String)workTypeAbbr, (int)1);
    }

    protected int count(Integer minutes) {
        return TimeUtility.count((Integer)minutes);
    }

    protected String getStringHours(Integer minutes, boolean needHyphen) {
        return TimeUtility.getStringPeriodTimeOrHyphen((MospParams)this.mospParams, (Integer)minutes, (boolean)needHyphen);
    }

    protected String getHourColonMinute(Date date, Date standardDate) {
        return TransStringUtility.getHourColonMinute((MospParams)this.mospParams, (Date)date, (Date)standardDate, (boolean)true);
    }

    protected String getIntegerTimes(Integer times) {
        return TransStringUtility.getIntegerTimes((MospParams)this.mospParams, (Integer)times, (boolean)true);
    }

    protected String getFloatTimes(Float times, boolean isDecimal) {
        return TransStringUtility.getFloatTimes((MospParams)this.mospParams, (Float)times, (boolean)true, (boolean)isDecimal);
    }

    protected String getDaysAndHours(Float days, Float hours) {
        return MospUtility.concat((Object)PfNameUtility.slash((MospParams)this.mospParams), (String[])new String[]{TransStringUtility.getFloatTimes((MospParams)this.mospParams, (Float)days, (boolean)true, (boolean)false), TransStringUtility.getFloatTimes((MospParams)this.mospParams, (Float)hours, (boolean)true, (boolean)false)});
    }

    protected boolean isTheListType(AttendanceListDto dto, int ... listTypes) {
        return AttendanceUtility.isTheListType((AttendanceListDto)dto, (int[])listTypes);
    }

    protected boolean isScheduleApplyRequest() {
        return AttendanceUtility.isScheduleApplyRequest((MospParams)this.mospParams);
    }

    public boolean isRetireOrSusoension(Date workDate) {
        if (HumanUtility.isRetired((Date)this.retireDate, (Date)workDate)) {
            return true;
        }
        return HumanUtility.isSuspension((Collection)this.suspensions, (Date)workDate);
    }

    public void setMospParams(MospParams mospParams) {
        this.mospParams = mospParams;
    }

    public List<AttendanceListDto> getAttendList() {
        return this.attendList;
    }

    public void setAttendList(List<AttendanceListDto> attendList) {
        this.attendList = attendList;
    }

    public void setRetireDate(Date retireDate) {
        this.retireDate = CapsuleUtility.getDateClone((Date)retireDate);
    }

    public Collection<SuspensionDtoInterface> getSuspensions() {
        return this.suspensions;
    }

    public void setSuspensions(Collection<SuspensionDtoInterface> suspensions) {
        this.suspensions = suspensions;
    }

    public ScheduleDateDtoInterface getScheduleDate(Date workDate) {
        return (ScheduleDateDtoInterface)this.scheduleDates.get(workDate);
    }

    public void setScheduleDates(Map<Date, ScheduleDateDtoInterface> scheduleDates) {
        this.scheduleDates = scheduleDates;
    }

    public void setWorkTypeEntities(Map<String, List<WorkTypeEntityInterface>> workTypeEntities) {
        this.workTypeEntities = workTypeEntities;
    }

    public AttendanceDtoInterface getAttendance(Date workDate) {
        return (AttendanceDtoInterface)this.attendances.get(workDate);
    }

    public void setAttendances(Map<Date, AttendanceDtoInterface> attendances) {
        this.attendances = attendances;
    }

    public void setOvertimeRequests(Map<Date, List<OvertimeRequestDtoInterface>> overtimeRequests) {
        this.overtimeRequests = overtimeRequests;
    }

    public void setHolidayRequests(Map<Date, List<HolidayRequestDtoInterface>> holidayRequests) {
        this.holidayRequests = holidayRequests;
    }

    public void setWorkOnHolidayRequests(Map<Date, WorkOnHolidayRequestDtoInterface> workOnHolidayRequests) {
        this.workOnHolidayRequests = workOnHolidayRequests;
    }

    public void setSubstitutedSchedules(Map<Date, ScheduleDateDtoInterface> substitutedSchedules) {
        this.substitutedSchedules = substitutedSchedules;
    }

    public void setSubstitutes(Map<Date, List<SubstituteDtoInterface>> substitutes) {
        this.substitutes = substitutes;
    }

    public void setSubHolidayRequests(Map<Date, List<SubHolidayRequestDtoInterface>> subHolidayRequests) {
        this.subHolidayRequests = subHolidayRequests;
    }

    public void setSubHolidays(Map<Integer, List<SubHolidayDtoInterface>> subHolidays) {
        this.subHolidays = subHolidays;
    }

    public void setWorkTypeChangeRequests(Map<Date, WorkTypeChangeRequestDtoInterface> workTypeChangeRequests) {
        this.workTypeChangeRequests = workTypeChangeRequests;
    }

    public void setDifferenceRequests(Map<Date, DifferenceRequestDtoInterface> differenceRequests) {
        this.differenceRequests = differenceRequests;
    }

    public void setWorkflows(Map<Long, WorkflowDtoInterface> workflows) {
        this.workflows = workflows;
    }

    public void setCorrections(Map<Date, List<AttendanceCorrectionDtoInterface>> corrections) {
        this.corrections = corrections;
    }

    public Set<HolidayDtoInterface> getHolidays() {
        return this.holidays;
    }

    public void setHolidays(Set<HolidayDtoInterface> holidays) {
        this.holidays = holidays;
    }
}

