/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.entity;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.time.entity.AttendCalcEntityInterface;
import jp.mosp.time.entity.AttendanceEntityInterface;
import jp.mosp.time.entity.RequestEntityInterface;
import jp.mosp.time.entity.TimeDuration;
import jp.mosp.time.entity.TimeSettingEntityInterface;
import jp.mosp.time.entity.WorkTypeEntityInterface;
import jp.mosp.time.utils.TimeUtility;

public class AttendCalcEntity
implements AttendCalcEntityInterface {
    public static final String KEY_LEGAL_WORK_TIME = "LegalWorkTime";
    public static final String KEY_ADD_HOLIDAY_TIMES = "AdditionalHolidayTimes";
    public static final String KEY_ADD_WORK_TIMES = "AdditionalWorkTimes";
    public static final String KEY_ADD_OVERTIME_IN_POSSIBLE = "AdditionalOvertimeInPossible";
    public static final String KEY_ADD_MINUTELY_HOLIDAY_A_TIMES = "AdditionalMinutelyHolidayATime";
    protected static final boolean IS_COMPLETED = true;
    protected AttendanceEntityInterface attendance;
    protected TimeSettingEntityInterface timeSetting;
    protected WorkTypeEntityInterface workType;
    protected RequestEntityInterface request;
    protected String nextWorkType;
    protected MospParams mospParams;
    protected Map<String, Object> params = new HashMap();

    public int calcStartTime(int inputStartTime) throws MospException {
        return this.calcStartTime(inputStartTime, this.attendance, this.workType, this.request, this.timeSetting);
    }

    public int calcActualStartTime(int inputStartTime) throws MospException {
        return this.calcActualStartTime(inputStartTime, this.attendance, this.workType, this.request, this.timeSetting);
    }

    public int calcEndTime(int inputEndTime) throws MospException {
        return this.calcEndTime(inputEndTime, this.attendance, this.workType, this.request, this.timeSetting);
    }

    public int calcActualEndTime(int inputEndTime) throws MospException {
        return this.calcActualEndTime(inputEndTime, this.attendance, this.workType, this.request, this.timeSetting);
    }

    public int calcLateTime(int startTime, int endTime) throws MospException {
        return this.calcLateTime(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting);
    }

    public int calcActualLateTime(int startTime, int endTime) throws MospException {
        return this.calcActualLateTime(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting);
    }

    public int calcLeaveEarlyTime(int startTime, int endTime) throws MospException {
        return this.calcLeaveEarlyTime(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting);
    }

    public int calcActualLeaveEarlyTime(int startTime, int endTime) throws MospException {
        return this.calcActualLeaveEarlyTime(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting);
    }

    public int calcWorkTime(int startTime, int endTime) throws MospException {
        return this.calcWorkTime(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting);
    }

    public int calcPrescribedWorkTime() throws MospException {
        return this.calcPrescribedWorkTime(this.workType, this.request);
    }

    public int calcWorkTimeWithinPrescribed(int startTime, int endTime) throws MospException {
        return this.calcWorkTimeWithinPrescribed(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting, this.nextWorkType);
    }

    public int calcShortUnpaid(int startTime, int endTime) throws MospException {
        return this.calcShortUnpay(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting);
    }

    public int calcRestTime(int startTime, int endTime) throws MospException {
        return this.calcRestTime(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting);
    }

    public int calcNightRestTime(int startTime, int endTime) throws MospException {
        return this.calcNightRestTime(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting);
    }

    public int calcLegalHolidayRestTime(int startTime, int endTime) throws MospException {
        return this.calcLegalHolidayRestTime(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting, this.nextWorkType);
    }

    public int calcPrescribedHolidayRestTime(int startTime, int endTime) throws MospException {
        return this.calcPrescribedHolidayRestTime(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting, this.nextWorkType);
    }

    public int calcPublicTime() {
        return this.calcPublicTime(this.attendance, this.timeSetting);
    }

    public int calcPrivateTime() {
        return this.calcPrivateTime(this.attendance, this.timeSetting);
    }

    public int calcOvertimeBefore(int startTime, int endTime) throws MospException {
        return this.calcOvertimeBefore(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting);
    }

    public int calcOvertimeAfter(int startTime, int endTime) throws MospException {
        return this.calcOvertimeAfter(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting, this.nextWorkType);
    }

    public int calcOvertimeIn(int startTime, int endTime) throws MospException {
        return this.calcOvertimeIn(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting, this.nextWorkType);
    }

    public int calcOvertimeOut(int startTime, int endTime) throws MospException {
        return this.calcOvertimeOut(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting, this.nextWorkType);
    }

    public int calcWorkdayOvertimeIn(int startTime, int endTime) throws MospException {
        return this.calcWorkdayOvertimeIn(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting, this.nextWorkType);
    }

    public int calcWorkdayOvertimeOut(int startTime, int endTime) throws MospException {
        return this.calcWorkdayOvertimeOut(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting, this.nextWorkType);
    }

    public int calcPrescribedHolidayOvertimeIn(int startTime, int endTime) throws MospException {
        return this.calcPrescribedHolidayOvertimeIn(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting, this.nextWorkType);
    }

    public int calcPrescribedHolidayOvertimeOut(int startTime, int endTime) throws MospException {
        return this.calcPrescribedHolidayOvertimeOut(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting, this.nextWorkType);
    }

    public int calcNightWorkTime(int startTime, int endTime) throws MospException {
        return this.calcNightWorkTime(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting);
    }

    public int calcNightWorkWithinPrescribed(int startTime, int endTime) throws MospException {
        return this.calcNightWorkWithinPrescribed(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting, this.nextWorkType);
    }

    public int calcNightWorkOvertime(int startTime, int endTime) throws MospException {
        return this.calcNightWorkOvertime(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting, this.nextWorkType);
    }

    public int calcNightWorkOnLegalHoliday(int startTime, int endTime) throws MospException {
        return this.calcNightWorkOnLegalHoliday(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting, this.nextWorkType);
    }

    public int calcPrescribedHolidayWorkTime(int startTime, int endTime) throws MospException {
        return this.calcPrescribedHolidayWorkTime(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting, this.nextWorkType);
    }

    public int calcLegalHolidayWorkTime(int startTime, int endTime) throws MospException {
        return this.calcLegalHolidayWorkTime(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting, this.nextWorkType);
    }

    public int calcDecreaseTime(int startTime, int endTime) throws MospException {
        return this.calcDecreaseTime(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting);
    }

    public int calcLegalHolidayWorkTimeIn(int startTime, int endTime) throws MospException {
        return this.calcLegalHolidayWorkTimeIn(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting, this.nextWorkType);
    }

    public int calcLegalHolidayWorkTimeOut(int startTime, int endTime) throws MospException {
        return this.calcLegalHolidayWorkTimeOut(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting, this.nextWorkType);
    }

    public int calcPrescribedHolidayWorkTimeIn(int startTime, int endTime) throws MospException {
        return this.calcPrescribedHolidayWorkTimeIn(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting, this.nextWorkType);
    }

    public int calcPrescribedHolidayWorkTimeOut(int startTime, int endTime) throws MospException {
        return this.calcPrescribedHolidayWorkTimeOut(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting, this.nextWorkType);
    }

    public Map<Integer, TimeDuration> getOvertimeBeforeRest(int startTime, int endTime) throws MospException {
        return this.getOvertimeBeforeRest(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting);
    }

    public Map<Integer, TimeDuration> getOvertimeRest(int startTime, int endTime) throws MospException {
        Map overtimeBeforeRest = this.getOvertimeBeforeRest(startTime, endTime, this.attendance, this.workType, this.request, this.timeSetting);
        return this.getOvertimeRest(startTime, endTime, overtimeBeforeRest, this.workType, this.request);
    }

    protected int calcStartTime(int inputStart, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        if (!this.isTimeValid(new int[]{inputStart})) {
            return inputStart;
        }
        int regularStart = this.getRegularAndHourlyHolidayTime(workType, request).getStartTime();
        TimeDuration beforeOvertime = this.getBeforeOvertime(workType, request, timeSetting);
        TimeDuration short1Pay = this.getShort1PayTime(workType, request);
        TimeDuration short2Pay = this.getShort2PayTime(workType, request);
        TimeDuration short1Unpay = this.getShort1UnpayTime(workType, request);
        TimeDuration short2Unpay = this.getShort2UnpayTime(workType, request);
        int roundedStart = timeSetting.roundDailyStart(inputStart);
        TimeDuration holiday = TimeUtility.getContainTime((Map)request.getHourlyHolidayTimes(true), (int)roundedStart);
        if (beforeOvertime.isValid() && roundedStart < beforeOvertime.getStartTime()) {
            return beforeOvertime.getStartTime();
        }
        if (beforeOvertime.isValid() && beforeOvertime.isContain(roundedStart, true, false)) {
            return roundedStart;
        }
        if (short1Pay.isValid() && short1Pay.isContain(roundedStart)) {
            return short1Pay.getStartTime();
        }
        if (short2Pay.isValid() && short2Pay.isContain(roundedStart)) {
            return short2Pay.getStartTime();
        }
        if (short1Unpay.isValid() && short1Unpay.isContain(roundedStart)) {
            return short1Unpay.getEndTime();
        }
        if (short2Unpay.isValid() && short2Unpay.isContain(roundedStart)) {
            return short2Unpay.getEndTime();
        }
        if (regularStart < roundedStart && attendance.isAttendanceDirectStart()) {
            return regularStart;
        }
        if (holiday.isValid()) {
            return holiday.getEndTime();
        }
        if (roundedStart < regularStart && !workType.isWorkOnHoliday()) {
            return regularStart;
        }
        return roundedStart;
    }

    protected int calcActualStartTime(int inputStart, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        if (!this.isTimeValid(new int[]{inputStart})) {
            return inputStart;
        }
        if (!timeSetting.isScheduledTimeAvailable()) {
            return inputStart;
        }
        if (workType.isAutoBeforeOvertimeAvailable()) {
            return inputStart;
        }
        int roundedStart = timeSetting.roundDailyStart(inputStart);
        TimeDuration holiday = TimeUtility.getContainTime((Map)request.getHourlyHolidayTimes(true), (int)roundedStart);
        if (this.getShort1PayTime(workType, request).isContain(roundedStart)) {
            return roundedStart;
        }
        if (holiday.isValid()) {
            return roundedStart;
        }
        return timeSetting.roundDailyStart(this.calcStartTime(inputStart, attendance, workType, request, timeSetting));
    }

    protected int calcEndTime(int inputEnd, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        if (!this.isTimeValid(new int[]{inputEnd})) {
            return inputEnd;
        }
        int regularEnd = this.getRegularAndHourlyHolidayTime(workType, request).getEndTime();
        TimeDuration bitweenAfterOvertime = this.getBitweenAfterOvertime(workType, request);
        TimeDuration short1Pay = this.getShort1PayTime(workType, request);
        TimeDuration short2Pay = this.getShort2PayTime(workType, request);
        TimeDuration short2Unpay = this.getShort2UnpayTime(workType, request);
        int roundedEnd = timeSetting.roundDailyEnd(inputEnd);
        TimeDuration holiday = TimeUtility.getContainTime((Map)request.getHourlyHolidayTimes(true), (int)roundedEnd);
        if (bitweenAfterOvertime.isValid() && bitweenAfterOvertime.getEndTime() < roundedEnd) {
            return bitweenAfterOvertime.getEndTime();
        }
        if (bitweenAfterOvertime.isValid() && bitweenAfterOvertime.isContain(roundedEnd)) {
            return roundedEnd;
        }
        if (request.isPmHoliday(true) && regularEnd < roundedEnd) {
            return regularEnd;
        }
        if (short1Pay.isValid() && short1Pay.isContain(roundedEnd)) {
            return short1Pay.getEndTime();
        }
        if (short2Pay.isValid() && short2Pay.isContain(roundedEnd)) {
            return short2Pay.getEndTime();
        }
        if (roundedEnd < short2Unpay.getEndTime() && attendance.isAttendanceDirectEnd()) {
            return short2Unpay.getStartTime();
        }
        if (roundedEnd < regularEnd && attendance.isAttendanceDirectEnd()) {
            return regularEnd;
        }
        if (holiday.isValid()) {
            return holiday.getStartTime();
        }
        return roundedEnd;
    }

    protected int calcActualEndTime(int inputEnd, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        if (!this.isTimeValid(new int[]{inputEnd})) {
            return inputEnd;
        }
        if (!timeSetting.isScheduledTimeAvailable()) {
            return inputEnd;
        }
        int roundedEnd = timeSetting.roundDailyEnd(inputEnd);
        TimeDuration holiday = TimeUtility.getContainTime((Map)request.getHourlyHolidayTimes(true), (int)roundedEnd);
        if (this.getShort2PayTime(workType, request).isContain(roundedEnd)) {
            return roundedEnd;
        }
        if (holiday.isValid()) {
            return roundedEnd;
        }
        return timeSetting.roundDailyEnd(this.calcEndTime(inputEnd, attendance, workType, request, timeSetting));
    }

    protected int calcLateTime(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        if (attendance.isLateReasonTrain() || attendance.isLateReasonCompany()) {
            return 0;
        }
        return this.calcActualLateTime(startTime, endTime, attendance, workType, request, timeSetting);
    }

    protected int calcActualLateTime(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        Map lates = this.getLateTimes(startTime, endTime, attendance, workType, request, timeSetting);
        return timeSetting.roundDailyLate(TimeUtility.getMinutes((Map)lates));
    }

    protected int calcLeaveEarlyTime(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        if (attendance.isLeaveEarlyReasonCompany()) {
            return 0;
        }
        return this.calcActualLeaveEarlyTime(startTime, endTime, attendance, workType, request, timeSetting);
    }

    protected int calcActualLeaveEarlyTime(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        if (!this.isTimeValid(new int[]{startTime, endTime})) {
            return 0;
        }
        TimeDuration regularTime = this.getRegularAndShortTime(workType, request);
        if (workType.isWorkOnHoliday()) {
            return 0;
        }
        if (regularTime.getEndTime() <= endTime) {
            return 0;
        }
        int leaveEarlyStartTime = regularTime.getStartTime();
        if (leaveEarlyStartTime < endTime) {
            leaveEarlyStartTime = endTime;
        }
        TimeDuration leaveEarlyTime = TimeDuration.getInstance((int)leaveEarlyStartTime, (int)regularTime.getEndTime());
        int leaveEarlyMinutes = leaveEarlyTime.getMinutes();
        Map restHolidays = this.getRestAndHourlyHolidayTimes(startTime, endTime, workType, request);
        return timeSetting.roundDailyLeaveEarly(leaveEarlyMinutes -= leaveEarlyTime.getOverlapMinutes(restHolidays));
    }

    protected int calcWorkTime(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        Map times = this.getWorkTimes(startTime, endTime, attendance, workType, request, timeSetting);
        return timeSetting.roundDailyWork(TimeUtility.getMinutes((Map)times));
    }

    protected int calcPrescribedWorkTime(WorkTypeEntityInterface workType, RequestEntityInterface request) throws MospException {
        int legalWorkTime;
        if (workType.isWorkOnHoliday()) {
            return 0;
        }
        int prescribedWorkTime = workType.getWorkTime();
        if (request.isAmHoliday(true) || request.isPmHoliday(true)) {
            prescribedWorkTime = this.getRegularTime(workType, request).getMinutes();
        }
        return prescribedWorkTime < (legalWorkTime = this.getLegalWorkTime()) ? prescribedWorkTime : legalWorkTime;
    }

    protected int calcWorkTimeWithinPrescribed(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        Map times = this.getWorkTimeWithinPrescribed(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        return timeSetting.roundDailyWork(TimeUtility.getMinutes((Map)times));
    }

    protected int calcShortUnpay(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        if (!this.isTimeValid(new int[]{startTime, endTime})) {
            return 0;
        }
        int unpay = TimeUtility.getMinutes((Map)workType.getShortUnpayTimes());
        int contained = this.getContainedShortUnpay(startTime, endTime, attendance, workType, request, timeSetting);
        int consumed = this.getConsumedShortUnpay(startTime, endTime, attendance, workType, request, timeSetting);
        return timeSetting.roundDailyShortUnpaid(unpay - contained - consumed);
    }

    protected int calcRestTime(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        if (!this.isTimeValid(new int[]{startTime, endTime})) {
            return 0;
        }
        Map rests = this.getAllRests(startTime, endTime, attendance, workType, request, timeSetting);
        return timeSetting.roundDailyRest(TimeUtility.getMinutes((Map)rests));
    }

    protected int calcNightRestTime(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        if (!this.isTimeValid(new int[]{startTime, endTime})) {
            return 0;
        }
        Map rests = this.getAllRests(startTime, endTime, attendance, workType, request, timeSetting);
        Map nightTimes = this.getNightTimes();
        return timeSetting.roundDailyRest(TimeUtility.getMinutes((Map)TimeUtility.getOverlap((Map)rests, (Map)nightTimes)));
    }

    protected int calcLegalHolidayRestTime(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        if (!this.isTimeValid(new int[]{startTime, endTime})) {
            return 0;
        }
        Map rests = this.getAllRests(startTime, endTime, attendance, workType, request, timeSetting);
        TimeDuration legalTime = this.getLegalTime(workType, timeSetting, nextWorkType);
        return timeSetting.roundDailyRest(TimeUtility.getMinutes((Map)legalTime.getOverlap(rests)));
    }

    protected int calcPrescribedHolidayRestTime(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        if (!this.isTimeValid(new int[]{startTime, endTime})) {
            return 0;
        }
        Map rests = this.getAllRests(startTime, endTime, attendance, workType, request, timeSetting);
        TimeDuration prescribedTime = this.getPrescribedTime(workType, timeSetting, nextWorkType);
        return timeSetting.roundDailyRest(TimeUtility.getMinutes((Map)prescribedTime.getOverlap(rests)));
    }

    protected int calcPublicTime(AttendanceEntityInterface attendance, TimeSettingEntityInterface timeSetting) {
        return TimeUtility.getMinutes((Map)attendance.getPublicGoOutTimes(timeSetting));
    }

    protected int calcPrivateTime(AttendanceEntityInterface attendance, TimeSettingEntityInterface timeSetting) {
        return TimeUtility.getMinutes((Map)attendance.getPrivateGoOutTimes(timeSetting));
    }

    protected int calcOvertimeBefore(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        Map overtimeBeforeTimes = this.getOvertimeBeforeTimes(startTime, endTime, attendance, workType, request, timeSetting);
        return timeSetting.roundDailyWork(TimeUtility.getMinutes((Map)overtimeBeforeTimes));
    }

    protected int calcOvertimeAfter(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        Map overtimeAfterTimes = this.getOvertimeAfterTimes(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        return timeSetting.roundDailyWork(TimeUtility.getMinutes((Map)overtimeAfterTimes));
    }

    protected int calcOvertimeIn(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        Map overtimeInTimes = this.getOvertimeInTimes(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        return timeSetting.roundDailyWork(TimeUtility.getMinutes((Map)overtimeInTimes));
    }

    protected int calcOvertimeOut(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        Map overtimeOutTimes = this.getOvertimeOutTimes(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        return timeSetting.roundDailyWork(TimeUtility.getMinutes((Map)overtimeOutTimes));
    }

    protected int calcWorkdayOvertimeIn(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        Map overtimeInTimes = this.getOvertimeInTimes(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        TimeDuration workDay = this.getWorkdayTime(workType, timeSetting, nextWorkType);
        return timeSetting.roundDailyWork(workDay.getOverlapMinutes(overtimeInTimes));
    }

    protected int calcWorkdayOvertimeOut(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        Map overtimeOutTimes = this.getOvertimeOutTimes(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        TimeDuration workDay = this.getWorkdayTime(workType, timeSetting, nextWorkType);
        return timeSetting.roundDailyWork(workDay.getOverlapMinutes(overtimeOutTimes));
    }

    protected int calcPrescribedHolidayOvertimeIn(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        Map overtimeInTimes = this.getOvertimeInTimes(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        TimeDuration prescribed = this.getPrescribedTime(workType, timeSetting, nextWorkType);
        return timeSetting.roundDailyWork(prescribed.getOverlapMinutes(overtimeInTimes));
    }

    protected int calcPrescribedHolidayOvertimeOut(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        Map overtimeOutTimes = this.getOvertimeOutTimes(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        TimeDuration prescribed = this.getPrescribedTime(workType, timeSetting, nextWorkType);
        return timeSetting.roundDailyWork(prescribed.getOverlapMinutes(overtimeOutTimes));
    }

    protected int calcNightWorkTime(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        if (!this.isTimeValid(new int[]{startTime, endTime})) {
            return 0;
        }
        Map nightWorkTimes = this.getNightWorkTimes(startTime, endTime, attendance, workType, request, timeSetting);
        return timeSetting.roundDailyWork(TimeUtility.getMinutes((Map)nightWorkTimes));
    }

    protected int calcNightWorkWithinPrescribed(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        if (!this.isTimeValid(new int[]{startTime, endTime})) {
            return 0;
        }
        Map times = this.getWorkTimeWithinPrescribed(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        Map nightWorkTimes = this.getNightWorkTimes(startTime, endTime, attendance, workType, request, timeSetting);
        return timeSetting.roundDailyWork(TimeUtility.getMinutes((Map)TimeUtility.getOverlap((Map)times, (Map)nightWorkTimes)));
    }

    protected int calcNightWorkOvertime(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        if (!this.isTimeValid(new int[]{startTime, endTime})) {
            return 0;
        }
        Map overtimeTimes = this.getOvertimeTimes(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        Map nightTimes = this.getNightWorkTimes(startTime, endTime, attendance, workType, request, timeSetting);
        return timeSetting.roundDailyWork(TimeUtility.getMinutes((Map)TimeUtility.getOverlap((Map)overtimeTimes, (Map)nightTimes)));
    }

    protected int calcNightWorkOnLegalHoliday(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        if (!this.isTimeValid(new int[]{startTime, endTime})) {
            return 0;
        }
        Map times = this.getWorkOnLegalTimes(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        Map nightTimes = this.getNightTimes();
        return timeSetting.roundDailyWork(TimeUtility.getMinutes((Map)TimeUtility.getOverlap((Map)times, (Map)nightTimes)));
    }

    protected int calcPrescribedHolidayWorkTime(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        Map times = this.getWorkOnPrescribedTimes(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        return timeSetting.roundDailyWork(TimeUtility.getMinutes((Map)times));
    }

    protected int calcLegalHolidayWorkTime(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        Map times = this.getWorkOnLegalTimes(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        return timeSetting.roundDailyWork(TimeUtility.getMinutes((Map)times));
    }

    protected int calcDecreaseTime(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        int decrease = 0;
        decrease += this.calcLateTime(startTime, endTime, attendance, workType, request, timeSetting);
        decrease += this.calcLeaveEarlyTime(startTime, endTime, attendance, workType, request, timeSetting);
        return timeSetting.roundDailyDecrease(decrease += this.calcPrivateTime(attendance, timeSetting));
    }

    protected int calcLegalHolidayWorkTimeIn(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        int overtimeStartTime = this.getOvertimeStartTime(startTime, endTime, attendance, workType, request, timeSetting);
        TimeDuration duration = TimeDuration.getInstance((int)TimeUtility.getNextDayStart(), (int)overtimeStartTime);
        if (!duration.isValid()) {
            return 0;
        }
        Map workOnLegalTimes = this.getWorkOnLegalTimes(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        return timeSetting.roundDailyWork(TimeUtility.getMinutes((Map)duration.getOverlap(workOnLegalTimes)));
    }

    protected int calcLegalHolidayWorkTimeOut(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        int legalHolidayWorkTime = this.calcLegalHolidayWorkTime(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        int legalHolidayWorkTimeIn = this.calcLegalHolidayWorkTimeIn(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        return timeSetting.roundDailyWork(legalHolidayWorkTime - legalHolidayWorkTimeIn);
    }

    protected int calcPrescribedHolidayWorkTimeIn(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        int overtimeStartTime = this.getOvertimeStartTime(startTime, endTime, attendance, workType, request, timeSetting);
        TimeDuration duration = TimeDuration.getInstance((int)TimeUtility.getNextDayStart(), (int)overtimeStartTime);
        if (!duration.isValid()) {
            return 0;
        }
        Map workOnPrescribedTimes = this.getWorkOnPrescribedTimes(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        return timeSetting.roundDailyWork(TimeUtility.getMinutes((Map)duration.getOverlap(workOnPrescribedTimes)));
    }

    protected int calcPrescribedHolidayWorkTimeOut(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        int prescribedHolidayWorkTime = this.calcPrescribedHolidayWorkTime(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        int prescribedHolidayWorkTimeIn = this.calcPrescribedHolidayWorkTimeIn(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        return timeSetting.roundDailyWork(prescribedHolidayWorkTime - prescribedHolidayWorkTimeIn);
    }

    protected TimeDuration getRegularTime(WorkTypeEntityInterface workType, RequestEntityInterface request) throws MospException {
        return workType.getRegularTime(request, true);
    }

    protected TimeDuration getRegularAndHourlyHolidayTime(WorkTypeEntityInterface workType, RequestEntityInterface request) throws MospException {
        return workType.getRegularAndHourlyHolidayTime(request, true);
    }

    protected TimeDuration getRegularAndShortTime(WorkTypeEntityInterface workType, RequestEntityInterface request) throws MospException {
        return workType.getRegularAndShortTime(request, true);
    }

    protected TimeDuration getBeforeOvertime(WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        return workType.getBeforeOvertime(timeSetting, request, true);
    }

    protected TimeDuration getBitweenAfterOvertime(WorkTypeEntityInterface workType, RequestEntityInterface request) throws MospException {
        return workType.getBitweenAfterOvertime(request, true);
    }

    protected TimeDuration getShort1PayTime(WorkTypeEntityInterface workType, RequestEntityInterface request) throws MospException {
        return workType.getShort1PayTime(request, true);
    }

    protected TimeDuration getShort2PayTime(WorkTypeEntityInterface workType, RequestEntityInterface request) throws MospException {
        return workType.getShort2PayTime(request, true);
    }

    protected TimeDuration getShort1UnpayTime(WorkTypeEntityInterface workType, RequestEntityInterface request) throws MospException {
        return workType.getShort1UnpayTime(request, true);
    }

    protected TimeDuration getShort2UnpayTime(WorkTypeEntityInterface workType, RequestEntityInterface request) throws MospException {
        return workType.getShort2UnpayTime(request, true);
    }

    protected Map<Integer, TimeDuration> getHolidayTimes(RequestEntityInterface request) {
        Map hourlies = request.getHourlyHolidayTimes(true);
        Map additionals = TimeUtility.getDurations((Map)this.params, (String)KEY_ADD_HOLIDAY_TIMES);
        return TimeUtility.mergeDurations((Map)hourlies, (Map)additionals);
    }

    protected Map<Integer, TimeDuration> getAllRests(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        Map inputRests = attendance.getRestTimes(timeSetting);
        Map overtimeBeforeRest = this.getOvertimeBeforeRest(startTime, endTime, attendance, workType, request, timeSetting);
        Map otRests = this.getOvertimeRest(startTime, endTime, overtimeBeforeRest, workType, request);
        Map overRests = TimeUtility.mergeDurations((Map)otRests, (Map)overtimeBeforeRest);
        return TimeUtility.mergeDurations((Map)inputRests, (Map)overRests);
    }

    protected int getOvertimeStartTime(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        int legalWorkTime = this.getLegalWorkTime();
        int overtimeBeforeRestStart = workType.getWorkTimeBeforeOvertime(request, legalWorkTime, true);
        int regularStart = this.getRegularTime(workType, request).getStartTime();
        if (workType.isWorkOnHoliday()) {
            regularStart = startTime;
        }
        Map inputRests = attendance.getRestTimes(timeSetting);
        Map lateRests = this.getLateAndLeaveEarlyRestTimes(startTime, endTime, workType, request);
        Map rests = TimeUtility.mergeDurations((Map)inputRests, (Map)lateRests);
        return TimeUtility.getReachTime((int)regularStart, (int)overtimeBeforeRestStart, (Map)rests);
    }

    protected int getOvertimeInPossible(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        int workTimeToOvertimeOut = this.getWorkTimeToOvertimeOut();
        int prescribedWorkTime = this.calcPrescribedWorkTime(workType, request);
        int overtimeInPossible = workTimeToOvertimeOut - prescribedWorkTime;
        overtimeInPossible += TimeUtility.getMinutes((Map)this.getHolidayTimes(request));
        overtimeInPossible += this.calcActualLateTime(startTime, endTime, attendance, workType, request, timeSetting);
        overtimeInPossible += this.calcActualLeaveEarlyTime(startTime, endTime, attendance, workType, request, timeSetting);
        overtimeInPossible += this.calcPrivateTime(attendance, timeSetting);
        return MospUtility.getIntOrZero((int)(overtimeInPossible += MospUtility.getIntValue((Map)this.params, (String)KEY_ADD_OVERTIME_IN_POSSIBLE)));
    }

    protected Map<Integer, TimeDuration> getOvertimeBeforeRest(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        TreeMap<Integer, TimeDuration> overtimeBeforeRests = new TreeMap<Integer, TimeDuration>();
        int overtimeBeforeRest = workType.getOvertimeBeforeRest();
        int legal = this.getLegalWorkTime();
        int beforeOvertimeBeforeRest = workType.getWorkTimeBeforeOvertimeBeforeRest(request, legal, true);
        int regularStart = this.getRegularTime(workType, request).getStartTime();
        Map inputRests = attendance.getRestTimes(timeSetting);
        Map lateRests = this.getLateAndLeaveEarlyRestTimes(startTime, endTime, workType, request);
        Map rests = TimeUtility.mergeDurations((Map)inputRests, (Map)lateRests);
        int overtimeBeforeRestStart = TimeUtility.getReachTime((int)regularStart, (int)beforeOvertimeBeforeRest, (Map)rests);
        int overtimeBeforeRestEnd = overtimeBeforeRestStart + overtimeBeforeRest;
        if (endTime < overtimeBeforeRestStart || overtimeBeforeRestEnd < startTime) {
            return overtimeBeforeRests;
        }
        int restStartTime = overtimeBeforeRestStart < startTime ? startTime : overtimeBeforeRestStart;
        int restEndTime = overtimeBeforeRestEnd < endTime ? overtimeBeforeRestEnd : endTime;
        TimeDuration duration = TimeDuration.getInstance((int)restStartTime, (int)restEndTime);
        Map holidayTimes = this.getHolidayTimes(request);
        return duration.getPostponed(holidayTimes);
    }

    protected Map<Integer, TimeDuration> getOvertimeRest(int startTime, int endTime, Map<Integer, TimeDuration> overtimeBeforeRest, WorkTypeEntityInterface workType, RequestEntityInterface request) throws MospException {
        if (!this.isTimeValid(new int[]{startTime, endTime})) {
            return Collections.emptyMap();
        }
        TreeMap<Integer, TimeDuration> overtimeRests = new TreeMap<Integer, TimeDuration>();
        if (!workType.isOvertimeRestValid()) {
            return Collections.emptyMap();
        }
        int overtimeRest = workType.getOvertimeRest();
        int overtimeRestPer = workType.getOvertimeRestPer();
        int countStart = this.getRegularTime(workType, request).getEndTime();
        if (!overtimeBeforeRest.isEmpty()) {
            countStart = TimeUtility.getDuration(overtimeBeforeRest).getEndTime();
        }
        if (countStart < startTime) {
            countStart = startTime;
        }
        int overtimeRestCount = (endTime - countStart) / overtimeRestPer;
        for (int i = 0; i < overtimeRestCount; ++i) {
            int overtimeRestStart = countStart + overtimeRestPer * (i + 1) - overtimeRest;
            TimeDuration duration = TimeDuration.getInstance((int)overtimeRestStart, (int)(overtimeRestStart + overtimeRest));
            overtimeRests.put(overtimeRestStart, duration);
        }
        return TimeUtility.combineDurations(overtimeRests);
    }

    protected Map<Integer, TimeDuration> getRestAndHourlyHolidayTimes(int startTime, int endTime, WorkTypeEntityInterface workType, RequestEntityInterface request) throws MospException {
        Map restTimes = workType.getRestTimes(startTime, endTime, request, true);
        Map holidayTimes = this.getHolidayTimes(request);
        return TimeUtility.mergeDurations((Map)restTimes, (Map)holidayTimes);
    }

    protected Map<Integer, TimeDuration> getLateAndLeaveEarlyRestTimes(int startTime, int endTime, WorkTypeEntityInterface workType, RequestEntityInterface request) throws MospException {
        TimeDuration startEndTime = TimeDuration.getInstance((int)startTime, (int)endTime);
        Map restTimes = workType.getRestTimes(startTime, endTime, request, true);
        Map holidayTimes = this.getHolidayTimes(request);
        restTimes = TimeUtility.getNotOverlap((Map)restTimes, (TimeDuration)startEndTime);
        restTimes = TimeUtility.getNotOverlap((Map)restTimes, (Map)holidayTimes);
        return restTimes;
    }

    protected Map<Integer, TimeDuration> getLateTimes(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        if (!this.isTimeValid(new int[]{startTime, endTime})) {
            return Collections.emptyMap();
        }
        TimeDuration regularTime = this.getRegularAndShortTime(workType, request);
        if (workType.isWorkOnHoliday()) {
            return Collections.emptyMap();
        }
        if (startTime <= regularTime.getStartTime()) {
            return Collections.emptyMap();
        }
        int lateEndTime = regularTime.getEndTime();
        if (startTime < lateEndTime) {
            lateEndTime = startTime;
        }
        TimeDuration lateTime = TimeDuration.getInstance((int)regularTime.getStartTime(), (int)lateEndTime);
        Map restHolidays = this.getRestAndHourlyHolidayTimes(startTime, endTime, workType, request);
        Map lateTimes = lateTime.getNotOverlap(restHolidays);
        return lateTimes;
    }

    protected Map<Integer, TimeDuration> getWorkTimes(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        if (!this.isTimeValid(new int[]{startTime, endTime})) {
            return Collections.emptyMap();
        }
        TimeDuration workTime = TimeDuration.getInstance((int)startTime, (int)endTime);
        TimeDuration short1Pay = this.getShort1PayTime(workType, request);
        TimeDuration short2Pay = this.getShort2PayTime(workType, request);
        Map holidayTimes = this.getHolidayTimes(request);
        Map rests = this.getAllRests(startTime, endTime, attendance, workType, request, timeSetting);
        Map goOuts = attendance.getAllGoOutTimes(timeSetting);
        Map durations = TimeUtility.mergeDurations((Map)holidayTimes, (Map)rests, (Map)goOuts);
        Map workTimes = workTime.getNotOverlap(durations);
        workTimes = TimeUtility.mergeDurations((Map)workTimes, (TimeDuration)short1Pay);
        workTimes = TimeUtility.mergeDurations((Map)workTimes, (TimeDuration)short2Pay);
        workTimes = TimeUtility.mergeDurations((Map)workTimes, (Map)TimeUtility.getDurations((Map)this.params, (String)KEY_ADD_WORK_TIMES));
        return workTimes;
    }

    protected Map<Integer, TimeDuration> getWorkTimeWithinPrescribed(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        if (!this.isTimeValid(new int[]{startTime, endTime})) {
            return Collections.emptyMap();
        }
        Map workTimes = this.getWorkTimes(startTime, endTime, attendance, workType, request, timeSetting);
        Map overtimeTimes = this.getOvertimeTimes(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        Map workOnLegalTimes = this.getWorkOnLegalTimes(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        Map times = TimeUtility.getNotOverlap((Map)workTimes, (Map)overtimeTimes);
        return TimeUtility.getNotOverlap((Map)times, (Map)workOnLegalTimes);
    }

    protected Map<Integer, TimeDuration> getWorkTimesForOvertimeAfter(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        if (!this.isTimeValid(new int[]{startTime, endTime})) {
            return Collections.emptyMap();
        }
        TimeDuration workTime = TimeDuration.getInstance((int)startTime, (int)endTime);
        Map rests = this.getAllRests(startTime, endTime, attendance, workType, request, timeSetting);
        Map overtimeBefores = this.getOvertimeBeforeTimes(startTime, endTime, attendance, workType, request, timeSetting);
        Map holidayTimes = this.getHolidayTimes(request);
        Map lates = this.getLateTimes(startTime, endTime, attendance, workType, request, timeSetting);
        TimeDuration short1Pay = this.getShort1PayTime(workType, request);
        TimeDuration short2Pay = this.getShort2PayTime(workType, request);
        Map subtracts = TimeUtility.mergeDurations((Map)rests, (Map)overtimeBefores);
        Map adds = TimeUtility.mergeDurations((Map)holidayTimes, (Map)lates);
        adds = TimeUtility.mergeDurations((Map)adds, (TimeDuration)short1Pay);
        adds = TimeUtility.mergeDurations((Map)adds, (TimeDuration)short2Pay);
        Map workTimes = workTime.getNotOverlap(subtracts);
        return TimeUtility.mergeDurations((Map)workTimes, (Map)adds);
    }

    protected int getContainedShortUnpay(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        TimeDuration short2Unpay = workType.getShort2UnpayTime(request, true);
        if (!short2Unpay.isValid()) {
            return 0;
        }
        Map workTimes = this.getWorkTimesForOvertimeAfter(startTime, endTime, attendance, workType, request, timeSetting);
        int overtimeStartTime = this.getOvertimeStartTime(startTime, endTime, attendance, workType, request, timeSetting);
        workTimes = TimeUtility.getBeforeTimes((Map)workTimes, (int)overtimeStartTime);
        int contained = short2Unpay.getOverlapMinutes(workTimes);
        if (short2Unpay.getMinutes() == contained) {
            return contained;
        }
        Map unpay2ToOvertime = TimeUtility.getAfterTimes((Map)workTimes, (int)short2Unpay.getEndTime());
        return (contained += TimeUtility.getMinutes((Map)unpay2ToOvertime)) < short2Unpay.getMinutes() ? contained : short2Unpay.getMinutes();
    }

    protected int getConsumedShortUnpay(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        int unpay = TimeUtility.getMinutes((Map)workType.getShortUnpayTimes());
        int containd = this.getContainedShortUnpay(startTime, endTime, attendance, workType, request, timeSetting);
        int remain = unpay - containd;
        Map workTimes = this.getWorkTimesForOvertimeAfter(startTime, endTime, attendance, workType, request, timeSetting);
        int overtimeStartTime = this.getOvertimeStartTime(startTime, endTime, attendance, workType, request, timeSetting);
        int overtime = TimeUtility.getMinutes((Map)(workTimes = TimeUtility.getAfterTimes((Map)workTimes, (int)overtimeStartTime)));
        int notConsumed = remain - overtime;
        notConsumed = notConsumed < 0 ? 0 : notConsumed;
        return remain - notConsumed;
    }

    protected Map<Integer, TimeDuration> getOvertimeTimes(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        Map befores = this.getOvertimeBeforeTimes(startTime, endTime, attendance, workType, request, timeSetting);
        Map afters = this.getOvertimeAfterTimes(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        return TimeUtility.mergeDurations((Map)befores, (Map)afters);
    }

    protected Map<Integer, TimeDuration> getOvertimeBeforeTimes(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        if (!this.isTimeValid(new int[]{startTime, endTime})) {
            return Collections.emptyMap();
        }
        if (workType.isWorkOnHoliday()) {
            return Collections.emptyMap();
        }
        int overtimeBeforeEnd = this.getRegularTime(workType, request).getStartTime();
        overtimeBeforeEnd = overtimeBeforeEnd < endTime ? overtimeBeforeEnd : endTime;
        TimeDuration overtimeBefore = TimeDuration.getInstance((int)startTime, (int)overtimeBeforeEnd);
        Map rests = attendance.getRestTimes(timeSetting);
        return overtimeBefore.getNotOverlap(rests);
    }

    protected Map<Integer, TimeDuration> getOvertimeAfterTimes(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        if (!this.isTimeValid(new int[]{startTime, endTime})) {
            return Collections.emptyMap();
        }
        Map workTimes = this.getWorkTimesForOvertimeAfter(startTime, endTime, attendance, workType, request, timeSetting);
        int overtimeStartTime = this.getOvertimeStartTime(startTime, endTime, attendance, workType, request, timeSetting);
        workTimes = TimeUtility.getAfterTimes((Map)workTimes, (int)overtimeStartTime);
        int consumedShort = this.getConsumedShortUnpay(startTime, endTime, attendance, workType, request, timeSetting);
        Map overtimeAfterTimes = TimeUtility.removeTime((Map)workTimes, (int)consumedShort);
        return TimeUtility.getNotOverlap((Map)overtimeAfterTimes, (TimeDuration)this.getLegalTime(workType, timeSetting, nextWorkType));
    }

    protected Map<Integer, TimeDuration> getOvertimeInTimes(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        Map overtimeTimes = this.getOvertimeTimes(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        int possible = this.getOvertimeInPossible(startTime, endTime, attendance, workType, request, timeSetting);
        return TimeUtility.getReachTimes((Map)overtimeTimes, (int)possible);
    }

    protected Map<Integer, TimeDuration> getOvertimeOutTimes(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        Map overtimeTimes = this.getOvertimeTimes(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        Map overtimeInTimes = this.getOvertimeInTimes(startTime, endTime, attendance, workType, request, timeSetting, nextWorkType);
        return TimeUtility.getNotOverlap((Map)overtimeTimes, (Map)overtimeInTimes);
    }

    protected Map<Integer, TimeDuration> getWorkOnPrescribedTimes(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        Map times = this.getWorkTimes(startTime, endTime, attendance, workType, request, timeSetting);
        TimeDuration prescribedTime = this.getPrescribedTime(workType, timeSetting, nextWorkType);
        return prescribedTime.getOverlap(times);
    }

    protected Map<Integer, TimeDuration> getWorkOnLegalTimes(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting, String nextWorkType) throws MospException {
        Map times = this.getWorkTimes(startTime, endTime, attendance, workType, request, timeSetting);
        TimeDuration legalTime = this.getLegalTime(workType, timeSetting, nextWorkType);
        return legalTime.getOverlap(times);
    }

    protected Map<Integer, TimeDuration> getNightWorkTimes(int startTime, int endTime, AttendanceEntityInterface attendance, WorkTypeEntityInterface workType, RequestEntityInterface request, TimeSettingEntityInterface timeSetting) throws MospException {
        Map times = this.getWorkTimes(startTime, endTime, attendance, workType, request, timeSetting);
        Map nightTimes = this.getNightTimes();
        return TimeUtility.getOverlap((Map)times, (Map)nightTimes);
    }

    protected TimeDuration getWorkdayTime(WorkTypeEntityInterface workType, TimeSettingEntityInterface timeSetting, String nextWorkType) {
        if (workType.isWorkOnPrescribed() && !timeSetting.isPrescribedHolidayBasedOnCalendar()) {
            return TimeDuration.getInvalid();
        }
        if (workType.isWorkOnHoliday() && TimeUtility.isLegalOrPrescribed((String)nextWorkType)) {
            return TimeDuration.getInvalid();
        }
        int startTime = 0;
        int endTime = TimeUtility.getNextDayEnd();
        if (workType.isWorkOnHoliday()) {
            startTime = TimeUtility.getNextDayStart();
        }
        if (TimeUtility.isLegal((String)nextWorkType)) {
            endTime = TimeUtility.getNextDayStart();
        }
        if (TimeUtility.isPrescribed((String)nextWorkType) && timeSetting.isPrescribedHolidayBasedOnCalendar()) {
            endTime = TimeUtility.getNextDayStart();
        }
        return TimeDuration.getInstance((int)startTime, (int)endTime);
    }

    protected TimeDuration getPrescribedTime(WorkTypeEntityInterface workType, TimeSettingEntityInterface timeSetting, String nextWorkType) {
        if (!workType.isPrescribed() && !TimeUtility.isPrescribed((String)nextWorkType)) {
            return TimeDuration.getInvalid();
        }
        if (workType.isWorkDay() && !timeSetting.isPrescribedHolidayBasedOnCalendar()) {
            return TimeDuration.getInvalid();
        }
        int startTime = 0;
        int endTime = TimeUtility.getNextDayEnd();
        if (workType.isPrescribed()) {
            endTime = TimeUtility.getNextDayStart();
        } else {
            startTime = TimeUtility.getNextDayStart();
        }
        if (TimeUtility.isPrescribed((String)nextWorkType)) {
            endTime = TimeUtility.getNextDayEnd();
        }
        if (workType.isPrescribed() && !timeSetting.isPrescribedHolidayBasedOnCalendar()) {
            endTime = TimeUtility.getNextDayEnd();
        }
        if (TimeUtility.isLegal((String)nextWorkType)) {
            endTime = TimeUtility.getNextDayStart();
        }
        return TimeDuration.getInstance((int)startTime, (int)endTime);
    }

    protected TimeDuration getLegalTime(WorkTypeEntityInterface workType, TimeSettingEntityInterface timeSetting, String nextWorkType) {
        int startTime = 0;
        int endTime = TimeUtility.getNextDayEnd();
        if (!workType.isLegal()) {
            startTime = TimeUtility.getNextDayStart();
        }
        if (!TimeUtility.isLegal((String)nextWorkType)) {
            endTime = TimeUtility.getNextDayStart();
        }
        return TimeDuration.getInstance((int)startTime, (int)endTime);
    }

    protected Map<Integer, TimeDuration> getNightTimes() {
        TreeMap<Integer, TimeDuration> nightTimes = new TreeMap<Integer, TimeDuration>();
        for (int i = 0; i < 3; ++i) {
            TimeDuration duration = TimeDuration.getInstance((int)TimeUtility.getNightStart((int)i), (int)TimeUtility.getNightEnd((int)i));
            nightTimes.put(duration.getStartTime(), duration);
        }
        return nightTimes;
    }

    protected int getLegalWorkTime() {
        int legalWorkTime = TimeUtility.getLegalWorkTime((MospParams)this.mospParams);
        int prior = MospUtility.getIntValue((Map)this.params, (String)KEY_LEGAL_WORK_TIME);
        return prior == 0 ? legalWorkTime : prior;
    }

    protected int getWorkTimeToOvertimeOut() {
        return this.getLegalWorkTime();
    }

    protected boolean isTimeValid(int ... times) {
        for (int time : times) {
            if (time != Integer.MIN_VALUE) continue;
            return false;
        }
        return true;
    }

    public AttendanceEntityInterface getAttendance() {
        return this.attendance;
    }

    public void setAttendance(AttendanceEntityInterface attendance) {
        this.attendance = attendance;
    }

    public void setTimeSetting(TimeSettingEntityInterface timeSetting) {
        this.timeSetting = timeSetting;
    }

    public void setWorkType(WorkTypeEntityInterface workType) {
        this.workType = workType;
    }

    public WorkTypeEntityInterface getWorkType() {
        return this.workType;
    }

    public void setRequest(RequestEntityInterface request) {
        this.request = request;
    }

    public RequestEntityInterface getRequest() {
        return this.request;
    }

    public void setNextWorkType(String nextWorkType) {
        this.nextWorkType = nextWorkType;
    }

    public void setMospParams(MospParams mospParams) {
        this.mospParams = mospParams;
    }

    public void putParam(String key, Object value) {
        this.params.put(key, value);
    }

    public void addDurationsParam(String key, Map<Integer, TimeDuration> durations) {
        TimeUtility.addDurations((Map)this.params, (String)key, durations);
    }

    public void addIntParam(String key, int value) {
        MospUtility.addValue((Map)this.params, (String)key, (int)value);
    }

    public Map<Integer, TimeDuration> getDurationsParam(String key) {
        return TimeUtility.getDurations((Map)this.params, (String)key);
    }
}

