/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.entity;

import java.util.Date;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.CapsuleUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.entity.CutoffEntityInterface;
import jp.mosp.time.utils.TimeMessageUtility;

public class ApplicationEntity {
    public static final int CODE_TIME_BUTTON_NONE = 9;
    public static final int CODE_REST_BUTTON_NONE = 2;
    protected ApplicationDtoInterface applicationDto;
    protected TimeSettingDtoInterface timeSettingDto;
    protected CutoffEntityInterface cutoffEntity;
    protected PaidHolidayDtoInterface paidHolidayDto;
    protected Date targetDate;

    public ApplicationEntity(ApplicationDtoInterface applicationDto) {
        this.applicationDto = applicationDto;
    }

    public boolean isValid() {
        if (this.applicationDto == null) {
            return false;
        }
        if (this.timeSettingDto == null) {
            return false;
        }
        if (!this.cutoffEntity.isExist()) {
            return false;
        }
        return this.paidHolidayDto != null;
    }

    public boolean isValid(MospParams mospParams) {
        boolean isValid = true;
        if (this.applicationDto == null) {
            isValid = false;
            TimeMessageUtility.addErrorApplicationDefect((MospParams)mospParams, (Date)this.targetDate);
        }
        return isValid;
    }

    public String getWorkSettingCode() {
        if (this.applicationDto == null || MospUtility.isEmpty((String[])new String[]{this.applicationDto.getWorkSettingCode()})) {
            return "";
        }
        return this.applicationDto.getWorkSettingCode();
    }

    public String getScheduleCode() {
        if (this.applicationDto == null || MospUtility.isEmpty((String[])new String[]{this.applicationDto.getScheduleCode()})) {
            return "";
        }
        return this.applicationDto.getScheduleCode();
    }

    public String getPaidHolidayCode() {
        if (this.applicationDto == null || MospUtility.isEmpty((String[])new String[]{this.applicationDto.getPaidHolidayCode()})) {
            return "";
        }
        return this.applicationDto.getPaidHolidayCode();
    }

    public String getCutoffCode() {
        if (this.timeSettingDto == null || this.timeSettingDto.getCutoffCode() == null) {
            return "";
        }
        return this.timeSettingDto.getCutoffCode();
    }

    public int getCutoffDate() {
        return this.cutoffEntity.getCutoffDate();
    }

    public boolean isTimeManaged() {
        if (this.timeSettingDto == null) {
            return false;
        }
        return PlatformUtility.isActivate((int)this.timeSettingDto.getTimeManagementFlag());
    }

    public int getStartDayOfWeek() {
        if (this.timeSettingDto == null) {
            return 1;
        }
        return this.timeSettingDto.getStartWeek();
    }

    public int getNoApproval() {
        return this.cutoffEntity.getNoApproval();
    }

    public boolean useScheduledTime() {
        if (this.timeSettingDto == null) {
            return false;
        }
        return this.timeSettingDto.getUseScheduledTime() == 0;
    }

    public boolean isSelfTightening() {
        return this.cutoffEntity.isSelfTightening();
    }

    public int getPortalTimeButtons() {
        if (this.timeSettingDto == null) {
            return 9;
        }
        return this.timeSettingDto.getPortalTimeButtons();
    }

    public int getPortalRestButtons() {
        if (this.timeSettingDto == null) {
            return 2;
        }
        return this.timeSettingDto.getPortalRestButtons();
    }

    public String getProspectsMonths() {
        if (this.timeSettingDto == null) {
            return "0";
        }
        return this.timeSettingDto.getProspectsMonths();
    }

    public boolean isHourlyPaidHolidayAvailable() {
        if (this.paidHolidayDto == null) {
            return false;
        }
        return PlatformUtility.isActivate((int)this.paidHolidayDto.getTimelyPaidHolidayFlag());
    }

    public ApplicationDtoInterface getApplicationDto() {
        return this.applicationDto;
    }

    public TimeSettingDtoInterface getTimeSettingDto() {
        return this.timeSettingDto;
    }

    public void setTimeSettingDto(TimeSettingDtoInterface timeSettingDto) {
        this.timeSettingDto = timeSettingDto;
    }

    public CutoffEntityInterface getCutoffEntity() {
        return this.cutoffEntity;
    }

    public void setCutoffEntity(CutoffEntityInterface cutoffEntity) {
        this.cutoffEntity = cutoffEntity;
    }

    public CutoffDtoInterface getCutoffDto() {
        return this.cutoffEntity.getCutoffDto();
    }

    public PaidHolidayDtoInterface getPaidHolidayDto() {
        return this.paidHolidayDto;
    }

    public void setPaidHolidayDto(PaidHolidayDtoInterface paidHolidayDto) {
        this.paidHolidayDto = paidHolidayDto;
    }

    public Date getTargetDate() {
        return CapsuleUtility.getDateClone((Date)this.targetDate);
    }

    public void setTargetDate(Date targetDate) {
        this.targetDate = CapsuleUtility.getDateClone((Date)targetDate);
    }
}

