/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.dao.settings.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.time.dao.settings.StockHolidayTransactionDaoInterface;
import jp.mosp.time.dto.settings.StockHolidayTransactionDtoInterface;
import jp.mosp.time.dto.settings.impl.TmtStockHolidayDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class TmtStockHolidayDao
extends PlatformDao
implements StockHolidayTransactionDaoInterface {
    public static final String TABLE = "tmt_stock_holiday";
    public static final String COL_TMT_STOCK_HOLIDAY_ID = "tmt_stock_holiday_id";
    public static final String COL_PERSONAL_ID = "personal_id";
    public static final String COL_ACTIVATE_DATE = "activate_date";
    public static final String COL_ACQUISITION_DATE = "acquisition_date";
    public static final String COL_GIVING_DAY = "giving_day";
    public static final String COL_CANCEL_DAY = "cancel_day";
    public static final String COL_INACTIVATE_FLAG = "inactivate_flag";
    public static final String KEY_1 = "tmt_stock_holiday_id";

    public void initDao() {
    }

    public BaseDto mapping() throws MospException {
        TmtStockHolidayDto dto = new TmtStockHolidayDto();
        dto.setTmtStockHolidayId(this.getLong("tmt_stock_holiday_id"));
        dto.setPersonalId(this.getString("personal_id"));
        dto.setActivateDate(this.getDate("activate_date"));
        dto.setAcquisitionDate(this.getDate("acquisition_date"));
        dto.setGivingDay(this.getDouble("giving_day"));
        dto.setCancelDay(this.getDouble("cancel_day"));
        dto.setInactivateFlag(this.getInt("inactivate_flag"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<StockHolidayTransactionDtoInterface> mappingAll() throws MospException {
        ArrayList<StockHolidayTransactionDtoInterface> all = new ArrayList<StockHolidayTransactionDtoInterface>();
        while (this.next()) {
            all.add((StockHolidayTransactionDtoInterface)this.mapping());
        }
        return all;
    }

    public StockHolidayTransactionDtoInterface findForKey(String personalId, Date activateDate, Date acquisitionDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmtStockHolidayDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmtStockHolidayDao.and());
            sb.append(TmtStockHolidayDao.equal((String)"personal_id"));
            sb.append(TmtStockHolidayDao.and());
            sb.append(TmtStockHolidayDao.equal((String)"activate_date"));
            sb.append(TmtStockHolidayDao.and());
            sb.append(TmtStockHolidayDao.equal((String)"acquisition_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, activateDate);
            this.setParam(this.index++, acquisitionDate);
            this.executeQuery();
            StockHolidayTransactionDtoInterface dto = null;
            if (this.next()) {
                dto = (StockHolidayTransactionDtoInterface)this.mapping();
            }
            StockHolidayTransactionDtoInterface stockHolidayTransactionDtoInterface = dto;
            return stockHolidayTransactionDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public StockHolidayTransactionDtoInterface findForInfo(String personalId, Date activateDate, Date acquisitionDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmtStockHolidayDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmtStockHolidayDao.and());
            sb.append(TmtStockHolidayDao.equal((String)"personal_id"));
            sb.append(TmtStockHolidayDao.and());
            sb.append(TmtStockHolidayDao.equal((String)"acquisition_date"));
            sb.append(TmtStockHolidayDao.and());
            sb.append("activate_date");
            sb.append(" <= ? ");
            sb.append(TmtStockHolidayDao.getOrderByColumnDescLimit1((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, acquisitionDate);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            StockHolidayTransactionDtoInterface dto = null;
            if (this.next()) {
                dto = (StockHolidayTransactionDtoInterface)this.mapping();
            }
            StockHolidayTransactionDtoInterface stockHolidayTransactionDtoInterface = dto;
            return stockHolidayTransactionDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<StockHolidayTransactionDtoInterface> findForList(String personalId, Date acquisitionDate, Date startDate, Date endDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmtStockHolidayDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmtStockHolidayDao.and());
            sb.append(TmtStockHolidayDao.inactivateFlagOff());
            sb.append(TmtStockHolidayDao.and());
            sb.append(TmtStockHolidayDao.equal((String)"personal_id"));
            sb.append(TmtStockHolidayDao.and());
            sb.append(TmtStockHolidayDao.equal((String)"acquisition_date"));
            if (startDate != null) {
                sb.append(TmtStockHolidayDao.and());
                sb.append(TmtStockHolidayDao.greaterEqual((String)"activate_date"));
            }
            if (endDate != null) {
                sb.append(TmtStockHolidayDao.and());
                sb.append(TmtStockHolidayDao.lessEqual((String)"activate_date"));
            }
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, acquisitionDate);
            if (startDate != null) {
                this.setParam(this.index++, startDate);
            }
            if (endDate != null) {
                this.setParam(this.index++, endDate);
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public StockHolidayTransactionDtoInterface findForKey(String personalId, Date activateDate, String inactivateFlag) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmtStockHolidayDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmtStockHolidayDao.and());
            sb.append(TmtStockHolidayDao.equal((String)"personal_id"));
            if (activateDate != null) {
                sb.append(TmtStockHolidayDao.and());
                sb.append(TmtStockHolidayDao.lessEqual((String)"activate_date"));
            }
            if (!inactivateFlag.isEmpty()) {
                sb.append(TmtStockHolidayDao.and());
                sb.append(TmtStockHolidayDao.equal((String)"inactivate_flag"));
            }
            sb.append(TmtStockHolidayDao.getOrderBy()).append("activate_date").append(TmtStockHolidayDao.getDescLimit1());
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            if (activateDate != null) {
                this.setParam(this.index++, activateDate);
            }
            if (!inactivateFlag.isEmpty()) {
                this.setParam(this.index++, Integer.parseInt(inactivateFlag));
            }
            this.executeQuery();
            StockHolidayTransactionDtoInterface dto = null;
            if (this.next()) {
                dto = (StockHolidayTransactionDtoInterface)this.mapping();
            }
            StockHolidayTransactionDtoInterface stockHolidayTransactionDtoInterface = dto;
            return stockHolidayTransactionDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            StockHolidayTransactionDtoInterface dto = (StockHolidayTransactionDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmtStockHolidayId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            StockHolidayTransactionDtoInterface dto = (StockHolidayTransactionDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmtStockHolidayId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        StockHolidayTransactionDtoInterface dto = (StockHolidayTransactionDtoInterface)baseDto;
        this.setParam(this.index++, dto.getTmtStockHolidayId());
        this.setParam(this.index++, dto.getPersonalId());
        this.setParam(this.index++, dto.getActivateDate());
        this.setParam(this.index++, dto.getAcquisitionDate());
        this.setParam(this.index++, dto.getGivingDay());
        this.setParam(this.index++, dto.getCancelDay());
        this.setParam(this.index++, dto.getInactivateFlag());
        this.setCommonParams(baseDto, isInsert);
    }
}

