/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.dao.settings.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.time.dao.settings.ApplicationDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmApplicationDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class TmmApplicationDao
extends PlatformDao
implements ApplicationDaoInterface {
    public static final String TABLE = "tmm_application";
    public static final String COL_TMM_APPLICATION_ID = "tmm_application_id";
    public static final String COL_APPLICATION_CODE = "application_code";
    public static final String COL_ACTIVATE_DATE = "activate_date";
    public static final String COL_APPLICATION_TYPE = "application_type";
    public static final String COL_APPLICATION_NAME = "application_name";
    public static final String COL_APPLICATION_ABBR = "application_abbr";
    public static final String COL_WORK_SETTING_CODE = "work_setting_code";
    public static final String COL_SCHEDULE_CODE = "schedule_code";
    public static final String COL_PAID_HOLIDAY_CODE = "paid_holiday_code";
    public static final String COL_WORK_PLACE_CODE = "work_place_code";
    public static final String COL_EMPLOYMENT_CONTRACT_CODE = "employment_contract_code";
    public static final String COL_SECTION_CODE = "section_code";
    public static final String COL_POSITION_CODE = "position_code";
    public static final String COL_PERSONAL_IDS = "personal_ids";
    public static final String COL_INACTIVATE_FLAG = "inactivate_flag";
    public static final String KEY_1 = "tmm_application_id";

    public void initDao() {
    }

    public BaseDto mapping() throws MospException {
        TmmApplicationDto dto = new TmmApplicationDto();
        dto.setTmmApplicationId(this.getLong("tmm_application_id"));
        dto.setApplicationCode(this.getString("application_code"));
        dto.setActivateDate(this.getDate("activate_date"));
        dto.setApplicationType(this.getInt("application_type"));
        dto.setApplicationName(this.getString("application_name"));
        dto.setApplicationAbbr(this.getString("application_abbr"));
        dto.setWorkSettingCode(this.getString("work_setting_code"));
        dto.setScheduleCode(this.getString("schedule_code"));
        dto.setPaidHolidayCode(this.getString("paid_holiday_code"));
        dto.setWorkPlaceCode(this.getString("work_place_code"));
        dto.setEmploymentContractCode(this.getString("employment_contract_code"));
        dto.setSectionCode(this.getString("section_code"));
        dto.setPositionCode(this.getString("position_code"));
        dto.setPersonalIds(this.getString("personal_ids"));
        dto.setInactivateFlag(this.getInt("inactivate_flag"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<ApplicationDtoInterface> mappingAll() throws MospException {
        ArrayList<ApplicationDtoInterface> all = new ArrayList<ApplicationDtoInterface>();
        while (this.next()) {
            all.add((ApplicationDtoInterface)this.mapping());
        }
        return all;
    }

    public ApplicationDtoInterface findForKey(String applicationCode, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"application_code"));
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, applicationCode);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            ApplicationDtoInterface dto = null;
            if (this.next()) {
                dto = (ApplicationDtoInterface)this.mapping();
            }
            ApplicationDtoInterface applicationDtoInterface = dto;
            return applicationDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<ApplicationDtoInterface> findForHistory(String applicationCode) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"application_code"));
            sb.append(TmmApplicationDao.getOrderByColumn((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, applicationCode);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<ApplicationDtoInterface> findForSearch(Map<String, Object> param) throws MospException {
        try {
            int i;
            Date activateDate = (Date)param.get("activateDate");
            String applicationCode = String.valueOf(param.get("applicationCode"));
            Integer applicationType = (Integer)param.get("applicationType");
            String applicationName = String.valueOf(param.get("applicationName"));
            String applicationAbbr = String.valueOf(param.get("applicationAbbr"));
            String workSettingCode = String.valueOf(param.get("workSettingCode"));
            String scheduleCode = String.valueOf(param.get("scheduleCode"));
            String paidHolidayCode = String.valueOf(param.get("paidHolidayCode"));
            String workPlaceCode = String.valueOf(param.get("workPlaceCode"));
            String employmentCode = String.valueOf(param.get("employmentCode"));
            String sectionCode = String.valueOf(param.get("sectionCode"));
            String positionCode = String.valueOf(param.get("positionCode"));
            List employeeCode = (List)param.get("personalId");
            String inactivateFlag = String.valueOf(param.get("inactivateFlag"));
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmApplicationDao.and());
            sb.append(this.getQueryForMaxActivateDate());
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.like((String)"application_code"));
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"application_type"));
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.like((String)"application_name"));
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.like((String)"application_abbr"));
            if (workPlaceCode != null && !workPlaceCode.equals("")) {
                sb.append(TmmApplicationDao.and());
                sb.append(TmmApplicationDao.equal((String)"work_place_code"));
            }
            if (employmentCode != null && !employmentCode.equals("")) {
                sb.append(TmmApplicationDao.and());
                sb.append(TmmApplicationDao.equal((String)"employment_contract_code"));
            }
            if (sectionCode != null && !sectionCode.equals("")) {
                sb.append(TmmApplicationDao.and());
                sb.append(TmmApplicationDao.equal((String)"section_code"));
            }
            if (positionCode != null && !positionCode.equals("")) {
                sb.append(TmmApplicationDao.and());
                sb.append(TmmApplicationDao.equal((String)"position_code"));
            }
            if (!workSettingCode.equals("null") && !workSettingCode.equals("")) {
                sb.append(TmmApplicationDao.and());
                sb.append(TmmApplicationDao.equal((String)"work_setting_code"));
            }
            if (!scheduleCode.equals("null") && !scheduleCode.equals("")) {
                sb.append(TmmApplicationDao.and());
                sb.append(TmmApplicationDao.equal((String)"schedule_code"));
            }
            if (!paidHolidayCode.equals("null") && !paidHolidayCode.equals("")) {
                sb.append(TmmApplicationDao.and());
                sb.append(TmmApplicationDao.equal((String)"paid_holiday_code"));
            }
            if (inactivateFlag != null && !inactivateFlag.equals("")) {
                sb.append(TmmApplicationDao.and());
                sb.append(TmmApplicationDao.equal((String)"inactivate_flag"));
            }
            if (employeeCode.size() > 0) {
                sb.append(TmmApplicationDao.and());
                sb.append(TmmApplicationDao.leftParenthesis());
                for (i = 0; i < employeeCode.size(); ++i) {
                    sb.append(TmmApplicationDao.like((String)"personal_ids"));
                    sb.append(TmmApplicationDao.or());
                }
                sb.delete(sb.lastIndexOf(TmmApplicationDao.or()), sb.length());
                sb.append(TmmApplicationDao.rightParenthesis());
            }
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, activateDate);
            this.setParam(this.index++, TmmApplicationDao.startWithParam((String)applicationCode));
            this.setParam(this.index++, applicationType.intValue());
            this.setParam(this.index++, TmmApplicationDao.containsParam((String)applicationName));
            this.setParam(this.index++, TmmApplicationDao.containsParam((String)applicationAbbr));
            if (!workPlaceCode.equals("")) {
                this.setParam(this.index++, workPlaceCode);
            }
            if (!employmentCode.equals("")) {
                this.setParam(this.index++, employmentCode);
            }
            if (!sectionCode.equals("")) {
                this.setParam(this.index++, sectionCode);
            }
            if (!positionCode.equals("")) {
                this.setParam(this.index++, positionCode);
            }
            if (!workSettingCode.equals("null") && !workSettingCode.equals("")) {
                this.setParam(this.index++, workSettingCode);
            }
            if (!scheduleCode.equals("null") && !scheduleCode.equals("")) {
                this.setParam(this.index++, scheduleCode);
            }
            if (!paidHolidayCode.equals("null") && !paidHolidayCode.equals("")) {
                this.setParam(this.index++, paidHolidayCode);
            }
            if (!inactivateFlag.equals("")) {
                this.setParam(this.index++, Integer.parseInt(inactivateFlag));
            }
            if (employeeCode.size() > 0) {
                for (i = 0; i < employeeCode.size(); ++i) {
                    this.setParam(this.index++, TmmApplicationDao.containsParam((String)String.valueOf(employeeCode.get(i))));
                }
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public ApplicationDtoInterface findFormerInfo(String applicationCode, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"application_code"));
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.less((String)"activate_date"));
            sb.append(TmmApplicationDao.getOrderByColumnDescLimit1((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, applicationCode);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            ApplicationDtoInterface dto = null;
            if (this.next()) {
                dto = (ApplicationDtoInterface)this.mapping();
            }
            ApplicationDtoInterface applicationDtoInterface = dto;
            return applicationDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public ApplicationDtoInterface findLatterInfo(String applicationCode, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"application_code"));
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.greater((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, applicationCode);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            ApplicationDtoInterface dto = null;
            if (this.next()) {
                dto = (ApplicationDtoInterface)this.mapping();
            }
            ApplicationDtoInterface applicationDtoInterface = dto;
            return applicationDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public ApplicationDtoInterface findForPersonalId(Date activateDate, String personalId) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmApplicationDao.and());
            sb.append(this.getQueryForMaxActivateDate());
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"inactivate_flag", (long)0L));
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"application_type", (long)Integer.parseInt("1")));
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.like((String)"personal_ids"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, activateDate);
            this.setParam(this.index++, TmmApplicationDao.containsParam((String)personalId));
            this.executeQuery();
            ApplicationDtoInterface dto = null;
            if (this.next()) {
                dto = (ApplicationDtoInterface)this.mapping();
            }
            ApplicationDtoInterface applicationDtoInterface = dto;
            return applicationDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<ApplicationDtoInterface> findPersonDuplicated(Date startDate, Date endDate, String personalId) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"inactivate_flag", (long)0L));
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.greater((String)"activate_date"));
            if (endDate != null) {
                sb.append(TmmApplicationDao.and());
                sb.append(TmmApplicationDao.less((String)"activate_date"));
            }
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"application_type", (long)Integer.parseInt("1")));
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.like((String)"personal_ids"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, startDate);
            if (endDate != null) {
                this.setParam(this.index++, endDate);
            }
            this.setParam(this.index++, TmmApplicationDao.containsParam((String)personalId));
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public ApplicationDtoInterface findForMaster(Date activateDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmApplicationDao.and());
            sb.append(this.getQueryForMaxActivateDate());
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"inactivate_flag", (long)0L));
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"application_type", (long)Integer.parseInt("0")));
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"work_place_code"));
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"employment_contract_code"));
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"section_code"));
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"position_code"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, activateDate);
            this.setParam(this.index++, workPlaceCode);
            this.setParam(this.index++, employmentContractCode);
            this.setParam(this.index++, sectionCode);
            this.setParam(this.index++, positionCode);
            this.executeQuery();
            ApplicationDtoInterface dto = null;
            if (this.next()) {
                dto = (ApplicationDtoInterface)this.mapping();
            }
            ApplicationDtoInterface applicationDtoInterface = dto;
            return applicationDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<ApplicationDtoInterface> findMasterDuplicated(Date startDate, Date endDate, String workPlaceCode, String employmentContractCode, String sectionCode, String positionCode) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"inactivate_flag", (long)0L));
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.greater((String)"activate_date"));
            sb.append(TmmApplicationDao.and());
            if (endDate != null) {
                sb.append(TmmApplicationDao.less((String)"activate_date"));
                sb.append(TmmApplicationDao.and());
            }
            sb.append(TmmApplicationDao.equal((String)"application_type", (long)Integer.parseInt("0")));
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"work_place_code"));
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"employment_contract_code"));
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"section_code"));
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"position_code"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, startDate);
            if (endDate != null) {
                this.setParam(this.index++, endDate);
            }
            this.setParam(this.index++, workPlaceCode);
            this.setParam(this.index++, employmentContractCode);
            this.setParam(this.index++, sectionCode);
            this.setParam(this.index++, positionCode);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<ApplicationDtoInterface> findPersonTerm(String personalId, Date startDate, Date endDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmApplicationDao.where());
            sb.append(this.deleteFlagOff());
            if (startDate != null) {
                sb.append(TmmApplicationDao.and());
                sb.append(TmmApplicationDao.greaterEqual((String)"activate_date"));
            }
            if (endDate != null) {
                sb.append(TmmApplicationDao.and());
                sb.append(TmmApplicationDao.lessEqual((String)"activate_date"));
            }
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.like((String)"personal_ids"));
            this.prepareStatement(sb.toString());
            if (startDate != null) {
                this.setParam(this.index++, startDate);
            }
            if (endDate != null) {
                this.setParam(this.index++, endDate);
            }
            this.setParam(this.index++, TmmApplicationDao.containsParam((String)personalId));
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            ApplicationDtoInterface dto = (ApplicationDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmmApplicationId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            ApplicationDtoInterface dto = (ApplicationDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmmApplicationId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        ApplicationDtoInterface dto = (ApplicationDtoInterface)baseDto;
        this.setParam(this.index++, dto.getTmmApplicationId());
        this.setParam(this.index++, dto.getApplicationCode());
        this.setParam(this.index++, dto.getActivateDate());
        this.setParam(this.index++, dto.getApplicationType());
        this.setParam(this.index++, dto.getApplicationName());
        this.setParam(this.index++, dto.getApplicationAbbr());
        this.setParam(this.index++, dto.getWorkSettingCode());
        this.setParam(this.index++, dto.getScheduleCode());
        this.setParam(this.index++, dto.getPaidHolidayCode());
        this.setParam(this.index++, dto.getWorkPlaceCode());
        this.setParam(this.index++, dto.getEmploymentContractCode());
        this.setParam(this.index++, dto.getSectionCode());
        this.setParam(this.index++, dto.getPositionCode());
        this.setParam(this.index++, dto.getPersonalIds());
        this.setParam(this.index++, dto.getInactivateFlag());
        this.setCommonParams(baseDto, isInsert);
    }

    public Map<String, Object> getParamsMap() {
        return new HashMap<String, Object>();
    }

    public StringBuffer getQueryForMaxActivateDate() {
        StringBuffer sb = new StringBuffer();
        sb.append("activate_date");
        sb.append(TmmApplicationDao.in());
        sb.append(TmmApplicationDao.leftParenthesis());
        sb.append(TmmApplicationDao.selectMax((String)"activate_date"));
        sb.append(TmmApplicationDao.from((String)"tmm_application"));
        sb.append("AS A ");
        sb.append(TmmApplicationDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(TmmApplicationDao.and());
        sb.append("tmm_application.application_code");
        sb.append(" = A.application_code");
        sb.append(TmmApplicationDao.and());
        sb.append(TmmApplicationDao.lessEqual((String)"activate_date"));
        sb.append(TmmApplicationDao.rightParenthesis());
        return sb;
    }

    public List<ApplicationDtoInterface> findForActivateDate(Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmApplicationDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmmApplicationDao.and());
            sb.append(TmmApplicationDao.equal((String)"inactivate_flag", (long)0L));
            sb.append(TmmApplicationDao.and());
            sb.append(this.getQueryForMaxActivateDate());
            sb.append(TmmApplicationDao.getOrderByColumn((String)"application_code"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<ApplicationDtoInterface> findForCheckTerm(Date fromActivateDate, Date toActivateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmApplicationDao.where());
            sb.append(this.deleteFlagOff());
            if (fromActivateDate != null) {
                sb.append(TmmApplicationDao.and());
                sb.append(TmmApplicationDao.greater((String)"activate_date"));
            }
            if (toActivateDate != null) {
                sb.append(TmmApplicationDao.and());
                sb.append(TmmApplicationDao.less((String)"activate_date"));
            }
            sb.append(TmmApplicationDao.getOrderByColumn((String)"application_code", (String)"activate_date"));
            this.prepareStatement(sb.toString());
            if (fromActivateDate != null) {
                this.setParam(this.index++, fromActivateDate);
            }
            if (toActivateDate != null) {
                this.setParam(this.index++, toActivateDate);
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<ApplicationDtoInterface> findForTerm(Date startDate, Date endDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmmApplicationDao.where());
            sb.append(this.deleteFlagOff());
            if (startDate != null) {
                sb.append(TmmApplicationDao.and());
                sb.append(TmmApplicationDao.greaterEqual((String)"activate_date"));
            }
            if (endDate != null) {
                sb.append(TmmApplicationDao.and());
                sb.append(TmmApplicationDao.lessEqual((String)"activate_date"));
            }
            sb.append(TmmApplicationDao.getOrderByColumn((String)"application_code", (String)"activate_date"));
            this.prepareStatement(sb.toString());
            if (startDate != null) {
                this.setParam(this.index++, startDate);
            }
            if (endDate != null) {
                this.setParam(this.index++, endDate);
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }
}

