/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.dao.settings.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDao;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.time.dao.settings.WorkTypeChangeRequestDaoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdWorkTypeChangeRequestDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class TmdWorkTypeChangeRequestDao
extends BaseDao
implements WorkTypeChangeRequestDaoInterface {
    public static final String TABLE = "tmd_work_type_change_request";
    public static final String COL_TMD_WORK_TYPE_CHANGE_REQUEST_ID = "tmd_work_type_change_request_id";
    public static final String COL_PERSONAL_ID = "personal_id";
    public static final String COL_REQUEST_DATE = "request_date";
    public static final String COL_TIMES_WORK = "times_work";
    public static final String COL_WORK_TYPE_CODE = "work_type_code";
    public static final String COL_REQUEST_REASON = "request_reason";
    public static final String COL_WORKFLOW = "workflow";
    public static final String KEY_1 = "tmd_work_type_change_request_id";
    private WorkflowDaoInterface workflowDao;

    public void initDao() throws MospException {
        this.workflowDao = (WorkflowDaoInterface)this.loadDao(WorkflowDaoInterface.class);
    }

    public BaseDto mapping() throws MospException {
        TmdWorkTypeChangeRequestDto dto = new TmdWorkTypeChangeRequestDto();
        dto.setTmdWorkTypeChangeRequestId(this.getLong("tmd_work_type_change_request_id"));
        dto.setPersonalId(this.getString("personal_id"));
        dto.setRequestDate(this.getDate("request_date"));
        dto.setTimesWork(this.getInt("times_work"));
        dto.setWorkTypeCode(this.getString("work_type_code"));
        dto.setRequestReason(this.getString("request_reason"));
        dto.setWorkflow(this.getLong("workflow"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<WorkTypeChangeRequestDtoInterface> mappingAll() throws MospException {
        ArrayList<WorkTypeChangeRequestDtoInterface> all = new ArrayList<WorkTypeChangeRequestDtoInterface>();
        while (this.next()) {
            all.add((WorkTypeChangeRequestDtoInterface)this.mapping());
        }
        return all;
    }

    public List<WorkTypeChangeRequestDtoInterface> findForSearch(Map<String, Object> param) throws MospException {
        try {
            String personalId = String.valueOf(param.get("personalId"));
            String workTypeCode = String.valueOf(param.get("workTypeCode"));
            Date requestStartDate = (Date)param.get("requestStartDate");
            Date requestEndDate = (Date)param.get("requestEndDate");
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdWorkTypeChangeRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdWorkTypeChangeRequestDao.and());
            sb.append(TmdWorkTypeChangeRequestDao.equal((String)"personal_id"));
            sb.append(TmdWorkTypeChangeRequestDao.and());
            sb.append(TmdWorkTypeChangeRequestDao.greaterEqual((String)"request_date"));
            sb.append(TmdWorkTypeChangeRequestDao.and());
            sb.append(TmdWorkTypeChangeRequestDao.lessEqual((String)"request_date"));
            if (!workTypeCode.isEmpty()) {
                sb.append(TmdWorkTypeChangeRequestDao.and());
                sb.append(TmdWorkTypeChangeRequestDao.equal((String)"work_type_code"));
            }
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, requestStartDate);
            this.setParam(this.index++, requestEndDate);
            if (!workTypeCode.isEmpty()) {
                this.setParam(this.index++, workTypeCode);
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public WorkTypeChangeRequestDtoInterface findForKeyOnWorkflow(String personalId, Date requestDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdWorkTypeChangeRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdWorkTypeChangeRequestDao.and());
            sb.append(TmdWorkTypeChangeRequestDao.equal((String)"personal_id"));
            sb.append(TmdWorkTypeChangeRequestDao.and());
            sb.append(TmdWorkTypeChangeRequestDao.equal((String)"request_date"));
            sb.append(TmdWorkTypeChangeRequestDao.and());
            sb.append("workflow");
            sb.append(TmdWorkTypeChangeRequestDao.in());
            sb.append(TmdWorkTypeChangeRequestDao.leftParenthesis());
            sb.append(this.workflowDao.getSubQueryForNotEqualWithdrawn());
            sb.append(TmdWorkTypeChangeRequestDao.rightParenthesis());
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, requestDate);
            this.executeQuery();
            WorkTypeChangeRequestDtoInterface dto = null;
            if (this.next()) {
                dto = (WorkTypeChangeRequestDtoInterface)this.mapping();
            }
            WorkTypeChangeRequestDtoInterface workTypeChangeRequestDtoInterface = dto;
            return workTypeChangeRequestDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public WorkTypeChangeRequestDtoInterface findForWorkflow(long workflow) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdWorkTypeChangeRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdWorkTypeChangeRequestDao.and());
            sb.append(TmdWorkTypeChangeRequestDao.equal((String)"workflow"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, workflow);
            this.executeQuery();
            WorkTypeChangeRequestDtoInterface dto = null;
            if (this.next()) {
                dto = (WorkTypeChangeRequestDtoInterface)this.mapping();
            }
            WorkTypeChangeRequestDtoInterface workTypeChangeRequestDtoInterface = dto;
            return workTypeChangeRequestDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<WorkTypeChangeRequestDtoInterface> findForPersonalIds(Collection<String> personalIds, Date workDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdWorkTypeChangeRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdWorkTypeChangeRequestDao.in((String)"personal_id", (int)personalIds.size()));
            sb.append(TmdWorkTypeChangeRequestDao.and());
            sb.append(TmdWorkTypeChangeRequestDao.equal((String)"request_date"));
            this.prepareStatement(sb.toString());
            this.setParamsStringIn(personalIds);
            this.setParam(this.index++, workDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<WorkTypeChangeRequestDtoInterface> findForTerm(String personalId, Date firstDate, Date lastDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdWorkTypeChangeRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdWorkTypeChangeRequestDao.and());
            sb.append(TmdWorkTypeChangeRequestDao.equal((String)"personal_id"));
            sb.append(TmdWorkTypeChangeRequestDao.and());
            sb.append(TmdWorkTypeChangeRequestDao.lessEqual((String)"request_date"));
            sb.append(TmdWorkTypeChangeRequestDao.and());
            sb.append(TmdWorkTypeChangeRequestDao.greaterEqual((String)"request_date"));
            sb.append(TmdWorkTypeChangeRequestDao.getOrderByColumn((String)"request_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, lastDate, false);
            this.setParam(this.index++, firstDate, false);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            WorkTypeChangeRequestDtoInterface dto = (WorkTypeChangeRequestDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmdWorkTypeChangeRequestId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            WorkTypeChangeRequestDtoInterface dto = (WorkTypeChangeRequestDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmdWorkTypeChangeRequestId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        WorkTypeChangeRequestDtoInterface dto = (WorkTypeChangeRequestDtoInterface)baseDto;
        this.setParam(this.index++, dto.getTmdWorkTypeChangeRequestId());
        this.setParam(this.index++, dto.getPersonalId());
        this.setParam(this.index++, dto.getRequestDate());
        this.setParam(this.index++, dto.getTimesWork());
        this.setParam(this.index++, dto.getWorkTypeCode());
        this.setParam(this.index++, dto.getRequestReason());
        this.setParam(this.index++, dto.getWorkflow());
        this.setCommonParams(baseDto, isInsert);
    }

    public Map<String, Object> getParamsMap() {
        return new HashMap<String, Object>();
    }
}

