/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.dao.settings.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.time.dao.settings.SubstituteDaoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdSubstituteDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class TmdSubstituteDao
extends PlatformDao
implements SubstituteDaoInterface {
    public static final String TABLE = "tmd_substitute";
    public static final String COL_TMD_SUBSTITUTE_ID = "tmd_substitute_id";
    public static final String COL_PERSONAL_ID = "personal_id";
    public static final String COL_SUBSTITUTE_DATE = "substitute_date";
    public static final String COL_SUBSTITUTE_TYPE = "substitute_type";
    public static final String COL_SUBSTITUTE_RANGE = "substitute_range";
    public static final String COL_WORK_DATE = "work_date";
    public static final String COL_TIMES_WORK = "times_work";
    public static final String COL_WORKFLOW = "workflow";
    public static final String COL_TRANSITION_FLAG = "transition_flag";
    public static final String KEY_1 = "tmd_substitute_id";
    private WorkflowDaoInterface workflowDao;

    public void initDao() throws MospException {
        this.workflowDao = (WorkflowDaoInterface)this.loadDao(WorkflowDaoInterface.class);
    }

    public BaseDto mapping() throws MospException {
        TmdSubstituteDto dto = new TmdSubstituteDto();
        dto.setTmdSubstituteId(this.getLong("tmd_substitute_id"));
        dto.setPersonalId(this.getString("personal_id"));
        dto.setSubstituteDate(this.getDate("substitute_date"));
        dto.setSubstituteType(this.getString("substitute_type"));
        dto.setSubstituteRange(this.getInt("substitute_range"));
        dto.setWorkDate(this.getDate("work_date"));
        dto.setTimesWork(this.getInt("times_work"));
        dto.setWorkflow(this.getLong("workflow"));
        dto.setTransitionFlag(this.getInt("transition_flag"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<SubstituteDtoInterface> mappingAll() throws MospException {
        ArrayList<SubstituteDtoInterface> all = new ArrayList<SubstituteDtoInterface>();
        while (this.next()) {
            all.add((SubstituteDtoInterface)this.mapping());
        }
        return all;
    }

    public SubstituteDtoInterface findForKeyOnWorkflow(String personalId, Date substituteDate, int substituteRange, Date workDate, int timesWork) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubstituteDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubstituteDao.and());
            sb.append(TmdSubstituteDao.equal((String)"personal_id"));
            sb.append(TmdSubstituteDao.and());
            sb.append(TmdSubstituteDao.equal((String)"substitute_date"));
            sb.append(TmdSubstituteDao.and());
            sb.append(TmdSubstituteDao.equal((String)"substitute_range"));
            sb.append(TmdSubstituteDao.and());
            sb.append(TmdSubstituteDao.equal((String)"work_date"));
            sb.append(TmdSubstituteDao.and());
            sb.append(TmdSubstituteDao.equal((String)"times_work"));
            sb.append(TmdSubstituteDao.and());
            sb.append("workflow");
            sb.append(TmdSubstituteDao.in());
            sb.append(TmdSubstituteDao.leftParenthesis());
            sb.append(this.workflowDao.getSubQueryForNotEqualWithdrawn());
            sb.append(TmdSubstituteDao.rightParenthesis());
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, substituteDate);
            this.setParam(this.index++, substituteRange);
            this.setParam(this.index++, workDate);
            this.setParam(this.index++, timesWork);
            this.executeQuery();
            SubstituteDtoInterface dto = null;
            if (this.next()) {
                dto = (SubstituteDtoInterface)this.mapping();
            }
            SubstituteDtoInterface substituteDtoInterface = dto;
            return substituteDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SubstituteDtoInterface> findForWorkDate(String personalId, Date workDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubstituteDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubstituteDao.and());
            sb.append(TmdSubstituteDao.equal((String)"personal_id"));
            sb.append(TmdSubstituteDao.and());
            sb.append(TmdSubstituteDao.equal((String)"work_date"));
            sb.append(TmdSubstituteDao.getOrderByColumn((String)"substitute_date", (String)"substitute_range"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, workDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SubstituteDtoInterface> findForList(String personalId, Date substituteDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubstituteDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubstituteDao.and());
            sb.append(TmdSubstituteDao.equal((String)"personal_id"));
            sb.append(TmdSubstituteDao.and());
            sb.append(TmdSubstituteDao.equal((String)"substitute_date"));
            sb.append(TmdSubstituteDao.getOrderByColumn((String)"substitute_date", (String)"substitute_range"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, substituteDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SubstituteDtoInterface> findForPersonalIds(Collection<String> personalIds, Date substituteDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubstituteDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubstituteDao.in((String)"personal_id", (int)personalIds.size()));
            sb.append(TmdSubstituteDao.and());
            sb.append(TmdSubstituteDao.equal((String)"substitute_date"));
            sb.append(TmdSubstituteDao.getOrderByColumn((String)"substitute_range"));
            this.prepareStatement(sb.toString());
            this.setParamsStringIn(personalIds);
            this.setParam(this.index++, substituteDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SubstituteDtoInterface> findForTerm(String personalId, Date firstDate, Date lastDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubstituteDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubstituteDao.and());
            sb.append(TmdSubstituteDao.equal((String)"personal_id"));
            sb.append(TmdSubstituteDao.and());
            sb.append(TmdSubstituteDao.lessEqual((String)"substitute_date"));
            sb.append(TmdSubstituteDao.and());
            sb.append(TmdSubstituteDao.greaterEqual((String)"substitute_date"));
            sb.append(TmdSubstituteDao.getOrderByColumn((String)"substitute_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, lastDate, false);
            this.setParam(this.index++, firstDate, false);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SubstituteDtoInterface> findForWorkflow(long workflow) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubstituteDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubstituteDao.and());
            sb.append(TmdSubstituteDao.equal((String)"workflow"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, workflow);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SubstituteDtoInterface> findForWorkDates(String personalId, Set<Date> workDates) throws MospException {
        if (MospUtility.isEmpty(workDates)) {
            return new ArrayList<SubstituteDtoInterface>();
        }
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubstituteDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubstituteDao.and());
            sb.append(TmdSubstituteDao.equal((String)"personal_id"));
            sb.append(TmdSubstituteDao.in((String)"work_date", (int)workDates.size()));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParamsDateIn(workDates);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            SubstituteDtoInterface dto = (SubstituteDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmdSubstituteId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            SubstituteDtoInterface dto = (SubstituteDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmdSubstituteId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        SubstituteDtoInterface dto = (SubstituteDtoInterface)baseDto;
        this.setParam(this.index++, dto.getTmdSubstituteId());
        this.setParam(this.index++, dto.getPersonalId());
        this.setParam(this.index++, dto.getSubstituteDate());
        this.setParam(this.index++, dto.getSubstituteType());
        this.setParam(this.index++, dto.getSubstituteRange());
        this.setParam(this.index++, dto.getWorkDate());
        this.setParam(this.index++, dto.getTimesWork());
        this.setParam(this.index++, dto.getWorkflow());
        this.setParam(this.index++, dto.getTransitionFlag());
        this.setCommonParams(baseDto, isInsert);
    }

    protected SubstituteDtoInterface castDto(BaseDtoInterface baseDto) {
        return (SubstituteDtoInterface)baseDto;
    }

    public SubstituteDtoInterface findForDate(String personalId, Date substituteDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubstituteDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubstituteDao.and());
            sb.append(TmdSubstituteDao.equal((String)"personal_id"));
            sb.append(TmdSubstituteDao.and());
            sb.append(TmdSubstituteDao.equal((String)"substitute_date"));
            sb.append(TmdSubstituteDao.and());
            sb.append("workflow");
            sb.append(TmdSubstituteDao.in());
            sb.append(TmdSubstituteDao.leftParenthesis());
            sb.append(this.workflowDao.getSubQueryForNotEqualWithdrawn());
            sb.append(TmdSubstituteDao.rightParenthesis());
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, substituteDate);
            this.executeQuery();
            SubstituteDtoInterface dto = null;
            if (this.next()) {
                dto = (SubstituteDtoInterface)this.mapping();
            }
            SubstituteDtoInterface substituteDtoInterface = dto;
            return substituteDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }
}

