/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.dao.settings.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.time.dao.settings.SubHolidayDaoInterface;
import jp.mosp.time.dto.settings.SubHolidayDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdSubHolidayDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class TmdSubHolidayDao
extends PlatformDao
implements SubHolidayDaoInterface {
    public static final String TABLE = "tmd_sub_holiday";
    public static final String COL_TMD_SUB_HOLIDAY_ID = "tmd_sub_holiday_id";
    public static final String COL_PERSONAL_ID = "personal_id";
    public static final String COL_WORK_DATE = "work_date";
    public static final String COL_TIMES_WORK = "times_work";
    public static final String COL_SUB_HOLIDAY_TYPE = "sub_holiday_type";
    public static final String COL_SUB_HOLIDAY_DAYS = "sub_holiday_days";
    public static final String COL_TRANSITION_FLAG = "transition_flag";
    public static final String KEY_1 = "tmd_sub_holiday_id";

    public void initDao() {
    }

    public BaseDto mapping() throws MospException {
        TmdSubHolidayDto dto = new TmdSubHolidayDto();
        dto.setTmdSubHolidayId(this.getLong("tmd_sub_holiday_id"));
        dto.setPersonalId(this.getString("personal_id"));
        dto.setWorkDate(this.getDate("work_date"));
        dto.setTimesWork(this.getInt("times_work"));
        dto.setSubHolidayType(this.getInt("sub_holiday_type"));
        dto.setSubHolidayDays(this.getDouble("sub_holiday_days"));
        dto.setTransitionFlag(this.getInt("transition_flag"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<SubHolidayDtoInterface> mappingAll() throws MospException {
        ArrayList<SubHolidayDtoInterface> all = new ArrayList<SubHolidayDtoInterface>();
        while (this.next()) {
            all.add((SubHolidayDtoInterface)this.mapping());
        }
        return all;
    }

    public SubHolidayDtoInterface findForKey(String personalId, Date workDate, int timesWork, int subHolidayType) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubHolidayDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubHolidayDao.and());
            sb.append(TmdSubHolidayDao.equal((String)"personal_id"));
            sb.append(TmdSubHolidayDao.and());
            sb.append(TmdSubHolidayDao.equal((String)"work_date"));
            sb.append(TmdSubHolidayDao.and());
            sb.append(TmdSubHolidayDao.equal((String)"times_work"));
            sb.append(TmdSubHolidayDao.and());
            sb.append(TmdSubHolidayDao.equal((String)"sub_holiday_type"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, workDate);
            this.setParam(this.index++, timesWork);
            this.setParam(this.index++, subHolidayType);
            this.executeQuery();
            SubHolidayDtoInterface dto = null;
            if (this.next()) {
                dto = (SubHolidayDtoInterface)this.mapping();
            }
            SubHolidayDtoInterface subHolidayDtoInterface = dto;
            return subHolidayDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SubHolidayDtoInterface> findForList(String personalId, Date workDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubHolidayDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubHolidayDao.and());
            sb.append(TmdSubHolidayDao.equal((String)"personal_id"));
            sb.append(TmdSubHolidayDao.and());
            sb.append(TmdSubHolidayDao.equal((String)"work_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, workDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SubHolidayDtoInterface> getSubHolidayList(String personalId, Date startDate, Date endDate, double subHolidayDays) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubHolidayDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubHolidayDao.and());
            sb.append(TmdSubHolidayDao.equal((String)"personal_id"));
            sb.append(TmdSubHolidayDao.and());
            sb.append(TmdSubHolidayDao.greaterEqual((String)"work_date"));
            sb.append(TmdSubHolidayDao.and());
            sb.append(TmdSubHolidayDao.lessEqual((String)"work_date"));
            sb.append(TmdSubHolidayDao.and());
            sb.append(TmdSubHolidayDao.greaterEqual((String)"sub_holiday_days"));
            sb.append(TmdSubHolidayDao.getOrderByColumn((String)"work_date", (String)"sub_holiday_type"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, startDate);
            this.setParam(this.index++, endDate);
            this.setParam(this.index++, subHolidayDays);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            SubHolidayDtoInterface dto = (SubHolidayDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmdSubHolidayId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            SubHolidayDtoInterface dto = (SubHolidayDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmdSubHolidayId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        SubHolidayDtoInterface dto = (SubHolidayDtoInterface)baseDto;
        this.setParam(this.index++, dto.getTmdSubHolidayId());
        this.setParam(this.index++, dto.getPersonalId());
        this.setParam(this.index++, dto.getWorkDate());
        this.setParam(this.index++, dto.getTimesWork());
        this.setParam(this.index++, dto.getSubHolidayType());
        this.setParam(this.index++, dto.getSubHolidayDays());
        this.setParam(this.index++, dto.getTransitionFlag());
        this.setCommonParams(baseDto, isInsert);
    }

    public List<SubHolidayDtoInterface> findForPersonalIds(Collection<String> personalIds, Date workDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubHolidayDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubHolidayDao.in((String)"personal_id", (int)personalIds.size()));
            sb.append(TmdSubHolidayDao.and());
            sb.append(TmdSubHolidayDao.equal((String)"work_date"));
            this.prepareStatement(sb.toString());
            this.setParamsStringIn(personalIds);
            this.setParam(this.index++, workDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<SubHolidayDtoInterface> findSubHolidayList(String personalId, Date startDate, Date endDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdSubHolidayDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdSubHolidayDao.and());
            sb.append(TmdSubHolidayDao.equal((String)"personal_id"));
            sb.append(TmdSubHolidayDao.and());
            sb.append(TmdSubHolidayDao.greaterEqual((String)"work_date"));
            sb.append(TmdSubHolidayDao.and());
            sb.append(TmdSubHolidayDao.lessEqual((String)"work_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, startDate);
            this.setParam(this.index++, endDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }
}

