/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.dao.settings.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.time.dao.settings.HolidayRequestDaoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdHolidayRequestDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class TmdHolidayRequestDao
extends PlatformDao
implements HolidayRequestDaoInterface {
    public static final String TABLE = "tmd_holiday_request";
    public static final String COL_TMD_HOLIDAY_REQUEST_ID = "tmd_holiday_request_id";
    public static final String COL_PERSONAL_ID = "personal_id";
    public static final String COL_REQUEST_START_DATE = "request_start_date";
    public static final String COL_REQUEST_END_DATE = "request_end_date";
    public static final String COL_HOLIDAY_TYPE1 = "holiday_type1";
    public static final String COL_HOLIDAY_TYPE2 = "holiday_type2";
    public static final String COL_HOLIDAY_RANGE = "holiday_range";
    public static final String COL_START_TIME = "start_time";
    public static final String COL_END_TIME = "end_time";
    public static final String COL_HOLIDAY_ACQUISITION_DATE = "holiday_acquisition_date";
    public static final String COL_USE_DAY = "use_day";
    public static final String COL_USE_HOUR = "use_hour";
    public static final String COL_REQUEST_REASON = "request_reason";
    public static final String COL_WORKFLOW = "workflow";
    public static final String KEY_1 = "tmd_holiday_request_id";
    protected WorkflowDaoInterface workflowDao;

    public void initDao() throws MospException {
        this.workflowDao = (WorkflowDaoInterface)this.loadDao(WorkflowDaoInterface.class);
    }

    public BaseDto mapping() throws MospException {
        TmdHolidayRequestDto dto = new TmdHolidayRequestDto();
        dto.setTmdHolidayRequestId(this.getLong("tmd_holiday_request_id"));
        dto.setPersonalId(this.getString("personal_id"));
        dto.setRequestStartDate(this.getDate("request_start_date"));
        dto.setRequestEndDate(this.getDate("request_end_date"));
        dto.setHolidayType1(this.getInt("holiday_type1"));
        dto.setHolidayType2(this.getString("holiday_type2"));
        dto.setHolidayRange(this.getInt("holiday_range"));
        dto.setStartTime(this.getTimestamp("start_time"));
        dto.setEndTime(this.getTimestamp("end_time"));
        dto.setHolidayAcquisitionDate(this.getDate("holiday_acquisition_date"));
        dto.setUseDay(this.getDouble("use_day"));
        dto.setUseHour(this.getInt("use_hour"));
        dto.setRequestReason(this.getString("request_reason"));
        dto.setWorkflow(this.getLong("workflow"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<HolidayRequestDtoInterface> mappingAll() throws MospException {
        ArrayList<HolidayRequestDtoInterface> all = new ArrayList<HolidayRequestDtoInterface>();
        while (this.next()) {
            all.add((HolidayRequestDtoInterface)this.mapping());
        }
        return all;
    }

    public List<HolidayRequestDtoInterface> findForApprovedList(String personalId, Date acquisitionDate, int holidayType1, String holidayType2, Date requestDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_acquisition_date"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_type1"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_type2"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.lessEqual((String)"request_start_date"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.greaterEqual((String)"request_end_date"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append("workflow");
            sb.append(TmdHolidayRequestDao.in());
            sb.append(TmdHolidayRequestDao.leftParenthesis());
            sb.append(TmdHolidayRequestDao.select());
            sb.append("workflow");
            sb.append(TmdHolidayRequestDao.from((String)"pft_workflow"));
            sb.append(TmdHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdHolidayRequestDao.and());
            sb.append("workflow_status");
            sb.append(" = '");
            sb.append("9");
            sb.append("'");
            sb.append(TmdHolidayRequestDao.rightParenthesis());
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, acquisitionDate);
            this.setParam(this.index++, holidayType1);
            this.setParam(this.index++, holidayType2);
            this.setParam(this.index++, requestDate);
            this.setParam(this.index++, requestDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<HolidayRequestDtoInterface> findForApprovedList(String personalId, Date acquisitionDate, int holidayType1, String holidayType2, Date requestStartDate, Date requestEndDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"personal_id"));
            if (!MospUtility.isEmpty((Object[])new Object[]{acquisitionDate})) {
                sb.append(TmdHolidayRequestDao.and());
                sb.append(TmdHolidayRequestDao.equal((String)"holiday_acquisition_date"));
            }
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_type1"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_type2"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.lessEqual((String)"request_start_date"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.greaterEqual((String)"request_end_date"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append("workflow");
            sb.append(TmdHolidayRequestDao.in());
            sb.append(TmdHolidayRequestDao.leftParenthesis());
            sb.append(TmdHolidayRequestDao.select());
            sb.append("workflow");
            sb.append(TmdHolidayRequestDao.from((String)"pft_workflow"));
            sb.append(TmdHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdHolidayRequestDao.and());
            sb.append("workflow_status");
            sb.append(" = '");
            sb.append("9");
            sb.append("'");
            sb.append(TmdHolidayRequestDao.rightParenthesis());
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            if (!MospUtility.isEmpty((Object[])new Object[]{acquisitionDate})) {
                this.setParam(this.index++, acquisitionDate);
            }
            this.setParam(this.index++, holidayType1);
            this.setParam(this.index++, holidayType2);
            this.setParam(this.index++, requestEndDate);
            this.setParam(this.index++, requestStartDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<HolidayRequestDtoInterface> findForRequestList(String personalId, Date acquisitionDate, int holidayType1, String holidayType2, Date startDate, Date endDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_acquisition_date"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_type1"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_type2"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.lessEqual((String)"request_start_date"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.greaterEqual((String)"request_end_date"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(this.workflowDao.getSubQueryForApplied("workflow"));
            sb.append(TmdHolidayRequestDao.getOrderByColumns((String[])new String[]{"request_start_date", "request_end_date", "start_time", "holiday_range"}));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, acquisitionDate);
            this.setParam(this.index++, holidayType1);
            this.setParam(this.index++, holidayType2);
            this.setParam(this.index++, endDate);
            this.setParam(this.index++, startDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<HolidayRequestDtoInterface> findForSearch(Map<String, Object> param) throws MospException {
        String personalId = String.valueOf(param.get("personalId"));
        String holidayType1 = String.valueOf(param.get("holidayType1"));
        String holidayType2 = String.valueOf(param.get("holidayType2"));
        String holidayLength = String.valueOf(param.get("holidayLength"));
        Date requestStartDate = (Date)param.get("requestStartDate");
        Date requestEndDate = (Date)param.get("requestEndDate");
        this.index = 1;
        StringBuffer sb = this.getSelectQuery(this.getClass());
        sb.append(TmdHolidayRequestDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(TmdHolidayRequestDao.and());
        sb.append(TmdHolidayRequestDao.equal((String)"personal_id"));
        sb.append(TmdHolidayRequestDao.and());
        sb.append(TmdHolidayRequestDao.lessEqual((String)"request_start_date"));
        sb.append(TmdHolidayRequestDao.and());
        sb.append(TmdHolidayRequestDao.greaterEqual((String)"request_end_date"));
        if (!holidayType1.equals("")) {
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_type1"));
        }
        if (!holidayType2.equals("")) {
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_type2"));
        }
        if (!holidayLength.equals("")) {
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_range"));
        }
        this.prepareStatement(sb.toString());
        this.setParam(this.index++, personalId);
        this.setParam(this.index++, requestEndDate);
        this.setParam(this.index++, requestStartDate);
        if (!holidayType1.equals("")) {
            this.setParam(this.index++, Integer.parseInt(holidayType1));
        }
        if (!holidayType2.equals("")) {
            this.setParam(this.index++, holidayType2);
        }
        if (!holidayLength.equals("")) {
            this.setParam(this.index++, Integer.parseInt(holidayLength));
        }
        this.executeQuery();
        return this.mappingAll();
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            HolidayRequestDtoInterface dto = (HolidayRequestDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmdHolidayRequestId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            HolidayRequestDtoInterface dto = (HolidayRequestDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmdHolidayRequestId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        HolidayRequestDtoInterface dto = (HolidayRequestDtoInterface)baseDto;
        this.setParam(this.index++, dto.getTmdHolidayRequestId());
        this.setParam(this.index++, dto.getPersonalId());
        this.setParam(this.index++, dto.getRequestStartDate());
        this.setParam(this.index++, dto.getRequestEndDate());
        this.setParam(this.index++, dto.getHolidayType1());
        this.setParam(this.index++, dto.getHolidayType2());
        this.setParam(this.index++, dto.getHolidayRange());
        this.setParam(this.index++, dto.getStartTime(), true);
        this.setParam(this.index++, dto.getEndTime(), true);
        this.setParam(this.index++, dto.getHolidayAcquisitionDate());
        this.setParam(this.index++, dto.getUseDay());
        this.setParam(this.index++, dto.getUseHour());
        this.setParam(this.index++, dto.getRequestReason());
        this.setParam(this.index++, dto.getWorkflow());
        this.setCommonParams(baseDto, isInsert);
    }

    public Map<String, Object> getParamsMap() {
        return new HashMap<String, Object>();
    }

    public HolidayRequestDtoInterface findForWorkflow(long workflow) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"workflow"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, workflow);
            this.executeQuery();
            HolidayRequestDtoInterface dto = null;
            if (this.next()) {
                dto = (HolidayRequestDtoInterface)this.mapping();
            }
            HolidayRequestDtoInterface holidayRequestDtoInterface = dto;
            return holidayRequestDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<HolidayRequestDtoInterface> findForList(String personalId, Date requestDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.lessEqual((String)"request_start_date"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.greaterEqual((String)"request_end_date"));
            sb.append(TmdHolidayRequestDao.getOrderByColumns((String[])new String[]{"request_start_date", "request_end_date", "start_time"}));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, requestDate);
            this.setParam(this.index++, requestDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public HolidayRequestDtoInterface findForKeyOnWorkflow(String personalId, Date requestStartDate, int holidayType1, String holidayType2, int holidayRange, Date startTime) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"request_start_date"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_type1"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_type2"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_range"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"start_time"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append("workflow");
            sb.append(TmdHolidayRequestDao.in());
            sb.append(TmdHolidayRequestDao.leftParenthesis());
            sb.append(this.workflowDao.getSubQueryForNotEqualWithdrawn());
            sb.append(TmdHolidayRequestDao.rightParenthesis());
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, requestStartDate);
            this.setParam(this.index++, holidayType1);
            this.setParam(this.index++, holidayType2);
            this.setParam(this.index++, holidayRange);
            this.setParam(this.index++, startTime, true);
            this.executeQuery();
            HolidayRequestDtoInterface dto = null;
            if (this.next()) {
                dto = (HolidayRequestDtoInterface)this.mapping();
            }
            HolidayRequestDtoInterface holidayRequestDtoInterface = dto;
            return holidayRequestDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<HolidayRequestDtoInterface> findForPersonalIds(Collection<String> personalIds, Date requestDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdHolidayRequestDao.in((String)"personal_id", (int)personalIds.size()));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.lessEqual((String)"request_start_date"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.greaterEqual((String)"request_end_date"));
            sb.append(TmdHolidayRequestDao.getOrderByColumn((String)"request_start_date", (String)"request_end_date"));
            this.prepareStatement(sb.toString());
            this.setParamsStringIn(personalIds);
            this.setParam(this.index++, requestDate);
            this.setParam(this.index++, requestDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<HolidayRequestDtoInterface> findForTerm(String personalId, Date firstDate, Date lastDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.lessEqual((String)"request_start_date"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.greaterEqual((String)"request_end_date"));
            sb.append(TmdHolidayRequestDao.getOrderByColumn((String)"request_start_date", (String)"request_end_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, lastDate, false);
            this.setParam(this.index++, firstDate, false);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<HolidayRequestDtoInterface> findForAppliedList(String personalId, Date acquisitionDate, Date firstDate, Date lastDate, int holidayType1, String holidayType2) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            if (!MospUtility.isEmpty((String[])new String[]{personalId})) {
                sb.append(TmdHolidayRequestDao.and());
                sb.append(TmdHolidayRequestDao.equal((String)"personal_id"));
            }
            if (!MospUtility.isEmpty((Object[])new Object[]{acquisitionDate})) {
                sb.append(TmdHolidayRequestDao.and());
                sb.append(TmdHolidayRequestDao.equal((String)"holiday_acquisition_date"));
            }
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_type1"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_type2"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.lessEqual((String)"request_start_date"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.greaterEqual((String)"request_end_date"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(this.workflowDao.getSubQueryForApplied("workflow"));
            sb.append(TmdHolidayRequestDao.getOrderByColumns((String[])new String[]{"request_start_date", "request_end_date", "holiday_range"}));
            this.prepareStatement(sb.toString());
            if (!MospUtility.isEmpty((String[])new String[]{personalId})) {
                this.setParam(this.index++, personalId);
            }
            if (!MospUtility.isEmpty((Object[])new Object[]{acquisitionDate})) {
                this.setParam(this.index++, acquisitionDate);
            }
            this.setParam(this.index++, holidayType1);
            this.setParam(this.index++, holidayType2);
            this.setParam(this.index++, lastDate, false);
            this.setParam(this.index++, firstDate, false);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<HolidayRequestDtoInterface> findForRequestList(int holidayType1, String holidayType2, Date startDate, Date endDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_type1"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_type2"));
            if (startDate != null) {
                sb.append(TmdHolidayRequestDao.and());
                sb.append(TmdHolidayRequestDao.greaterEqual((String)"request_end_date"));
            }
            if (endDate != null) {
                sb.append(TmdHolidayRequestDao.and());
                sb.append(TmdHolidayRequestDao.lessEqual((String)"request_start_date"));
            }
            sb.append(TmdHolidayRequestDao.getOrderByColumn((String)"request_start_date", (String)"request_end_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, holidayType1);
            this.setParam(this.index++, holidayType2);
            if (startDate != null) {
                this.setParam(this.index++, startDate, false);
            }
            if (endDate != null) {
                this.setParam(this.index++, endDate, false);
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<HolidayRequestDtoInterface> findForTermOnWorkflow(String personalId, Date firstDate, Date lastDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.lessEqual((String)"request_start_date"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.greaterEqual((String)"request_end_date"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append("workflow");
            sb.append(TmdHolidayRequestDao.in());
            sb.append(TmdHolidayRequestDao.leftParenthesis());
            sb.append(this.workflowDao.getSubQueryForNotEqualWithdrawn());
            sb.append(TmdHolidayRequestDao.rightParenthesis());
            sb.append(TmdHolidayRequestDao.getOrderByColumn((String)"request_start_date", (String)"request_end_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, lastDate, false);
            this.setParam(this.index++, firstDate, false);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<HolidayRequestDtoInterface> findForAcquisitionList(String personalId, int holidayType1, String holidayType2, Date acquisitionDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdHolidayRequestDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"personal_id"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_type1"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_type2"));
            sb.append(TmdHolidayRequestDao.and());
            sb.append(TmdHolidayRequestDao.equal((String)"holiday_acquisition_date"));
            sb.append(TmdHolidayRequestDao.getOrderByColumn((String)"request_start_date", (String)"start_time"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, holidayType1);
            this.setParam(this.index++, holidayType2);
            this.setParam(this.index++, acquisitionDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }
}

