/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.dao.settings.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.time.dao.settings.AttendanceCorrectionDaoInterface;
import jp.mosp.time.dto.settings.AttendanceCorrectionDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdAttendanceCorrectionDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class TmdAttendanceCorrectionDao
extends PlatformDao
implements AttendanceCorrectionDaoInterface {
    public static final String TABLE = "tmd_attendance_correction";
    public static final String COL_TMD_ATTENDANCE_CORRECTION_ID = "tmd_attendance_correction_id";
    public static final String COL_PERSONAL_ID = "personal_id";
    public static final String COL_WORK_DATE = "work_date";
    public static final String COL_WORKS = "works";
    public static final String COL_CORRECTION_TIMES = "correction_times";
    public static final String COL_CORRECTION_TYPE = "correction_type";
    public static final String COL_CORRECTION_DATE = "correction_date";
    public static final String COL_CORRECTION_PERSONAL_ID = "correction_personal_id";
    public static final String COL_CORRECTION_BEFORE = "correction_before";
    public static final String COL_CORRECTION_AFTER = "correction_after";
    public static final String COL_CORRECTION_REASON = "correction_reason";
    public static final String KEY_1 = "tmd_attendance_correction_id";

    public void initDao() {
    }

    public BaseDto mapping() throws MospException {
        TmdAttendanceCorrectionDto dto = new TmdAttendanceCorrectionDto();
        dto.setTmdAttendanceCorrectionId(this.getLong("tmd_attendance_correction_id"));
        dto.setPersonalId(this.getString("personal_id"));
        dto.setWorkDate(this.getDate("work_date"));
        dto.setWorks(this.getInt("works"));
        dto.setCorrectionTimes(this.getInt("correction_times"));
        dto.setCorrectionDate(this.getTimestamp("correction_date"));
        dto.setCorrectionPersonalId(this.getString("correction_personal_id"));
        dto.setCorrectionType(this.getString("correction_type"));
        dto.setCorrectionBefore(this.getString("correction_before"));
        dto.setCorrectionAfter(this.getString("correction_after"));
        dto.setCorrectionReason(this.getString("correction_reason"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<AttendanceCorrectionDtoInterface> mappingAll() throws MospException {
        ArrayList<AttendanceCorrectionDtoInterface> all = new ArrayList<AttendanceCorrectionDtoInterface>();
        while (this.next()) {
            all.add((AttendanceCorrectionDtoInterface)this.mapping());
        }
        return all;
    }

    protected Map<Date, List<AttendanceCorrectionDtoInterface>> mappingAllMap(Collection<AttendanceCorrectionDtoInterface> dtos) throws MospException {
        TreeMap<Date, List<AttendanceCorrectionDtoInterface>> map = new TreeMap<Date, List<AttendanceCorrectionDtoInterface>>();
        for (AttendanceCorrectionDtoInterface dto : dtos) {
            Date workDate = dto.getWorkDate();
            List list = MospUtility.getListValue(map, (Object)workDate);
            list.add(dto);
        }
        return map;
    }

    public AttendanceCorrectionDtoInterface findForLatestInfo(String personalId, Date workDate, int works) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdAttendanceCorrectionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdAttendanceCorrectionDao.and());
            sb.append(TmdAttendanceCorrectionDao.equal((String)"personal_id"));
            sb.append(TmdAttendanceCorrectionDao.and());
            sb.append(TmdAttendanceCorrectionDao.equal((String)"work_date"));
            sb.append(TmdAttendanceCorrectionDao.and());
            sb.append(TmdAttendanceCorrectionDao.equal((String)"works"));
            sb.append(TmdAttendanceCorrectionDao.getOrderByColumnDescLimit1((String)"correction_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, workDate);
            this.setParam(this.index++, works);
            this.executeQuery();
            AttendanceCorrectionDtoInterface dto = null;
            if (this.next()) {
                dto = (AttendanceCorrectionDtoInterface)this.mapping();
            }
            AttendanceCorrectionDtoInterface attendanceCorrectionDtoInterface = dto;
            return attendanceCorrectionDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<AttendanceCorrectionDtoInterface> findForHistory(String personalId, Date workDate, int works) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdAttendanceCorrectionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdAttendanceCorrectionDao.and());
            sb.append(TmdAttendanceCorrectionDao.equal((String)"personal_id"));
            sb.append(TmdAttendanceCorrectionDao.and());
            sb.append(TmdAttendanceCorrectionDao.equal((String)"work_date"));
            sb.append(TmdAttendanceCorrectionDao.and());
            sb.append(TmdAttendanceCorrectionDao.equal((String)"works"));
            sb.append(TmdAttendanceCorrectionDao.getOrderByColumn((String)"correction_date", (String)"tmd_attendance_correction_id"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, workDate);
            this.setParam(this.index++, works);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public Map<Date, List<AttendanceCorrectionDtoInterface>> findForTerm(String personalId, Date firstDate, Date lastDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdAttendanceCorrectionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdAttendanceCorrectionDao.and());
            sb.append(TmdAttendanceCorrectionDao.equal((String)"personal_id"));
            sb.append(TmdAttendanceCorrectionDao.and());
            sb.append(TmdAttendanceCorrectionDao.greaterEqual((String)"work_date"));
            sb.append(TmdAttendanceCorrectionDao.and());
            sb.append(TmdAttendanceCorrectionDao.lessEqual((String)"work_date"));
            sb.append(TmdAttendanceCorrectionDao.getOrderByColumn((String)"correction_date", (String)"tmd_attendance_correction_id"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, firstDate);
            this.setParam(this.index++, lastDate);
            this.executeQuery();
            Map map = this.mappingAllMap((Collection)this.cast(this.mappingAll()));
            return map;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<AttendanceCorrectionDtoInterface> findForPersonalIds(Collection<String> personalIds, Date workDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(TmdAttendanceCorrectionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(TmdAttendanceCorrectionDao.in((String)"personal_id", (int)personalIds.size()));
            sb.append(TmdAttendanceCorrectionDao.and());
            sb.append(TmdAttendanceCorrectionDao.equal((String)"work_date"));
            sb.append(TmdAttendanceCorrectionDao.getOrderByColumn((String)"correction_date", (String)"tmd_attendance_correction_id"));
            this.prepareStatement(sb.toString());
            this.setParamsStringIn(personalIds);
            this.setParam(this.index++, workDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            AttendanceCorrectionDtoInterface dto = (AttendanceCorrectionDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmdAttendanceCorrectionId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            AttendanceCorrectionDtoInterface dto = (AttendanceCorrectionDtoInterface)baseDto;
            this.setParam(this.index++, dto.getTmdAttendanceCorrectionId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        AttendanceCorrectionDtoInterface dto = (AttendanceCorrectionDtoInterface)baseDto;
        this.setParam(this.index++, dto.getTmdAttendanceCorrectionId());
        this.setParam(this.index++, dto.getPersonalId());
        this.setParam(this.index++, dto.getWorkDate());
        this.setParam(this.index++, dto.getWorks());
        this.setParam(this.index++, dto.getCorrectionTimes());
        this.setParam(this.index++, dto.getCorrectionType());
        this.setParam(this.index++, dto.getCorrectionDate(), true);
        this.setParam(this.index++, dto.getCorrectionPersonalId());
        this.setParam(this.index++, dto.getCorrectionBefore());
        this.setParam(this.index++, dto.getCorrectionAfter());
        this.setParam(this.index++, dto.getCorrectionReason());
        this.setCommonParams(baseDto, isInsert);
    }
}

