/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.calculation.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.base.TimeAction;
import jp.mosp.time.bean.CutoffReferenceBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.StockHolidayDataGrantBeanInterface;
import jp.mosp.time.bean.TotalTimeCalcBeanInterface;
import jp.mosp.time.bean.TotalTimeEmployeeTransactionReferenceBeanInterface;
import jp.mosp.time.bean.TotalTimeEmployeeTransactionRegistBeanInterface;
import jp.mosp.time.bean.TotalTimeTransactionRegistBeanInterface;
import jp.mosp.time.bean.TotalTimeTransactionSearchBeanInterface;
import jp.mosp.time.calculation.vo.TotalTimeVo;
import jp.mosp.time.comparator.settings.TotalTimeCutoffListCutoffCodeComparator;
import jp.mosp.time.dto.settings.TotalTimeCutoffListDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDtoInterface;
import jp.mosp.time.entity.CutoffEntityInterface;

public class TotalTimeAction
extends TimeAction {
    public static final String CMD_SHOW = "TM3110";
    public static final String CMD_SEARCH = "TM3112";
    public static final String CMD_RE_SHOW = "TM3113";
    public static final String CMD_TEMP_TIGHTEN = "TM3114";
    public static final String CMD_DECIDE = "TM3115";
    public static final String CMD_REMOVE = "TM3117";
    public static final String CMD_SORT = "TM3118";
    public static final String CMD_PAGE = "TM3119";
    public static final String CMD_SET_TOTAL_MONTH = "TM3180";

    public TotalTimeAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    protected BaseVo getSpecificVo() {
        return new TotalTimeVo();
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_TEMP_TIGHTEN)) {
            this.prepareVo(true, false);
            this.tmpTighten();
        } else if (this.mospParams.getCommand().equals(CMD_DECIDE)) {
            this.prepareVo(true, false);
            this.decide();
        } else if (this.mospParams.getCommand().equals(CMD_REMOVE)) {
            this.prepareVo(true, false);
            this.remove();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        } else if (this.mospParams.getCommand().equals(CMD_SET_TOTAL_MONTH)) {
            this.prepareVo();
            this.setActivationMonth();
        }
    }

    protected void show() throws MospException {
        TotalTimeVo vo = (TotalTimeVo)this.mospParams.getVo();
        this.setDefaultValues();
        this.setPageInfo(CMD_PAGE, this.getListLength());
        vo.setComparatorName(TotalTimeCutoffListCutoffCodeComparator.class.getName());
        vo.setModeActivateDate("fixed");
    }

    protected void search() throws MospException {
        TotalTimeVo vo = (TotalTimeVo)this.mospParams.getVo();
        TotalTimeTransactionSearchBeanInterface search = this.timeReference().totalTimeTransactionSearch();
        search.setRequestYear(this.getInt(vo.getPltEditRequestYear()));
        search.setRequestMonth(this.getInt(vo.getPltEditRequestMonth()));
        search.setCutoffDate(vo.getPltEditCutoffDate());
        search.setCutoffCode(vo.getTxtEditCutoffCode());
        search.setCutoffName(vo.getTxtEditCutoffName());
        search.setCutoffState(vo.getPltEditCutoffState());
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(TotalTimeCutoffListCutoffCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        if (list.isEmpty()) {
            PfMessageUtility.addMessageNoData((MospParams)this.mospParams);
        }
        vo.setTotalTimeRequestYear(vo.getPltEditRequestYear());
        vo.setTotalTimeRequestMonth(vo.getPltEditRequestMonth());
    }

    protected void tmpTighten() throws MospException {
        TotalTimeVo vo = (TotalTimeVo)this.mospParams.getVo();
        String cutoffCode = this.getTransferredCode();
        int targetYear = Integer.parseInt(vo.getPltEditRequestYear());
        int targetMonth = Integer.parseInt(vo.getPltEditRequestMonth());
        TotalTimeCalcBeanInterface calc = this.time().totalTimeCalc();
        List list = calc.tightening(targetYear, targetMonth, cutoffCode);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        if (!list.isEmpty()) {
            this.mospParams.addGeneralParam("TotalTimeError", (Object)list);
            this.mospParams.addGeneralParam("transferredGenericCode", (Object)cutoffCode);
            this.mospParams.addGeneralParam("transferredYear", (Object)targetYear);
            this.mospParams.addGeneralParam("transferredMonth", (Object)targetMonth);
            this.mospParams.setNextCommand("TM3140");
            return;
        }
        this.commit();
        this.addTighteningMessage();
        this.search();
    }

    protected void decide() throws MospException {
        TotalTimeVo vo = (TotalTimeVo)this.mospParams.getVo();
        TotalTimeTransactionRegistBeanInterface regist = this.time().totalTimeTransactionRegist();
        String cutoffCode = this.getTransferredCode();
        int calculationYear = Integer.parseInt(vo.getPltEditRequestYear());
        int calculationMonth = Integer.parseInt(vo.getPltEditRequestMonth());
        CutoffUtilBeanInterface cutoffUtil = this.timeReference().cutoffUtil();
        CutoffEntityInterface cutoff = this.timeReference().master().getCutoff(cutoffCode, calculationYear, calculationMonth);
        Date cutoffTermTargetDate = cutoff.getCutoffTermTargetDate(calculationYear, calculationMonth, this.mospParams);
        Set personalIdSet = cutoffUtil.getCutoffPersonalIdSet(cutoffCode, calculationYear, calculationMonth);
        for (String personalId : personalIdSet) {
            Integer state = this.timeReference().totalTimeEmployeeTransaction().getCutoffState(personalId, calculationYear, calculationMonth);
            if (state != null && state == 1) continue;
            String employeeCode = this.reference().human().getEmployeeCode(personalId, cutoffTermTargetDate);
            this.mospParams.addErrorMessage("TMW0274", new String[]{employeeCode});
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        TotalTimeDtoInterface dto = this.timeReference().totalTimeTransaction().findForKey(calculationYear, calculationMonth, cutoffCode);
        this.setDtoFields(dto);
        dto.setCutoffState(2);
        regist.regist(dto);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.grantStockHoliday(personalIdSet);
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        this.addDecideMessage();
        this.search();
    }

    protected void remove() throws MospException {
        TotalTimeVo vo = (TotalTimeVo)this.mospParams.getVo();
        TotalTimeTransactionRegistBeanInterface regist = this.time().totalTimeTransactionRegist();
        TotalTimeEmployeeTransactionRegistBeanInterface employeeRegist = this.time().totalTimeEmployeeTransactionRegist();
        TotalTimeEmployeeTransactionReferenceBeanInterface employeeTransactionReference = this.timeReference().totalTimeEmployeeTransaction();
        String cutoffCode = this.getTransferredCode();
        int calculationYear = Integer.parseInt(vo.getPltEditRequestYear());
        int calculationMonth = Integer.parseInt(vo.getPltEditRequestMonth());
        Set personalIdSet = this.timeReference().cutoffUtil().getCutoffPersonalIdSet(cutoffCode, calculationYear, calculationMonth);
        if (personalIdSet.isEmpty()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            PfMessageUtility.addErrorEmployeeNotExist((MospParams)this.mospParams);
            return;
        }
        TotalTimeDtoInterface totalTimeDto = this.timeReference().totalTimeTransaction().findForKey(calculationYear, calculationMonth, cutoffCode);
        if (totalTimeDto.getCutoffState() == 1) {
            ArrayList<String> removePersonalIdList = new ArrayList<String>();
            for (String personalId : personalIdSet) {
                Integer state = employeeTransactionReference.getCutoffState(personalId, calculationYear, calculationMonth);
                if (state == null || state == 0) continue;
                removePersonalIdList.add(personalId);
            }
            this.time().totalLeaveRegist().delete(removePersonalIdList, calculationYear, calculationMonth);
            this.time().totalOtherVacationRegist().delete(removePersonalIdList, calculationYear, calculationMonth);
            this.time().totalAbsenceRegist().delete(removePersonalIdList, calculationYear, calculationMonth);
            this.time().totalTimeRegist().delete(removePersonalIdList, calculationYear, calculationMonth);
            this.time().totalTimeCorrectionRegist().delete(removePersonalIdList, calculationYear, calculationMonth);
            employeeRegist.draftRelease(removePersonalIdList, calculationYear, calculationMonth, cutoffCode);
            this.setDtoFields(totalTimeDto);
            totalTimeDto.setCutoffState(0);
            regist.draftRelease(totalTimeDto);
        } else if (totalTimeDto.getCutoffState() == 2) {
            this.setDtoFields(totalTimeDto);
            totalTimeDto.setCutoffState(1);
            regist.registRelease(totalTimeDto);
            if (this.mospParams.hasErrorMessage()) {
                PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
                return;
            }
        } else {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        if (this.mospParams.hasErrorMessage()) {
            PfMessageUtility.addMessageInsertFailed((MospParams)this.mospParams);
            return;
        }
        this.commit();
        this.addReleaseMessage();
        this.search();
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() throws MospException {
        this.setVoList(this.pageList());
    }

    protected void setActivationMonth() throws MospException {
        TotalTimeVo vo = (TotalTimeVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
            vo.setAryPltEditRequestYear(this.getYearArray(MospUtility.getInt((Object)vo.getPltEditRequestYear())));
        } else {
            vo.setModeActivateDate("chaning");
        }
        ArrayList list = new ArrayList();
        vo.setList(list);
        this.setVoList(list);
    }

    public void setDefaultValues() {
        TotalTimeVo vo = (TotalTimeVo)this.mospParams.getVo();
        Date date = this.getSystemDate();
        Date targetYearMonth = MonthUtility.getTargetYearMonth((Date)date, (MospParams)this.mospParams);
        vo.setAryPltEditRequestYear(this.getYearArray(DateUtility.getYear((Date)targetYearMonth)));
        vo.setPltEditRequestYear(DateUtility.getStringYear((Date)targetYearMonth));
        vo.setAryPltEditRequestMonth(this.getMonthArray());
        vo.setPltEditRequestMonth(DateUtility.getStringMonthM((Date)targetYearMonth));
        vo.setTxtEditCutoffCode("");
        vo.setTxtEditCutoffName("");
        vo.setPltEditCutoffDate("");
        vo.setTxtEditCutoffCode("");
        vo.setPltEditCutoffState("");
        vo.setTxtLblRequestYear("");
        vo.setTxtLblRequestMonth("");
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) throws MospException {
        TotalTimeVo vo = (TotalTimeVo)this.mospParams.getVo();
        String[] aryCkbRecordId = new String[list.size()];
        String[] aryLblCutoffCode = new String[list.size()];
        String[] aryLblCutoffName = new String[list.size()];
        String[] aryLblCutoffDate = new String[list.size()];
        String[] aryLblCutoffState = new String[list.size()];
        int[] aryCutoffState = new int[list.size()];
        String[][] cutoffDateArray = this.mospParams.getProperties().getCodeArray("CutoffDate", false);
        for (int i = 0; i < list.size(); ++i) {
            TotalTimeCutoffListDtoInterface dto = (TotalTimeCutoffListDtoInterface)list.get(i);
            aryCkbRecordId[i] = String.valueOf(dto.getTmmCutoffId());
            aryLblCutoffCode[i] = dto.getCutoffCode();
            aryLblCutoffName[i] = dto.getCutoffName();
            aryLblCutoffDate[i] = MospUtility.getCodeName((String)String.valueOf(dto.getCutoffDate()), (String[][])cutoffDateArray);
            aryLblCutoffState[i] = this.getStringState(Integer.valueOf(dto.getCutoffState()).intValue());
            aryCutoffState[i] = dto.getCutoffState();
        }
        vo.setAryCkbTotalTimeListId(aryCkbRecordId);
        vo.setAryLblCutoffCode(aryLblCutoffCode);
        vo.setAryLblCutoffName(aryLblCutoffName);
        vo.setAryLblCutoffDate(aryLblCutoffDate);
        vo.setAryLblCutoffState(aryLblCutoffState);
        vo.setAryCutoffState(aryCutoffState);
    }

    protected String getStringState(int state) throws MospException {
        if (state == 0) {
            return this.mospParams.getName("Ram") + this.mospParams.getName("Cutoff");
        }
        if (state == 1) {
            return this.mospParams.getName("Provisional") + this.mospParams.getName("Cutoff");
        }
        return this.mospParams.getName("Definition");
    }

    protected void setDtoFields(TotalTimeDtoInterface dto) throws MospException {
        TotalTimeVo vo = (TotalTimeVo)this.mospParams.getVo();
        CutoffReferenceBeanInterface cutoffRefer = this.timeReference().cutoff();
        int year = this.getInt(vo.getTotalTimeRequestYear());
        int month = this.getInt(vo.getTotalTimeRequestMonth());
        String cutoffCode = this.getTransferredCode();
        Date date = MonthUtility.getYearMonthTargetDate((int)year, (int)month, (MospParams)this.mospParams);
        CutoffEntityInterface cutoff = cutoffRefer.getCutoffEntity(cutoffCode, date);
        cutoffRefer.chkExistCutoff(cutoff.getCutoffDto(), date);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        Date calculationDate = cutoff.getCutoffCalculationDate(year, month, this.mospParams);
        dto.setCalculationYear(year);
        dto.setCalculationMonth(month);
        dto.setCutoffCode(cutoffCode);
        dto.setCalculationDate(calculationDate);
        dto.setCutoffState(0);
    }

    protected void grantStockHoliday(Set<String> personalIdSet) throws MospException {
        TotalTimeVo vo = (TotalTimeVo)this.mospParams.getVo();
        StockHolidayDataGrantBeanInterface stockHolidayDataGrant = this.time().stockHolidayDataGrant();
        int year = Integer.parseInt(vo.getPltEditRequestYear());
        int month = Integer.parseInt(vo.getPltEditRequestMonth());
        String cutoffCode = this.getTransferredCode();
        CutoffEntityInterface cutoff = this.timeReference().master().getCutoff(cutoffCode, year, month);
        Date cutoffDate = cutoff.getCutoffLastDate(year, month, this.mospParams);
        Date targetDate = DateUtility.addDay((Date)cutoffDate, (int)1);
        for (String personalId : personalIdSet) {
            stockHolidayDataGrant.grant(personalId, targetDate, false);
        }
    }
}

