/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dao.settings.WorkTypeDaoInterface;
import jp.mosp.time.dao.settings.WorkTypeItemDaoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmWorkTypeDto;
import jp.mosp.time.entity.WorkTypeEntityInterface;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeUtility;

public class WorkTypeReferenceBean
extends PlatformBean
implements WorkTypeReferenceBeanInterface {
    protected WorkTypeDaoInterface dao;
    protected WorkTypeItemDaoInterface workTypeItemDao;

    public void initBean() throws MospException {
        this.dao = (WorkTypeDaoInterface)this.createDaoInstance(WorkTypeDaoInterface.class);
        this.workTypeItemDao = (WorkTypeItemDaoInterface)this.createDaoInstance(WorkTypeItemDaoInterface.class);
    }

    public WorkTypeDtoInterface getWorkTypeInfo(String workTypeCode, Date targetDate) throws MospException {
        if (workTypeCode.equals("work_on_legal")) {
            return this.getWorkOnLegalHolidayWorkType();
        }
        if (workTypeCode.equals("work_on_prescribed")) {
            return this.getWorkOnPrescribedHolidayWorkType();
        }
        return this.findForInfo(workTypeCode, targetDate);
    }

    public List<WorkTypeDtoInterface> getWorkTypeHistory(String workTypeCode) throws MospException {
        return this.dao.findForHistory(workTypeCode);
    }

    public String getWorkTypeAbbr(String workTypeCode, Date targetDate) throws MospException {
        if (workTypeCode.equals("prescribed_holiday")) {
            return TimeNamingUtility.prescribedHolidayAbbr((MospParams)this.mospParams);
        }
        if (workTypeCode.equals("legal_holiday")) {
            return TimeNamingUtility.legalHolidayAbbr((MospParams)this.mospParams);
        }
        WorkTypeDtoInterface dto = this.getWorkTypeInfo(workTypeCode, targetDate);
        if (dto == null) {
            return workTypeCode;
        }
        return dto.getWorkTypeAbbr();
    }

    public String getParticularWorkTypeName(String workTypeCode) {
        if ("work_on_legal".equals(workTypeCode)) {
            return this.getWorkOnLegalHolidayNaming();
        }
        if ("work_on_prescribed".equals(workTypeCode)) {
            return this.getWorkOnPrescribedHolidayNaming();
        }
        if ("legal_holiday".equals(workTypeCode)) {
            return TimeNamingUtility.legalHoliday((MospParams)this.mospParams);
        }
        if ("prescribed_holiday".equals(workTypeCode)) {
            return TimeNamingUtility.prescribedHoliday((MospParams)this.mospParams);
        }
        return null;
    }

    public String getWorkTypeNameAndTime(String workTypeCode, Date targetDate) throws MospException {
        WorkTypeDtoInterface dto = this.findForInfo(workTypeCode, targetDate);
        if (dto == null) {
            return workTypeCode;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(dto.getWorkTypeName());
        sb.append(this.getWorkBeginAndWorkEnd(dto));
        return sb.toString();
    }

    public String getWorkTypeAbbrAndTime(String workTypeCode, Date targetDate) throws MospException {
        WorkTypeDtoInterface dto = this.findForInfo(workTypeCode, targetDate);
        if (dto == null) {
            return workTypeCode;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(dto.getWorkTypeAbbr());
        sb.append(this.getWorkBeginAndWorkEnd(dto));
        return sb.toString();
    }

    public String getWorkTypeAbbrAndTime(String workTypeCode, Date targetDate, boolean amHoliday, boolean pmHoliday) throws MospException {
        WorkTypeDtoInterface dto = this.findForInfo(workTypeCode, targetDate);
        if (dto == null) {
            return workTypeCode;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(dto.getWorkTypeAbbr());
        sb.append(this.getWorkBeginAndWorkEnd(dto, amHoliday, pmHoliday));
        return sb.toString();
    }

    public String[][] getSelectArray(Date targetDate) throws MospException {
        return this.getSelectArray(targetDate, true, false, false, false);
    }

    public String[][] getCodedSelectArray(Date targetDate) throws MospException {
        List list = this.dao.findForActivateDate(targetDate);
        if (list.isEmpty()) {
            return this.getNoObjectDataPulldown();
        }
        String[][] array = new String[list.size()][2];
        int idx = 0;
        int codeLength = 0;
        for (WorkTypeDtoInterface dto : list) {
            if (dto.getWorkTypeCode().length() <= codeLength) continue;
            codeLength = dto.getWorkTypeCode().length();
        }
        for (WorkTypeDtoInterface dto : list) {
            array[idx][0] = dto.getWorkTypeCode();
            array[idx][1] = this.getCodedName(dto.getWorkTypeCode(), dto.getWorkTypeAbbr(), codeLength);
            ++idx;
        }
        return array;
    }

    public String[][] getTimeSelectArray(Date targetDate) throws MospException {
        return this.getSelectArray(targetDate, false, true, false, false);
    }

    public String[][] getTimeSelectArray(Date targetDate, boolean amHoliday, boolean pmHoliday) throws MospException {
        return this.getSelectArray(targetDate, false, true, amHoliday, pmHoliday);
    }

    public String[][] getNameTimeSelectArray(Date targetDate) throws MospException {
        return this.getSelectArray(targetDate, true, true, false, false);
    }

    public String[][] getNameTimeSelectArray(Date targetDate, boolean amHoliday, boolean pmHoliday) throws MospException {
        return this.getSelectArray(targetDate, true, true, amHoliday, pmHoliday);
    }

    public WorkTypeDtoInterface findForKey(String workTypeCode, Date activateDate) throws MospException {
        return this.dao.findForKey(workTypeCode, activateDate);
    }

    public String[][] getSelectAbbrArray(Date targetDate) throws MospException {
        return this.getSelectArray(targetDate, false, false, false, false);
    }

    public WorkTypeDtoInterface findForInfo(String workTypeCode, Date activateDate) throws MospException {
        return this.dao.findForInfo(workTypeCode, activateDate);
    }

    public List<WorkTypeEntityInterface> getWorkTypeEntityHistory(String workTypeCode) throws MospException {
        ArrayList<WorkTypeEntityInterface> history = new ArrayList<WorkTypeEntityInterface>();
        List list = this.getWorkTypeHistory(workTypeCode);
        for (WorkTypeDtoInterface dto : list) {
            Date activateDate = dto.getActivateDate();
            List itemList = this.workTypeItemDao.findForWorkType(workTypeCode, activateDate);
            history.add(this.createWorkTypeEntity(dto, itemList));
        }
        return history;
    }

    public WorkTypeEntityInterface getWorkTypeEntity(String workTypeCode, Date targetDate) throws MospException {
        WorkTypeDtoInterface dto = this.getWorkTypeInfo(workTypeCode, targetDate);
        if (dto != null) {
            List list = this.workTypeItemDao.findForWorkType(workTypeCode, dto.getActivateDate());
            return this.createWorkTypeEntity(dto, list);
        }
        dto = this.getExtraWorkTypeDto(workTypeCode);
        return this.createWorkTypeEntity(dto, new ArrayList());
    }

    protected WorkTypeDtoInterface getExtraWorkTypeDto(String workTypeCode) throws MospException {
        WorkTypeDtoInterface dto = this.getInitDto();
        dto.setWorkTypeCode(workTypeCode);
        dto.setWorkTypeAbbr("");
        if (MospUtility.isEqual((Object)workTypeCode, (Object)"work_on_legal")) {
            dto = this.getWorkOnLegalHolidayWorkType();
        }
        if (MospUtility.isEqual((Object)workTypeCode, (Object)"work_on_prescribed")) {
            dto = this.getWorkOnPrescribedHolidayWorkType();
        }
        if (MospUtility.isEqual((Object)workTypeCode, (Object)"legal_holiday")) {
            dto = this.getLegalHolidayWorkType();
        }
        if (MospUtility.isEqual((Object)workTypeCode, (Object)"prescribed_holiday")) {
            dto = this.getPrescribedHolidayWorkType();
        }
        dto.setActivateDate(DateUtility.getDefaultTime());
        return dto;
    }

    public Map<String, List<WorkTypeEntityInterface>> getExtraWorkTypeEntityHistories() throws MospException {
        TreeMap<String, List<WorkTypeEntityInterface>> histories = new TreeMap<String, List<WorkTypeEntityInterface>>();
        histories.put("work_on_legal", this.getExtraWorkTypeEntityHistory("work_on_legal"));
        histories.put("work_on_prescribed", this.getExtraWorkTypeEntityHistory("work_on_prescribed"));
        histories.put("legal_holiday", this.getExtraWorkTypeEntityHistory("legal_holiday"));
        histories.put("prescribed_holiday", this.getExtraWorkTypeEntityHistory("prescribed_holiday"));
        histories.put("", this.getExtraWorkTypeEntityHistory(""));
        return histories;
    }

    protected List<WorkTypeEntityInterface> getExtraWorkTypeEntityHistory(String workTypeCode) throws MospException {
        ArrayList<WorkTypeEntityInterface> history = new ArrayList<WorkTypeEntityInterface>();
        history.add(this.createWorkTypeEntity(this.getExtraWorkTypeDto(workTypeCode), new ArrayList()));
        return history;
    }

    protected String[][] getSelectArray(Date targetDate, boolean isName, boolean viewTime, boolean amHoliday, boolean pmHoliday) throws MospException {
        List list = this.dao.findForActivateDate(targetDate);
        if (list.isEmpty()) {
            return this.getNoObjectDataPulldown();
        }
        String[][] array = this.prepareSelectArray(list.size(), false);
        for (int i = 0; i < list.size(); ++i) {
            WorkTypeDtoInterface dto = (WorkTypeDtoInterface)list.get(i);
            StringBuffer sb = new StringBuffer();
            if (isName) {
                sb.append(dto.getWorkTypeName());
            } else {
                sb.append(dto.getWorkTypeAbbr());
            }
            if (viewTime) {
                sb.append(this.getWorkBeginAndWorkEnd(dto, amHoliday, pmHoliday));
            }
            array[i][0] = dto.getWorkTypeCode();
            array[i][1] = sb.toString();
        }
        return array;
    }

    protected String getWorkBeginAndWorkEnd(WorkTypeDtoInterface dto) throws MospException {
        WorkTypeItemDtoInterface workBeginDto = this.workTypeItemDao.findForKey(dto.getWorkTypeCode(), dto.getActivateDate(), "WorkStart");
        WorkTypeItemDtoInterface workEndDto = this.workTypeItemDao.findForKey(dto.getWorkTypeCode(), dto.getActivateDate(), "WorkEnd");
        Date defaultTime = DateUtility.getDefaultTime();
        StringBuffer sb = new StringBuffer();
        sb.append(this.mospParams.getName("FrontWithCornerParentheses"));
        sb.append(DateUtility.getStringTime((Date)workBeginDto.getWorkTypeItemValue(), (Date)defaultTime));
        sb.append(this.mospParams.getName("Wave"));
        sb.append(DateUtility.getStringTime((Date)workEndDto.getWorkTypeItemValue(), (Date)defaultTime));
        sb.append(this.mospParams.getName("BackWithCornerParentheses"));
        return sb.toString();
    }

    protected String getWorkBeginAndWorkEnd(WorkTypeDtoInterface dto, boolean amHoliday, boolean pmHoliday) throws MospException {
        Date defaultTime = DateUtility.getDefaultTime();
        WorkTypeEntityInterface workTypeEntity = this.getWorkTypeEntity(dto.getWorkTypeCode(), dto.getActivateDate());
        if (amHoliday) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("FrontWithCornerParentheses"));
            sb.append(DateUtility.getStringTime((Date)workTypeEntity.getBackStartTime(), (Date)defaultTime));
            sb.append(this.mospParams.getName("Wave"));
            sb.append(DateUtility.getStringTime((Date)workTypeEntity.getBackEndTime(), (Date)defaultTime));
            sb.append(this.mospParams.getName("BackWithCornerParentheses"));
            return sb.toString();
        }
        if (pmHoliday) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.mospParams.getName("FrontWithCornerParentheses"));
            sb.append(DateUtility.getStringTime((Date)workTypeEntity.getFrontStartTime(), (Date)defaultTime));
            sb.append(this.mospParams.getName("Wave"));
            sb.append(DateUtility.getStringTime((Date)workTypeEntity.getFrontEndTime(), (Date)defaultTime));
            sb.append(this.mospParams.getName("BackWithCornerParentheses"));
            return sb.toString();
        }
        return this.getWorkBeginAndWorkEnd(dto);
    }

    protected WorkTypeDtoInterface getWorkOnLegalHolidayWorkType() {
        WorkTypeDtoInterface dto = this.getInitDto();
        dto.setWorkTypeCode("work_on_legal");
        dto.setWorkTypeAbbr(this.getWorkOnLegalHolidayAbbrNaming());
        return dto;
    }

    protected WorkTypeDtoInterface getWorkOnPrescribedHolidayWorkType() {
        WorkTypeDtoInterface dto = this.getInitDto();
        dto.setWorkTypeCode("work_on_prescribed");
        dto.setWorkTypeAbbr(this.getWorkOnPrescribedHolidayAbbrNaming());
        return dto;
    }

    protected WorkTypeDtoInterface getLegalHolidayWorkType() {
        WorkTypeDtoInterface dto = this.getInitDto();
        dto.setWorkTypeCode("legal_holiday");
        dto.setWorkTypeName(TimeNamingUtility.legalHoliday((MospParams)this.mospParams));
        dto.setWorkTypeAbbr(TimeNamingUtility.legalHolidayAbbr((MospParams)this.mospParams));
        return dto;
    }

    protected WorkTypeDtoInterface getPrescribedHolidayWorkType() {
        WorkTypeDtoInterface dto = this.getInitDto();
        dto.setWorkTypeCode("prescribed_holiday");
        dto.setWorkTypeName(TimeNamingUtility.prescribedHoliday((MospParams)this.mospParams));
        dto.setWorkTypeAbbr(TimeNamingUtility.prescribedHolidayAbbr((MospParams)this.mospParams));
        return dto;
    }

    protected WorkTypeDtoInterface getInitDto() {
        TmmWorkTypeDto dto = new TmmWorkTypeDto();
        return dto;
    }

    protected WorkTypeEntityInterface createWorkTypeEntity(WorkTypeDtoInterface workTypeDto, List<WorkTypeItemDtoInterface> itemDtoList) throws MospException {
        WorkTypeEntityInterface entity = TimeUtility.getBareWorkTypeEntity((MospParams)this.mospParams);
        entity.setWorkTypeDto(workTypeDto);
        entity.setWorkTypeItemList(itemDtoList);
        return entity;
    }

    protected String getWorkOnPrescribedHolidayAbbrNaming() {
        return this.mospParams.getName("PrescribedAbbreviation") + this.mospParams.getName("WorkingHoliday");
    }

    protected String getWorkOnLegalHolidayAbbrNaming() {
        return this.mospParams.getName("LegalAbbreviation") + this.mospParams.getName("WorkingHoliday");
    }

    protected String getWorkOnPrescribedHolidayNaming() {
        return this.mospParams.getName("Prescribed") + this.mospParams.getName("DayOff") + this.mospParams.getName("GoingWork");
    }

    protected String getWorkOnLegalHolidayNaming() {
        return this.mospParams.getName("Legal") + this.mospParams.getName("DayOff") + this.mospParams.getName("GoingWork");
    }
}

