/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.WorkTypePatternRegistBeanInterface;
import jp.mosp.time.dao.settings.WorkTypePatternDaoInterface;
import jp.mosp.time.dto.settings.WorkTypePatternDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmWorkTypePatternDto;

public class WorkTypePatternRegistBean
extends PlatformBean
implements WorkTypePatternRegistBeanInterface {
    protected WorkTypePatternDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (WorkTypePatternDaoInterface)this.createDaoInstance(WorkTypePatternDaoInterface.class);
    }

    public WorkTypePatternDtoInterface getInitDto() {
        return new TmmWorkTypePatternDto();
    }

    public void insert(WorkTypePatternDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmWorkTypePatternId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(WorkTypePatternDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmWorkTypePatternId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(WorkTypePatternDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmWorkTypePatternId());
        dto.setTmmWorkTypePatternId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(WorkTypePatternDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmWorkTypePatternId());
    }

    protected void checkInsert(WorkTypePatternDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getPatternCode()));
    }

    protected void checkAdd(WorkTypePatternDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getPatternCode(), dto.getActivateDate()));
    }

    protected void checkUpdate(WorkTypePatternDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmWorkTypePatternId());
    }

    protected void checkDelete(WorkTypePatternDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmWorkTypePatternId());
    }

    protected void validate(WorkTypePatternDtoInterface dto) {
    }
}

