/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.time.bean.WorkTypePatternItemRegistBeanInterface;
import jp.mosp.time.dao.settings.WorkTypePatternItemDaoInterface;
import jp.mosp.time.dto.settings.WorkTypePatternItemDtoInterface;
import jp.mosp.time.dto.settings.impl.TmaWorkTypePatternItemDto;

public class WorkTypePatternItemRegistBean
extends PlatformBean
implements WorkTypePatternItemRegistBeanInterface {
    protected WorkTypePatternItemDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (WorkTypePatternItemDaoInterface)this.createDaoInstance(WorkTypePatternItemDaoInterface.class);
    }

    public WorkTypePatternItemDtoInterface getInitDto() {
        return new TmaWorkTypePatternItemDto();
    }

    public void insert(String patternCode, Date activateDate, int inactivateFlag, String[] workTypeCodeArray) throws MospException {
        this.validate((Object[])workTypeCodeArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        int i = 0;
        for (String workTypeCode : workTypeCodeArray) {
            WorkTypePatternItemDtoInterface dto = this.getInitDto();
            this.setDtoFields(dto, patternCode, activateDate, workTypeCode, ++i, inactivateFlag);
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkInsert(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            dto.setTmaWorkTypePatternItemId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void add(String patternCode, Date activateDate, int inactivateFlag, String[] workTypeCodeArray) throws MospException {
        this.validate((Object[])workTypeCodeArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        int i = 0;
        for (String workTypeCode : workTypeCodeArray) {
            WorkTypePatternItemDtoInterface dto = this.getInitDto();
            this.setDtoFields(dto, patternCode, activateDate, workTypeCode, ++i, inactivateFlag);
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkAdd(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            dto.setTmaWorkTypePatternItemId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void update(String patternCode, Date activateDate, int inactivateFlag, String[] workTypeCodeArray) throws MospException {
        this.validate((Object[])workTypeCodeArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        List list = this.dao.findForList(patternCode, activateDate);
        for (WorkTypePatternItemDtoInterface dto : list) {
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmaWorkTypePatternItemId());
        }
        int i = 0;
        for (String workTypeCode : workTypeCodeArray) {
            WorkTypePatternItemDtoInterface dto = this.getInitDto();
            this.setDtoFields(dto, patternCode, activateDate, workTypeCode, ++i, inactivateFlag);
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            dto.setTmaWorkTypePatternItemId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void delete(String patternCode, Date activateDate) throws MospException {
        List list = this.dao.findForList(patternCode, activateDate);
        for (WorkTypePatternItemDtoInterface dto : list) {
            this.checkDelete(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmaWorkTypePatternItemId());
        }
    }

    protected void validate(WorkTypePatternItemDtoInterface dto) {
    }

    protected <T> void validate(T[] array) {
        if (array == null || array.length == 0) {
            PfMessageUtility.addErrorRequired((MospParams)this.mospParams, (String)PfNameUtility.selectItem((MospParams)this.mospParams));
        }
    }

    protected void checkInsert(WorkTypePatternItemDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKey(dto.getPatternCode(), dto.getActivateDate(), dto.getWorkTypeCode()));
    }

    protected void checkAdd(WorkTypePatternItemDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getPatternCode(), dto.getActivateDate(), dto.getWorkTypeCode()));
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
    }

    protected void checkUpdate(WorkTypePatternItemDtoInterface dto) {
    }

    protected void checkDelete(WorkTypePatternItemDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmaWorkTypePatternItemId());
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
    }

    protected void setDtoFields(WorkTypePatternItemDtoInterface dto, String patternCode, Date activateDate, String workTypeCode, int itemOrder, int inactivateFlag) {
        dto.setPatternCode(patternCode);
        dto.setActivateDate(activateDate);
        dto.setWorkTypeCode(workTypeCode);
        dto.setItemOrder(itemOrder);
        dto.setInactivateFlag(inactivateFlag);
    }
}

