/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.CapsuleUtility;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.bean.WorkTypeItemRegistAddonBeanInterface;
import jp.mosp.time.bean.WorkTypeItemRegistBeanInterface;
import jp.mosp.time.dao.settings.WorkTypeDaoInterface;
import jp.mosp.time.dao.settings.WorkTypeItemDaoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmWorkTypeItemDto;
import jp.mosp.time.entity.TimeDuration;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeUtility;

public class WorkTypeItemRegistBean
extends PlatformBean
implements WorkTypeItemRegistBeanInterface {
    protected WorkTypeItemDaoInterface dao;
    protected WorkTypeDaoInterface workTypeDao;
    protected String[] codesWorkTypeItem = new String[]{"WorkStart", "WorkEnd", "WorkTime", "RestTime", "RestStart1", "RestEnd1", "RestStart2", "RestEnd2", "RestStart3", "RestEnd3", "RestStart4", "RestEnd4", "FrontStart", "FrontEnd", "BackStart", "BackEnd", "OverBefore", "OverPer", "OverRest", "HalfRest", "HalfRestStart", "HalfRestEnd", "DirectStart", "DirectEnd", "ExcludeNightRest", "Short1Start", "Short1End", "Short2Start", "Short2End", "AutoBefOverWork"};
    protected static final int LEN_WORK_TYPE_CODE = 10;
    protected List<WorkTypeItemRegistAddonBeanInterface> addonBeans;
    protected static final String CODE_KEY_ADDONS = "WorkTypeItemRegistAddons";

    public void initBean() throws MospException {
        this.dao = (WorkTypeItemDaoInterface)this.createDaoInstance(WorkTypeItemDaoInterface.class);
        this.workTypeDao = (WorkTypeDaoInterface)this.createDaoInstance(WorkTypeDaoInterface.class);
        this.addonBeans = this.getAddonBeans();
    }

    public WorkTypeItemDtoInterface getInitDto() {
        TmmWorkTypeItemDto dto = new TmmWorkTypeItemDto();
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            dto = addonBean.getInitDto((WorkTypeItemDtoInterface)dto);
        }
        return dto;
    }

    public void insert(WorkTypeItemDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.insert(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void insert(List<WorkTypeItemDtoInterface> dtoList) throws MospException {
        this.checkItemTimeValidate(dtoList);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemDtoInterface dto : dtoList) {
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkInsert(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.insert(dtoList);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void add(List<WorkTypeItemDtoInterface> dtoList) throws MospException {
        this.checkItemTimeValidate(dtoList);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemDtoInterface dto : dtoList) {
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkAdd(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.add(dtoList);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void update(WorkTypeItemDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (dto.getTmmWorkTypeItemId() == 0L) {
            dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        } else {
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmWorkTypeItemId());
            dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.update(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void update(List<WorkTypeItemDtoInterface> dtoList) throws MospException {
        this.checkItemTimeValidate(dtoList);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemDtoInterface dto : dtoList) {
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            if (dto.getTmmWorkTypeItemId() == 0L) {
                dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmWorkTypeItemId());
            dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.update(dtoList);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            for (String workTypeItemCode : this.getCodesAdditionalWorkTypeItem()) {
                WorkTypeItemDtoInterface dto = this.dao.findForKey(code, activateDate, workTypeItemCode);
                if (dto == null) {
                    dto = this.dao.findForInfo(code, activateDate, workTypeItemCode);
                    if (dto == null) continue;
                    dto.setActivateDate(activateDate);
                    dto.setInactivateFlag(inactivateFlag);
                    this.validate(dto);
                    this.checkAdd(dto);
                    if (this.mospParams.hasErrorMessage()) continue;
                    dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
                    this.dao.insert((BaseDtoInterface)dto);
                    continue;
                }
                dto.setInactivateFlag(inactivateFlag);
                this.validate(dto);
                this.checkUpdate(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmWorkTypeItemId());
                dto.setTmmWorkTypeItemId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
            }
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.update(idArray, activateDate, inactivateFlag);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public void delete(String workTypeCode, Date activateDate) throws MospException {
        for (String workTypeItemCode : this.getCodesAdditionalWorkTypeItem()) {
            WorkTypeItemDtoInterface dto = this.dao.findForKey(workTypeCode, activateDate, workTypeItemCode);
            if (dto == null) continue;
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkDelete(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmmWorkTypeItemId());
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.delete(workTypeCode, activateDate);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    public String[] getCodesWorkTypeItem() {
        return CapsuleUtility.getStringArrayClone((String[])this.codesWorkTypeItem);
    }

    public String[] getCodesAdditionalWorkTypeItem() {
        String[][] additionalWorktypeItemArray = this.mospParams.getProperties().getCodeArray("additionalWorkTypeItem", false);
        ArrayList<String> workTypeAdditionalItemList = new ArrayList<String>();
        for (String[] validateAryId : additionalWorktypeItemArray) {
            workTypeAdditionalItemList.add(validateAryId[1]);
        }
        ArrayList<String> workTypeItemList = new ArrayList<String>();
        workTypeItemList.addAll(Arrays.asList(this.codesWorkTypeItem));
        workTypeItemList.addAll(workTypeAdditionalItemList);
        return CapsuleUtility.getStringArrayClone((String[])workTypeItemList.toArray(new String[workTypeItemList.size()]));
    }

    protected void checkItemTimeValidate(List<WorkTypeItemDtoInterface> itemList) throws MospException {
        boolean isShort2Set;
        HashMap<String, Date> map = new HashMap<String, Date>();
        Date defaultTime = DateUtility.getDefaultTime();
        boolean isAutoBeforeOverwork = false;
        boolean isShort1TypePay = false;
        boolean isShort2TypePay = false;
        for (WorkTypeItemDtoInterface dto : itemList) {
            String workTypeItemCode = dto.getWorkTypeItemCode();
            Date targetTime = dto.getWorkTypeItemValue();
            map.put(workTypeItemCode, targetTime);
            if (workTypeItemCode.equals("AutoBefOverWork") && dto.getPreliminary().equals(String.valueOf(1))) {
                isAutoBeforeOverwork = true;
            }
            if (workTypeItemCode.equals("ExcludeNightRest") && dto.getPreliminary().isEmpty()) {
                dto.setPreliminary(String.valueOf(1));
            }
            if (workTypeItemCode.equals("Short1Start") && dto.getPreliminary().equals("0")) {
                isShort1TypePay = true;
            }
            if (workTypeItemCode.equals("Short2Start") && dto.getPreliminary().equals("0")) {
                isShort2TypePay = true;
            }
            if (targetTime.compareTo(defaultTime) == 0) continue;
            int time = DateUtility.getHour((Date)targetTime, (Date)defaultTime);
            int minute = DateUtility.getMinute((Date)targetTime);
            if (time > 47) {
                PfMessageUtility.addErrorOverLimit((MospParams)this.mospParams, (String)this.getWorkTypeItemName(workTypeItemCode), (int)47);
            }
            if (minute <= 59) continue;
            PfMessageUtility.addErrorOverLimit((MospParams)this.mospParams, (String)this.getWorkTypeItemName(workTypeItemCode), (int)59);
        }
        Date startTime = (Date)map.get("WorkStart");
        Date endTime = (Date)map.get("WorkEnd");
        if (startTime.compareTo(DateUtility.addDay((Date)defaultTime, (int)1)) >= 0) {
            TimeMessageUtility.addErrorWorkStartTimeOverLimit((MospParams)this.mospParams);
            return;
        }
        if (endTime.compareTo(startTime) < 0) {
            TimeMessageUtility.addErrorWorkTimeOrder((MospParams)this.mospParams);
            return;
        }
        this.checkRestTimes(map);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        Date frontStart = (Date)map.get("FrontStart");
        Date frontEnd = (Date)map.get("FrontEnd");
        Date backStart = (Date)map.get("BackStart");
        Date backEnd = (Date)map.get("BackEnd");
        if (frontStart.compareTo(defaultTime) != 0 && backStart.compareTo(defaultTime) != 0) {
            if (DateUtility.isTermContain((Date)backStart, (Date)frontStart, (Date)frontEnd) && !DateUtility.isSame((Date)frontEnd, (Date)backStart)) {
                TimeMessageUtility.addErrorRangeDuplicate((MospParams)this.mospParams, (String)TimeNamingUtility.pmRest((MospParams)this.mospParams));
                return;
            }
            if (DateUtility.isTermContain((Date)frontEnd, (Date)backStart, (Date)backEnd) && !DateUtility.isSame((Date)frontEnd, (Date)backStart)) {
                TimeMessageUtility.addErrorRangeDuplicate((MospParams)this.mospParams, (String)TimeNamingUtility.pmRest((MospParams)this.mospParams));
                return;
            }
        }
        if (frontStart.compareTo(defaultTime) != 0) {
            if (frontEnd.compareTo(frontStart) < 0) {
                String afterName = TimeNamingUtility.amRestEndTime((MospParams)this.mospParams);
                String beforeName = TimeNamingUtility.amRestStartTime((MospParams)this.mospParams);
                PfMessageUtility.addErrorOrderInvalid((MospParams)this.mospParams, (String)afterName, (String)beforeName);
                return;
            }
            if (frontStart.compareTo(startTime) < 0) {
                String afterName = TimeNamingUtility.amRestStartTime((MospParams)this.mospParams);
                String beforeName = TimeNamingUtility.startWorkTime((MospParams)this.mospParams);
                PfMessageUtility.addErrorOrderInvalid((MospParams)this.mospParams, (String)afterName, (String)beforeName);
                return;
            }
            if (endTime.compareTo(frontEnd) < 0) {
                String afterName = TimeNamingUtility.endWorkTime((MospParams)this.mospParams);
                String beforeName = TimeNamingUtility.amRestStartTime((MospParams)this.mospParams);
                PfMessageUtility.addErrorOrderInvalid((MospParams)this.mospParams, (String)afterName, (String)beforeName);
                return;
            }
        }
        if (backStart.compareTo(defaultTime) != 0) {
            if (backEnd.compareTo(backStart) < 0) {
                String afterName = TimeNamingUtility.pmRestEndTime((MospParams)this.mospParams);
                String beforeName = TimeNamingUtility.pmRestStartTime((MospParams)this.mospParams);
                PfMessageUtility.addErrorOrderInvalid((MospParams)this.mospParams, (String)afterName, (String)beforeName);
                return;
            }
            if (backEnd.compareTo(endTime) > 0) {
                String afterName = TimeNamingUtility.endWorkTime((MospParams)this.mospParams);
                String beforeName = TimeNamingUtility.pmRestEndTime((MospParams)this.mospParams);
                PfMessageUtility.addErrorOrderInvalid((MospParams)this.mospParams, (String)afterName, (String)beforeName);
                return;
            }
        }
        Date halfRestStart = (Date)map.get("HalfRestStart");
        Date halfRestEnd = (Date)map.get("HalfRestEnd");
        if (halfRestStart.compareTo(defaultTime) != 0 && halfRestEnd.compareTo(defaultTime) != 0 && halfRestEnd.compareTo(halfRestStart) < 0) {
            String afterName = TimeNamingUtility.halfHolidayRestEndTime((MospParams)this.mospParams);
            String beforeName = TimeNamingUtility.halfHolidayRestStartTime((MospParams)this.mospParams);
            PfMessageUtility.addErrorOrderInvalid((MospParams)this.mospParams, (String)afterName, (String)beforeName);
            return;
        }
        int overPerMinute = TimeUtility.getMinutes((Date)((Date)map.get("OverPer")));
        int overRestMinute = TimeUtility.getMinutes((Date)((Date)map.get("OverRest")));
        if (overPerMinute == 0 && overRestMinute > 0) {
            String fieldName = TimeNamingUtility.restTime((MospParams)this.mospParams);
            String rangeName = TimeNamingUtility.overtimeRest((MospParams)this.mospParams);
            TimeMessageUtility.addErrorTimeOutOfRange((MospParams)this.mospParams, (String)fieldName, (String)rangeName);
            return;
        }
        if (overPerMinute > 0 && overPerMinute <= overRestMinute) {
            String fieldName = TimeNamingUtility.restTime((MospParams)this.mospParams);
            String rangeName = TimeNamingUtility.overtimeRest((MospParams)this.mospParams);
            TimeMessageUtility.addErrorTimeOutOfRange((MospParams)this.mospParams, (String)fieldName, (String)rangeName);
            return;
        }
        Date short1StartTime = (Date)map.get("Short1Start");
        Date short1EndTime = (Date)map.get("Short1End");
        Date short2StartTime = (Date)map.get("Short2Start");
        Date short2EndTime = (Date)map.get("Short2End");
        boolean isShort1Set = short1StartTime != null && short1StartTime.compareTo(defaultTime) != 0 || short1EndTime != null && short1EndTime.compareTo(defaultTime) != 0;
        boolean bl = isShort2Set = short2StartTime != null && short2StartTime.compareTo(defaultTime) != 0 || short2EndTime != null && short2EndTime.compareTo(defaultTime) != 0;
        if (isShort1Set) {
            if (short1StartTime.compareTo(startTime) != 0) {
                TimeMessageUtility.addErrorShort1TimeBoundary((MospParams)this.mospParams);
            }
            if (short1EndTime.after(endTime)) {
                TimeMessageUtility.addErrorShort1OutOfWorkTime((MospParams)this.mospParams);
            }
            if (!short1EndTime.after(short1StartTime)) {
                TimeMessageUtility.addErrorShort1EndBeforeStart((MospParams)this.mospParams);
            }
        }
        if (isShort2Set) {
            if (short2EndTime.compareTo(endTime) != 0) {
                TimeMessageUtility.addErrorShort2TimeBoundary((MospParams)this.mospParams);
            }
            if (short2StartTime.before(startTime)) {
                TimeMessageUtility.addErrorShort2OutOfWorkTime((MospParams)this.mospParams);
            }
            if (!short2EndTime.after(short2StartTime)) {
                TimeMessageUtility.addErrorShort2EndBeforeStart((MospParams)this.mospParams);
            }
        }
        if (isShort1Set && isShort2Set && !isShort1TypePay && isShort2TypePay) {
            TimeMessageUtility.addErrorShortTypePair((MospParams)this.mospParams);
        }
        this.checkAutoBeforeOverWork(isAutoBeforeOverwork, isShort1TypePay, short1StartTime, short1EndTime);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkItemTimeValidate(itemList);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkRestTimes(Map<String, Date> map) throws MospException {
        int startTime = TimeUtility.getMinutes((Date)map.get("WorkStart"));
        int endTime = TimeUtility.getMinutes((Date)map.get("WorkEnd"));
        int rest1Start = TimeUtility.getMinutes((Date)map.get("RestStart1"));
        int rest1End = TimeUtility.getMinutes((Date)map.get("RestEnd1"));
        int rest2Start = TimeUtility.getMinutes((Date)map.get("RestStart2"));
        int rest2End = TimeUtility.getMinutes((Date)map.get("RestEnd2"));
        int rest3Start = TimeUtility.getMinutes((Date)map.get("RestStart3"));
        int rest3End = TimeUtility.getMinutes((Date)map.get("RestEnd3"));
        int rest4Start = TimeUtility.getMinutes((Date)map.get("RestStart4"));
        int rest4End = TimeUtility.getMinutes((Date)map.get("RestEnd4"));
        int[] aryRestStart = new int[]{rest1Start, rest2Start, rest3Start, rest4Start};
        int[] aryRestEnd = new int[]{rest1End, rest2End, rest3End, rest4End};
        LinkedHashSet<TimeDuration> durations = new LinkedHashSet<TimeDuration>();
        for (int i = 0; i < aryRestStart.length; ++i) {
            TimeDuration duration;
            int restStart = aryRestStart[i];
            int restEnd = aryRestEnd[i];
            if (restStart == 0 && restEnd == 0) continue;
            if (restStart < startTime) {
                PfMessageUtility.addErrorOrderInvalid((MospParams)this.mospParams, (String)TimeNamingUtility.rest((MospParams)this.mospParams, (int)(i + 1)), (String)TimeNamingUtility.startWorkTime((MospParams)this.mospParams));
            }
            if (endTime < restEnd) {
                PfMessageUtility.addErrorOrderInvalid((MospParams)this.mospParams, (String)TimeNamingUtility.endWorkTime((MospParams)this.mospParams), (String)TimeNamingUtility.rest((MospParams)this.mospParams, (int)(i + 1)));
            }
            if (!(duration = TimeDuration.getInstance((int)restStart, (int)restEnd)).isValid()) {
                TimeMessageUtility.addErrorEndBeforeStart((MospParams)this.mospParams, (String)TimeNamingUtility.rest((MospParams)this.mospParams, (int)(i + 1)));
            }
            durations.add(TimeDuration.getInstance((int)restStart, (int)restEnd));
        }
        if (TimeUtility.isOverlap(durations)) {
            TimeMessageUtility.addErrorRangeDuplicate((MospParams)this.mospParams, (String)TimeNamingUtility.restTime((MospParams)this.mospParams));
        }
    }

    protected void checkAutoBeforeOverWork(boolean isAutoBeforeOverwork, boolean isShort1TypePay, Date short1Start, Date short1End) throws MospException {
        if (isAutoBeforeOverwork) {
            return;
        }
        if (short1Start.compareTo(DateUtility.getDefaultTime()) == 0 && short1End.compareTo(DateUtility.getDefaultTime()) == 0) {
            return;
        }
        if (isShort1TypePay) {
            return;
        }
        TimeMessageUtility.addErrorAnotherItemInvalid((MospParams)this.mospParams);
    }

    protected void checkInsert(WorkTypeItemDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getWorkTypeCode(), dto.getWorkTypeItemCode()));
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkInsert(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkAdd(WorkTypeItemDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getWorkTypeCode(), dto.getActivateDate(), dto.getWorkTypeItemCode()));
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getWorkTypeCode(), dto.getWorkTypeItemCode());
        if (!this.needCheckTermForAdd((PlatformDtoInterface)dto, list)) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkAdd(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkUpdate(WorkTypeItemDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmWorkTypeItemId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmmWorkTypeItemId(), true))) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkUpdate(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkDelete(WorkTypeItemDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmmWorkTypeItemId());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getWorkTypeCode(), dto.getWorkTypeItemCode());
        if (!this.needCheckTermForDelete((PlatformDtoInterface)dto, list)) {
            return;
        }
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.checkDelete(dto);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            WorkTypeDtoInterface dto = (WorkTypeDtoInterface)this.workTypeDao.findForKey(id, false);
            list.add(dto.getWorkTypeCode());
        }
        return list;
    }

    protected void validate(WorkTypeItemDtoInterface dto) throws MospException {
        this.checkLength(dto.getWorkTypeCode(), 10, TimeNamingUtility.workTypeCode((MospParams)this.mospParams), null);
        this.checkTypeCode(dto.getWorkTypeCode(), TimeNamingUtility.workTypeCode((MospParams)this.mospParams), null);
        for (WorkTypeItemRegistAddonBeanInterface addonBean : this.addonBeans) {
            addonBean.validate(dto);
        }
    }

    protected String getWorkTypeItemName(String worktypeItemCode) {
        String name = "";
        if (worktypeItemCode.equals("WorkStart")) {
            name = TimeNamingUtility.startWork((MospParams)this.mospParams);
        } else if (worktypeItemCode.equals("WorkEnd")) {
            name = TimeNamingUtility.endWork((MospParams)this.mospParams);
        } else if (worktypeItemCode.equals("WorkTime")) {
            name = TimeNamingUtility.workTime((MospParams)this.mospParams);
        } else if (worktypeItemCode.equals("RestTime")) {
            name = TimeNamingUtility.restTime((MospParams)this.mospParams);
        } else if (worktypeItemCode.equals("RestStart1")) {
            name = TimeNamingUtility.rest((MospParams)this.mospParams, (int)1);
        } else if (worktypeItemCode.equals("RestEnd1")) {
            name = TimeNamingUtility.rest((MospParams)this.mospParams, (int)1);
        } else if (worktypeItemCode.equals("RestStart2")) {
            name = TimeNamingUtility.rest((MospParams)this.mospParams, (int)2);
        } else if (worktypeItemCode.equals("RestEnd2")) {
            name = TimeNamingUtility.rest((MospParams)this.mospParams, (int)2);
        } else if (worktypeItemCode.equals("RestStart3")) {
            name = TimeNamingUtility.rest((MospParams)this.mospParams, (int)3);
        } else if (worktypeItemCode.equals("RestEnd3")) {
            name = TimeNamingUtility.rest((MospParams)this.mospParams, (int)3);
        } else if (worktypeItemCode.equals("RestStart4")) {
            name = TimeNamingUtility.rest((MospParams)this.mospParams, (int)4);
        } else if (worktypeItemCode.equals("RestEnd4")) {
            name = TimeNamingUtility.rest((MospParams)this.mospParams, (int)4);
        } else if (worktypeItemCode.equals("FrontStart")) {
            name = TimeNamingUtility.amRest((MospParams)this.mospParams);
        } else if (worktypeItemCode.equals("FrontEnd")) {
            name = TimeNamingUtility.amRest((MospParams)this.mospParams);
        } else if (worktypeItemCode.equals("BackStart")) {
            name = TimeNamingUtility.pmRest((MospParams)this.mospParams);
        } else if (worktypeItemCode.equals("BackEnd")) {
            name = TimeNamingUtility.pmRest((MospParams)this.mospParams);
        } else if (worktypeItemCode.equals("OverBefore")) {
            name = TimeNamingUtility.overtimeBeforeRest((MospParams)this.mospParams);
        } else if (worktypeItemCode.equals("OverPer")) {
            name = TimeNamingUtility.overtimeRest((MospParams)this.mospParams);
        } else if (worktypeItemCode.equals("OverRest")) {
            name = TimeNamingUtility.overtimeRest((MospParams)this.mospParams);
        } else if (worktypeItemCode.equals("HalfRest")) {
            name = TimeNamingUtility.halfHolidayRest((MospParams)this.mospParams);
        } else if (worktypeItemCode.equals("HalfRestStart")) {
            name = TimeNamingUtility.halfHolidayRest((MospParams)this.mospParams);
        } else if (worktypeItemCode.equals("HalfRestEnd")) {
            name = TimeNamingUtility.halfHolidayRest((MospParams)this.mospParams);
        } else if (worktypeItemCode.equals("DirectStart")) {
            name = TimeNamingUtility.directStart((MospParams)this.mospParams);
        } else if (worktypeItemCode.equals("DirectEnd")) {
            name = TimeNamingUtility.directEnd((MospParams)this.mospParams);
        } else if (worktypeItemCode.equals("ExcludeNightRest")) {
            name = this.mospParams.getName("ExcludeNightRest");
        } else if (worktypeItemCode.equals("Short1Start")) {
            name = this.mospParams.getName("ShortTime", new String[]{"Time", "No1"});
        } else if (worktypeItemCode.equals("Short1End")) {
            name = this.mospParams.getName("ShortTime", new String[]{"Time", "No1"});
        } else if (worktypeItemCode.equals("Short2Start")) {
            name = this.mospParams.getName("ShortTime", new String[]{"Time", "No2"});
        } else if (worktypeItemCode.equals("Short2End")) {
            name = this.mospParams.getName("ShortTime", new String[]{"Time", "No2"});
        } else if (worktypeItemCode.equals("AutoBefOverWork")) {
            name = TimeNamingUtility.registActualOvertimeBeforeWork((MospParams)this.mospParams);
        }
        return name;
    }

    public Date getDefaultTime(String hour, String minute) throws MospException {
        Date defaultDate = DateUtility.getDefaultTime();
        return TimeUtility.getAttendanceTime((Date)defaultDate, (String)hour, (String)minute, (MospParams)this.mospParams);
    }

    protected List<WorkTypeItemRegistAddonBeanInterface> getAddonBeans() throws MospException {
        ArrayList<WorkTypeItemRegistAddonBeanInterface> addonBeans = new ArrayList<WorkTypeItemRegistAddonBeanInterface>();
        for (String[] addon : this.mospParams.getProperties().getCodeArray(CODE_KEY_ADDONS, false)) {
            String addonBean = addon[0];
            if (MospUtility.isEmpty((String[])new String[]{addonBean})) continue;
            WorkTypeItemRegistAddonBeanInterface bean = (WorkTypeItemRegistAddonBeanInterface)this.createBean(addonBean);
            addonBeans.add(bean);
        }
        return addonBeans;
    }
}

