/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.WorkTypeItemReferenceBeanInterface;
import jp.mosp.time.dao.settings.WorkTypeItemDaoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.utils.TimeUtility;

public class WorkTypeItemReferenceBean
extends PlatformBean
implements WorkTypeItemReferenceBeanInterface {
    protected WorkTypeItemDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (WorkTypeItemDaoInterface)this.createDaoInstance(WorkTypeItemDaoInterface.class);
    }

    public WorkTypeItemDtoInterface getWorkTypeItemInfo(String workTypeCode, Date targetDate, String workTypeItemCode) throws MospException {
        return this.dao.findForInfo(workTypeCode, targetDate, workTypeItemCode);
    }

    public WorkTypeItemDtoInterface findForKey(String workTypeCode, Date activateDate, String workTypeItemCode) throws MospException {
        return this.dao.findForKey(workTypeCode, activateDate, workTypeItemCode);
    }

    public int getWorkTime(Date startWorkTime, Date endWorkTime, int restTime) {
        if (startWorkTime == null || endWorkTime == null) {
            return 0;
        }
        long startTime = startWorkTime.getTime();
        long endTime = endWorkTime.getTime();
        int difference = (int)(endTime - startTime) / 60000;
        return difference - restTime;
    }

    public int getRestTime(int rest1, int rest2, int rest3, int rest4) {
        return rest1 + rest2 + rest3 + rest4;
    }

    public int getDifferenceTime(String startTimeHour, String startTimeMinute, String endTimeHour, String endTimeMinute) {
        if (startTimeHour.isEmpty() || startTimeMinute.isEmpty() || endTimeHour.isEmpty() || endTimeMinute.isEmpty()) {
            return 0;
        }
        int differencetime = 0;
        try {
            Date defaultDate = DateUtility.getDefaultTime();
            long start = TimeUtility.getAttendanceTime((Date)defaultDate, (String)startTimeHour, (String)startTimeMinute, (MospParams)this.mospParams).getTime();
            long end = TimeUtility.getAttendanceTime((Date)defaultDate, (String)endTimeHour, (String)endTimeMinute, (MospParams)this.mospParams).getTime();
            differencetime = (int)Math.abs((end - start) / 60000L);
        }
        catch (MospException e) {
            e.printStackTrace();
        }
        return differencetime;
    }

    public HashMap<String, WorkTypeItemDtoInterface> getWorkTypeItemMap(String workTypeCode, Date activateDate) throws MospException {
        HashMap<String, WorkTypeItemDtoInterface> map = new HashMap<String, WorkTypeItemDtoInterface>();
        List list = this.dao.findForWorkType(workTypeCode, activateDate);
        if (list.isEmpty()) {
            return null;
        }
        for (WorkTypeItemDtoInterface dto : list) {
            map.put(dto.getWorkTypeItemCode(), dto);
        }
        return map;
    }
}

