/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowCommentRegistBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.bean.workflow.impl.WorkflowReferenceBean;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.ApprovalInfoReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceReferenceBeanInterface;
import jp.mosp.time.bean.AttendanceRegistBeanInterface;
import jp.mosp.time.bean.AttendanceTransactionRegistBeanInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.SubHolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.SubstituteReferenceBeanInterface;
import jp.mosp.time.bean.SubstituteRegistBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.WorkOnHolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.WorkOnHolidayRequestRegistBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dao.settings.SubstituteDaoInterface;
import jp.mosp.time.dao.settings.WorkOnHolidayRequestDaoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdWorkOnHolidayRequestDto;
import jp.mosp.time.entity.RequestEntityInterface;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeRequestUtility;
import jp.mosp.time.utils.TimeUtility;

public class WorkOnHolidayRequestRegistBean
extends TimeBean
implements WorkOnHolidayRequestRegistBeanInterface {
    protected WorkOnHolidayRequestDaoInterface dao;
    protected WorkOnHolidayRequestReferenceBeanInterface workOnHolidayReference;
    protected WorkflowReferenceBeanInterface workflowReference;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected WorkflowRegistBeanInterface workflowRegist;
    protected WorkflowCommentRegistBeanInterface workflowCommentRegist;
    protected SubstituteDaoInterface substituteDao;
    protected SubstituteReferenceBeanInterface substituteReference;
    protected SubstituteRegistBeanInterface substituteRegist;
    protected AttendanceRegistBeanInterface attendanceRegist;
    protected AttendanceReferenceBeanInterface attendanceReference;
    protected ApprovalInfoReferenceBeanInterface approvalInfoReference;
    protected SuspensionReferenceBeanInterface suspensionReference;
    protected RetirementReferenceBeanInterface retirementReference;
    protected ScheduleUtilBeanInterface scheduleUtil;
    protected WorkTypeReferenceBeanInterface workTypeReference;
    protected CutoffUtilBeanInterface cutoffUtil;
    protected AttendanceTransactionRegistBeanInterface attendanceTransactionRegist;
    protected SubHolidayRequestReferenceBeanInterface subholidayRequestReference;
    protected TimeMasterBeanInterface timeMaster;

    public void initBean() throws MospException {
        this.dao = (WorkOnHolidayRequestDaoInterface)this.createDaoInstance(WorkOnHolidayRequestDaoInterface.class);
        this.workOnHolidayReference = (WorkOnHolidayRequestReferenceBeanInterface)this.createBeanInstance(WorkOnHolidayRequestReferenceBeanInterface.class);
        this.workflowReference = (WorkflowReferenceBeanInterface)this.createBeanInstance(WorkflowReferenceBean.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBeanInstance(WorkflowIntegrateBeanInterface.class);
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBeanInstance(WorkflowRegistBeanInterface.class);
        this.workflowCommentRegist = (WorkflowCommentRegistBeanInterface)this.createBeanInstance(WorkflowCommentRegistBeanInterface.class);
        this.substituteDao = (SubstituteDaoInterface)this.createDaoInstance(SubstituteDaoInterface.class);
        this.substituteReference = (SubstituteReferenceBeanInterface)this.createBeanInstance(SubstituteReferenceBeanInterface.class);
        this.substituteRegist = (SubstituteRegistBeanInterface)this.createBeanInstance(SubstituteRegistBeanInterface.class);
        this.attendanceRegist = (AttendanceRegistBeanInterface)this.createBeanInstance(AttendanceRegistBeanInterface.class);
        this.attendanceReference = (AttendanceReferenceBeanInterface)this.createBeanInstance(AttendanceReferenceBeanInterface.class);
        this.approvalInfoReference = (ApprovalInfoReferenceBeanInterface)this.createBeanInstance(ApprovalInfoReferenceBeanInterface.class);
        this.suspensionReference = (SuspensionReferenceBeanInterface)this.createBeanInstance(SuspensionReferenceBeanInterface.class);
        this.retirementReference = (RetirementReferenceBeanInterface)this.createBeanInstance(RetirementReferenceBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBeanInstance(ScheduleUtilBeanInterface.class);
        this.workTypeReference = (WorkTypeReferenceBeanInterface)this.createBeanInstance(WorkTypeReferenceBeanInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBeanInstance(CutoffUtilBeanInterface.class);
        this.attendanceTransactionRegist = (AttendanceTransactionRegistBeanInterface)this.createBeanInstance(AttendanceTransactionRegistBeanInterface.class);
        this.subholidayRequestReference = (SubHolidayRequestReferenceBeanInterface)this.createBeanInstance(SubHolidayRequestReferenceBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class);
        this.setTimeMaster(this.timeMaster);
    }

    public WorkOnHolidayRequestDtoInterface getInitDto() {
        return new TmdWorkOnHolidayRequestDto();
    }

    protected void insert(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdWorkOnHolidayRequestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public List<WorkflowDtoInterface> update(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        ArrayList<WorkflowDtoInterface> workflowList = new ArrayList<WorkflowDtoInterface>();
        for (long id : idArray) {
            BaseDto baseDto = this.findForKey((BaseDaoInterface)this.dao, id, true);
            this.checkExclusive((BaseDtoInterface)baseDto);
            if (this.mospParams.hasErrorMessage()) continue;
            WorkOnHolidayRequestDtoInterface dto = (WorkOnHolidayRequestDtoInterface)baseDto;
            this.checkAppli(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            List substituteList = this.substituteDao.findForWorkflow(dto.getWorkflow());
            int size = substituteList.size();
            if (size == 1) {
                SubstituteDtoInterface substituteDto = (SubstituteDtoInterface)substituteList.get(0);
                this.substituteRegist.checkRegist(substituteDto);
                if (this.mospParams.hasErrorMessage()) continue;
                this.attendanceRegist.delete(substituteDto.getPersonalId(), substituteDto.getSubstituteDate());
            }
            WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(dto.getWorkflow());
            this.workflowRegist.appli(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1, null);
            if (!substituteList.isEmpty()) {
                this.attendanceTransactionRegist.regist((SubstituteDtoInterface)substituteList.get(0));
            }
            if (workflowDto == null) continue;
            workflowList.add(workflowDto);
        }
        return workflowList;
    }

    public void regist(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getTmdWorkOnHolidayRequestId(), false) == null) {
            this.insert(dto);
        } else {
            this.add(dto);
        }
    }

    protected void add(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdWorkOnHolidayRequestId());
        dto.setTmdWorkOnHolidayRequestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdWorkOnHolidayRequestId());
    }

    public void withdrawn(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            BaseDto baseDto = this.findForKey((BaseDaoInterface)this.dao, id, true);
            this.checkExclusive((BaseDtoInterface)baseDto);
            if (this.mospParams.hasErrorMessage()) continue;
            WorkOnHolidayRequestDtoInterface dto = (WorkOnHolidayRequestDtoInterface)baseDto;
            this.checkWithdrawn(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(dto.getWorkflow());
            if ((workflowDto = this.workflowRegist.withdrawn(workflowDto)) == null) continue;
            this.workflowCommentRegist.addComment(workflowDto, this.mospParams.getUser().getPersonalId(), PfMessageUtility.getWithdrawSucceed((MospParams)this.mospParams));
        }
    }

    protected void checkInsert(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKeyOnWorkflow(dto.getPersonalId(), dto.getRequestDate()));
    }

    protected void checkAdd(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdWorkOnHolidayRequestId());
    }

    protected void checkUpdate(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdWorkOnHolidayRequestId());
    }

    public void validate(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.workOnHolidayReference.chkBasicInfo(dto.getPersonalId(), dto.getRequestDate());
    }

    public void checkValidate(WorkOnHolidayRequestDtoInterface dto) {
        this.checkRequired((Object)dto.getRequestDate(), PfNameUtility.workDay((MospParams)this.mospParams), null);
    }

    public void checkSetRequestDate(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBeanInstance(RequestUtilBeanInterface.class);
        RequestEntityInterface request = requestUtil.getRequestEntity(dto.getPersonalId(), dto.getRequestDate());
        this.checkSetRequestDate(dto, request);
    }

    protected void checkSetRequestDate(WorkOnHolidayRequestDtoInterface dto, RequestEntityInterface request) throws MospException {
        this.checkEntered(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRetired(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkSuspended(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTightenForSetRequestDate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkWorkOnHolidayOverlap(dto, request);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkHolidayDate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAttendance(dto, request);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkHolidayRequest(dto, request);
    }

    public void checkDraft(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBeanInstance(RequestUtilBeanInterface.class);
        RequestEntityInterface request = requestUtil.getRequestEntity(dto.getPersonalId(), dto.getRequestDate());
        this.checkDraft(dto, request);
    }

    protected void checkDraft(WorkOnHolidayRequestDtoInterface dto, RequestEntityInterface request) throws MospException {
        this.checkSetRequestDate(dto, request);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkLegalHolidayDate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkWorkTypeCode(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTemporaryClosingFinal(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.doStoredLogic(new Object[]{"WorkOnHolidayRequestRegistAddons", dto, request});
    }

    public void checkAppli(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBeanInstance(RequestUtilBeanInterface.class);
        RequestEntityInterface request = requestUtil.getRequestEntity(dto.getPersonalId(), dto.getRequestDate());
        this.checkDraft(dto, request);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRequired(dto);
        this.checkHalfSubstitute(dto, request);
        this.checkAttendanceDraft(dto, request);
    }

    protected void checkHalfSubstitute(WorkOnHolidayRequestDtoInterface dto, RequestEntityInterface request) throws MospException {
        if (!this.workOnHolidayReference.useHalfSubstitute()) {
            return;
        }
        Date workDate = dto.getRequestDate();
        int substitute = dto.getSubstitute();
        List beforeList = request.getSubstituteList(WorkflowUtility.getCompletedStatuses());
        if (beforeList.isEmpty()) {
            return;
        }
        boolean isHalfSubstitute = false;
        int beforeHolidayRange = ((SubstituteDtoInterface)beforeList.get(0)).getHolidayRange();
        boolean bl = isHalfSubstitute = beforeHolidayRange == 2 || beforeHolidayRange == 3;
        if (isHalfSubstitute && substitute != 3 && substitute != 4) {
            this.mospParams.addErrorMessage("TMW0334", new String[]{this.getStringDate(workDate)});
            return;
        }
        this.halfHolidayRangeCheck(dto, beforeList);
    }

    protected void checkAttendanceDraft(WorkOnHolidayRequestDtoInterface dto, RequestEntityInterface request) throws MospException {
        int substitute = dto.getSubstitute();
        if (substitute != 3 && substitute != 4) {
            return;
        }
        if (request.hasAttendance() && !request.isAttendanceApplied()) {
            this.attendanceRegist.delete(dto.getPersonalId(), dto.getRequestDate());
        }
    }

    protected void halfHolidayRangeCheck(WorkOnHolidayRequestDtoInterface dto, List<SubstituteDtoInterface> beforeList) {
        int range = dto.getSubstitute();
        if (range == 3) {
            range = 2;
        } else if (range == 4) {
            range = 3;
        } else {
            return;
        }
        int substituteRange = beforeList.get(0).getSubstituteRange();
        if (substituteRange == 1) {
            return;
        }
        if (beforeList.size() == 1 && range != substituteRange) {
            String[] rep = new String[]{this.getStringDate(dto.getRequestDate()), TimeNamingUtility.substituteHolidayRange((MospParams)this.mospParams), PfNameUtility.application((MospParams)this.mospParams)};
            this.mospParams.addErrorMessage("TMW0333", rep);
            return;
        }
    }

    public void checkCancelAppli(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.checkTemporaryClosingFinal(dto);
        this.checkCancel(dto);
    }

    public void checkWithdrawn(WorkOnHolidayRequestDtoInterface dto) {
    }

    public void checkApproval(WorkOnHolidayRequestDtoInterface dto) {
    }

    public void checkCancelApproval(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.checkCancelAppli(dto);
    }

    public void checkCancel(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        String personalId = dto.getPersonalId();
        Date workDate = dto.getRequestDate();
        if (dto.getSubstitute() == 2) {
            this.checkSubHolidayRequest(personalId, workDate);
            return;
        }
        this.checkWorkDate(personalId, workDate);
        SubstituteDtoInterface substituteDto = this.substituteReference.getSubstituteDto(personalId, workDate);
        Date substituteDate = substituteDto.getSubstituteDate();
        this.checkSubstituteDate(personalId, substituteDate);
        substituteDto = this.substituteReference.getSubstituteDto(personalId, substituteDate);
        if (substituteDto != null) {
            WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(substituteDto.getWorkflow());
            if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isFirstReverted((WorkflowDtoInterface)workflowDto)) {
                return;
            }
            this.mospParams.addErrorMessage("TMW0283", new String[0]);
            this.mospParams.addErrorMessage("TMW0284", new String[0]);
        } else {
            WorkOnHolidayRequestDtoInterface workOnHolidayDto = this.workOnHolidayReference.findForKeyOnWorkflow(personalId, substituteDate);
            if (workOnHolidayDto == null) {
                return;
            }
            WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(workOnHolidayDto.getWorkflow());
            if (WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isFirstReverted((WorkflowDtoInterface)workflowDto)) {
                return;
            }
            this.mospParams.addErrorMessage("TMW0283", new String[0]);
            this.mospParams.addErrorMessage("TMW0284", new String[0]);
        }
    }

    protected void checkWorkDate(String personalId, Date workDate) throws MospException {
        if (this.approvalInfoReference.isExistAttendanceTargetDate(personalId, workDate)) {
            this.addOthersRequestErrorMessage(workDate, TimeNamingUtility.getWorkManage((MospParams)this.mospParams));
        }
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBeanInstance(RequestUtilBeanInterface.class);
        requestUtil.setRequests(personalId, workDate);
        this.checkHolidayRequest(requestUtil, workDate);
        this.checkSubHolidayRequest(requestUtil, workDate);
        this.checkWorkTypeChangeRequest(requestUtil, workDate);
        this.checkOverTimeRequest(requestUtil, workDate);
        this.checkDifferenceRequest(requestUtil, workDate);
    }

    protected void checkSubstituteDate(String personalId, Date substituteDate) throws MospException {
        this.checkSubstituteAttendance(personalId, substituteDate);
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBeanInstance(RequestUtilBeanInterface.class);
        requestUtil.setRequests(personalId, substituteDate);
        this.checkHolidayRequest(requestUtil, substituteDate);
        this.checkSubHolidayRequest(requestUtil, substituteDate);
    }

    protected void checkHolidayRequest(RequestUtilBeanInterface requestUtil, Date targetDate) throws MospException {
        List holidayList = requestUtil.getHolidayList(false);
        if (!MospUtility.isEmpty((Collection)holidayList)) {
            this.addOthersRequestErrorMessage(targetDate, TimeNamingUtility.getVacation((MospParams)this.mospParams));
        }
    }

    protected void checkSubHolidayRequest(RequestUtilBeanInterface requestUtil, Date targetDate) throws MospException {
        List subHolidayList = requestUtil.getSubHolidayList(false);
        if (!MospUtility.isEmpty((Collection)subHolidayList)) {
            this.addOthersRequestErrorMessage(targetDate, TimeNamingUtility.getSubHoliday((MospParams)this.mospParams));
        }
    }

    protected void checkSubstituteAttendance(String personalId, Date substituteDate) throws MospException {
        WorkflowDtoInterface workflowDto;
        AttendanceDtoInterface attendanceDto = this.attendanceReference.findForKey(personalId, substituteDate);
        if (attendanceDto != null && WorkflowUtility.isApplied((WorkflowDtoInterface)(workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(attendanceDto.getWorkflow())))) {
            TimeMessageUtility.addErrorCancelAfterWithdrawForSubstituteDay((MospParams)this.mospParams, (String)TimeNamingUtility.attendanceRequest((MospParams)this.mospParams));
        }
    }

    protected void checkWorkOnHolidayOverlap(WorkOnHolidayRequestDtoInterface dto, RequestEntityInterface request) throws MospException {
        WorkOnHolidayRequestDtoInterface registered = request.getWorkOnHolidayRequestDto(WorkflowUtility.getStatusesExceptWithDrawn());
        if (MospUtility.isEmpty((Object[])new Object[]{registered})) {
            return;
        }
        if (dto.getWorkflow() == registered.getWorkflow()) {
            return;
        }
        TimeMessageUtility.addErrorAlreadyApplyWorkOnHolidayForWorkOnHoliday((MospParams)this.mospParams, (Date)dto.getRequestDate());
    }

    public void checkHolidayDate(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        if (dto.getWorkOnHolidayType() == null || dto.getWorkOnHolidayType().isEmpty()) {
            this.addWorkTypeNotExistErrorMessage(dto.getRequestDate());
            return;
        }
        if (!"legal_holiday".equals(dto.getWorkOnHolidayType()) && !"prescribed_holiday".equals(dto.getWorkOnHolidayType())) {
            this.addWorkOnHolidayTargetWorkDateHolidayErrorMessage(dto.getRequestDate());
        }
    }

    protected void checkAttendance(WorkOnHolidayRequestDtoInterface dto, RequestEntityInterface request) throws MospException {
        if (request.isAttendanceApplied()) {
            TimeMessageUtility.addErrorAlreadyApplyWorkForWorkOnHoliday((MospParams)this.mospParams, (Date)dto.getRequestDate());
        }
    }

    protected void checkLegalHolidayDate(WorkOnHolidayRequestDtoInterface dto) {
        if (this.mospParams.getApplicationPropertyBool("HalfLegalSubstitute")) {
            return;
        }
        if (!TimeUtility.isTheSubstitute((WorkOnHolidayRequestDtoInterface)dto, (int[])new int[]{3, 4})) {
            return;
        }
        if (TimeUtility.isLegalHoliday((String)dto.getWorkOnHolidayType())) {
            TimeMessageUtility.addErrorWorkOnHalfLegalHoliday((MospParams)this.mospParams);
        }
    }

    protected void checkHolidayRequest(WorkOnHolidayRequestDtoInterface dto, RequestEntityInterface request) throws MospException {
        List list = request.getHolidayRequestList(WorkflowUtility.getEffectiveStatuses());
        if (TimeRequestUtility.isWorkOnHolidaySubstitute((WorkOnHolidayRequestDtoInterface)dto)) {
            if (MospUtility.isEmpty((Collection)list)) {
                return;
            }
            TimeMessageUtility.addErrorSubstituteDuplicateHolidays((MospParams)this.mospParams);
            return;
        }
        Date requestDate = dto.getRequestDate();
        for (HolidayRequestDtoInterface holiday : list) {
            if (!DateUtility.isSame((Date)holiday.getRequestStartDate(), (Date)requestDate) && !DateUtility.isSame((Date)holiday.getRequestEndDate(), (Date)requestDate)) continue;
            TimeMessageUtility.addErrorWorkOnHolidayOtherRequest((MospParams)this.mospParams, (Date)requestDate);
            return;
        }
    }

    protected void checkWorkTypeCode(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        if (dto.getSubstitute() != 5) {
            return;
        }
        WorkTypeDtoInterface workTypeDto = this.workTypeReference.findForInfo(dto.getWorkTypeCode(), dto.getRequestDate());
        if (workTypeDto == null || workTypeDto.getInactivateFlag() == 1) {
            this.addWorkTypeNotExistErrorMessage(dto.getRequestDate());
        }
    }

    protected void checkRequired(WorkOnHolidayRequestDtoInterface dto) {
        if (dto.getRequestReason().isEmpty()) {
            PfMessageUtility.addErrorRequired((MospParams)this.mospParams, (String)TimeNamingUtility.applicationReason((MospParams)this.mospParams));
        }
    }

    protected void checkEntered(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        if (!this.isEntered(dto.getPersonalId(), dto.getRequestDate())) {
            PfMessageUtility.addErrorEmployeeNotJoin((MospParams)this.mospParams);
        }
    }

    protected void checkRetired(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        if (this.retirementReference.isRetired(dto.getPersonalId(), dto.getRequestDate())) {
            PfMessageUtility.addErrorEmployeeRetired((MospParams)this.mospParams);
        }
    }

    protected void checkSuspended(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        if (this.suspensionReference.isSuspended(dto.getPersonalId(), dto.getRequestDate())) {
            PfMessageUtility.addErrorEmployeeSuspended((MospParams)this.mospParams);
        }
    }

    protected void checkTightenForSetRequestDate(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.cutoffUtil.checkTighten(dto.getPersonalId(), dto.getRequestDate(), this.getNameGoingWorkDay());
    }

    protected void checkTemporaryClosingFinal(WorkOnHolidayRequestDtoInterface dto) throws MospException {
        this.cutoffUtil.checkTighten(dto.getPersonalId(), dto.getRequestDate(), this.getNameGoingWorkDay());
        if (dto.getSubstitute() == 2) {
            return;
        }
        List substituteList = this.substituteReference.getSubstituteList(dto.getWorkflow());
        for (SubstituteDtoInterface substituteDto : substituteList) {
            this.cutoffUtil.checkTighten(substituteDto.getPersonalId(), substituteDto.getSubstituteDate(), TimeNamingUtility.substituteDay((MospParams)this.mospParams));
        }
    }

    public String getScheduledWorkTypeCode(String personalId, Date targetDate) throws MospException {
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(personalId, targetDate);
        return this.getScheduledWorkTypeCode(personalId, targetDate, requestUtil);
    }

    protected String getScheduledWorkTypeCode(String personalId, Date targetDate, RequestUtilBeanInterface requestUtil) throws MospException {
        List list = requestUtil.getSubstituteList(true);
        for (SubstituteDtoInterface substituteDto : list) {
            if (substituteDto.getSubstituteRange() != 1) continue;
            return substituteDto.getSubstituteType();
        }
        return this.scheduleUtil.getScheduledWorkTypeCode(personalId, targetDate);
    }

    protected void checkSubHolidayRequest(String personalId, Date workDate) throws MospException {
        List subholidayRequestList = this.subholidayRequestReference.findForWorkDate(personalId, workDate);
        if (!MospUtility.isEmpty((Collection)subholidayRequestList)) {
            for (SubHolidayRequestDtoInterface subholidayRequestDto : subholidayRequestList) {
                WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(subholidayRequestDto.getWorkflow());
                if (!WorkflowUtility.isApplied((WorkflowDtoInterface)workflowDto)) continue;
                TimeMessageUtility.addErrorCancelAfterWithdraw((MospParams)this.mospParams, (String)DateUtility.getStringDate((Date)subholidayRequestDto.getRequestDate()), (String)TimeNamingUtility.subHolidayRequest((MospParams)this.mospParams));
            }
        }
        if (this.approvalInfoReference.isExistAttendanceTargetDate(personalId, workDate)) {
            this.mospParams.addErrorMessage("TMW0337", new String[]{DateUtility.getStringDate((Date)workDate)});
        }
    }

    protected void checkWorkTypeChangeRequest(RequestUtilBeanInterface requestUtil, Date workDate) throws MospException {
        WorkTypeChangeRequestDtoInterface workTypeChangeDto = requestUtil.getWorkTypeChangeDto(false);
        if (!MospUtility.isEmpty((Object[])new Object[]{workTypeChangeDto})) {
            TimeMessageUtility.addErrorCancelAfterWithdrawForWorkDay((MospParams)this.mospParams, (String)TimeNamingUtility.workTypeChangeRequest((MospParams)this.mospParams));
        }
    }

    protected void checkOverTimeRequest(RequestUtilBeanInterface requestUtil, Date workDate) throws MospException {
        List overtimeList = requestUtil.getOverTimeList(false);
        if (!MospUtility.isEmpty((Collection)overtimeList)) {
            TimeMessageUtility.addErrorCancelAfterWithdrawForWorkDay((MospParams)this.mospParams, (String)TimeNamingUtility.overtimeRequest((MospParams)this.mospParams));
        }
    }

    protected void checkDifferenceRequest(RequestUtilBeanInterface requestUtil, Date workDate) throws MospException {
        DifferenceRequestDtoInterface differenceDto = requestUtil.getDifferenceDto(false);
        if (!MospUtility.isEmpty((Object[])new Object[]{differenceDto})) {
            TimeMessageUtility.addErrorCancelAfterWithdrawForWorkDay((MospParams)this.mospParams, (String)TimeNamingUtility.differenceRequest((MospParams)this.mospParams));
        }
    }

    protected String getNameGoingWorkDay() {
        return PfNameUtility.goingWorkDay((MospParams)this.mospParams);
    }

    public void setTimeMaster(TimeMasterBeanInterface timeMaster) {
        this.timeMaster = timeMaster;
        this.scheduleUtil.setTimeMaster(timeMaster);
        this.cutoffUtil.setTimeMaster(timeMaster);
        this.attendanceRegist.setTimeMaster(timeMaster);
        this.attendanceTransactionRegist.setTimeMaster(timeMaster);
    }
}

