/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.file.ImportBeanInterface;
import jp.mosp.platform.bean.file.PlatformFileBean;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowRegistBeanInterface;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.dto.file.ImportFieldDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.bean.AttendanceTransactionRegistBeanInterface;
import jp.mosp.time.bean.SubstituteRegistBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.WorkOnHolidayRequestRegistBeanInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.utils.TimeNamingUtility;

public class WorkOnHolidayRequestImportBean
extends PlatformFileBean
implements ImportBeanInterface {
    protected WorkOnHolidayRequestRegistBeanInterface workOnHolidayRequestRegist;
    protected SubstituteRegistBeanInterface substituteRegist;
    protected AttendanceTransactionRegistBeanInterface attendanceTransactionRegist;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected WorkflowRegistBeanInterface workflowRegist;
    protected TimeMasterBeanInterface timeMaster;

    public void initBean() throws MospException {
        this.workOnHolidayRequestRegist = (WorkOnHolidayRequestRegistBeanInterface)this.createBeanInstance(WorkOnHolidayRequestRegistBeanInterface.class);
        this.substituteRegist = (SubstituteRegistBeanInterface)this.createBeanInstance(SubstituteRegistBeanInterface.class);
        this.attendanceTransactionRegist = (AttendanceTransactionRegistBeanInterface)this.createBeanInstance(AttendanceTransactionRegistBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBeanInstance(WorkflowIntegrateBeanInterface.class);
        this.workflowRegist = (WorkflowRegistBeanInterface)this.createBeanInstance(WorkflowRegistBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class);
        this.workOnHolidayRequestRegist.setTimeMaster(this.timeMaster);
    }

    public int importFile(ImportDtoInterface importDto, InputStream requestedFile) throws MospException {
        List dataList = this.getDataList(importDto, requestedFile);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        List fieldList = this.getImportFieldList(importDto.getImportCode());
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        this.checkCsvLength(fieldList, dataList);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        this.convertEmployeeCodeIntoPersonalId(fieldList, dataList, "request_date", this.getWorkOnHolidayName());
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        if ("import_tmd_work_on_holiday_request_substitute_off".equals(importDto.getImportTable())) {
            return this.importFileSubstituteOff(fieldList, dataList);
        }
        return this.importFile(fieldList, dataList);
    }

    protected int importFile(List<ImportFieldDtoInterface> fieldList, List<String[]> dataList) throws MospException {
        for (String[] data : dataList) {
            this.importData(fieldList, data);
        }
        return dataList.size();
    }

    protected void importData(List<ImportFieldDtoInterface> fieldList, String[] data) throws MospException {
        WorkOnHolidayRequestDtoInterface dto = this.getWorkOnHolidayRequestDto(fieldList, data);
        SubstituteDtoInterface substituteDto = this.getSubstituteDto(fieldList, data);
        this.workOnHolidayRequestRegist.checkValidate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.substituteRegist.checkImport(substituteDto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.workOnHolidayRequestRegist.checkAppli(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(dto.getWorkflow());
        if (workflowDto == null) {
            workflowDto = this.workflowRegist.getInitDto();
            workflowDto.setFunctionCode("4");
        }
        this.workflowRegist.setSelfApproval(workflowDto);
        workflowDto = this.workflowRegist.appli(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1, null);
        if (workflowDto != null) {
            long workflow = workflowDto.getWorkflow();
            dto.setWorkflow(workflow);
            substituteDto.setWorkflow(workflow);
            this.workOnHolidayRequestRegist.regist(dto);
            this.substituteRegist.insert(substituteDto);
            this.attendanceTransactionRegist.regist(substituteDto);
        }
    }

    protected WorkOnHolidayRequestDtoInterface getWorkOnHolidayRequestDto(List<ImportFieldDtoInterface> fieldList, String[] data) throws MospException {
        WorkOnHolidayRequestDtoInterface dto = this.workOnHolidayRequestRegist.getInitDto();
        String personalId = this.getFieldValue("personal_id", fieldList, data);
        Date requestDate = this.getDateFieldValue("request_date", fieldList, data);
        int substitute = 1;
        String workTypeCode = this.getFieldValue("work_type_code", fieldList, data);
        if (!workTypeCode.isEmpty()) {
            substitute = 5;
        }
        dto.setPersonalId(personalId);
        dto.setRequestDate(requestDate);
        dto.setTimesWork(1);
        dto.setWorkOnHolidayType(this.workOnHolidayRequestRegist.getScheduledWorkTypeCode(personalId, requestDate));
        dto.setWorkTypeCode(workTypeCode);
        dto.setSubstitute(substitute);
        dto.setStartTime(null);
        dto.setEndTime(null);
        dto.setRequestReason(this.getFieldValue("request_reason", fieldList, data));
        return dto;
    }

    protected SubstituteDtoInterface getSubstituteDto(List<ImportFieldDtoInterface> fieldList, String[] data) throws MospException {
        String personalId = this.getFieldValue("personal_id", fieldList, data);
        Date workDate = this.getDateFieldValue("request_date", fieldList, data);
        SubstituteDtoInterface dto = this.substituteRegist.getInitDto();
        dto.setPersonalId(personalId);
        dto.setSubstituteDate(this.getDateFieldValue("substitute_date", fieldList, data));
        dto.setSubstituteType(this.workOnHolidayRequestRegist.getScheduledWorkTypeCode(personalId, workDate));
        dto.setSubstituteRange(1);
        dto.setWorkDate(workDate);
        dto.setTimesWork(1);
        return dto;
    }

    protected int importFileSubstituteOff(List<ImportFieldDtoInterface> fieldList, List<String[]> dataList) throws MospException {
        this.checkCsvLength(fieldList, dataList);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        for (String[] data : dataList) {
            this.importDataSubstituteOff(fieldList, data);
        }
        return dataList.size();
    }

    protected void importDataSubstituteOff(List<ImportFieldDtoInterface> fieldList, String[] data) throws MospException {
        WorkOnHolidayRequestDtoInterface dto = this.getWorkOnHolidayRequestSubstituteOffDto(fieldList, data);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.workOnHolidayRequestRegist.checkAppli(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.workflowIntegrate.getLatestWorkflowInfo(dto.getWorkflow());
        if (workflowDto == null) {
            workflowDto = this.workflowRegist.getInitDto();
            workflowDto.setFunctionCode("4");
        }
        this.workflowRegist.setSelfApproval(workflowDto);
        workflowDto = this.workflowRegist.appli(workflowDto, dto.getPersonalId(), dto.getRequestDate(), 1, null);
        if (workflowDto != null) {
            long workflow = workflowDto.getWorkflow();
            dto.setWorkflow(workflow);
            this.workOnHolidayRequestRegist.regist(dto);
        }
    }

    protected WorkOnHolidayRequestDtoInterface getWorkOnHolidayRequestSubstituteOffDto(List<ImportFieldDtoInterface> fieldList, String[] data) throws MospException {
        WorkOnHolidayRequestDtoInterface dto = this.workOnHolidayRequestRegist.getInitDto();
        String personalId = this.getFieldValue("personal_id", fieldList, data);
        Date requestDate = this.getDateFieldValue("request_date", fieldList, data);
        Date startDate = this.getDateTimeFieldValue("start_time", fieldList, data);
        if (startDate == null) {
            PfMessageUtility.addErrorCheckForm((MospParams)this.mospParams, (String[])new String[]{TimeNamingUtility.scheduledStartWork((MospParams)this.mospParams)});
            return dto;
        }
        if (!DateUtility.getStringDate((Date)requestDate).equals(DateUtility.getStringDate((Date)startDate))) {
            PfMessageUtility.addErrorRequired((MospParams)this.mospParams, (String)TimeNamingUtility.scheduledStartWork((MospParams)this.mospParams));
            return dto;
        }
        ApplicationEntity application = this.timeMaster.getApplicationEntity(personalId, requestDate);
        if (!application.isValid(this.mospParams)) {
            return dto;
        }
        Date startDayTime = application.getTimeSettingDto().getStartDayTime();
        Date limitTime = DateUtility.addDay((Date)requestDate, (int)1);
        limitTime = DateUtility.addHour((Date)limitTime, (int)DateUtility.getHour((Date)startDayTime));
        limitTime = DateUtility.addMinute((Date)limitTime, (int)DateUtility.getMinute((Date)startDayTime));
        Date endDate = this.getDateTimeFieldValue("end_time", fieldList, data);
        if (endDate == null) {
            PfMessageUtility.addErrorCheckForm((MospParams)this.mospParams, (String[])new String[]{TimeNamingUtility.scheduledEndWork((MospParams)this.mospParams)});
            return dto;
        }
        if (DateUtility.getStringDateAndTime((Date)startDate).compareTo(DateUtility.getStringDateAndTime((Date)endDate)) != -1 || DateUtility.getStringDateAndTime((Date)endDate).compareTo(DateUtility.getStringDateAndTime((Date)limitTime)) != -1) {
            PfMessageUtility.addErrorRequired((MospParams)this.mospParams, (String)TimeNamingUtility.scheduledEndWork((MospParams)this.mospParams));
            return dto;
        }
        dto.setPersonalId(personalId);
        dto.setRequestDate(requestDate);
        dto.setTimesWork(1);
        dto.setWorkTypeCode("");
        dto.setWorkOnHolidayType(this.workOnHolidayRequestRegist.getScheduledWorkTypeCode(personalId, requestDate));
        dto.setSubstitute(2);
        dto.setStartTime(startDate);
        dto.setEndTime(endDate);
        dto.setRequestReason(this.getFieldValue("request_reason", fieldList, data));
        return dto;
    }

    protected Date getDateTimeFieldValue(String fieldName, List<ImportFieldDtoInterface> fieldList, String[] data) {
        String date = this.getFieldValue(fieldName, fieldList, data);
        if (date == null || date.isEmpty()) {
            return null;
        }
        return DateUtility.getDate((String)date, (String)"yyyyMMdd HH:mm");
    }

    protected String getWorkOnHolidayName() {
        return this.mospParams.getName("GoingWork", new String[]{"Day"});
    }
}

