/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataReferenceBeanInterface;
import jp.mosp.time.bean.impl.TimeBaseExportBean;
import jp.mosp.time.dto.base.HolidayRangeDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDataDtoInterface;
import jp.mosp.time.utils.TimeRequestUtility;
import jp.mosp.time.utils.TimeUtility;

public class UsedPaidHolidayDataExportBean
extends TimeBaseExportBean {
    protected PaidHolidayDataReferenceBeanInterface paidHolidayRefer;
    protected HolidayRequestReferenceBeanInterface holidayRequestRefer;

    public void initBean() throws MospException {
        super.initBean();
        this.paidHolidayRefer = (PaidHolidayDataReferenceBeanInterface)this.createBeanInstance(PaidHolidayDataReferenceBeanInterface.class);
        this.holidayRequestRefer = (HolidayRequestReferenceBeanInterface)this.createBeanInstance(HolidayRequestReferenceBeanInterface.class);
    }

    protected List<String[]> makeCsvDataList(List<String> fieldList, Date firstDate, Date lastDate, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, boolean needLowerSection, String positionCode) throws MospException {
        ArrayList<String[]> csvDataList = new ArrayList<String[]>();
        List humanList = this.getHumanList(firstDate, lastDate, cutoffCode, workPlaceCode, employmentContractCode, sectionCode, needLowerSection, positionCode);
        Map requestMap = this.getHolidayRequestMap(firstDate, lastDate);
        for (HumanDtoInterface humanDto : humanList) {
            Map holidayMap = (Map)requestMap.get(humanDto.getPersonalId());
            if (MospUtility.isEmpty((Map)holidayMap)) continue;
            for (Map.Entry entry : holidayMap.entrySet()) {
                Date acquisitionDate = (Date)entry.getKey();
                List requests = (List)entry.getValue();
                csvDataList.add(this.makeCsvData(acquisitionDate, requests, humanDto, fieldList, firstDate, lastDate));
            }
        }
        return csvDataList;
    }

    protected String[] makeCsvData(Date acquisitionDate, List<HolidayRequestDtoInterface> requests, HumanDtoInterface humanDto, List<String> fieldList, Date firstDate, Date lastDate) throws MospException {
        String[] csvData = this.getHumanCsvData(fieldList, humanDto, lastDate);
        String csvAcquisitionDate = DateUtility.getStringDate((Date)acquisitionDate);
        double csvUsedDays = this.getUsedDays(requests);
        String csvAppliDate = MospUtility.concat((Object)",", (String[])MospUtility.toArray((Collection)this.getAppliDates(requests)));
        this.setCsvValue(csvData, fieldList, "acquisition_date", (Object)csvAcquisitionDate);
        this.setCsvValue(csvData, fieldList, "used_days", (Object)csvUsedDays);
        this.setCsvValue(csvData, fieldList, "appli_date", (Object)csvAppliDate);
        return csvData;
    }

    protected double getUsedDays(Collection<HolidayRequestDtoInterface> requests) {
        double usedDays = 0.0;
        for (HolidayRequestDtoInterface request : requests) {
            if (TimeRequestUtility.isHolidayRangeHour((HolidayRangeDtoInterface)request)) continue;
            usedDays += request.getUseDay();
        }
        return usedDays;
    }

    protected List<String> getAppliDates(Collection<HolidayRequestDtoInterface> requests) {
        ArrayList<String> appliDates = new ArrayList<String>();
        for (HolidayRequestDtoInterface request : requests) {
            if (TimeRequestUtility.isHolidayRangeHour((HolidayRangeDtoInterface)request)) continue;
            StringBuilder sb = new StringBuilder(DateUtility.getStringDate((Date)request.getRequestStartDate()));
            sb.append(" ");
            sb.append(TimeUtility.getHolidayRangeAbbr((MospParams)this.mospParams, (int)request.getHolidayRange()));
            appliDates.add(sb.toString());
        }
        return appliDates;
    }

    protected Map<String, Map<Date, List<HolidayRequestDtoInterface>>> getHolidayRequestMap(Date startDate, Date endDate) throws MospException {
        List dtos = this.paidHolidayRefer.getPaidHolidayDataForTerm(startDate, endDate);
        TreeMap<String, Map<Date, List<HolidayRequestDtoInterface>>> paidHolidayMap = new TreeMap<String, Map<Date, List<HolidayRequestDtoInterface>>>();
        Map requestMap = this.getPersonalHolidayRequestMap(startDate, endDate);
        for (PaidHolidayDataDtoInterface dto : dtos) {
            TreeMap resultMap;
            ArrayList requestList;
            String personalId = dto.getPersonalId();
            Date acquisitionDate = dto.getAcquisitionDate();
            TreeMap map = (TreeMap)requestMap.get(personalId);
            if (map == null) {
                map = new TreeMap();
            }
            if ((requestList = (ArrayList)map.get(acquisitionDate)) == null) {
                requestList = new ArrayList();
            }
            if ((resultMap = (TreeMap)paidHolidayMap.get(personalId)) == null) {
                resultMap = new TreeMap();
            }
            resultMap.put(acquisitionDate, requestList);
            paidHolidayMap.put(personalId, resultMap);
        }
        return paidHolidayMap;
    }

    protected Map<String, Map<Date, List<HolidayRequestDtoInterface>>> getPersonalHolidayRequestMap(Date startDate, Date endDate) throws MospException {
        TreeMap<String, Map<Date, List<HolidayRequestDtoInterface>>> resultMap = new TreeMap<String, Map<Date, List<HolidayRequestDtoInterface>>>();
        List dtos = this.holidayRequestRefer.getAppliedPaidHolidayRequests(startDate, endDate);
        for (HolidayRequestDtoInterface dto : dtos) {
            ArrayList<HolidayRequestDtoInterface> list;
            String personalId = dto.getPersonalId();
            Date acquisitionDate = dto.getHolidayAcquisitionDate();
            TreeMap<Date, ArrayList<HolidayRequestDtoInterface>> map = (TreeMap<Date, ArrayList<HolidayRequestDtoInterface>>)resultMap.get(personalId);
            if (map == null) {
                map = new TreeMap<Date, ArrayList<HolidayRequestDtoInterface>>();
            }
            if ((list = (ArrayList<HolidayRequestDtoInterface>)map.get(acquisitionDate)) == null) {
                list = new ArrayList<HolidayRequestDtoInterface>();
            }
            list.add(dto);
            map.put(acquisitionDate, list);
            resultMap.put(personalId, map);
        }
        return resultMap;
    }
}

