/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.bean.TotalTimeTransactionSearchBeanInterface;
import jp.mosp.time.dao.settings.CutoffDaoInterface;
import jp.mosp.time.dao.settings.TotalTimeDaoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeCutoffListDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDtoInterface;
import jp.mosp.time.dto.settings.impl.TotalTimeCutoffListDto;

public class TotalTimeTransactionSearchBean
extends PlatformBean
implements TotalTimeTransactionSearchBeanInterface {
    protected CutoffDaoInterface cutoffDao;
    protected TotalTimeDaoInterface totalTimeDao;
    private int requestYear;
    private int requestMonth;
    private String cutoffDate;
    private String cutoffCode;
    private String cutoffName;
    private String cutoffState;

    public void initBean() throws MospException {
        this.cutoffDao = (CutoffDaoInterface)this.createDaoInstance(CutoffDaoInterface.class);
        this.totalTimeDao = (TotalTimeDaoInterface)this.createDaoInstance(TotalTimeDaoInterface.class);
    }

    public List<TotalTimeCutoffListDtoInterface> getSearchList() throws MospException {
        Date targetDate = MonthUtility.getYearMonthTargetDate((int)this.requestYear, (int)this.requestMonth, (MospParams)this.mospParams);
        Map param = this.cutoffDao.getParamsMap();
        param.put("targetDate", targetDate);
        param.put("cutoffDate", this.cutoffDate);
        param.put("cutoffCode", this.cutoffCode);
        param.put("cutoffName", this.cutoffName);
        param.put("cutoffAbbr", "");
        param.put("noApproval", "");
        param.put("selfTightening", "");
        param.put("inactivateFlag", 0);
        List list = this.cutoffDao.findForSearch(param);
        ArrayList<TotalTimeCutoffListDtoInterface> totalTimeCutoffList = new ArrayList<TotalTimeCutoffListDtoInterface>();
        for (CutoffDtoInterface dto : list) {
            TotalTimeCutoffListDto totalTimeCutoffListDto = new TotalTimeCutoffListDto();
            totalTimeCutoffListDto.setCutoffCode(dto.getCutoffCode());
            totalTimeCutoffListDto.setCutoffName(dto.getCutoffName());
            totalTimeCutoffListDto.setCutoffAbbr(dto.getCutoffAbbr());
            totalTimeCutoffListDto.setCutoffDate(dto.getCutoffDate());
            totalTimeCutoffListDto.setCutoffState(0);
            TotalTimeDtoInterface totalTimeDto = this.totalTimeDao.findForKey(this.requestYear, this.requestMonth, dto.getCutoffCode());
            if (totalTimeDto != null) {
                totalTimeCutoffListDto.setCutoffState(totalTimeDto.getCutoffState());
            }
            if (!this.cutoffState.isEmpty() && !String.valueOf(totalTimeCutoffListDto.getCutoffState()).equals(this.cutoffState)) continue;
            totalTimeCutoffList.add((TotalTimeCutoffListDtoInterface)totalTimeCutoffListDto);
        }
        return totalTimeCutoffList;
    }

    public void setRequestYear(int requestYear) {
        this.requestYear = requestYear;
    }

    public void setRequestMonth(int requestMonth) {
        this.requestMonth = requestMonth;
    }

    public void setCutoffDate(String cutoffDate) {
        this.cutoffDate = cutoffDate;
    }

    public void setCutoffCode(String cutoffCode) {
        this.cutoffCode = cutoffCode;
    }

    public void setCutoffName(String cutoffName) {
        this.cutoffName = cutoffName;
    }

    public void setCutoffState(String cutoffState) {
        this.cutoffState = cutoffState;
    }
}

