/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.SubordinateSearchBeanInterface;
import jp.mosp.time.bean.TotalTimeSearchBeanInterface;
import jp.mosp.time.bean.impl.SubordinateSearchBean;
import jp.mosp.time.dao.settings.TotalTimeDataDaoInterface;
import jp.mosp.time.dto.settings.SubordinateListDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDataDtoInterface;
import jp.mosp.time.entity.CutoffEntityInterface;

public class TotalTimeSearchBean
extends SubordinateSearchBean
implements TotalTimeSearchBeanInterface {
    private TotalTimeDataDaoInterface totalTimeDataDao;
    private CutoffUtilBeanInterface cutoffUtil;
    private SubordinateSearchBeanInterface subordinateSearch;
    protected String cutoffCode;

    public void initBean() throws MospException {
        super.initBean();
        this.totalTimeDataDao = (TotalTimeDataDaoInterface)this.createDaoInstance(TotalTimeDataDaoInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBeanInstance(CutoffUtilBeanInterface.class);
        this.subordinateSearch = (SubordinateSearchBeanInterface)this.createBeanInstance(SubordinateSearchBeanInterface.class);
    }

    public List<SubordinateListDtoInterface> getSearchList() throws MospException {
        ArrayList<SubordinateListDtoInterface> list = new ArrayList<SubordinateListDtoInterface>();
        Set personalIdSet = this.cutoffUtil.getCutoffPersonalIdSet(this.cutoffCode, this.targetYear, this.targetMonth);
        CutoffEntityInterface cutoff = this.timeMaster.getCutoff(this.cutoffCode, this.targetYear, this.targetMonth);
        this.setTargetDate(cutoff.getCutoffTermTargetDate(this.targetYear, this.targetMonth, this.mospParams));
        this.setStartDate(cutoff.getCutoffFirstDate(this.targetYear, this.targetMonth, this.mospParams));
        this.setEndDate(cutoff.getCutoffLastDate(this.targetYear, this.targetMonth, this.mospParams));
        this.setEmployeeCodeType("forward");
        this.setStateType("presence");
        boolean searchBeforeDay = this.approvalBeforeDay.equals("1");
        List humanList = this.search();
        for (HumanDtoInterface human : humanList) {
            TotalTimeDataDtoInterface totalTimeDto;
            SubordinateListDtoInterface dto;
            String personalId = human.getPersonalId();
            if (!personalIdSet.contains(personalId) || !this.isApprovalConditionMatch(dto = this.subordinateSearch.getSubordinateListDto(human, this.targetYear, this.targetMonth, totalTimeDto = this.totalTimeDataDao.findForKey(personalId, this.targetYear, this.targetMonth), searchBeforeDay)) || !this.isCalcConditionMatch(dto)) continue;
            list.add(dto);
        }
        return list;
    }

    public void setCutoffCode(String cutoffCode) {
        this.cutoffCode = cutoffCode;
    }
}

