/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.bean.TotalTimeReferenceBeanInterface;
import jp.mosp.time.dao.settings.TotalTimeDataDaoInterface;
import jp.mosp.time.dto.settings.TotalTimeDataDtoInterface;

public class TotalTimeReferenceBean
extends PlatformBean
implements TotalTimeReferenceBeanInterface {
    protected TotalTimeDataDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (TotalTimeDataDaoInterface)this.createDaoInstance(TotalTimeDataDaoInterface.class);
    }

    public TotalTimeDataDtoInterface findForKey(String personalId, int calculationYear, int calculationMonth) throws MospException {
        TotalTimeDataDtoInterface dto = this.dao.findForKey(personalId, calculationYear, calculationMonth);
        this.doAdditionalLogic(new Object[]{"Add_TotalTimeReferenceBean_FindForKey", dto});
        return dto;
    }

    public Map<Date, TotalTimeDataDtoInterface> findTermMap(String personalId, Date firstMonth, Date lastMonth) throws MospException {
        TreeMap<Date, TotalTimeDataDtoInterface> map = new TreeMap<Date, TotalTimeDataDtoInterface>();
        int startYear = DateUtility.getYear((Date)firstMonth);
        int startMonth = DateUtility.getMonth((Date)firstMonth);
        int endYear = DateUtility.getYear((Date)lastMonth);
        int endMonth = DateUtility.getMonth((Date)lastMonth);
        for (TotalTimeDataDtoInterface dto : this.dao.findForTerm(personalId, startYear, startMonth, endYear, endMonth)) {
            map.put(MonthUtility.getYearMonthDate((int)dto.getCalculationYear(), (int)dto.getCalculationMonth()), dto);
        }
        return map;
    }

    public Map<Integer, TotalTimeDataDtoInterface> findFiscalMap(String personalId, Date firstDate, Date lastDate) throws MospException {
        int startYear = DateUtility.getYear((Date)firstDate);
        int startMonth = DateUtility.getMonth((Date)firstDate);
        int endYear = DateUtility.getYear((Date)lastDate);
        int endMonth = DateUtility.getMonth((Date)lastDate);
        return this.findFiscalMap(personalId, startYear, startMonth, endYear, endMonth);
    }

    public Map<Integer, TotalTimeDataDtoInterface> findFiscalMap(String personalId, int startYear, int startMonth, int endYear, int endMonth) throws MospException {
        LinkedHashMap<Integer, TotalTimeDataDtoInterface> map = new LinkedHashMap<Integer, TotalTimeDataDtoInterface>();
        for (TotalTimeDataDtoInterface dto : this.dao.findForTerm(personalId, startYear, startMonth, endYear, endMonth)) {
            map.put(dto.getCalculationMonth(), dto);
        }
        this.doAdditionalLogic(new Object[]{"Add_TotalTimeReferenceBean_FindFiscalMap", map});
        return map;
    }

    public int getMinYear() throws MospException {
        return this.dao.getMinYear();
    }
}

