/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.system.PlatformMasterBeanInterface;
import jp.mosp.platform.dao.human.EntranceDaoInterface;
import jp.mosp.platform.dao.human.RetirementDaoInterface;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.ScheduleDateReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.TotalTimeEntityReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dao.settings.AttendanceDaoInterface;
import jp.mosp.time.dao.settings.AttendanceTransactionDaoInterface;
import jp.mosp.time.dao.settings.DifferenceRequestDaoInterface;
import jp.mosp.time.dao.settings.HolidayDaoInterface;
import jp.mosp.time.dao.settings.HolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.OvertimeRequestDaoInterface;
import jp.mosp.time.dao.settings.SubHolidayDaoInterface;
import jp.mosp.time.dao.settings.SubHolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.SubstituteDaoInterface;
import jp.mosp.time.dao.settings.TimeSettingDaoInterface;
import jp.mosp.time.dao.settings.WorkOnHolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.WorkTypeChangeRequestDaoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.AttendanceTransactionDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.entity.CutoffEntityInterface;
import jp.mosp.time.entity.RequestDetectEntityInterface;
import jp.mosp.time.entity.TotalTimeEntityInterface;
import jp.mosp.time.entity.WorkTypeEntityInterface;
import jp.mosp.time.utils.TimeUtility;

public class TotalTimeEntityReferenceBean
extends TimeBean
implements TotalTimeEntityReferenceBeanInterface {
    public static final int DAYS_FORMER_ATTENDANCE = -7;
    protected EntranceDaoInterface entranceDao;
    protected SuspensionReferenceBeanInterface suspentionReference;
    protected RetirementDaoInterface retirementDao;
    protected HolidayDaoInterface holidayDao;
    protected AttendanceDaoInterface attendanceDao;
    protected OvertimeRequestDaoInterface overtimeRequestDao;
    protected HolidayRequestDaoInterface holidayRequestDao;
    protected WorkOnHolidayRequestDaoInterface workOnHolidayRequestDao;
    protected SubHolidayRequestDaoInterface subHolidayRequestDao;
    protected WorkTypeChangeRequestDaoInterface workTypeChangeRequestDao;
    protected DifferenceRequestDaoInterface differenceRequestDao;
    protected SubstituteDaoInterface substituteDao;
    protected SubHolidayDaoInterface subHolidayDao;
    protected WorkflowDaoInterface workflowDao;
    protected AttendanceTransactionDaoInterface attendanceTransactionDao;
    protected TimeSettingDaoInterface timeSettingDao;
    protected ScheduleDateReferenceBeanInterface scheduleDateReference;
    protected WorkTypeReferenceBeanInterface workTypeReference;
    protected ScheduleUtilBeanInterface scheduleUtil;
    protected PlatformMasterBeanInterface platformMaster;
    protected TimeMasterBeanInterface timeMaster;

    public void initBean() throws MospException {
        this.entranceDao = (EntranceDaoInterface)this.createDaoInstance(EntranceDaoInterface.class);
        this.retirementDao = (RetirementDaoInterface)this.createDaoInstance(RetirementDaoInterface.class);
        this.holidayDao = (HolidayDaoInterface)this.createDaoInstance(HolidayDaoInterface.class);
        this.attendanceDao = (AttendanceDaoInterface)this.createDaoInstance(AttendanceDaoInterface.class);
        this.overtimeRequestDao = (OvertimeRequestDaoInterface)this.createDaoInstance(OvertimeRequestDaoInterface.class);
        this.holidayRequestDao = (HolidayRequestDaoInterface)this.createDaoInstance(HolidayRequestDaoInterface.class);
        this.workOnHolidayRequestDao = (WorkOnHolidayRequestDaoInterface)this.createDaoInstance(WorkOnHolidayRequestDaoInterface.class);
        this.subHolidayRequestDao = (SubHolidayRequestDaoInterface)this.createDaoInstance(SubHolidayRequestDaoInterface.class);
        this.workTypeChangeRequestDao = (WorkTypeChangeRequestDaoInterface)this.createDaoInstance(WorkTypeChangeRequestDaoInterface.class);
        this.differenceRequestDao = (DifferenceRequestDaoInterface)this.createDaoInstance(DifferenceRequestDaoInterface.class);
        this.workflowDao = (WorkflowDaoInterface)this.createDaoInstance(WorkflowDaoInterface.class);
        this.timeSettingDao = (TimeSettingDaoInterface)this.createDaoInstance(TimeSettingDaoInterface.class);
        this.substituteDao = (SubstituteDaoInterface)this.createDaoInstance(SubstituteDaoInterface.class);
        this.attendanceTransactionDao = (AttendanceTransactionDaoInterface)this.createDaoInstance(AttendanceTransactionDaoInterface.class);
        this.subHolidayDao = (SubHolidayDaoInterface)this.createDaoInstance(SubHolidayDaoInterface.class);
        this.suspentionReference = (SuspensionReferenceBeanInterface)this.createBeanInstance(SuspensionReferenceBeanInterface.class);
        this.scheduleDateReference = (ScheduleDateReferenceBeanInterface)this.createBeanInstance(ScheduleDateReferenceBeanInterface.class);
        this.workTypeReference = (WorkTypeReferenceBeanInterface)this.createBeanInstance(WorkTypeReferenceBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBeanInstance(ScheduleUtilBeanInterface.class);
    }

    public TotalTimeEntityInterface getTotalTimeEntity(String personalId, int targetYear, int targetMonth, CutoffEntityInterface cutoff) throws MospException {
        TotalTimeEntityInterface entity = (TotalTimeEntityInterface)this.createObject(TotalTimeEntityInterface.class);
        entity.setMospParams(this.mospParams);
        entity.setPersonalId(personalId);
        entity.setCalculationYear(targetYear);
        entity.setCalculationMonth(targetMonth);
        entity.setCutoffCode(cutoff.getCode());
        if (!cutoff.isExist()) {
            return entity;
        }
        int cutoffDate = cutoff.getCutoffDate();
        Date cutoffTermTargetDate = cutoff.getCutoffTermTargetDate(targetYear, targetMonth, this.mospParams);
        Date firstDate = cutoff.getCutoffFirstDate(targetYear, targetMonth, this.mospParams);
        Date lastDate = cutoff.getCutoffLastDate(targetYear, targetMonth, this.mospParams);
        Date personalFirstDate = this.getPersonalFirstDate(personalId, targetYear, targetMonth, cutoffDate);
        Date personalLastDate = this.getPersonalLastDate(personalId, targetYear, targetMonth, cutoffDate);
        if (personalFirstDate == null || personalLastDate == null) {
            return entity;
        }
        Date attendanceFirstDate = DateUtility.addDay((Date)firstDate, (int)-7);
        entity.setHolidaySet(this.timeMaster.getHolidaySet(cutoffTermTargetDate));
        entity.setCutoffFirstDate(firstDate);
        entity.setCutoffLastDate(lastDate);
        entity.setSuspensionList(this.suspentionReference.getSuspentionList(personalId));
        entity.setTargetDateList(TimeUtility.getDateList((Date)personalFirstDate, (Date)personalLastDate));
        entity.setApplicationMap(this.timeMaster.getApplicationMap(personalId, attendanceFirstDate, personalLastDate));
        entity.setTimeSettingMap(this.timeMaster.getTimeSettingMap(entity.getApplicationMap()));
        entity.setScheduleMap(this.scheduleUtil.getScheduledWorkTypeCodes(personalId, personalFirstDate, personalLastDate));
        entity.setAttendanceList(this.attendanceDao.findForList(personalId, attendanceFirstDate, lastDate));
        entity.setHolidayRequestList(this.holidayRequestDao.findForTerm(personalId, firstDate, lastDate));
        entity.setWorkOnHolidayRequestList(this.workOnHolidayRequestDao.findForList(personalId, firstDate, lastDate));
        entity.setOvertimeRequestList(this.overtimeRequestDao.findForList(personalId, firstDate, lastDate));
        entity.setWorkTypeChangeRequestList(this.workTypeChangeRequestDao.findForTerm(personalId, firstDate, lastDate));
        entity.setDifferenceRequestList(this.differenceRequestDao.findForList(personalId, firstDate, lastDate));
        entity.setSubstitubeList(this.substituteDao.findForTerm(personalId, firstDate, lastDate));
        Date subHolidayFirstDate = this.getDateOnTimeSetteingDto(entity);
        entity.setSubHolidayList(this.subHolidayDao.findSubHolidayList(personalId, subHolidayFirstDate, lastDate));
        entity.setSubHolidayTimeSettingMap(this.getSubHolidayTimeSettingMap(entity.getSubHolidayList()));
        entity.setSubHolidayRequestList(this.subHolidayRequestDao.findForList(personalId, subHolidayFirstDate, lastDate));
        Date workflowFirstDate = this.getRequestStartDateForWorkflow(entity);
        Date workflowLastDate = this.getRequestEndDateForWorkflow(entity);
        entity.setWorkflowMap(this.workflowDao.findForCondition(personalId, workflowFirstDate, workflowLastDate));
        entity.setAttendanceTransactionSet(this.getAttendanceTransactionSet(personalId, firstDate, lastDate));
        entity.setSubstitutedMap(this.getSubstitutedMap(entity));
        Map workTypeEntityMap = Collections.emptyMap();
        if (this.mospParams.getApplicationPropertyBool("UseShortUnpaid")) {
            workTypeEntityMap = this.getWorkTypeEntityMap(entity);
        }
        entity.setWorkTypeEntityMap(workTypeEntityMap);
        this.doAdditionalLogic(new Object[]{"Add_TotalTimeEntityReferenceBean_GetTotalTimeEntity", entity});
        return entity;
    }

    protected Date getPersonalFirstDate(String personalId, int targetYear, int targetMonth, int cutoffDate) throws MospException {
        EntranceDtoInterface entranceDto = this.entranceDao.findForInfo(personalId);
        if (entranceDto == null) {
            return null;
        }
        List humanList = this.platformMaster.getHumanHistory(personalId);
        if (humanList.isEmpty()) {
            return null;
        }
        Date cutoffFirstDate = TimeUtility.getCutoffFirstDate((int)cutoffDate, (int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
        if (cutoffFirstDate.before(((HumanDtoInterface)humanList.get(0)).getActivateDate())) {
            return ((HumanDtoInterface)humanList.get(0)).getActivateDate();
        }
        if (cutoffFirstDate.before(entranceDto.getEntranceDate())) {
            return entranceDto.getEntranceDate();
        }
        return cutoffFirstDate;
    }

    protected Date getPersonalLastDate(String personalId, int targetYear, int targetMonth, int cutoffDate) throws MospException {
        Date cutoffLastDate = TimeUtility.getCutoffLastDate((int)cutoffDate, (int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
        RetirementDtoInterface retirementDto = this.retirementDao.findForInfo(personalId);
        if (retirementDto == null) {
            return cutoffLastDate;
        }
        if (cutoffLastDate.after(retirementDto.getRetirementDate())) {
            return retirementDto.getRetirementDate();
        }
        return cutoffLastDate;
    }

    protected Date getDateOnTimeSetteingDto(TotalTimeEntityInterface entity) {
        Date targetDate = entity.getCutoffFirstDate();
        TimeSettingDtoInterface timeSettingDto = (TimeSettingDtoInterface)entity.getTimeSettingMap().get(targetDate);
        if (timeSettingDto == null) {
            return entity.getCutoffFirstDate();
        }
        Date date = this.addDay(DateUtility.addMonth((Date)targetDate, (int)(-timeSettingDto.getSubHolidayLimitMonth())), -timeSettingDto.getSubHolidayLimitDate());
        return date;
    }

    protected Map<Date, TimeSettingDtoInterface> getSubHolidayTimeSettingMap(List<SubHolidayDtoInterface> subHolidayList) throws MospException {
        HashMap<Date, TimeSettingDtoInterface> map = new HashMap<Date, TimeSettingDtoInterface>();
        for (SubHolidayDtoInterface subHolidayDto : subHolidayList) {
            Map tmpMap;
            Date workDate = subHolidayDto.getWorkDate();
            TimeSettingDtoInterface dto = (TimeSettingDtoInterface)map.get(workDate);
            if (dto != null || (tmpMap = this.timeMaster.getTimeSettingMap(this.timeMaster.getApplicationMap(subHolidayDto.getPersonalId(), workDate, workDate))) == null) continue;
            map.putAll(tmpMap);
        }
        return map;
    }

    protected Date getRequestStartDateForWorkflow(TotalTimeEntityInterface entity) {
        Date startDate = entity.getCutoffFirstDate();
        for (AttendanceDtoInterface dto : entity.getAttendanceList()) {
            if (startDate.compareTo(dto.getWorkDate()) <= 0) continue;
            startDate = dto.getWorkDate();
        }
        for (AttendanceDtoInterface dto : entity.getHolidayRequestList()) {
            if (startDate.compareTo(dto.getRequestStartDate()) <= 0) continue;
            startDate = dto.getRequestStartDate();
        }
        for (AttendanceDtoInterface dto : entity.getWorkOnHolidayRequestList()) {
            if (startDate.compareTo(dto.getRequestDate()) <= 0) continue;
            startDate = dto.getRequestDate();
        }
        for (AttendanceDtoInterface dto : entity.getSubstitubeList()) {
            if (startDate.compareTo(dto.getWorkDate()) <= 0) continue;
            startDate = dto.getWorkDate();
        }
        for (AttendanceDtoInterface dto : entity.getSubHolidayRequestList()) {
            if (startDate.compareTo(dto.getRequestDate()) <= 0) continue;
            startDate = dto.getRequestDate();
        }
        for (AttendanceDtoInterface dto : entity.getOvertimeRequestList()) {
            if (startDate.compareTo(dto.getRequestDate()) <= 0) continue;
            startDate = dto.getRequestDate();
        }
        for (AttendanceDtoInterface dto : entity.getWorkTypeChangeRequestList()) {
            if (startDate.compareTo(dto.getRequestDate()) <= 0) continue;
            startDate = dto.getRequestDate();
        }
        for (AttendanceDtoInterface dto : entity.getDifferenceRequestList()) {
            if (startDate.compareTo(dto.getRequestDate()) <= 0) continue;
            startDate = dto.getRequestDate();
        }
        return startDate;
    }

    protected Date getRequestEndDateForWorkflow(TotalTimeEntityInterface entity) {
        Date endDate = entity.getCutoffLastDate();
        for (SubstituteDtoInterface dto : entity.getSubstitubeList()) {
            if (endDate.compareTo(dto.getWorkDate()) >= 0) continue;
            endDate = dto.getWorkDate();
        }
        return endDate;
    }

    protected Set<AttendanceTransactionDtoInterface> getAttendanceTransactionSet(String personalId, Date firstDate, Date lastDate) throws MospException {
        Map map = this.attendanceTransactionDao.findForTerm(personalId, firstDate, lastDate);
        return new HashSet<AttendanceTransactionDtoInterface>(map.values());
    }

    public RequestDetectEntityInterface getRequestDetectEntity(TotalTimeEntityInterface totalTimeEntity) throws MospException {
        RequestDetectEntityInterface entity = (RequestDetectEntityInterface)this.createObject(RequestDetectEntityInterface.class);
        entity.setTargetDateList(totalTimeEntity.getTargetDateList());
        entity.setSuspensionList(totalTimeEntity.getSuspensionList());
        entity.setScheduleMap(totalTimeEntity.getScheduleMap());
        entity.setAttendanceList(totalTimeEntity.getAttendanceList());
        entity.setWorkOnHolidayRequestList(totalTimeEntity.getWorkOnHolidayRequestList());
        entity.setHolidayRequestList(totalTimeEntity.getHolidayRequestList());
        entity.setSubHolidayRequestList(totalTimeEntity.getSubHolidayRequestList());
        entity.setOvertimeRequestList(totalTimeEntity.getOvertimeRequestList());
        entity.setWorkTypeChangeRequestList(totalTimeEntity.getWorkTypeChangeRequestList());
        entity.setDifferenceRequestList(totalTimeEntity.getDifferenceRequestList());
        entity.setSubstituteList(totalTimeEntity.getSubstitubeList());
        entity.setWorkflowMap(totalTimeEntity.getWorkflowMap());
        return entity;
    }

    public RequestDetectEntityInterface getRequestDetectEntity(String personalId, int targetYear, int targetMonth, int cutoffDate) throws MospException {
        RequestDetectEntityInterface entity = (RequestDetectEntityInterface)this.createObject(RequestDetectEntityInterface.class);
        Date firstDate = this.getPersonalFirstDate(personalId, targetYear, targetMonth, cutoffDate);
        Date lastDate = this.getPersonalLastDate(personalId, targetYear, targetMonth, cutoffDate);
        entity.setPersonalId(personalId);
        entity.setTargetDateList(TimeUtility.getDateList((Date)firstDate, (Date)lastDate));
        entity.setScheduleMap(this.scheduleUtil.getScheduledWorkTypeCodes(personalId, firstDate, lastDate));
        entity.setSuspensionList(this.suspentionReference.getSuspentionList(personalId));
        List attendances = this.attendanceDao.findForList(personalId, DateUtility.addDay((Date)firstDate, (int)-6), lastDate);
        entity.setAttendanceList(attendances);
        List holidayRequests = this.holidayRequestDao.findForTerm(personalId, firstDate, lastDate);
        entity.setHolidayRequestList(holidayRequests);
        List workOnHolidayRequests = this.workOnHolidayRequestDao.findForList(personalId, firstDate, lastDate);
        entity.setWorkOnHolidayRequestList(workOnHolidayRequests);
        List overtimeRequests = this.overtimeRequestDao.findForList(personalId, firstDate, lastDate);
        entity.setOvertimeRequestList(overtimeRequests);
        List workTypeChangeRequests = this.workTypeChangeRequestDao.findForTerm(personalId, firstDate, lastDate);
        entity.setWorkTypeChangeRequestList(workTypeChangeRequests);
        List differenceRequests = this.differenceRequestDao.findForList(personalId, firstDate, lastDate);
        entity.setDifferenceRequestList(differenceRequests);
        List subHolidayRequests = this.subHolidayRequestDao.findForList(personalId, firstDate, lastDate);
        entity.setSubHolidayRequestList(subHolidayRequests);
        List substitutes = this.substituteDao.findForTerm(personalId, firstDate, lastDate);
        entity.setSubstituteList(substitutes);
        Set workflowSet = WorkflowUtility.getWorkflowSet((Collection[])new Collection[]{attendances, overtimeRequests, holidayRequests, workOnHolidayRequests, substitutes, subHolidayRequests, workTypeChangeRequests, differenceRequests});
        Map workflows = this.workflowDao.findForInKey(workflowSet);
        entity.setWorkflowMap(workflows);
        this.doStoredLogic(new Object[]{"TotalTimeEntRefDetectAddons", personalId, firstDate, lastDate, workflows});
        return entity;
    }

    protected Map<Date, String> getSubstitutedMap(TotalTimeEntityInterface entity) throws MospException {
        HashMap<Date, String> substitutedMap = new HashMap<Date, String>();
        for (Date targetDate : entity.getTargetDateList()) {
            substitutedMap.put(targetDate, "");
        }
        String personalId = entity.getPersonalId();
        for (WorkOnHolidayRequestDtoInterface dto : entity.getWorkOnHolidayRequestList()) {
            if (!WorkflowUtility.isCompleted((WorkflowDtoInterface)entity.getWorkflowDto(dto.getWorkflow()))) continue;
            Date requestDate = dto.getRequestDate();
            int substitute = dto.getSubstitute();
            String workOnHolidayType = dto.getWorkOnHolidayType();
            if (substitute == 2) {
                if (workOnHolidayType.equals("legal_holiday")) {
                    substitutedMap.put(requestDate, "work_on_legal");
                }
                if (!workOnHolidayType.equals("prescribed_holiday")) continue;
                substitutedMap.put(requestDate, "work_on_prescribed");
                continue;
            }
            if (substitute == 5) {
                substitutedMap.put(requestDate, dto.getWorkTypeCode());
                continue;
            }
            for (SubstituteDtoInterface substituteDto : entity.getSubstitubeList()) {
                Date substituteDate;
                ScheduleDateDtoInterface scheduleDateDto;
                if (substituteDto.getWorkDate().compareTo(requestDate) != 0 || (scheduleDateDto = this.scheduleUtil.getScheduleDate(personalId, substituteDate = substituteDto.getSubstituteDate())) == null) continue;
                substitutedMap.put(requestDate, scheduleDateDto.getWorkTypeCode());
            }
        }
        return substitutedMap;
    }

    protected Map<String, List<WorkTypeEntityInterface>> getWorkTypeEntityMap(TotalTimeEntityInterface entity) throws MospException {
        String workTypeCode;
        HashMap<String, List<WorkTypeEntityInterface>> map = new HashMap<String, List<WorkTypeEntityInterface>>();
        for (String workTypeCode2 : entity.getScheduleMap().values()) {
            map.put(workTypeCode2, this.timeMaster.getWorkTypeEntityHistory(workTypeCode2));
        }
        for (String workTypeCode2 : entity.getSubstitutedMap().values()) {
            map.put(workTypeCode2, this.timeMaster.getWorkTypeEntityHistory(workTypeCode2));
        }
        for (WorkOnHolidayRequestDtoInterface dto : entity.getWorkOnHolidayRequestList()) {
            if (dto.getSubstitute() != 5) continue;
            workTypeCode = dto.getWorkTypeCode();
            map.put(workTypeCode, this.timeMaster.getWorkTypeEntityHistory(workTypeCode));
        }
        for (WorkOnHolidayRequestDtoInterface dto : entity.getWorkTypeChangeRequestList()) {
            workTypeCode = dto.getWorkTypeCode();
            map.put(workTypeCode, this.timeMaster.getWorkTypeEntityHistory(workTypeCode));
        }
        return map;
    }

    public void setTimeMasterBean(TimeMasterBeanInterface timeMaster) {
        this.timeMaster = timeMaster;
        this.scheduleUtil.setTimeMaster(timeMaster);
    }

    public void setPlatformMasterBean(PlatformMasterBeanInterface platformMaster) {
        this.platformMaster = platformMaster;
    }
}

