/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.time.bean.TotalTimeEmployeeTransactionReferenceBeanInterface;
import jp.mosp.time.dao.settings.TotalTimeEmployeeDaoInterface;
import jp.mosp.time.dto.settings.TotalTimeEmployeeDtoInterface;

public class TotalTimeEmployeeTransactionReferenceBean
extends PlatformBean
implements TotalTimeEmployeeTransactionReferenceBeanInterface {
    protected TotalTimeEmployeeDaoInterface dao;
    protected Map<Date, Map<String, TotalTimeEmployeeDtoInterface>> dtos;

    public void initBean() throws MospException {
        this.dao = (TotalTimeEmployeeDaoInterface)this.createDaoInstance(TotalTimeEmployeeDaoInterface.class);
    }

    public TotalTimeEmployeeDtoInterface findForKey(String personalId, int calculationYear, int calculationMonth) throws MospException {
        return this.dao.findForKey(personalId, calculationYear, calculationMonth);
    }

    public TotalTimeEmployeeDtoInterface getTotalTimeEmployee(String personalId, Date month) throws MospException {
        Map map;
        if (this.dtos == null) {
            this.dtos = new TreeMap();
        }
        if ((map = (Map)this.dtos.get(month)) == null) {
            int calculationYear = DateUtility.getYear((Date)month);
            int calculationMonth = DateUtility.getMonth((Date)month);
            List list = this.dao.findForMonth(calculationYear, calculationMonth);
            map = PlatformUtility.getPersonalIdDtoMap((Collection)list);
            this.dtos.put(month, map);
        }
        return (TotalTimeEmployeeDtoInterface)map.get(personalId);
    }

    public Integer getCutoffState(String personalId, int calculationYear, int calculationMonth) throws MospException {
        TotalTimeEmployeeDtoInterface dto = this.dao.findForKey(personalId, calculationYear, calculationMonth);
        if (dto != null) {
            return dto.getCutoffState();
        }
        return null;
    }

    public boolean getCutoffTermState(String personalId, Date startDate, Date endDate) throws MospException {
        List list = this.dao.findPersonTerm(personalId, startDate, endDate);
        return !list.isEmpty();
    }

    public List<TotalTimeEmployeeDtoInterface> isCutoffTermState(String cutoffCode, Date startDate, Date endDate) throws MospException {
        return this.dao.findCalcDataTerm(cutoffCode, startDate, endDate);
    }

    public TotalTimeEmployeeDtoInterface findForPersonalList(String personalId, int cutoffState) throws MospException {
        List personalList = this.dao.findForPersonalList(personalId, cutoffState);
        if (personalList.isEmpty()) {
            return null;
        }
        return (TotalTimeEmployeeDtoInterface)personalList.get(personalList.size() - 1);
    }
}

