/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.TotalOtherVacationRegistBeanInterface;
import jp.mosp.time.dao.settings.TotalOtherVacationDaoInterface;
import jp.mosp.time.dto.settings.TotalOtherVacationDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdTotalOtherVacationDto;

public class TotalOtherVacationRegistBean
extends PlatformBean
implements TotalOtherVacationRegistBeanInterface {
    protected TotalOtherVacationDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (TotalOtherVacationDaoInterface)this.createDaoInstance(TotalOtherVacationDaoInterface.class);
    }

    public TotalOtherVacationDtoInterface getInitDto() {
        return new TmdTotalOtherVacationDto();
    }

    public void insert(TotalOtherVacationDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdTotalOtherVacationId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(TotalOtherVacationDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdTotalOtherVacationId());
        dto.setTmdTotalOtherVacationId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void regist(TotalOtherVacationDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getPersonalId(), dto.getCalculationYear(), dto.getCalculationMonth(), dto.getHolidayCode()) == null) {
            this.insert(dto);
        } else {
            this.update(dto);
        }
    }

    public void delete(String personalId, int calculationYear, int calculationMonth) throws MospException {
        List list = this.dao.findForList(personalId, calculationYear, calculationMonth);
        for (TotalOtherVacationDtoInterface dto : list) {
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkDelete(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdTotalOtherVacationId());
        }
    }

    public void delete(List<String> personalIdList, int calculationYear, int calculationMonth) throws MospException {
        for (String personalId : personalIdList) {
            this.delete(personalId, calculationYear, calculationMonth);
            if (!this.mospParams.hasErrorMessage()) continue;
            return;
        }
    }

    protected void checkInsert(TotalOtherVacationDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKey(dto.getPersonalId(), dto.getCalculationYear(), dto.getCalculationMonth(), dto.getHolidayCode()));
    }

    protected void checkUpdate(TotalOtherVacationDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdTotalOtherVacationId());
    }

    protected void checkDelete(TotalOtherVacationDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdTotalOtherVacationId());
    }

    protected void validate(TotalOtherVacationDtoInterface dto) {
    }
}

