/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.TotalLeaveRegistBeanInterface;
import jp.mosp.time.dao.settings.TotalLeaveDaoInterface;
import jp.mosp.time.dto.settings.TotalLeaveDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdTotalLeaveDto;

public class TotalLeaveRegistBean
extends PlatformBean
implements TotalLeaveRegistBeanInterface {
    protected TotalLeaveDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (TotalLeaveDaoInterface)this.createDaoInstance(TotalLeaveDaoInterface.class);
    }

    public TotalLeaveDtoInterface getInitDto() {
        return new TmdTotalLeaveDto();
    }

    public void insert(TotalLeaveDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdTotalLeaveId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(TotalLeaveDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdTotalLeaveId());
        dto.setTmdTotalLeaveId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void regist(TotalLeaveDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getPersonalId(), dto.getCalculationYear(), dto.getCalculationMonth(), dto.getHolidayCode()) == null) {
            this.insert(dto);
        } else {
            this.update(dto);
        }
    }

    public void delete(String personalId, int calculationYear, int calculationMonth) throws MospException {
        List list = this.dao.findForList(personalId, calculationYear, calculationMonth);
        for (TotalLeaveDtoInterface dto : list) {
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkDelete(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdTotalLeaveId());
        }
    }

    public void delete(List<String> personalIdList, int calculationYear, int calculationMonth) throws MospException {
        for (String personalId : personalIdList) {
            List list = this.dao.findForList(personalId, calculationYear, calculationMonth);
            for (TotalLeaveDtoInterface dto : list) {
                this.validate(dto);
                if (this.mospParams.hasErrorMessage()) {
                    return;
                }
                this.checkDelete(dto);
                if (this.mospParams.hasErrorMessage()) {
                    return;
                }
                this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdTotalLeaveId());
            }
        }
    }

    protected void checkInsert(TotalLeaveDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKey(dto.getPersonalId(), dto.getCalculationYear(), dto.getCalculationMonth(), dto.getHolidayCode()));
    }

    protected void checkUpdate(TotalLeaveDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdTotalLeaveId());
    }

    protected void checkDelete(TotalLeaveDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdTotalLeaveId());
    }

    protected void validate(TotalLeaveDtoInterface dto) {
    }
}

