/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.TimeRecordBeanInterface;
import jp.mosp.time.bean.TimeRecordReferenceBeanInterface;
import jp.mosp.time.bean.TimeRecordRegistBeanInterface;
import jp.mosp.time.bean.impl.AttendanceListRegistBean;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.GoOutDtoInterface;
import jp.mosp.time.dto.settings.RestDtoInterface;
import jp.mosp.time.dto.settings.TimeRecordDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.entity.RequestEntityInterface;
import jp.mosp.time.entity.TimeSettingEntityInterface;
import jp.mosp.time.entity.WorkTypeEntityInterface;
import jp.mosp.time.utils.AttendanceUtility;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeUtility;

public class TimeRecordBean
extends AttendanceListRegistBean
implements TimeRecordBeanInterface {
    protected static final int MAX_REST_TIMES = 6;
    protected static final int MAX_GO_OUT_TIMES = 2;
    public static final String TYPE_RS_END_WORK_APPLI_STATUS = "rs_end_work_application_status";
    public static final int TYPE_RECORD_APPLY = 1;
    public static final int TYPE_RECORD_DRAFT = 2;
    protected TimeRecordReferenceBeanInterface timeRecordReference;
    protected TimeRecordRegistBeanInterface timeRecordRegist;
    protected RequestUtilBeanInterface requestUtil;

    public void initBean() throws MospException {
        super.initBean();
        this.timeRecordReference = (TimeRecordReferenceBeanInterface)this.createBeanInstance(TimeRecordReferenceBeanInterface.class);
        this.timeRecordRegist = (TimeRecordRegistBeanInterface)this.createBeanInstance(TimeRecordRegistBeanInterface.class);
        this.requestUtil = (RequestUtilBeanInterface)this.createBeanInstance(RequestUtilBeanInterface.class);
        this.requestUtil.setTimeMaster(this.timeMaster);
    }

    public Date recordStartWork(String personalId, Date recordTime) throws MospException {
        this.doStoredLogic(new Object[]{"BeforeRecordTimeAddons", personalId, recordTime});
        this.personalId = personalId;
        this.targetDate = this.getTargetDate(recordTime);
        this.recordPortalTime(personalId, this.targetDate, recordTime, "StartWork");
        AttendanceDtoInterface dto = this.attendanceReference.findForKey(this.personalId, this.targetDate);
        if (dto != null) {
            this.mospParams.addErrorMessage("TMW0301", new String[]{DateUtility.getStringDate((Date)this.targetDate), this.mospParams.getName("WorkManage"), this.mospParams.getName("RecordTime")});
            return null;
        }
        ApplicationEntity application = this.applicationReference.getApplicationEntity(personalId, this.targetDate);
        RequestEntityInterface request = this.requestUtil.getRequestEntity(personalId, this.targetDate);
        String workTypeCode = request.getWorkType();
        WorkTypeEntityInterface workType = this.workTypeReference.getWorkTypeEntity(workTypeCode, this.targetDate);
        if (!workType.isWorkTypeForWork()) {
            this.addNotWorkDateErrorMessage(this.targetDate);
            return null;
        }
        Date startTime = AttendanceUtility.getStartTimeForTimeRecord((ApplicationEntity)application, (RequestEntityInterface)request, (WorkTypeEntityInterface)workType, (Date)recordTime);
        dto = this.getAttendanceDto(startTime, startTime, null, false, false, false, false, false);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.setDirectStartEnd(dto, workType);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.attendanceRegist.checkTimeExist(dto);
        this.attendanceRegist.checkValidate(dto);
        this.attendanceRegist.checkDraft(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.draft(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        List restList = this.registRest(startTime, workType.getEndTime(request));
        for (RestDtoInterface restDto : restList) {
            this.restRegist.regist(restDto);
        }
        this.attendanceRegist.regist(dto);
        this.doAdditionalLogic(new Object[]{"PortalAttedanceCardAddons", "Add_Portal_Attedance_Regist_registAddonTable", this.targetDate});
        return recordTime;
    }

    public Date recordEndWork(String personalId, Date recordTime) throws MospException {
        this.doStoredLogic(new Object[]{"BeforeRecordTimeAddons", personalId, recordTime});
        this.personalId = personalId;
        AttendanceDtoInterface dto = this.setTargetDate(recordTime, TimeMessageUtility.getNameEndWork((MospParams)this.mospParams));
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.recordPortalTime(personalId, this.targetDate, recordTime, "EndWork");
        this.checkRestEnd();
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        ApplicationEntity applicationEntity = this.applicationReference.getApplicationEntity(personalId, this.targetDate);
        TimeSettingEntityInterface timeSetting = this.timeSettingReference.getEntity(applicationEntity.getTimeSettingDto());
        int endWorkAppliStatus = timeSetting.getLimit(TYPE_RS_END_WORK_APPLI_STATUS, 1);
        if (endWorkAppliStatus == 1) {
            this.apply(dto);
        }
        if (endWorkAppliStatus == 2) {
            this.draft(dto);
        }
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        RequestEntityInterface requestEntity = this.requestUtil.getRequestEntity(personalId, this.targetDate);
        WorkTypeEntityInterface workTypeEntity = this.workTypeReference.getWorkTypeEntity(dto.getWorkTypeCode(), this.targetDate);
        Date endTime = this.getEndTime(applicationEntity, requestEntity, workTypeEntity, recordTime);
        dto = this.getAttendanceDto(dto.getStartTime(), dto.getActualStartTime(), endTime, false, true, false, false, false);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.setDirectStartEnd(dto, workTypeEntity);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.attendanceRegist.checkTimeExist(dto);
        this.attendanceRegist.checkValidate(dto);
        this.attendanceRegist.checkAppli(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.checkRestTime(dto, personalId, recordTime, this.targetDate);
        this.attendanceRegist.regist(dto);
        this.attendanceTransactionRegist.regist(dto);
        this.registSubHoliday(dto);
        if (endWorkAppliStatus == 1) {
            this.afterApplyAttendance(dto);
        }
        this.doAdditionalLogic(new Object[]{"PortalAttedanceCardAddons", "Add_Portal_Attedance_Regist_registAddonTable", this.targetDate});
        return recordTime;
    }

    protected Date getEndTime(ApplicationEntity applicationEntity, RequestEntityInterface requestEntity, WorkTypeEntityInterface workTypeEntity, Date recordTime) throws MospException {
        Date scheduledTime = workTypeEntity.getEndTime(requestEntity);
        TimeSettingDtoInterface timeSettingDto = applicationEntity.getTimeSettingDto();
        if (workTypeEntity.isDirectEnd()) {
            return scheduledTime;
        }
        if (recordTime.before(scheduledTime)) {
            if (applicationEntity.useScheduledTime()) {
                return AttendanceUtility.getRoundedEndTimeForTimeRecord((Date)recordTime, (TimeSettingDtoInterface)timeSettingDto);
            }
            return AttendanceUtility.getRoundedActualEndTimeForTimeRecord((Date)recordTime, (TimeSettingDtoInterface)timeSettingDto);
        }
        if (applicationEntity.useScheduledTime()) {
            return AttendanceUtility.getRoundedEndTimeForTimeRecord((Date)recordTime, (TimeSettingDtoInterface)timeSettingDto);
        }
        return AttendanceUtility.getRoundedActualEndTimeForTimeRecord((Date)recordTime, (TimeSettingDtoInterface)timeSettingDto);
    }

    public Date recordStartRest(String personalId, Date recordTime) throws MospException {
        this.doStoredLogic(new Object[]{"BeforeRecordTimeAddons", personalId, recordTime});
        this.personalId = personalId;
        String recordName = TimeNamingUtility.startRest((MospParams)this.mospParams);
        this.setTargetDate(recordTime, recordName);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        List rests = this.restDao.findForList(this.personalId, this.targetDate, 1);
        List publics = this.goOutReference.getPublicGoOutList(personalId, this.targetDate);
        List privates = this.goOutReference.getPrivateGoOutList(personalId, this.targetDate);
        this.checkRestDuplicate(recordTime, rests, recordName);
        this.checkGoOutDuplicate(recordTime, publics, recordName, TimeNamingUtility.getPublicGoOut((MospParams)this.mospParams));
        this.checkGoOutDuplicate(recordTime, privates, recordName, TimeNamingUtility.getPrivateGoOut((MospParams)this.mospParams));
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        RestDtoInterface dto = null;
        for (RestDtoInterface rest : rests) {
            Date startTime = rest.getRestStart();
            Date endTime = rest.getRestEnd();
            if (DateUtility.isSame((Date)startTime, (Date)this.targetDate) && DateUtility.isSame((Date)endTime, (Date)this.targetDate)) {
                dto = rest;
                break;
            }
            if (!DateUtility.isSame((Date)endTime, (Date)this.targetDate)) continue;
            TimeMessageUtility.addErrorStartRestAlreadyRecorded((MospParams)this.mospParams, (Date)this.targetDate);
            return null;
        }
        if (MospUtility.isEmpty((Object[])new Object[]{dto}) && 6 <= rests.size()) {
            TimeMessageUtility.addErrorRestOverLimit((MospParams)this.mospParams, (Date)this.targetDate);
            return null;
        }
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            dto = this.restRegist.getInitDto();
            dto.setPersonalId(this.personalId);
            dto.setWorkDate(this.targetDate);
            dto.setTimesWork(1);
            dto.setRest(rests.size() + 1);
            dto.setRestEnd(this.targetDate);
            dto.setRestTime(0);
        }
        ApplicationEntity application = this.timeMaster.getApplicationEntity(personalId, this.targetDate);
        TimeSettingDtoInterface timeSettingDto = application.getTimeSettingDto();
        dto.setRestStart(AttendanceUtility.getRoundedRestStartTimeForTimeRecord((Date)recordTime, (TimeSettingDtoInterface)timeSettingDto));
        this.restRegist.regist(dto);
        this.doAdditionalLogic(new Object[]{"PortalAttedanceCardAddons", "Add_Portal_Attedance_Regist_registAddonTable", this.targetDate});
        return recordTime;
    }

    public Date recordEndRest(String personalId, Date recordTime) throws MospException {
        this.doStoredLogic(new Object[]{"BeforeRecordTimeAddons", personalId, recordTime});
        this.personalId = personalId;
        String recordName = TimeNamingUtility.endRest((MospParams)this.mospParams);
        this.setTargetDate(recordTime, recordName);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        List rests = this.restDao.findForList(this.personalId, this.targetDate, 1);
        List publics = this.goOutReference.getPublicGoOutList(personalId, this.targetDate);
        List privates = this.goOutReference.getPrivateGoOutList(personalId, this.targetDate);
        this.checkRestDuplicate(recordTime, rests, recordName);
        this.checkGoOutDuplicate(recordTime, publics, recordName, TimeNamingUtility.getPublicGoOut((MospParams)this.mospParams));
        this.checkGoOutDuplicate(recordTime, privates, recordName, TimeNamingUtility.getPrivateGoOut((MospParams)this.mospParams));
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        RestDtoInterface dto = null;
        for (RestDtoInterface rest : rests) {
            Date startTime = rest.getRestStart();
            Date endTime = rest.getRestEnd();
            if (DateUtility.isSame((Date)startTime, (Date)this.targetDate) || !DateUtility.isSame((Date)endTime, (Date)this.targetDate)) continue;
            ApplicationEntity application = this.timeMaster.getApplicationEntity(personalId, this.targetDate);
            TimeSettingDtoInterface timeSettingDto = application.getTimeSettingDto();
            dto = rest;
            dto.setRestEnd(AttendanceUtility.getRoundedRestEndTimeForTimeRecord((Date)recordTime, (TimeSettingDtoInterface)timeSettingDto));
            dto.setRestTime(this.restRegist.getCalcRestTime(startTime, endTime, timeSettingDto));
            break;
        }
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            TimeMessageUtility.addErrorStartRestNotRecorded((MospParams)this.mospParams, (Date)this.targetDate);
            return null;
        }
        this.restRegist.regist(dto);
        return recordTime;
    }

    public Date recordStartPrivate(String personalId, Date recordTime) throws MospException {
        this.doStoredLogic(new Object[]{"BeforeRecordTimeAddons", personalId, recordTime});
        this.personalId = personalId;
        String recordName = TimeNamingUtility.startPrivateGoOut((MospParams)this.mospParams);
        this.setTargetDate(recordTime, recordName);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        List rests = this.restDao.findForList(this.personalId, this.targetDate, 1);
        List publics = this.goOutReference.getPublicGoOutList(personalId, this.targetDate);
        List privates = this.goOutReference.getPrivateGoOutList(personalId, this.targetDate);
        this.checkRestDuplicate(recordTime, rests, recordName);
        this.checkGoOutDuplicate(recordTime, publics, recordName, TimeNamingUtility.getPublicGoOut((MospParams)this.mospParams));
        this.checkGoOutDuplicate(recordTime, privates, recordName, TimeNamingUtility.getPrivateGoOut((MospParams)this.mospParams));
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        GoOutDtoInterface dto = null;
        for (GoOutDtoInterface goOut : privates) {
            Date startTime = goOut.getGoOutStart();
            Date endTime = goOut.getGoOutEnd();
            if (DateUtility.isSame((Date)startTime, (Date)this.targetDate) && DateUtility.isSame((Date)endTime, (Date)this.targetDate)) {
                dto = goOut;
                break;
            }
            if (!DateUtility.isSame((Date)endTime, (Date)this.targetDate)) continue;
            TimeMessageUtility.addErrorStartPrivateAlreadyRecorded((MospParams)this.mospParams, (Date)this.targetDate);
            return null;
        }
        if (MospUtility.isEmpty((Object[])new Object[]{dto}) && 2 <= privates.size()) {
            TimeMessageUtility.addErrorPrivateOverLimit((MospParams)this.mospParams, (Date)this.targetDate);
            return null;
        }
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            dto = this.goOutRegist.getInitDto();
            dto.setPersonalId(this.personalId);
            dto.setWorkDate(this.targetDate);
            dto.setTimesWork(1);
            dto.setGoOutType(2);
            dto.setTimesGoOut(privates.size() + 1);
            dto.setGoOutEnd(this.targetDate);
            dto.setGoOutTime(0);
        }
        ApplicationEntity application = this.timeMaster.getApplicationEntity(personalId, this.targetDate);
        TimeSettingDtoInterface timeSettingDto = application.getTimeSettingDto();
        dto.setGoOutStart(AttendanceUtility.getRoundedPrivateStartTimeForTimeRecord((Date)recordTime, (TimeSettingDtoInterface)timeSettingDto));
        this.goOutRegist.regist(dto);
        return recordTime;
    }

    public Date recordEndPrivate(String personalId, Date recordTime) throws MospException {
        this.doStoredLogic(new Object[]{"BeforeRecordTimeAddons", personalId, recordTime});
        this.personalId = personalId;
        String recordName = TimeNamingUtility.endRest((MospParams)this.mospParams);
        this.setTargetDate(recordTime, recordName);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        List rests = this.restDao.findForList(this.personalId, this.targetDate, 1);
        List publics = this.goOutReference.getPublicGoOutList(personalId, this.targetDate);
        List privates = this.goOutReference.getPrivateGoOutList(personalId, this.targetDate);
        this.checkRestDuplicate(recordTime, rests, recordName);
        this.checkGoOutDuplicate(recordTime, publics, recordName, TimeNamingUtility.getPublicGoOut((MospParams)this.mospParams));
        this.checkGoOutDuplicate(recordTime, privates, recordName, TimeNamingUtility.getPrivateGoOut((MospParams)this.mospParams));
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        GoOutDtoInterface dto = null;
        for (GoOutDtoInterface goOut : privates) {
            Date startTime = goOut.getGoOutStart();
            Date endTime = goOut.getGoOutEnd();
            if (DateUtility.isSame((Date)startTime, (Date)this.targetDate) || !DateUtility.isSame((Date)endTime, (Date)this.targetDate)) continue;
            ApplicationEntity application = this.timeMaster.getApplicationEntity(personalId, this.targetDate);
            TimeSettingDtoInterface timeSettingDto = application.getTimeSettingDto();
            dto = goOut;
            dto.setGoOutEnd(AttendanceUtility.getRoundedPrivateEndTimeForTimeRecord((Date)recordTime, (TimeSettingDtoInterface)timeSettingDto));
            dto.setGoOutTime(this.goOutRegist.getCalcPrivateGoOutTime(startTime, endTime, timeSettingDto));
            break;
        }
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            TimeMessageUtility.addErrorStartPrivateNotRecorded((MospParams)this.mospParams, (Date)this.targetDate);
            return null;
        }
        this.goOutRegist.regist(dto);
        return recordTime;
    }

    public Date recordRegularEnd(String personalId, Date recordTime) throws MospException {
        WorkTypeEntityInterface workTypeEntity;
        this.doStoredLogic(new Object[]{"BeforeRecordTimeAddons", personalId, recordTime});
        this.personalId = personalId;
        AttendanceDtoInterface dto = this.setTargetDate(recordTime, TimeMessageUtility.getNameRegularEnd((MospParams)this.mospParams));
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.recordPortalTime(personalId, this.targetDate, recordTime, "EndWork");
        this.checkRestEnd();
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.applyAndApprove(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        RequestEntityInterface requestEntity = this.requestUtil.getRequestEntity(personalId, this.targetDate);
        if (this.isLate(requestEntity, workTypeEntity = this.workTypeReference.getWorkTypeEntity(dto.getWorkTypeCode(), this.targetDate), dto.getStartTime()) || this.isLeaveEarly(requestEntity, workTypeEntity, recordTime)) {
            ApplicationEntity applicationEntity = this.applicationReference.getApplicationEntity(personalId, this.targetDate);
            TimeSettingDtoInterface timeSettingDto = applicationEntity.getTimeSettingDto();
            Date targetTime = AttendanceUtility.getRoundedEndTimeForTimeRecord((Date)recordTime, (TimeSettingDtoInterface)timeSettingDto);
            this.setNextCommandForAttendanceCard(personalId, this.targetDate);
            this.mospParams.addGeneralParam("prmTargetTime", (Object)targetTime);
            TimeMessageUtility.addErrorSelfApproveFailed((MospParams)this.mospParams);
            return null;
        }
        Date endTime = workTypeEntity.getEndTime(requestEntity);
        if (requestEntity.getWorkOnHolidayStartTime(false) != null) {
            ApplicationEntity applicationEntity = this.applicationReference.getApplicationEntity(personalId, this.targetDate);
            endTime = this.getEndTime(applicationEntity, requestEntity, workTypeEntity, recordTime);
        }
        dto = this.getAttendanceDto(dto.getStartTime(), dto.getActualStartTime(), endTime, false, true, false, false, false);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.setDirectStartEnd(dto, workTypeEntity);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.attendanceRegist.checkTimeExist(dto);
        this.attendanceRegist.checkValidate(dto);
        this.attendanceRegist.checkAppli(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.checkRestTime(dto, personalId, recordTime, this.targetDate);
        this.attendanceRegist.regist(dto);
        this.attendanceTransactionRegist.regist(dto);
        this.registSubHoliday(dto);
        this.afterApplyAttendance(dto);
        this.doAdditionalLogic(new Object[]{"PortalAttedanceCardAddons", "Add_Portal_Attedance_Regist_registAddonTable", this.targetDate});
        return recordTime;
    }

    protected boolean isLate(RequestEntityInterface requestEntity, WorkTypeEntityInterface workTypeEntity, Date startTime) throws MospException {
        Date short1EndTime;
        if (MospUtility.isEmpty((Object[])new Object[]{startTime})) {
            return false;
        }
        Date scheduledStartTime = workTypeEntity.getStartTime(requestEntity);
        boolean isLate = scheduledStartTime.before(startTime);
        if (requestEntity.isAttendanceDirectStart()) {
            isLate = false;
        }
        if (workTypeEntity.isDirectStart()) {
            isLate = false;
        }
        if (requestEntity.getWorkOnHolidayStartTime(false) != null) {
            isLate = false;
        }
        if (workTypeEntity.isShort1TimeSet() && workTypeEntity.isShort1TypePay() && !startTime.after(short1EndTime = TimeUtility.getDateTime((Date)this.targetDate, (Date)workTypeEntity.getShort1EndTime()))) {
            isLate = false;
        }
        return isLate;
    }

    protected boolean isLeaveEarly(RequestEntityInterface requestEntity, WorkTypeEntityInterface workTypeEntity, Date endTime) throws MospException {
        Date short2StartTime;
        Date scheduledEndTime = workTypeEntity.getEndTime(requestEntity);
        boolean isLeaveEarly = scheduledEndTime.after(endTime);
        if (requestEntity.isAttendanceDirectEnd()) {
            isLeaveEarly = false;
        }
        if (workTypeEntity.isDirectEnd()) {
            isLeaveEarly = false;
        }
        if (requestEntity.getWorkOnHolidayStartTime(false) != null) {
            isLeaveEarly = false;
        }
        if (workTypeEntity.isShort2TimeSet() && workTypeEntity.isShort2TypePay() && !endTime.before(short2StartTime = TimeUtility.getDateTime((Date)this.targetDate, (Date)workTypeEntity.getShort2StartTime()))) {
            isLeaveEarly = false;
        }
        return isLeaveEarly;
    }

    public void recordOverEnd(String personalId, Date recordTime) throws MospException {
        this.doStoredLogic(new Object[]{"BeforeRecordTimeAddons", personalId, recordTime});
        this.personalId = personalId;
        AttendanceDtoInterface dto = this.setTargetDate(recordTime, TimeMessageUtility.getNameOverEnd((MospParams)this.mospParams));
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.recordPortalTime(personalId, this.targetDate, recordTime, "EndWork");
        ApplicationEntity applicationEntity = this.applicationReference.getApplicationEntity(personalId, this.targetDate);
        TimeSettingDtoInterface timeSettingDto = applicationEntity.getTimeSettingDto();
        Date targetTime = AttendanceUtility.getRoundedEndTimeForTimeRecord((Date)recordTime, (TimeSettingDtoInterface)timeSettingDto);
        this.setNextCommandForAttendanceCard(personalId, this.targetDate);
        this.mospParams.addGeneralParam("prmTargetTime", (Object)targetTime);
        if (dto != null && dto.getWorkTypeCode() != null) {
            String workTypeCode = dto.getWorkTypeCode();
            WorkTypeEntityInterface workTypeEntity = this.workTypeReference.getWorkTypeEntity(workTypeCode, this.targetDate);
            if (workTypeEntity.isDirectStart()) {
                this.mospParams.addGeneralParam("transferredDirectStart", (Object)"1");
            }
            if (workTypeEntity.isDirectEnd()) {
                this.mospParams.addGeneralParam("transferredDirectEnd", (Object)"1");
            }
        }
        this.doAdditionalLogic(new Object[]{"PortalAttedanceCardAddons", "Add_Portal_Attedance_Regist_registAddonTable", this.targetDate});
    }

    public Date recordRegularWork(String personalId, Date recordTime) throws MospException {
        this.doStoredLogic(new Object[]{"BeforeRecordTimeAddons", personalId, recordTime});
        this.personalId = personalId;
        this.targetDate = this.getTargetDate(recordTime);
        this.recordPortalTime(personalId, this.targetDate, recordTime, "StartWork");
        AttendanceDtoInterface dto = this.attendanceReference.findForKey(this.personalId, this.targetDate);
        if (dto != null) {
            TimeMessageUtility.addErrorStartWorkAlreadyRecorded((MospParams)this.mospParams, (Date)this.targetDate);
            return null;
        }
        RequestEntityInterface requestEntity = this.requestUtil.getRequestEntity(personalId, this.targetDate);
        String workTypeCode = requestEntity.getWorkType();
        WorkTypeEntityInterface workTypeEntity = this.workTypeReference.getWorkTypeEntity(workTypeCode, this.targetDate);
        if (!workTypeEntity.isWorkTypeForWork()) {
            this.addNotWorkDateErrorMessage(this.targetDate);
            return null;
        }
        Date startTime = workTypeEntity.getStartTime(requestEntity);
        Date endTime = workTypeEntity.getEndTime(requestEntity);
        dto = this.getAttendanceDto(startTime, startTime, endTime, false, true, false, false, false);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.setDirectStartEnd(dto, workTypeEntity);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.attendanceRegist.checkTimeExist(dto);
        this.attendanceRegist.checkValidate(dto);
        this.attendanceRegist.checkAppli(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        this.applyAndApprove(dto);
        if (this.mospParams.hasErrorMessage()) {
            return null;
        }
        List restList = this.registRest(startTime, endTime);
        for (RestDtoInterface restDto : restList) {
            this.restRegist.regist(restDto);
        }
        this.checkRestTime(dto, personalId, recordTime, this.targetDate);
        this.attendanceRegist.regist(dto);
        this.attendanceTransactionRegist.regist(dto);
        this.registSubHoliday(dto);
        this.doAdditionalLogic(new Object[]{"PortalAttedanceCardAddons", "Add_Portal_Attedance_Regist_registAddonTable", this.targetDate});
        return recordTime;
    }

    public Date recordStartWork() throws MospException {
        return this.recordStartWork(this.mospParams.getUser().getPersonalId(), this.getSystemTimeAndSecond());
    }

    public Date recordEndWork() throws MospException {
        return this.recordEndWork(this.mospParams.getUser().getPersonalId(), this.getSystemTimeAndSecond());
    }

    public Date recordStartRest() throws MospException {
        return this.recordStartRest(this.mospParams.getUser().getPersonalId(), this.getSystemTimeAndSecond());
    }

    public Date recordEndRest() throws MospException {
        return this.recordEndRest(this.mospParams.getUser().getPersonalId(), this.getSystemTimeAndSecond());
    }

    public Date recordRegularEnd() throws MospException {
        return this.recordRegularEnd(this.mospParams.getUser().getPersonalId(), this.getSystemTimeAndSecond());
    }

    public void recordOverEnd() throws MospException {
        this.recordOverEnd(this.mospParams.getUser().getPersonalId(), this.getSystemTimeAndSecond());
    }

    public Date recordRegularWork() throws MospException {
        return this.recordRegularWork(this.mospParams.getUser().getPersonalId(), this.getSystemTimeAndSecond());
    }

    protected AttendanceDtoInterface setTargetDate(Date recordTime, String process) throws MospException {
        AttendanceDtoInterface dto = this.attendanceReference.findForKey(this.personalId, recordTime);
        if (dto == null) {
            Date beforeDate = this.addDay(recordTime, -1);
            dto = this.attendanceReference.findForKey(this.personalId, beforeDate);
            if (dto != null && dto.getEndTime() == null) {
                this.targetDate = beforeDate;
            } else {
                TimeMessageUtility.addErrorStratWorkNotRecorded((MospParams)this.mospParams, (Date)recordTime, (String)process);
            }
        } else if (dto.getEndTime() != null) {
            TimeMessageUtility.addErrorEndWorkAlreadyRecorded((MospParams)this.mospParams, (Date)recordTime);
        } else {
            this.targetDate = DateUtility.getDate((Date)recordTime);
        }
        return dto;
    }

    protected Date getTargetDate(Date recordTime) throws MospException {
        this.targetDate = DateUtility.getDate((Date)recordTime);
        if (this.doAdditionalLogic(new Object[]{"PortalAttedanceCardAddons", "Add_Portal_Attedance_Regist_getTargetDateOnStartWork", this.targetDate, recordTime, this.personalId})) {
            this.targetDate = (Date)this.mospParams.getGeneralParam("prmTargetDate");
        }
        return this.targetDate;
    }

    protected void setDirectStartEnd(AttendanceDtoInterface dto, WorkTypeEntityInterface workTypeEntity) throws MospException {
        if (workTypeEntity.isDirectStart()) {
            dto.setDirectStart(MospUtility.getInt((Object)"1"));
        }
        if (workTypeEntity.isDirectEnd()) {
            dto.setDirectEnd(MospUtility.getInt((Object)"1"));
        }
    }

    protected void checkGoOutDuplicate(Date recordTime, List<GoOutDtoInterface> dtos, String recordName, String timeName) {
        for (GoOutDtoInterface dto : dtos) {
            Date startTime = dto.getGoOutStart();
            Date endTime = dto.getGoOutEnd();
            int times = dto.getGoOutTime();
            this.checkDuplicate(recordTime, startTime, endTime, times, recordName, timeName);
        }
    }

    protected void checkRestDuplicate(Date recordTime, List<RestDtoInterface> dtos, String recordName) {
        String timeName = TimeNamingUtility.rest((MospParams)this.mospParams);
        for (RestDtoInterface dto : dtos) {
            Date startTime = dto.getRestStart();
            Date endTime = dto.getRestEnd();
            int times = dto.getRestTime();
            this.checkDuplicate(recordTime, startTime, endTime, times, recordName, timeName);
        }
    }

    protected void checkDuplicate(Date recordTime, Date startTime, Date endTime, int times, String recordName, String timeName) {
        if (DateUtility.isSame((Date)endTime, (Date)this.targetDate)) {
            return;
        }
        if (DateUtility.isTermContain((Date)recordTime, (Date)startTime, (Date)endTime)) {
            StringBuilder sb = new StringBuilder(timeName).append(times);
            TimeMessageUtility.addErrorOverlap1((MospParams)this.mospParams, (Date)recordTime, (String)recordName, (String)sb.toString());
        }
    }

    protected void addStartRestDuplicationErrorMessage(String stringTagetDate, String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.mospParams.getName("RestTime"));
        sb.append(this.mospParams.getName("Into"));
        String[] rep = new String[]{stringTagetDate, sb.toString(), name};
        this.mospParams.addErrorMessage("TMW0312", rep);
    }

    protected void addEndRestDuplicationErrorMessage(String stringTagetDate, String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.mospParams.getName("RestTime"));
        sb.append(this.mospParams.getName("Return"));
        String[] rep = new String[]{stringTagetDate, sb.toString(), name};
        this.mospParams.addErrorMessage("TMW0312", rep);
    }

    protected void recordPortalTime(String personalId, Date workDate, Date recordTime, String recordType) throws MospException {
        if (this.timeRecordReference.findForKey(personalId, workDate, recordType) != null) {
            return;
        }
        TimeRecordDtoInterface dto = this.timeRecordRegist.getInitDto();
        dto.setPersonalId(personalId);
        dto.setWorkDate(workDate);
        dto.setTimesWork(1);
        dto.setRecordType(recordType);
        dto.setRecordTime(recordTime);
        this.timeRecordRegist.insert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.timeRecordRegist.commit();
    }

    protected void checkRestEnd() throws MospException {
        List rests = this.restDao.findForList(this.personalId, this.targetDate, 1);
        for (RestDtoInterface rest : rests) {
            if (DateUtility.isSame((Date)rest.getRestStart(), (Date)this.targetDate) || !DateUtility.isSame((Date)rest.getRestEnd(), (Date)this.targetDate)) continue;
            TimeMessageUtility.addErrorEndRestNotRecorded((MospParams)this.mospParams, (Date)this.targetDate);
            return;
        }
        List privates = this.goOutReference.getPrivateGoOutList(this.personalId, this.targetDate);
        for (GoOutDtoInterface goOut : privates) {
            if (DateUtility.isSame((Date)goOut.getGoOutStart(), (Date)this.targetDate) || !DateUtility.isSame((Date)goOut.getGoOutEnd(), (Date)this.targetDate)) continue;
            TimeMessageUtility.addErrorEndRestNotRecorded((MospParams)this.mospParams, (Date)this.targetDate);
            return;
        }
    }

    protected void applyAndApprove(AttendanceDtoInterface dto) throws MospException {
        WorkflowDtoInterface workflowDto = this.workflowRegist.getInitDto();
        if (dto.getWorkflow() != 0L) {
            workflowDto = this.workflow.getLatestWorkflowInfo(dto.getWorkflow());
        }
        workflowDto.setApproverId("SELF_APPRO");
        workflowDto.setFunctionCode("1");
        workflowDto = this.workflowRegist.appli(workflowDto, this.personalId, this.targetDate, 1, null);
        if (workflowDto == null) {
            return;
        }
        dto.setWorkflow(workflowDto.getWorkflow());
    }

    protected void checkRestTime(AttendanceDtoInterface dto, String personalId, Date recordTime, Date targetDate) throws MospException {
        if (TimeUtility.isWorkOnLegalOrPrescribedHoliday((String)dto.getWorkTypeCode()) && dto.getWorkTime() > 360 && dto.getRestTime() == 0) {
            ApplicationEntity applicationEntity = this.applicationReference.getApplicationEntity(personalId, targetDate);
            TimeSettingDtoInterface timeSettingDto = applicationEntity.getTimeSettingDto();
            Date targetTime = AttendanceUtility.getRoundedEndTimeForTimeRecord((Date)recordTime, (TimeSettingDtoInterface)timeSettingDto);
            this.setNextCommandForAttendanceCard(personalId, targetDate);
            this.mospParams.addGeneralParam("prmTargetTime", (Object)targetTime);
            TimeMessageUtility.addErrorShortRestTimeForWorkOnHoliday((MospParams)this.mospParams);
        }
    }

    protected void setNextCommandForAttendanceCard(String personalId, Date targetDate) throws MospException {
        this.mospParams.addGeneralParam("prmTargetPersonalId", (Object)personalId);
        this.mospParams.addGeneralParam("prmTargetDate", (Object)targetDate);
        this.mospParams.setNextCommand("TM1206");
    }
}

