/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.PlatformMasterBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.time.bean.CutoffReferenceBeanInterface;
import jp.mosp.time.bean.LimitStandardReferenceBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dao.settings.ApplicationDaoInterface;
import jp.mosp.time.dao.settings.HolidayDaoInterface;
import jp.mosp.time.dao.settings.PaidHolidayDaoInterface;
import jp.mosp.time.dao.settings.TimeSettingDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayDtoInterface;
import jp.mosp.time.dto.settings.LimitStandardDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.entity.CutoffEntityInterface;
import jp.mosp.time.entity.TimeSettingEntityInterface;
import jp.mosp.time.entity.WorkTypeEntityInterface;
import jp.mosp.time.utils.DifferenceUtility;
import jp.mosp.time.utils.TimeUtility;
import jp.mosp.time.utils.TotalTimeUtility;

public class TimeMasterBean
extends PlatformBean
implements TimeMasterBeanInterface {
    protected ApplicationDaoInterface applicationDao;
    protected TimeSettingDaoInterface timeSettingDao;
    protected PaidHolidayDaoInterface paidHolidayDao;
    protected HolidayDaoInterface holidayDao;
    protected CutoffReferenceBeanInterface cutoffRefer;
    protected LimitStandardReferenceBeanInterface limitStandardRefer;
    protected WorkTypeReferenceBeanInterface workTypeRefer;
    protected PlatformMasterBeanInterface platformMaster;
    protected Date applicationFromDate;
    protected Date applicationToDate;
    protected Set<Date> applicationDateSet;
    protected Map<Date, Set<ApplicationDtoInterface>> applicationPersonMap;
    protected Map<Date, Set<ApplicationDtoInterface>> applicationMasterMap;
    protected Map<Date, Set<TimeSettingDtoInterface>> timeSettingMap;
    protected Map<Date, Set<PaidHolidayDtoInterface>> paidHolidayMap;
    protected Map<Date, Set<CutoffEntityInterface>> cutoffMap;
    protected Map<String, Set<LimitStandardDtoInterface>> limitStandardMap;
    protected Map<String, List<WorkTypeEntityInterface>> workTypeMap;
    protected Map<Date, Set<HolidayDtoInterface>> holidayMap;

    public void initBean() throws MospException {
        this.applicationDao = (ApplicationDaoInterface)this.createDaoInstance(ApplicationDaoInterface.class);
        this.timeSettingDao = (TimeSettingDaoInterface)this.createDaoInstance(TimeSettingDaoInterface.class);
        this.paidHolidayDao = (PaidHolidayDaoInterface)this.createDaoInstance(PaidHolidayDaoInterface.class);
        this.holidayDao = (HolidayDaoInterface)this.createDaoInstance(HolidayDaoInterface.class);
        this.cutoffRefer = (CutoffReferenceBeanInterface)this.createBeanInstance(CutoffReferenceBeanInterface.class);
        this.limitStandardRefer = (LimitStandardReferenceBeanInterface)this.createBeanInstance(LimitStandardReferenceBeanInterface.class);
        this.workTypeRefer = (WorkTypeReferenceBeanInterface)this.createBeanInstance(WorkTypeReferenceBeanInterface.class);
        this.platformMaster = (PlatformMasterBeanInterface)this.createBeanInstance(PlatformMasterBeanInterface.class);
        this.applicationDateSet = new HashSet();
        this.applicationPersonMap = new HashMap();
        this.applicationMasterMap = new HashMap();
        this.timeSettingMap = new HashMap();
        this.paidHolidayMap = new HashMap();
        this.cutoffMap = new HashMap();
        this.limitStandardMap = new HashMap();
        this.workTypeMap = new HashMap();
        this.holidayMap = new HashMap();
    }

    public void setPlatformMaster(PlatformMasterBeanInterface platformMaster) {
        this.platformMaster = platformMaster;
    }

    public ApplicationDtoInterface getApplication(String personalId, Date targetDate) throws MospException {
        HumanDtoInterface humanDto = this.platformMaster.getHuman(personalId, targetDate);
        return this.getApplication(humanDto, targetDate);
    }

    public ApplicationDtoInterface getApplication(HumanDtoInterface humanDto, Date targetDate) throws MospException {
        Set personSet = this.getApplicationPersonSet(targetDate);
        Set masterSet = this.getApplicationMasterSet(targetDate);
        return (ApplicationDtoInterface)PlatformUtility.getApplicationMaster((HumanDtoInterface)humanDto, (Set)personSet, (Set)masterSet);
    }

    public PaidHolidayDtoInterface getPaidHoliday(HumanDtoInterface humanDto, Date targetDate) throws MospException {
        ApplicationDtoInterface application = this.getApplication(humanDto, targetDate);
        if (application == null) {
            return null;
        }
        return this.getPaidHoliday(application.getPaidHolidayCode(), targetDate);
    }

    public Map<Date, ApplicationDtoInterface> getApplicationMap(String personalId, Date firstDate, Date lastDate) throws MospException {
        HashMap<Date, ApplicationDtoInterface> map = new HashMap<Date, ApplicationDtoInterface>();
        List humanList = this.platformMaster.getHumanHistory(personalId);
        Set activateDateSet = this.getApplicationDateSet(firstDate, lastDate);
        for (HumanDtoInterface humanDto : humanList) {
            activateDateSet.add(humanDto.getActivateDate());
        }
        activateDateSet.add(firstDate);
        ApplicationDtoInterface applicationDto = null;
        for (Date targetDate : TimeUtility.getDateList((Date)firstDate, (Date)lastDate)) {
            HumanDtoInterface humanDto;
            if (activateDateSet.contains(targetDate) && (humanDto = (HumanDtoInterface)PlatformUtility.getLatestDto((List)humanList, (Date)targetDate)) != null) {
                applicationDto = this.getApplication(humanDto, targetDate);
            }
            map.put(targetDate, applicationDto);
        }
        return map;
    }

    public ApplicationEntity getApplicationEntity(HumanDtoInterface humanDto, int targetYear, int targetMonth) throws MospException {
        Date targetDate = MonthUtility.getYearMonthTargetDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
        return this.getApplicationEntity(humanDto, targetDate);
    }

    public ApplicationEntity getApplicationEntity(HumanDtoInterface humanDto, Date targetDate) throws MospException {
        ApplicationDtoInterface applicationDto = this.getApplication(humanDto, targetDate);
        ApplicationEntity applicationEntity = new ApplicationEntity(applicationDto);
        applicationEntity.setTargetDate(targetDate);
        if (MospUtility.isEmpty((Object[])new Object[]{applicationDto})) {
            applicationEntity.setCutoffEntity(TimeUtility.getBareCutoffEntity((MospParams)this.mospParams));
            return applicationEntity;
        }
        String workSettingCode = applicationEntity.getWorkSettingCode();
        applicationEntity.setTimeSettingDto(this.getTimeSetting(workSettingCode, targetDate));
        String cutoffCode = applicationEntity.getCutoffCode();
        applicationEntity.setCutoffEntity(this.getCutoff(cutoffCode, targetDate));
        String paidHolidayCode = applicationEntity.getPaidHolidayCode();
        applicationEntity.setPaidHolidayDto(this.getPaidHoliday(paidHolidayCode, targetDate));
        return applicationEntity;
    }

    public ApplicationEntity getApplicationEntity(String personalId, Date targetDate) throws MospException {
        return this.getApplicationEntity(this.platformMaster.getHuman(personalId, targetDate), targetDate);
    }

    public ApplicationEntity getApplicationEntity(String personalId, int targetYear, int targetMonth) throws MospException {
        Date targetDate = MonthUtility.getYearMonthTargetDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
        return this.getApplicationEntity(personalId, targetDate);
    }

    public Map<Date, TimeSettingDtoInterface> getTimeSettingMap(Map<Date, ApplicationDtoInterface> applicationMap) throws MospException {
        HashMap<Date, TimeSettingDtoInterface> map = new HashMap<Date, TimeSettingDtoInterface>();
        for (Map.Entry<Date, ApplicationDtoInterface> entry : applicationMap.entrySet()) {
            Date targetDate = entry.getKey();
            ApplicationDtoInterface applicationDto = entry.getValue();
            if (applicationDto == null) {
                map.put(targetDate, null);
                continue;
            }
            map.put(targetDate, this.getTimeSetting(applicationDto.getWorkSettingCode(), targetDate));
        }
        return map;
    }

    public CutoffEntityInterface getCutoff(String cutoffCode, int targetYear, int targetMonth) throws MospException {
        Date targetDate = MonthUtility.getYearMonthTargetDate((int)targetYear, (int)targetMonth, (MospParams)this.mospParams);
        return this.getCutoff(cutoffCode, targetDate);
    }

    public CutoffEntityInterface getCutoff(String cutoffCode, Date targetDate) throws MospException {
        HashSet<CutoffEntityInterface> cutoffs = (HashSet<CutoffEntityInterface>)this.cutoffMap.get(targetDate);
        if (cutoffs == null) {
            cutoffs = new HashSet<CutoffEntityInterface>();
            this.cutoffMap.put(targetDate, cutoffs);
        }
        CutoffEntityInterface cutoff = (CutoffEntityInterface)PlatformUtility.getCodeDto((Collection)cutoffs, (String)cutoffCode);
        if (MospUtility.isEmpty((Object[])new Object[]{cutoff})) {
            cutoff = this.cutoffRefer.getCutoffEntity(cutoffCode, targetDate);
            cutoffs.add(cutoff);
        }
        return cutoff;
    }

    public CutoffEntityInterface getCutoffForPersonalId(String personalId, Date targetDate) throws MospException {
        ApplicationDtoInterface dto = this.getApplication(personalId, targetDate);
        return this.getCutoff(dto, targetDate);
    }

    public CutoffEntityInterface getCutoff(ApplicationDtoInterface dto, Date targetDate) throws MospException {
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return TimeUtility.getBareCutoffEntity((MospParams)this.mospParams);
        }
        TimeSettingDtoInterface timeSetting = this.getTimeSetting(dto.getWorkSettingCode(), targetDate);
        if (MospUtility.isEmpty((Object[])new Object[]{timeSetting})) {
            return TimeUtility.getBareCutoffEntity((MospParams)this.mospParams);
        }
        return this.getCutoff(timeSetting.getCutoffCode(), targetDate);
    }

    public Set<HolidayDtoInterface> getHolidaySet(Date targetDate) throws MospException {
        Set set = (Set)this.holidayMap.get(targetDate);
        if (set == null) {
            set = this.holidayDao.findForActivateDate(targetDate);
            this.holidayMap.put(targetDate, set);
        }
        return set;
    }

    public HolidayDtoInterface getHoliday(String holidayCode, int holidayType, Date targetDate) throws MospException {
        return TimeUtility.getHolidayDto((Collection)this.getHolidaySet(targetDate), (String)holidayCode, (int)holidayType);
    }

    public String getHolidayName(String holidayCode, int holidayType, Date targetDate) throws MospException {
        HolidayDtoInterface dto = this.getHoliday(holidayCode, holidayType, targetDate);
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return holidayCode;
        }
        return dto.getHolidayName();
    }

    public String getHolidayAbbr(String holidayCode, int holidayType, Date targetDate) throws MospException {
        HolidayDtoInterface dto = this.getHoliday(holidayCode, holidayType, targetDate);
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return holidayCode;
        }
        return dto.getHolidayAbbr();
    }

    protected Set<ApplicationDtoInterface> getApplicationPersonSet(Date targetDate) throws MospException {
        if (this.applicationPersonMap.get(targetDate) == null) {
            this.addApplicationSet(targetDate);
        }
        return (Set)this.applicationPersonMap.get(targetDate);
    }

    protected Set<ApplicationDtoInterface> getApplicationMasterSet(Date targetDate) throws MospException {
        if (this.applicationMasterMap.get(targetDate) == null) {
            this.addApplicationSet(targetDate);
        }
        return (Set)this.applicationMasterMap.get(targetDate);
    }

    protected void addApplicationSet(Date targetDate) throws MospException {
        HashSet<ApplicationDtoInterface> personSet = new HashSet<ApplicationDtoInterface>();
        HashSet<ApplicationDtoInterface> masterSet = new HashSet<ApplicationDtoInterface>();
        this.applicationPersonMap.put(targetDate, personSet);
        this.applicationMasterMap.put(targetDate, masterSet);
        int person = Integer.parseInt("1");
        int master = Integer.parseInt("0");
        List list = this.applicationDao.findForActivateDate(targetDate);
        for (ApplicationDtoInterface dto : list) {
            if (dto.getApplicationType() == person) {
                personSet.add(dto);
            }
            if (dto.getApplicationType() != master) continue;
            masterSet.add(dto);
        }
    }

    protected Set<Date> getApplicationDateSet(Date firstDate, Date lastDate) throws MospException {
        boolean isOutOfTerm = false;
        if (this.applicationFromDate == null || firstDate.before(this.applicationFromDate)) {
            isOutOfTerm = true;
            this.applicationFromDate = firstDate;
        }
        if (this.applicationToDate == null || lastDate.after(this.applicationToDate)) {
            isOutOfTerm = true;
            this.applicationToDate = lastDate;
        }
        if (isOutOfTerm) {
            this.applicationDateSet = new HashSet();
            List list = this.applicationDao.findForTerm(this.applicationFromDate, this.applicationToDate);
            for (ApplicationDtoInterface dto : list) {
                this.applicationDateSet.add(dto.getActivateDate());
            }
        }
        return new HashSet<Date>(this.applicationDateSet);
    }

    public TimeSettingDtoInterface getTimeSetting(String workSettingCode, Date targetDate) throws MospException {
        HashSet<TimeSettingDtoInterface> set = (HashSet<TimeSettingDtoInterface>)this.timeSettingMap.get(targetDate);
        if (set == null) {
            set = new HashSet<TimeSettingDtoInterface>();
            this.timeSettingMap.put(targetDate, set);
        }
        for (TimeSettingDtoInterface dto : set) {
            if (!dto.getWorkSettingCode().equals(workSettingCode)) continue;
            return dto;
        }
        TimeSettingDtoInterface dto = this.timeSettingDao.findForInfo(workSettingCode, targetDate);
        set.add(dto);
        return dto;
    }

    public TimeSettingEntityInterface getTimeSetting(TimeSettingDtoInterface dto) throws MospException {
        TimeSettingEntityInterface entity = TimeUtility.getBareTimeSettingEntity((MospParams)this.mospParams);
        entity.setTimeSettingDto(dto);
        if (!entity.isExist()) {
            return entity;
        }
        String workSettingCode = dto.getWorkSettingCode();
        Date activateDate = dto.getActivateDate();
        entity.setLimitStandardDtos(this.getLimitStandards(workSettingCode, activateDate));
        return entity;
    }

    public TimeSettingEntityInterface getTimeSettingForPersonalId(String personalId, Date targetDate) throws MospException {
        ApplicationDtoInterface application = this.getApplication(personalId, targetDate);
        if (MospUtility.isEmpty((Object[])new Object[]{application})) {
            return TimeUtility.getBareTimeSettingEntity((MospParams)this.mospParams);
        }
        TimeSettingDtoInterface dto = this.getTimeSetting(application.getWorkSettingCode(), targetDate);
        return this.getTimeSetting(dto);
    }

    protected Map<String, LimitStandardDtoInterface> getLimitStandards(String workSettingCode, Date activateDate) throws MospException {
        Set dtos = (Set)this.limitStandardMap.get(workSettingCode);
        if (dtos == null) {
            dtos = this.limitStandardRefer.getLimitStandards(workSettingCode);
            this.limitStandardMap.put(workSettingCode, dtos);
        }
        Map map = PlatformUtility.getActivateDateMap((Collection)dtos);
        return TimeUtility.getLimitStandards((Collection)((Collection)map.get(activateDate)));
    }

    public PaidHolidayDtoInterface getPaidHoliday(String paidHolidayCode, Date targetDate) throws MospException {
        HashSet<PaidHolidayDtoInterface> set = (HashSet<PaidHolidayDtoInterface>)this.paidHolidayMap.get(targetDate);
        if (set == null) {
            set = new HashSet<PaidHolidayDtoInterface>();
            this.paidHolidayMap.put(targetDate, set);
        }
        for (PaidHolidayDtoInterface dto : set) {
            if (!dto.getPaidHolidayCode().equals(paidHolidayCode)) continue;
            return dto;
        }
        PaidHolidayDtoInterface dto = this.paidHolidayDao.findForInfo(paidHolidayCode, targetDate);
        set.add(dto);
        return dto;
    }

    public Optional<PaidHolidayDtoInterface> getPaidHolidayForPersonalId(String personalId, Date targetDate) throws MospException {
        return Optional.ofNullable(this.getPaidHoliday(this.platformMaster.getHuman(personalId, targetDate), targetDate));
    }

    public int getPaidHolidayHoursPerDay(String personalId, Date targetDate) throws MospException {
        return this.getPaidHolidayHoursPerDay(this.platformMaster.getHuman(personalId, targetDate), targetDate);
    }

    public int getPaidHolidayHoursPerDay(HumanDtoInterface humanDto, Date targetDate) throws MospException {
        PaidHolidayDtoInterface dto = this.getPaidHoliday(humanDto, targetDate);
        if (dto == null) {
            return 0;
        }
        return dto.getTimeAcquisitionLimitTimes();
    }

    public WorkTypeEntityInterface getWorkTypeEntity(String workTypeCode, Date targetDate) throws MospException {
        this.getWorkTypeEntityHistory(workTypeCode);
        WorkTypeEntityInterface entity = TotalTimeUtility.getLatestWorkTypeEntity((Map)this.workTypeMap, (String)workTypeCode, (Date)targetDate);
        if (MospUtility.isEmpty((Object[])new Object[]{entity})) {
            entity = TimeUtility.getBareWorkTypeEntity((MospParams)this.mospParams);
        }
        return entity;
    }

    public List<WorkTypeEntityInterface> getWorkTypeEntityHistory(String workTypeCode) throws MospException {
        List history = (List)this.workTypeMap.get(workTypeCode);
        if (history != null) {
            return history;
        }
        history = this.workTypeRefer.getWorkTypeEntityHistory(workTypeCode);
        this.workTypeMap.put(workTypeCode, history);
        return history;
    }

    public Map<String, List<WorkTypeEntityInterface>> getWorkTypeEntities(Collection<String> workTypeCodes) throws MospException {
        TreeMap<String, List<WorkTypeEntityInterface>> entities = new TreeMap<String, List<WorkTypeEntityInterface>>();
        for (String workTypeCode : workTypeCodes) {
            entities.put(workTypeCode, this.getWorkTypeEntityHistory(workTypeCode));
        }
        entities.putAll(this.workTypeRefer.getExtraWorkTypeEntityHistories());
        return entities;
    }

    public WorkTypeEntityInterface getWorkTypeEntity(String workTypeCode, Date targetDate, DifferenceRequestDtoInterface differenceRequest) throws MospException {
        WorkTypeEntityInterface workType = this.getWorkTypeEntity(workTypeCode, targetDate);
        if (!MospUtility.isEmpty((Object[])new Object[]{differenceRequest})) {
            String differenceWorkTypeCode = differenceRequest.getWorkTypeCode();
            workType = this.getWorkTypeEntity(differenceWorkTypeCode, targetDate);
            workType = DifferenceUtility.makeDifferenceWorkType((MospParams)this.mospParams, (DifferenceRequestDtoInterface)differenceRequest, (WorkTypeEntityInterface)workType);
        }
        return workType;
    }
}

