/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.ExtraHumanDeleteBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.ApplicationReferenceBeanInterface;
import jp.mosp.time.bean.HolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayTransactionReferenceBeanInterface;
import jp.mosp.time.bean.TotalTimeEmployeeTransactionReferenceBeanInterface;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeUtility;

public class TimeHumanDeleteBean
extends TimeBean
implements ExtraHumanDeleteBeanInterface {
    protected WorkflowReferenceBeanInterface workflowReference;
    protected ApplicationReferenceBeanInterface applicationReference;
    protected PaidHolidayTransactionReferenceBeanInterface paidHolidayTransaction;
    protected HolidayInfoReferenceBeanInterface holidayInfoReference;
    protected TotalTimeEmployeeTransactionReferenceBeanInterface totalTimeEmployeeReference;

    public void initBean() throws MospException {
        this.workflowReference = (WorkflowReferenceBeanInterface)this.createBeanInstance(WorkflowReferenceBeanInterface.class);
        this.applicationReference = (ApplicationReferenceBeanInterface)this.createBeanInstance(ApplicationReferenceBeanInterface.class);
        this.paidHolidayTransaction = (PaidHolidayTransactionReferenceBeanInterface)this.createBeanInstance(PaidHolidayTransactionReferenceBeanInterface.class);
        this.holidayInfoReference = (HolidayInfoReferenceBeanInterface)this.createBeanInstance(HolidayInfoReferenceBeanInterface.class);
        this.totalTimeEmployeeReference = (TotalTimeEmployeeTransactionReferenceBeanInterface)this.createBeanInstance(TotalTimeEmployeeTransactionReferenceBeanInterface.class);
    }

    public Set<String> getTargetTable() {
        HashSet<String> lockTableSet = new HashSet<String>();
        return lockTableSet;
    }

    public void humanDelete(HumanDtoInterface dto, boolean isAllDelete) {
    }

    public void checkDelete(List<HumanDtoInterface> list, int deleateIndex, int deleteCase) throws MospException {
        switch (deleteCase) {
            case 1: {
                HumanDtoInterface deleateHumanDto = list.get(deleateIndex);
                Date endDate = null;
                this.checkWorkflow(deleateHumanDto, endDate);
                this.checkCutoff(deleateHumanDto, endDate);
                this.checkExist(deleateHumanDto, endDate);
                break;
            }
            case 2: {
                HumanDtoInterface humanDto = list.get(deleateIndex);
                HumanDtoInterface afterHumanDto = list.get(deleateIndex + 1);
                Date endDate = DateUtility.addDay((Date)afterHumanDto.getActivateDate(), (int)-1);
                this.checkWorkflow(humanDto, endDate);
                this.checkCutoff(humanDto, endDate);
                this.checkExist(humanDto, endDate);
                break;
            }
        }
    }

    protected void checkWorkflow(HumanDtoInterface deleteHumanDto, Date endDate) throws MospException {
        Date startDate = deleteHumanDto.getActivateDate();
        List list = this.workflowReference.getPersonalList(deleteHumanDto.getPersonalId(), startDate, endDate, TimeUtility.getTimeFunctionSet());
        if (!list.isEmpty()) {
            this.addDeleteTimeErrorMessage(this.mospParams.getName("WorkManage"), this.mospParams.getName("Application"));
            return;
        }
    }

    protected void checkExist(HumanDtoInterface deleteHumanDto, Date endDate) throws MospException {
        this.checkApplication(deleteHumanDto, endDate);
        this.checkPaidHoliday(deleteHumanDto, endDate);
        this.checkSpecialHoliday(deleteHumanDto, endDate);
        this.checkOtherHoliday(deleteHumanDto, endDate);
    }

    protected void checkCutoff(HumanDtoInterface deleteHumanDto, Date endDate) throws MospException {
        Date startDate = deleteHumanDto.getActivateDate();
        if (this.totalTimeEmployeeReference.getCutoffTermState(deleteHumanDto.getPersonalId(), startDate, endDate)) {
            this.addDeleteTimeErrorMessage(this.mospParams.getName("WorkManage") + this.mospParams.getName("Total"), this.mospParams.getName("Information"));
        }
    }

    protected void checkApplication(HumanDtoInterface deleteDto, Date endDate) throws MospException {
        Date startDate = deleteDto.getActivateDate();
        if (this.applicationReference.hasPersonalApplication(deleteDto.getPersonalId(), startDate, endDate)) {
            String employeeCode = deleteDto.getEmployeeCode();
            String fieldName = TimeNamingUtility.getApplication((MospParams)this.mospParams);
            PfMessageUtility.addErrorHumanCanNotDelete((MospParams)this.mospParams, (String)employeeCode, (String)fieldName);
        }
    }

    protected void checkPaidHoliday(HumanDtoInterface deleteDto, Date endDate) throws MospException {
        Date startDate = deleteDto.getActivateDate();
        if (this.paidHolidayTransaction.hasPersonalApplication(deleteDto.getPersonalId(), startDate, endDate)) {
            String employeeCode = deleteDto.getEmployeeCode();
            String fieldName = TimeNamingUtility.paidHolidayAbbr((MospParams)this.mospParams);
            PfMessageUtility.addErrorHumanCanNotDelete((MospParams)this.mospParams, (String)employeeCode, (String)fieldName);
        }
    }

    protected void checkSpecialHoliday(HumanDtoInterface deleteDto, Date endDate) throws MospException {
        Date startDate = deleteDto.getActivateDate();
        if (this.holidayInfoReference.hasPersonalApplication(deleteDto.getPersonalId(), startDate, endDate, 2)) {
            String employeeCode = deleteDto.getEmployeeCode();
            String fieldName = TimeNamingUtility.specialHoliday((MospParams)this.mospParams);
            PfMessageUtility.addErrorHumanCanNotDelete((MospParams)this.mospParams, (String)employeeCode, (String)fieldName);
        }
    }

    protected void checkOtherHoliday(HumanDtoInterface deleteDto, Date endDate) throws MospException {
        Date startDate = deleteDto.getActivateDate();
        if (this.holidayInfoReference.hasPersonalApplication(deleteDto.getPersonalId(), startDate, endDate, 3)) {
            String employeeCode = deleteDto.getEmployeeCode();
            String fieldName = TimeNamingUtility.otherHoliday((MospParams)this.mospParams);
            PfMessageUtility.addErrorHumanCanNotDelete((MospParams)this.mospParams, (String)employeeCode, (String)fieldName);
        }
    }

    protected void addDeleteTimeErrorMessage(String errorTargetName, String activeName) {
        this.mospParams.addErrorMessage("TMW0217", new String[]{errorTargetName, activeName});
    }
}

