/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.bean.file.impl.BaseExportBean;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.time.bean.TimeExportBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.entity.CutoffEntityInterface;
import jp.mosp.time.utils.TimeUtility;

public abstract class TimeBaseExportBean
extends BaseExportBean
implements TimeExportBeanInterface {
    protected TimeMasterBeanInterface timeMaster;

    public void initBean() throws MospException {
        super.initBean();
        this.timeMaster = (TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class);
        this.timeMaster.setPlatformMaster(this.platformMaster);
    }

    public void export(String exportCode, int startYear, int startMonth, int endYear, int endMonth, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, boolean needLowerSection, String positionCode) throws MospException {
        Date lastDate;
        Date firstDate;
        ExportDtoInterface exportDto = this.exportDao.findForKey(exportCode);
        if (exportDto == null) {
            PfMessageUtility.addErrorNoExportInfo((MospParams)this.mospParams);
            return;
        }
        List fieldList = this.exportFieldRefer.getExportFieldNameList(exportCode);
        List csvDataList = this.makeCsvDataList(fieldList, firstDate = this.getCutoffFirstDate(cutoffCode, startYear, startMonth), lastDate = this.getCutoffLastDate(cutoffCode, endYear, endMonth), cutoffCode, workPlaceCode, employmentContractCode, sectionCode, needLowerSection, positionCode);
        if (csvDataList.isEmpty()) {
            PfMessageUtility.addErrorNoExportInfo((MospParams)this.mospParams);
            return;
        }
        this.addHeader(csvDataList, exportDto, fieldList, lastDate);
        this.mospParams.setFile((Object)OrangeSignalUtility.getOrangeSignalParams((List)csvDataList));
        this.mospParams.setFileName(this.getFileName(exportDto, firstDate, lastDate));
    }

    protected String getFileName(ExportDtoInterface dto, Date firstDate, Date lastDate) {
        return TimeUtility.getExportFileName((MospParams)this.mospParams, (ExportDtoInterface)dto, (Date)firstDate, (Date)lastDate);
    }

    protected List<String[]> makeCsvDataList(List<String> fieldList, Date firstDate, Date lastDate, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, boolean needLowerSection, String positionCode) throws MospException {
        return Collections.emptyList();
    }

    protected Date getCutoffFirstDate(String cutoffCode, int targetYear, int targetMonth) throws MospException {
        CutoffEntityInterface cutoff = this.timeMaster.getCutoff(cutoffCode, targetYear, targetMonth);
        return cutoff.getCutoffFirstDate(targetYear, targetMonth, this.mospParams);
    }

    protected Date getCutoffLastDate(String cutoffCode, int targetYear, int targetMonth) throws MospException {
        CutoffEntityInterface cutoff = this.timeMaster.getCutoff(cutoffCode, targetYear, targetMonth);
        return cutoff.getCutoffLastDate(targetYear, targetMonth, this.mospParams);
    }

    protected boolean isTheCutoff(HumanDtoInterface human, Date targetDate, String cutoffCode) throws MospException {
        ApplicationEntity application = this.timeMaster.getApplicationEntity(human, targetDate);
        if (!application.isValid()) {
            return false;
        }
        return MospUtility.isEqual((Object)cutoffCode, (Object)application.getCutoffCode());
    }

    protected List<HumanDtoInterface> getCutoffHumans(List<HumanDtoInterface> dtos, Date targetDate, String cutoffCode) throws MospException {
        ArrayList<HumanDtoInterface> cutoffHumans = new ArrayList<HumanDtoInterface>();
        for (HumanDtoInterface dto : dtos) {
            if (!this.isTheCutoff(dto, targetDate, cutoffCode)) continue;
            cutoffHumans.add(dto);
        }
        return cutoffHumans;
    }

    protected List<HumanDtoInterface> getHumanList(Date firstDate, Date lastDate, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, boolean needLowerSection, String positionCode) throws MospException {
        ArrayList dtos = new ArrayList();
        this.humanSearch.setStartDate(firstDate);
        this.humanSearch.setEndDate(lastDate);
        this.humanSearch.setTargetDate(lastDate);
        this.humanSearch.setWorkPlaceCode(workPlaceCode);
        this.humanSearch.setEmploymentContractCode(employmentContractCode);
        this.humanSearch.setSectionCode(sectionCode);
        this.humanSearch.setNeedLowerSection(needLowerSection);
        this.humanSearch.setPositionCode(positionCode);
        this.humanSearch.setNeedConcurrent(true);
        this.humanSearch.setOperationType("1");
        this.humanSearch.setStateType("presence");
        dtos.addAll(this.humanSearch.search());
        this.humanSearch.setStateType("suspend");
        dtos.addAll(this.humanSearch.search());
        return this.getCutoffHumans(dtos, lastDate, cutoffCode);
    }

    protected List<HumanDtoInterface> getHumanList(Date targetDate, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, boolean needLowerSection, String positionCode) throws MospException {
        this.humanSearch.setTargetDate(targetDate);
        this.humanSearch.setWorkPlaceCode(workPlaceCode);
        this.humanSearch.setEmploymentContractCode(employmentContractCode);
        this.humanSearch.setSectionCode(sectionCode);
        this.humanSearch.setNeedLowerSection(needLowerSection);
        this.humanSearch.setPositionCode(positionCode);
        this.humanSearch.setStateType("");
        this.humanSearch.setNeedConcurrent(true);
        this.humanSearch.setOperationType("1");
        return this.getCutoffHumans(this.humanSearch.search(), targetDate, cutoffCode);
    }
}

