/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PfMessageUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.CutoffUtilBeanInterface;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.SubstituteReferenceBeanInterface;
import jp.mosp.time.bean.SubstituteRegistBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.WorkOnHolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeChangeRequestReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeItemReferenceBeanInterface;
import jp.mosp.time.bean.WorkTypeReferenceBeanInterface;
import jp.mosp.time.dao.settings.AttendanceDaoInterface;
import jp.mosp.time.dao.settings.DifferenceRequestDaoInterface;
import jp.mosp.time.dao.settings.HolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.OvertimeRequestDaoInterface;
import jp.mosp.time.dao.settings.SubHolidayRequestDaoInterface;
import jp.mosp.time.dao.settings.SubstituteDaoInterface;
import jp.mosp.time.dao.settings.WorkOnHolidayRequestDaoInterface;
import jp.mosp.time.dto.base.HolidayRangeDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.OvertimeRequestDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeItemDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdSubstituteDto;
import jp.mosp.time.entity.ApplicationEntity;
import jp.mosp.time.entity.RequestEntityInterface;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeRequestUtility;
import jp.mosp.time.utils.TimeUtility;

public class SubstituteRegistBean
extends TimeBean
implements SubstituteRegistBeanInterface {
    protected SubstituteDaoInterface dao;
    protected SubstituteReferenceBeanInterface substituteReference;
    protected WorkOnHolidayRequestDaoInterface workOnHolidayRequestDao;
    protected WorkOnHolidayRequestReferenceBeanInterface workOnHolidayRefer;
    protected HolidayRequestDaoInterface holidayRequestDao;
    protected SubHolidayRequestDaoInterface subHolidayRequestDao;
    protected OvertimeRequestDaoInterface overtimeRequestDao;
    protected DifferenceRequestDaoInterface differenceRequestDao;
    protected AttendanceDaoInterface attendanceDao;
    protected WorkflowDaoInterface workflowDao;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected SuspensionReferenceBeanInterface suspensionReference;
    protected RetirementReferenceBeanInterface retirementReference;
    protected CutoffUtilBeanInterface cutoffUtil;
    protected ScheduleUtilBeanInterface scheduleUtil;
    protected WorkTypeReferenceBeanInterface workTypeRefer;
    protected WorkTypeItemReferenceBeanInterface workTypeItemRefer;
    protected WorkflowReferenceBeanInterface workflowReference;
    protected WorkTypeChangeRequestReferenceBeanInterface workTypeChangeReference;
    protected TimeMasterBeanInterface timeMaster;

    public void initBean() throws MospException {
        this.dao = (SubstituteDaoInterface)this.createDaoInstance(SubstituteDaoInterface.class);
        this.workOnHolidayRequestDao = (WorkOnHolidayRequestDaoInterface)this.createDaoInstance(WorkOnHolidayRequestDaoInterface.class);
        this.holidayRequestDao = (HolidayRequestDaoInterface)this.createDaoInstance(HolidayRequestDaoInterface.class);
        this.subHolidayRequestDao = (SubHolidayRequestDaoInterface)this.createDaoInstance(SubHolidayRequestDaoInterface.class);
        this.overtimeRequestDao = (OvertimeRequestDaoInterface)this.createDaoInstance(OvertimeRequestDaoInterface.class);
        this.differenceRequestDao = (DifferenceRequestDaoInterface)this.createDaoInstance(DifferenceRequestDaoInterface.class);
        this.attendanceDao = (AttendanceDaoInterface)this.createDaoInstance(AttendanceDaoInterface.class);
        this.workflowDao = (WorkflowDaoInterface)this.createDaoInstance(WorkflowDaoInterface.class);
        this.substituteReference = (SubstituteReferenceBeanInterface)this.createBeanInstance(SubstituteReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBeanInstance(WorkflowIntegrateBeanInterface.class);
        this.suspensionReference = (SuspensionReferenceBeanInterface)this.createBeanInstance(SuspensionReferenceBeanInterface.class);
        this.retirementReference = (RetirementReferenceBeanInterface)this.createBeanInstance(RetirementReferenceBeanInterface.class);
        this.cutoffUtil = (CutoffUtilBeanInterface)this.createBeanInstance(CutoffUtilBeanInterface.class);
        this.workTypeRefer = (WorkTypeReferenceBeanInterface)this.createBeanInstance(WorkTypeReferenceBeanInterface.class);
        this.workTypeItemRefer = (WorkTypeItemReferenceBeanInterface)this.createBeanInstance(WorkTypeItemReferenceBeanInterface.class);
        this.workOnHolidayRefer = (WorkOnHolidayRequestReferenceBeanInterface)this.createBeanInstance(WorkOnHolidayRequestReferenceBeanInterface.class);
        this.workflowReference = (WorkflowReferenceBeanInterface)this.createBeanInstance(WorkflowReferenceBeanInterface.class);
        this.workTypeChangeReference = (WorkTypeChangeRequestReferenceBeanInterface)this.createBeanInstance(WorkTypeChangeRequestReferenceBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class);
        this.scheduleUtil = (ScheduleUtilBeanInterface)this.createBeanInstance(ScheduleUtilBeanInterface.class);
        this.scheduleUtil.setTimeMaster(this.timeMaster);
        this.cutoffUtil.setTimeMaster(this.timeMaster);
    }

    public SubstituteDtoInterface getInitDto() {
        return new TmdSubstituteDto();
    }

    public void insert(SubstituteDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdSubstituteId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(long workflow) throws MospException {
        List list = this.dao.findForWorkflow(workflow);
        for (SubstituteDtoInterface dto : list) {
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkDelete(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdSubstituteId());
        }
    }

    protected void checkInsert(SubstituteDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKeyOnWorkflow(dto.getPersonalId(), dto.getSubstituteDate(), dto.getSubstituteRange(), dto.getWorkDate(), dto.getTimesWork()));
    }

    protected void checkDelete(SubstituteDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdSubstituteId());
    }

    public void validate(SubstituteDtoInterface dto) throws MospException {
        this.substituteReference.chkBasicInfo(dto.getPersonalId(), dto.getSubstituteDate());
    }

    public void checkValidate(SubstituteDtoInterface dto) {
        this.checkRequired((Object)dto.getSubstituteDate(), this.mospParams.getName("Transfer", new String[]{"Day"}), null);
    }

    public void checkRegist(SubstituteDtoInterface dto) throws MospException {
        this.checkSuspension(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRetirement(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTargetTransferDate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkHolidayDate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTransferDateRange(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRequest(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAttendance(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTighten(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkOverTime(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkWorkTypeChange(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkHalfRequest(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
    }

    public void checkImport(SubstituteDtoInterface dto) throws MospException {
        this.checkValidate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkEntered(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRetirement(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkSuspension(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTighten(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkHolidayDate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkTransferDateRange(dto);
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(dto.getPersonalId(), dto.getSubstituteDate());
        this.checkWorkType(dto, requestUtil);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDuplicate(dto, requestUtil);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkRequest(requestUtil);
    }

    protected void checkWorkType(SubstituteDtoInterface dto, RequestUtilBeanInterface requestUtil) throws MospException {
        Date targetDate;
        String personalId = dto.getPersonalId();
        String workTypeCode = this.scheduleUtil.getScheduledWorkTypeCode(personalId, targetDate = dto.getSubstituteDate(), requestUtil);
        if (workTypeCode == null || workTypeCode.isEmpty()) {
            this.addSubstituteDateErrorMessage(dto.getSubstituteDate());
            return;
        }
        if (this.isLegalDayOff(workTypeCode) || this.isPrescribedDayOff(workTypeCode)) {
            this.addSubstituteDateErrorMessage(dto.getSubstituteDate());
            return;
        }
        if ("work_on_legal".equals(workTypeCode) || "work_on_prescribed".equals(workTypeCode)) {
            this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("WorkingHoliday"));
        }
    }

    protected void checkDuplicate(SubstituteDtoInterface dto, RequestUtilBeanInterface requestUtil) throws MospException {
        int holidayRange;
        boolean substituteRangeAm = false;
        boolean substituteRangePm = false;
        boolean holidayRangeAm = false;
        boolean holidayRangePm = false;
        boolean holidayRangeTime = false;
        boolean subHolidayRangeAm = false;
        boolean subHolidayRangePm = false;
        List substituteList = this.dao.findForList(dto.getPersonalId(), dto.getSubstituteDate());
        for (SubstituteDtoInterface substituteDto : substituteList) {
            long workflow = substituteDto.getWorkflow();
            if (this.workflowIntegrate.isWithDrawn(workflow) || dto.getWorkflow() == workflow || !this.isLegalDayOff(substituteDto.getSubstituteType()) && !this.isPrescribedDayOff(substituteDto.getSubstituteType())) continue;
            int range = substituteDto.getSubstituteRange();
            if (range == 1) {
                this.addSubstituteDateErrorMessage(dto.getSubstituteDate());
                return;
            }
            if (range == 2) {
                substituteRangeAm = true;
                continue;
            }
            if (range != 3) continue;
            substituteRangePm = true;
        }
        if (substituteRangeAm && substituteRangePm) {
            this.addSubstituteDateErrorMessage(dto.getSubstituteDate());
            return;
        }
        int substituteRange = dto.getSubstituteRange();
        if (substituteRange == 1) {
            if (substituteRangeAm || substituteRangePm) {
                this.addSubstituteDateErrorMessage(dto.getSubstituteDate());
                return;
            }
        } else if (substituteRange == 2) {
            if (subHolidayRangeAm) {
                this.addSubstituteDateErrorMessage(dto.getSubstituteDate());
                return;
            }
        } else if (substituteRange == 3 && substituteRangePm) {
            this.addSubstituteDateErrorMessage(dto.getSubstituteDate());
            return;
        }
        if ((holidayRange = requestUtil.checkHolidayRangeHoliday(requestUtil.getHolidayList(false))) == 1 || holidayRange == 5) {
            this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("Holiday"));
            return;
        }
        if (holidayRange == 2) {
            holidayRangeAm = true;
        } else if (holidayRange == 3) {
            holidayRangePm = true;
        } else if (holidayRange == 4) {
            holidayRangeTime = true;
        }
        int subHolidayRange = requestUtil.checkHolidayRangeSubHoliday(requestUtil.getSubHolidayList(false));
        if (subHolidayRange == 1 || subHolidayRange == 5) {
            this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("CompensatoryHoliday"));
            return;
        }
        if (subHolidayRange == 2) {
            subHolidayRangeAm = true;
        } else if (subHolidayRange == 3) {
            subHolidayRangePm = true;
        }
        if ((substituteRangeAm || holidayRangeAm || subHolidayRangeAm) && (substituteRangePm || holidayRangePm || subHolidayRangePm)) {
            this.addSubstituteDateErrorMessage(dto.getSubstituteDate());
            return;
        }
        if (substituteRange == 1) {
            if (holidayRangeAm || holidayRangePm) {
                this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("Holiday"));
                return;
            }
            if (holidayRangeTime) {
                this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("HolidayTime"));
                return;
            }
        } else if (substituteRange == 2) {
            if (holidayRangeAm) {
                this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("Holiday"));
                return;
            }
            if (holidayRangeTime) {
                this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("HolidayTime"));
                return;
            }
        } else if (substituteRange == 3) {
            if (holidayRangePm) {
                this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("Holiday"));
                return;
            }
            if (holidayRangeTime) {
                this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("HolidayTime"));
                return;
            }
        }
        if (substituteRange == 1) {
            if (subHolidayRangeAm || subHolidayRangePm) {
                this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("CompensatoryHoliday"));
                return;
            }
        } else if (substituteRange == 2) {
            if (subHolidayRangeAm) {
                this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("CompensatoryHoliday"));
                return;
            }
        } else if (substituteRange == 3 && subHolidayRangePm) {
            this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("CompensatoryHoliday"));
            return;
        }
        int range = dto.getSubstituteRange();
        if (substituteRange == 2) {
            if (substituteRangePm || holidayRangePm || subHolidayRangePm) {
                range = 1;
            }
        } else if (substituteRange == 3 && (substituteRangeAm || holidayRangeAm || subHolidayRangeAm)) {
            range = 1;
        }
        this.checkOvertimeWorkRequest(dto, requestUtil, range);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkWorkTypeChangeRequest(requestUtil, range);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDifferenceRequest(requestUtil, range);
    }

    public void checkTargetTransferDate(SubstituteDtoInterface dto) throws MospException {
        WorkflowDtoInterface workflowDto;
        if (MospUtility.isEmpty((Object[])new Object[]{dto})) {
            return;
        }
        String personalId = dto.getPersonalId();
        Date substituteDate = dto.getSubstituteDate();
        int substituteRange = dto.getSubstituteRange();
        boolean substituteFlag = false;
        List substituteList = this.dao.findForList(personalId, substituteDate);
        for (Object substituteDto : substituteList) {
            if (dto.getWorkflow() == substituteDto.getWorkflow()) continue;
            workflowDto = this.workflowDao.findForKey(substituteDto.getWorkflow());
            if (MospUtility.isEmpty((Object[])new Object[]{workflowDto}) || WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) continue;
            substituteFlag = true;
            if (!"legal_holiday".equals(substituteDto.getSubstituteType()) && !"prescribed_holiday".equals(substituteDto.getSubstituteType()) || substituteDto.getSubstituteRange() != 1 && substituteRange != substituteDto.getSubstituteRange()) break;
            String[] aryRep = new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameGoingWorkDay(), this.getNameSubstituteDay()};
            this.mospParams.addErrorMessage("TMW0242", aryRep);
            return;
        }
        if (!substituteFlag) {
            ScheduleDateDtoInterface scheduleDateDto = this.scheduleUtil.getScheduleDate(personalId, substituteDate);
            if (MospUtility.isEmpty((Object[])new Object[]{scheduleDateDto})) {
                PfMessageUtility.addErrorNoItem((MospParams)this.mospParams, (String)TimeNamingUtility.calendarData((MospParams)this.mospParams));
                return;
            }
            if (scheduleDateDto.getWorkTypeCode() == null || scheduleDateDto.getWorkTypeCode().isEmpty() || this.isLegalDayOff(scheduleDateDto.getWorkTypeCode()) || this.isPrescribedDayOff(scheduleDateDto.getWorkTypeCode())) {
                String[] aryRep = new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameGoingWorkDay(), this.getNameSubstituteDay()};
                this.mospParams.addErrorMessage("TMW0242", aryRep);
                return;
            }
        }
        for (Object substituteDto : substituteList) {
            if (dto.getWorkflow() == substituteDto.getWorkflow() || (workflowDto = this.workflowDao.findForKey(substituteDto.getWorkflow())) == null || WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) continue;
            int range = substituteDto.getSubstituteRange();
            if (substituteRange == 1 || range == 1) {
                this.mospParams.addErrorMessage("TMW0277", new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameSubstituteDay()});
                return;
            }
            if (range != 2 && range != 3 || range != substituteRange) continue;
            String[] aryRep = new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameGoingWorkDay(), this.getNameSubstituteDay()};
            this.mospParams.addErrorMessage("TMW0242", aryRep);
            return;
        }
        List holidayRequestList = this.holidayRequestDao.findForList(personalId, substituteDate);
        for (HolidayRequestDtoInterface holidayRequestDto : holidayRequestList) {
            WorkflowDtoInterface workflowDto2 = this.workflowDao.findForKey(holidayRequestDto.getWorkflow());
            if (WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto2) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto2)) continue;
            int holidayRange = holidayRequestDto.getHolidayRange();
            if (substituteRange == 1 || holidayRange == 1) {
                this.mospParams.addErrorMessage("TMW0277", new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameSubstituteDay()});
                return;
            }
            if (holidayRange == 2 || holidayRange == 3) {
                if (holidayRange != substituteRange) continue;
                String[] aryRep = new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameGoingWorkDay(), this.getNameSubstituteDay()};
                this.mospParams.addErrorMessage("TMW0242", aryRep);
                return;
            }
            if (holidayRange != 4) continue;
            this.mospParams.addErrorMessage("TMW0277", new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameSubstituteDay()});
            return;
        }
        List subHolidayRequestList = this.subHolidayRequestDao.findForList(personalId, substituteDate);
        for (SubHolidayRequestDtoInterface subHolidayRequestDto : subHolidayRequestList) {
            WorkflowDtoInterface workflowDto3 = this.workflowDao.findForKey(subHolidayRequestDto.getWorkflow());
            if (WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto3) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto3)) continue;
            int holidayRange = subHolidayRequestDto.getHolidayRange();
            if (substituteRange == 1 || holidayRange == 1) {
                this.mospParams.addErrorMessage("TMW0277", new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameSubstituteDay()});
                return;
            }
            if (holidayRange != 2 && holidayRange != 3 || holidayRange != substituteRange) continue;
            String[] aryRep = new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameGoingWorkDay(), this.getNameSubstituteDay()};
            this.mospParams.addErrorMessage("TMW0242", aryRep);
            return;
        }
    }

    protected void checkOvertimeWorkRequest(SubstituteDtoInterface dto, RequestUtilBeanInterface requestUtil, int range) throws MospException {
        if (range != 1) {
            return;
        }
        if (requestUtil.getOverTimeList(false).isEmpty()) {
            return;
        }
        this.addOthersRequestErrorMessage(dto.getSubstituteDate(), this.mospParams.getName("OvertimeWork"));
    }

    protected void checkWorkTypeChangeRequest(RequestUtilBeanInterface requestUtil, int range) throws MospException {
        if (range != 1) {
            return;
        }
        WorkTypeChangeRequestDtoInterface workTypeChangeRequestDto = requestUtil.getWorkTypeChangeDto(false);
        if (workTypeChangeRequestDto == null) {
            return;
        }
        this.addOthersRequestErrorMessage(workTypeChangeRequestDto.getRequestDate(), this.mospParams.getName("Work", new String[]{"Form", "Change"}));
    }

    protected void checkDifferenceRequest(RequestUtilBeanInterface requestUtil, int range) throws MospException {
        if (range != 1 && range != 2) {
            return;
        }
        DifferenceRequestDtoInterface differenceRequestDto = requestUtil.getDifferenceDto(false);
        if (differenceRequestDto == null) {
            return;
        }
        this.addOthersRequestErrorMessage(differenceRequestDto.getRequestDate(), this.mospParams.getName("TimeDifference", new String[]{"GoingWork"}));
    }

    public void checkTransferDateRange(SubstituteDtoInterface dto) throws MospException {
        if (dto == null) {
            return;
        }
        Date workDate = dto.getWorkDate();
        ApplicationEntity application = this.timeMaster.getApplicationEntity(dto.getPersonalId(), workDate);
        if (!application.isValid(this.mospParams)) {
            return;
        }
        TimeSettingDtoInterface timeSettingDto = application.getTimeSettingDto();
        Date beforeDate = DateUtility.addDay((Date)DateUtility.addMonth((Date)workDate, (int)(-timeSettingDto.getTransferAheadLimitMonth())), (int)(-timeSettingDto.getTransferAheadLimitDate()));
        Date afterDate = DateUtility.addDay((Date)DateUtility.addMonth((Date)workDate, (int)timeSettingDto.getTransferLaterLimitMonth()), (int)timeSettingDto.getTransferLaterLimitDate());
        Date substituteDate = dto.getSubstituteDate();
        if (!substituteDate.after(beforeDate) || !substituteDate.before(afterDate)) {
            this.mospParams.addErrorMessage("TMW0248", new String[]{this.getStringDate(dto.getSubstituteDate()), null});
        }
    }

    protected void checkRequest(RequestUtilBeanInterface requestUtil) throws MospException {
        this.checkWorkOnHolidayRequest(requestUtil);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAttendance(requestUtil);
    }

    public void checkRequest(SubstituteDtoInterface dto) throws MospException {
        WorkflowDtoInterface workflowDto;
        Date substituteDate;
        if (dto == null) {
            return;
        }
        String personalId = dto.getPersonalId();
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = this.workOnHolidayRequestDao.findForKeyOnWorkflow(personalId, substituteDate = dto.getSubstituteDate());
        if (workOnHolidayRequestDto != null && (workflowDto = this.workflowDao.findForKey(workOnHolidayRequestDto.getWorkflow())) != null && workflowDto.getWorkflowStage() != 0 && !WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) && !WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) {
            String[] aryRep = new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameSubstituteDay()};
            this.mospParams.addErrorMessage("TMW0277", aryRep);
        }
        if (dto.getSubstituteRange() == 1) {
            DifferenceRequestDtoInterface differenceRequestDto;
            RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
            requestUtil.setRequests(personalId, dto.getSubstituteDate());
            List list = this.overtimeRequestDao.findForList(personalId, substituteDate);
            for (OvertimeRequestDtoInterface requestDto : list) {
                WorkflowDtoInterface workflowDto2 = this.workflowDao.findForKey(requestDto.getWorkflow());
                if (workflowDto2 == null || WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto2) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto2)) continue;
                String[] aryRep = new String[]{this.getStringDate(dto.getSubstituteDate()), this.getNameSubstituteDay()};
                this.mospParams.addErrorMessage("TMW0277", aryRep);
                return;
            }
            if (requestUtil.getWorkTypeChangeDto(false) != null) {
                this.mospParams.addErrorMessage("TMW0277", new String[]{DateUtility.getStringDate((Date)dto.getSubstituteDate()), this.getNameSubstituteDay()});
            }
            if ((differenceRequestDto = this.differenceRequestDao.findForKeyOnWorkflow(personalId, substituteDate)) == null) {
                return;
            }
            WorkflowDtoInterface workflowDto3 = this.workflowDao.findForKey(differenceRequestDto.getWorkflow());
            if (!WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto3) && !WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto3)) {
                String[] aryRep = new String[]{this.getStringDate(dto.getSubstituteDate()), this.getNameSubstituteDay()};
                this.mospParams.addErrorMessage("TMW0277", aryRep);
            }
        }
    }

    protected void checkWorkOnHolidayRequest(RequestUtilBeanInterface requestUtil) throws MospException {
        WorkOnHolidayRequestDtoInterface workOnHolidayRequestDto = requestUtil.getWorkOnHolidayDto(true);
        if (workOnHolidayRequestDto == null) {
            return;
        }
        this.addSubstituteDateErrorMessage(workOnHolidayRequestDto.getRequestDate());
    }

    protected void checkAttendance(RequestUtilBeanInterface requestUtil) throws MospException {
        AttendanceDtoInterface attendanceDto = requestUtil.getApplicatedAttendance();
        if (attendanceDto == null) {
            attendanceDto = requestUtil.getFirstRevertedAttendance();
        }
        if (attendanceDto == null) {
            return;
        }
        this.addOthersRequestErrorMessage(attendanceDto.getWorkDate(), this.mospParams.getName("WorkManage"));
    }

    public void checkAttendance(SubstituteDtoInterface dto) throws MospException {
        if (dto == null) {
            return;
        }
        AttendanceDtoInterface attendanceDto = this.attendanceDao.findForKey(dto.getPersonalId(), dto.getSubstituteDate(), 1);
        if (attendanceDto == null) {
            return;
        }
        WorkflowDtoInterface workflowDto = this.workflowDao.findForKey(attendanceDto.getWorkflow());
        if (WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isFirstReverted((WorkflowDtoInterface)workflowDto)) {
            return;
        }
        String[] aryRep = new String[]{this.getStringDate(dto.getSubstituteDate()), this.mospParams.getName("WorkManage"), this.getNameSubstituteDay()};
        this.mospParams.addErrorMessage("TMW0240", aryRep);
    }

    protected void checkHalfRequest(SubstituteDtoInterface dto) throws MospException {
        if (!this.workOnHolidayRefer.useHalfSubstitute()) {
            return;
        }
        String personalId = dto.getPersonalId();
        Date workDate = dto.getWorkDate();
        Date substituteDate = dto.getSubstituteDate();
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBeanInstance(RequestUtilBeanInterface.class);
        requestUtil.setRequests(personalId, workDate);
        List beforeList = requestUtil.getSubstituteList(true);
        if (!MospUtility.isEmpty((Collection)beforeList) && TimeRequestUtility.isHolidayRangeAm((HolidayRangeDtoInterface)dto) || !MospUtility.isEmpty((Collection)beforeList) && TimeRequestUtility.isHolidayRangePm((HolidayRangeDtoInterface)dto)) {
            RequestUtilBeanInterface requestUtil2 = (RequestUtilBeanInterface)this.createBeanInstance(RequestUtilBeanInterface.class);
            Date targetDate = substituteDate;
            if (beforeList.size() == 2) {
                for (SubstituteDtoInterface beforeDto : beforeList) {
                    if (beforeDto.getSubstituteRange() != dto.getSubstituteRange()) continue;
                    targetDate = beforeDto.getWorkDate();
                    requestUtil2.setRequests(personalId, targetDate);
                }
            } else {
                requestUtil2.setRequests(personalId, targetDate);
            }
            RequestEntityInterface entity1 = requestUtil.getRequestEntity(personalId, workDate);
            RequestEntityInterface entity2 = requestUtil2.getRequestEntity(personalId, targetDate);
            String workTypeCode1 = entity1.getWorkType(false);
            String workTypeCode2 = entity2.getWorkType(false);
            WorkTypeChangeRequestDtoInterface workTypeChangeDto1 = requestUtil.getWorkTypeChangeDto(false);
            WorkTypeChangeRequestDtoInterface workTypeChangeDto2 = requestUtil2.getWorkTypeChangeDto(false);
            WorkflowDtoInterface workflowDto1 = null;
            WorkflowDtoInterface workflowDto2 = null;
            if (workTypeChangeDto1 != null) {
                workflowDto1 = this.workflowReference.getLatestWorkflowInfo(workTypeChangeDto1.getWorkflow());
            }
            if (workTypeChangeDto2 != null) {
                workflowDto2 = this.workflowReference.getLatestWorkflowInfo(workTypeChangeDto2.getWorkflow());
            }
            String requestName = this.mospParams.getName("Work", new String[]{"Form", "Change", "Application"});
            if (workflowDto1 != null && WorkflowUtility.isNotApproved((WorkflowDtoInterface)workflowDto1)) {
                this.mospParams.addErrorMessage("TMW0267", new String[]{this.getStringDate(workDate), requestName});
            }
            if (workflowDto2 != null && WorkflowUtility.isNotApproved((WorkflowDtoInterface)workflowDto2)) {
                this.mospParams.addErrorMessage("TMW0267", new String[]{this.getStringDate(substituteDate), requestName});
            }
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            if (!workTypeCode1.equals(workTypeCode2)) {
                this.mospParams.addErrorMessage("TMW0335", new String[]{this.getStringDate(substituteDate)});
                return;
            }
        }
        this.checkWorkTypeInfo(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
    }

    protected void checkWorkTypeInfo(SubstituteDtoInterface dto) throws MospException {
        WorkTypeDtoInterface workTypeDto;
        String personalId = dto.getPersonalId();
        Date targetDate = dto.getSubstituteDate();
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(personalId, targetDate);
        RequestEntityInterface entity = requestUtil.getRequestEntity(personalId, targetDate);
        String workTypeCode = entity.getWorkType(false);
        if ((dto.getSubstituteRange() == 2 || dto.getSubstituteRange() == 3) && (workTypeDto = this.workTypeRefer.findForInfo(workTypeCode, targetDate)) != null) {
            WorkTypeItemDtoInterface frontStart = this.workTypeItemRefer.getWorkTypeItemInfo(workTypeCode, targetDate, "FrontStart");
            WorkTypeItemDtoInterface frontEnd = this.workTypeItemRefer.getWorkTypeItemInfo(workTypeCode, targetDate, "FrontEnd");
            WorkTypeItemDtoInterface backStart = this.workTypeItemRefer.getWorkTypeItemInfo(workTypeCode, targetDate, "BackStart");
            WorkTypeItemDtoInterface backEnd = this.workTypeItemRefer.getWorkTypeItemInfo(workTypeCode, targetDate, "BackEnd");
            String[] rep = new String[]{this.mospParams.getName("Code", new String[]{"SingleColon"}) + workTypeCode, this.mospParams.getName("AmRest", new String[]{"Or", "PmRest"}), this.mospParams.getName("HalfDay", new String[]{"Transfer"})};
            if (frontStart == null || frontEnd == null || backStart == null || backEnd == null) {
                this.mospParams.addErrorMessage("TMW0264", rep);
                return;
            }
            if (DateUtility.getDefaultTime().compareTo(frontStart.getWorkTypeItemValue()) == 0 && DateUtility.getDefaultTime().compareTo(frontEnd.getWorkTypeItemValue()) == 0) {
                this.mospParams.addErrorMessage("TMW0264", rep);
                return;
            }
            if (DateUtility.getDefaultTime().compareTo(backStart.getWorkTypeItemValue()) == 0 && DateUtility.getDefaultTime().compareTo(backEnd.getWorkTypeItemValue()) == 0) {
                this.mospParams.addErrorMessage("TMW0264", rep);
                return;
            }
        }
    }

    protected void checkHolidayDate(SubstituteDtoInterface dto) throws MospException {
        if (dto == null) {
            return;
        }
        if (!TimeUtility.isHoliday((String)dto.getSubstituteType())) {
            TimeMessageUtility.addErrorWorkOnNotHoliday((MospParams)this.mospParams);
        }
        if (this.mospParams.getApplicationPropertyBool("HalfLegalSubstitute")) {
            return;
        }
        if (dto.getSubstituteRange() == 1) {
            return;
        }
        if (TimeUtility.isLegalHoliday((String)dto.getSubstituteType())) {
            TimeMessageUtility.addErrorSubstituteHalfLegalHoliday((MospParams)this.mospParams);
        }
    }

    protected void checkEntered(SubstituteDtoInterface dto) throws MospException {
        if (this.isEntered(dto.getPersonalId(), dto.getSubstituteDate())) {
            return;
        }
        PfMessageUtility.addErrorEmployeeNotJoin((MospParams)this.mospParams);
    }

    public void checkSuspension(SubstituteDtoInterface dto) throws MospException {
        if (dto == null) {
            return;
        }
        if (this.suspensionReference.isSuspended(dto.getPersonalId(), dto.getSubstituteDate())) {
            PfMessageUtility.addErrorEmployeeSuspended((MospParams)this.mospParams);
        }
    }

    public void checkRetirement(SubstituteDtoInterface dto) throws MospException {
        if (dto == null) {
            return;
        }
        if (this.retirementReference.isRetired(dto.getPersonalId(), dto.getSubstituteDate())) {
            PfMessageUtility.addErrorEmployeeRetired((MospParams)this.mospParams);
        }
    }

    public void checkOverTime(SubstituteDtoInterface dto) throws MospException {
        String personalId = dto.getPersonalId();
        Date substituteDate = dto.getSubstituteDate();
        float holidayTimes = 0.0f;
        if (Float.compare(holidayTimes = this.checkHolidayRange(dto, holidayTimes, personalId, substituteDate), 0.5f) == 0) {
            ArrayList<OvertimeRequestDtoInterface> overTimeList = new ArrayList<OvertimeRequestDtoInterface>();
            List overTimeRequestList = this.overtimeRequestDao.findForList(personalId, substituteDate);
            for (OvertimeRequestDtoInterface overTimeDto : overTimeRequestList) {
                WorkflowDtoInterface workflowDto = this.workflowReference.getLatestWorkflowInfo(overTimeDto.getWorkflow());
                if (workflowDto == null || WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) || WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) continue;
                overTimeList.add(overTimeDto);
            }
            if (!overTimeList.isEmpty()) {
                this.addOthersRequestErrorMessage(substituteDate, this.mospParams.getName("OvertimeWork"));
            }
        }
    }

    public float checkHolidayRange(SubstituteDtoInterface dto, float holidayTimes, String personalId, Date substituteDate) throws MospException {
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBean(RequestUtilBeanInterface.class);
        requestUtil.setRequests(personalId, substituteDate);
        int holidayRange = requestUtil.checkHolidayRangeHoliday(requestUtil.getHolidayList(false));
        if (holidayRange == 2 || holidayRange == 3) {
            return holidayTimes + 0.5f;
        }
        int subHolidayRange = requestUtil.checkHolidayRangeSubHoliday(requestUtil.getSubHolidayList(false));
        if (subHolidayRange == 2 || subHolidayRange == 3) {
            return holidayTimes + 0.5f;
        }
        List substituteDtoList = requestUtil.getSubstituteList(false);
        ArrayList<SubstituteDtoInterface> substituteList = new ArrayList<SubstituteDtoInterface>();
        for (SubstituteDtoInterface substituteDto : substituteDtoList) {
            if (dto.getWorkflow() == substituteDto.getWorkflow()) continue;
            substituteList.add(substituteDto);
        }
        int substituteRange = requestUtil.checkHolidayRangeSubstitute(substituteList);
        if (substituteRange == 2 || substituteRange == 3) {
            return holidayTimes + 0.5f;
        }
        return holidayRange;
    }

    public void checkWorkTypeChange(SubstituteDtoInterface dto) throws MospException {
        WorkflowDtoInterface workflowDto;
        WorkTypeChangeRequestDtoInterface workTypeChangeDto;
        String personalId = dto.getPersonalId();
        Date substituteDate = dto.getSubstituteDate();
        float holidayTimes = 0.0f;
        if (Float.compare(holidayTimes = this.checkHolidayRange(dto, holidayTimes, personalId, substituteDate), 0.5f) == 0 && (workTypeChangeDto = this.workTypeChangeReference.findForKeyOnWorkflow(personalId, substituteDate)) != null && (workflowDto = this.workflowReference.getLatestWorkflowInfo(workTypeChangeDto.getWorkflow())) != null && !WorkflowUtility.isDraft((WorkflowDtoInterface)workflowDto) && !WorkflowUtility.isWithDrawn((WorkflowDtoInterface)workflowDto)) {
            this.addOthersRequestErrorMessage(substituteDate, this.mospParams.getName("Work", new String[]{"Form", "Change"}));
        }
    }

    protected void checkTighten(SubstituteDtoInterface dto) throws MospException {
        this.cutoffUtil.checkTighten(dto.getPersonalId(), dto.getSubstituteDate(), this.getNameSubstituteDay());
    }

    protected boolean isLegalDayOff(String workTypeCode) {
        return "legal_holiday".equals(workTypeCode);
    }

    protected boolean isPrescribedDayOff(String workTypeCode) {
        return "prescribed_holiday".equals(workTypeCode);
    }

    protected void addSubstituteDateErrorMessage(Date date) {
        this.mospParams.addErrorMessage("TMW0242", new String[]{DateUtility.getStringDate((Date)date), this.getNameGoingWorkDay(), this.getNameSubstituteDay()});
    }

    protected void addOthersRequestErrorMessage(Date date, String requestTitle) {
        this.mospParams.addErrorMessage("TMW0309", new String[]{this.getStringDate(date), requestTitle});
    }

    protected String getNameGoingWorkDay() {
        return PfNameUtility.goingWorkDay((MospParams)this.mospParams);
    }

    protected String getNameSubstituteDay() {
        return TimeNamingUtility.substituteDay((MospParams)this.mospParams);
    }
}

