/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.SubstituteReferenceBeanInterface;
import jp.mosp.time.dao.settings.SubstituteDaoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.utils.TimeUtility;

public class SubstituteReferenceBean
extends TimeBean
implements SubstituteReferenceBeanInterface {
    protected SubstituteDaoInterface dao;
    protected WorkflowIntegrateBeanInterface workflow;

    public void initBean() throws MospException {
        this.dao = (SubstituteDaoInterface)this.createDaoInstance(SubstituteDaoInterface.class);
        this.workflow = (WorkflowIntegrateBeanInterface)this.createBeanInstance(WorkflowIntegrateBeanInterface.class);
    }

    public SubstituteDtoInterface getSubstituteDto(String personalId, Date workDate) throws MospException {
        List list = this.dao.findForWorkDate(personalId, workDate);
        for (SubstituteDtoInterface dto : list) {
            if (this.workflow.isWithDrawn(dto.getWorkflow())) continue;
            return dto;
        }
        return null;
    }

    public List<SubstituteDtoInterface> getSubstituteList(String personalId, Date substituteDate) throws MospException {
        return this.dao.findForList(personalId, substituteDate);
    }

    public List<SubstituteDtoInterface> getSubstituteList(long workflow) throws MospException {
        return this.dao.findForWorkflow(workflow);
    }

    public List<SubstituteDtoInterface> getSubstituteList(String personalId, Date firstDate, Date lastDate) throws MospException {
        return this.dao.findForTerm(personalId, firstDate, lastDate);
    }

    public Map<String, Set<SubstituteDtoInterface>> getSubstitutes(Collection<String> personalIds, Date substituteDate) throws MospException {
        return PlatformUtility.getPersonalIdMap((Collection)this.dao.findForPersonalIds(personalIds, substituteDate));
    }

    public Map<Date, List<SubstituteDtoInterface>> getSubstitutes(String personalId, Date firstDate, Date lastDate) throws MospException {
        return TimeUtility.getSubstitutesMap((List)this.dao.findForTerm(personalId, firstDate, lastDate));
    }

    public Map<Date, Date> getSubstituteDates(String personalId, Set<Date> workDates) throws MospException {
        if (MospUtility.isEmpty(workDates)) {
            return new TreeMap<Date, Date>();
        }
        return TimeUtility.getSubstitutDates((List)this.dao.findForWorkDates(personalId, workDates));
    }

    public void chkBasicInfo(String personalId, Date targetDate) throws MospException {
        this.initial(personalId, targetDate, "4");
    }

    public Date getSubstituteDate(long workflow) throws MospException {
        List list = this.getSubstituteList(workflow);
        if (list.isEmpty()) {
            return null;
        }
        return ((SubstituteDtoInterface)list.get(0)).getSubstituteDate();
    }
}

