/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.impl.HumanSubordinateBean;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.bean.AttendanceReferenceBeanInterface;
import jp.mosp.time.bean.HolidayDataReferenceBeanInterface;
import jp.mosp.time.bean.HolidayInfoReferenceBeanInterface;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayRemainBeanInterface;
import jp.mosp.time.bean.SubordinateFiscalSearchBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.TotalTimeCalcBeanInterface;
import jp.mosp.time.bean.TotalTimeReferenceBeanInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.HolidayDataDtoInterface;
import jp.mosp.time.dto.settings.SubordinateFiscalListDtoInterface;
import jp.mosp.time.dto.settings.TotalTimeDataDtoInterface;
import jp.mosp.time.dto.settings.impl.HolidayRemainDto;
import jp.mosp.time.dto.settings.impl.SubordinateFiscalListDto;
import jp.mosp.time.utils.TimeUtility;

public class SubordinateFiscalSearchBean
extends HumanSubordinateBean
implements SubordinateFiscalSearchBeanInterface {
    protected TotalTimeCalcBeanInterface totalTimeCalc;
    protected TotalTimeReferenceBeanInterface totalTimeRefer;
    protected HolidayRequestReferenceBeanInterface holidayRequestRefer;
    protected AttendanceReferenceBeanInterface attendanceRefer;
    protected HolidayDataReferenceBeanInterface holidayDataRefer;
    protected HolidayInfoReferenceBeanInterface holidayInfo;
    protected PaidHolidayRemainBeanInterface paidHolidayRemain;
    protected TimeMasterBeanInterface timeMaster;
    protected int displayYear;
    protected int targetYear;
    protected int targetMonth;

    public void initBean() throws MospException {
        super.initBean();
        this.totalTimeCalc = (TotalTimeCalcBeanInterface)this.createBeanInstance(TotalTimeCalcBeanInterface.class);
        this.holidayRequestRefer = (HolidayRequestReferenceBeanInterface)this.createBeanInstance(HolidayRequestReferenceBeanInterface.class);
        this.totalTimeRefer = (TotalTimeReferenceBeanInterface)this.createBeanInstance(TotalTimeReferenceBeanInterface.class);
        this.attendanceRefer = (AttendanceReferenceBeanInterface)this.createBeanInstance(AttendanceReferenceBeanInterface.class);
        this.holidayDataRefer = (HolidayDataReferenceBeanInterface)this.createBeanInstance(HolidayDataReferenceBeanInterface.class);
        this.holidayInfo = (HolidayInfoReferenceBeanInterface)this.createBeanInstance(HolidayInfoReferenceBeanInterface.class);
        this.paidHolidayRemain = (PaidHolidayRemainBeanInterface)this.createBeanInstance(PaidHolidayRemainBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class);
        this.paidHolidayRemain.setTimeMaster(this.timeMaster);
    }

    public List<SubordinateFiscalListDtoInterface> getSubordinateFiscalList() throws MospException {
        return this.subordinateFiscalList(this.getHumanSubordinates(this.humanType, 1));
    }

    protected List<SubordinateFiscalListDtoInterface> subordinateFiscalList(List<HumanDtoInterface> humanList) throws MospException {
        ArrayList<SubordinateFiscalListDtoInterface> subordinateFiscalList = new ArrayList<SubordinateFiscalListDtoInterface>();
        Date firstDate = MonthUtility.getFiscalYearFirstDate((int)this.displayYear, (MospParams)this.mospParams);
        Date lastDate = MonthUtility.getFiscalYearLastDate((int)this.displayYear, (MospParams)this.mospParams);
        Date searchEndDate = DateUtility.getEndTargetDate((Date)firstDate, (Date)lastDate);
        ArrayList errorMessageList = new ArrayList(this.mospParams.getErrorMessageList());
        for (HumanDtoInterface humanDto : humanList) {
            Date applicationTargetDate;
            ApplicationDtoInterface applicationDto = this.timeMaster.getApplication(humanDto, applicationTargetDate = MonthUtility.getYearMonthTermLastDate((int)this.targetYear, (int)this.targetMonth, (MospParams)this.mospParams));
            if (applicationDto == null) continue;
            String personalId = humanDto.getPersonalId();
            SubordinateFiscalListDto dto = new SubordinateFiscalListDto();
            List attendanceList = this.attendanceRefer.getAttendanceList(humanDto.getPersonalId(), firstDate, lastDate);
            Map totalMap = this.totalTimeRefer.findFiscalMap(personalId, firstDate, lastDate);
            if (!attendanceList.isEmpty() || totalMap != null && !totalMap.isEmpty()) {
                this.setOverTime((SubordinateFiscalListDtoInterface)dto, totalMap, personalId, firstDate);
            } else {
                dto.setOverTime(0);
            }
            this.setPaidHoliday((SubordinateFiscalListDtoInterface)dto, personalId, this.displayYear, searchEndDate);
            this.setStockHoliday((SubordinateFiscalListDtoInterface)dto, personalId, this.displayYear, searchEndDate);
            this.setHoliday((SubordinateFiscalListDtoInterface)dto, humanDto, applicationTargetDate, firstDate, lastDate);
            this.setHuman((SubordinateFiscalListDtoInterface)dto, humanDto);
            this.doStoredLogic(new Object[]{"Add_SubordinateFiscalSearchBean_subordinateFiscalList", dto, totalMap});
            subordinateFiscalList.add((SubordinateFiscalListDtoInterface)dto);
        }
        this.mospParams.getErrorMessageList().clear();
        this.mospParams.getErrorMessageList().addAll(errorMessageList);
        return subordinateFiscalList;
    }

    protected void setOverTime(SubordinateFiscalListDtoInterface dto, Map<Integer, TotalTimeDataDtoInterface> totalMap, String personalId, Date firstDate) throws MospException {
        int overTime = 0;
        for (int i = 0; i < 12; ++i) {
            Date targetDate = DateUtility.addMonth((Date)firstDate, (int)i);
            int year = DateUtility.getYear((Date)targetDate);
            int month = DateUtility.getMonth((Date)targetDate);
            TotalTimeDataDtoInterface totalTimeDto = totalMap.get(month);
            if (totalTimeDto == null) {
                totalTimeDto = this.totalTimeCalc.calc(personalId, year, month, false);
                totalMap.put(month, totalTimeDto);
            }
            overTime += totalTimeDto.getOvertime();
        }
        dto.setOverTime(overTime);
    }

    protected void setPaidHoliday(SubordinateFiscalListDtoInterface dto, String personalId, int displayYear, Date targetDate) throws MospException {
        HolidayRemainDto remain = this.paidHolidayRemain.getPaidHolidayRemainForYear(personalId, targetDate, displayYear);
        dto.setPaidHolidayDays(remain.getGivenDays());
        dto.setPaidHolidayTime(remain.getGivenHours());
        dto.setPaidHolidayRestDays(remain.getRemainDays());
        dto.setPaidHolidayRestTime(remain.getRemainHours());
    }

    protected void setStockHoliday(SubordinateFiscalListDtoInterface dto, String personalId, int displayYear, Date targetDate) throws MospException {
        HolidayRemainDto remain = this.paidHolidayRemain.getStockHolidayRemainForYear(personalId, targetDate, displayYear);
        dto.setStockHolidayDays(remain.getGivenDays());
        dto.setStockHolidayRestDays(remain.getRemainDays());
    }

    protected void setHoliday(SubordinateFiscalListDtoInterface dto, HumanDtoInterface humanDto, Date targetDate, Date firstDate, Date lastDate) throws MospException {
        String personalId = humanDto.getPersonalId();
        int hoursPerDay = this.timeMaster.getPaidHolidayHoursPerDay(humanDto, targetDate);
        int minutesPerDay = this.holidayInfo.getMinutesPerDay(personalId, targetDate);
        String holidayCode = this.mospParams.getApplicationProperty("SeasonHolidayCode");
        int holidayType = 2;
        double currentDays = 0.0;
        int currentHours = 0;
        int useMinutes = 0;
        HashSet<Date> acquisitionDates = new HashSet<Date>();
        List list = this.holidayDataRefer.getActiveListForTerm(personalId, firstDate, lastDate, holidayType, holidayCode);
        for (HolidayDataDtoInterface holidayDataDto : list) {
            currentDays += TimeUtility.getCurrentDays((HolidayDataDtoInterface)holidayDataDto);
            currentHours += TimeUtility.getCurrentHours((HolidayDataDtoInterface)holidayDataDto);
            acquisitionDates.add(holidayDataDto.getActivateDate());
            useMinutes += this.holidayInfo.getUseMinutes(holidayDataDto);
        }
        AbstractMap.SimpleEntry uses = this.holidayRequestRefer.getHolidayUses(personalId, firstDate, lastDate, holidayType, holidayCode, acquisitionDates);
        double useDays = (Double)uses.getKey();
        int useHours = (Integer)uses.getValue();
        HolidayRemainDto remain = new HolidayRemainDto();
        remain.setRemainDays(currentDays);
        remain.setRemainHours(currentHours);
        TimeUtility.calcHolidayRemains((HolidayRemainDto)remain, (double)useDays, (int)useHours, (int)useMinutes, (int)hoursPerDay, (int)minutesPerDay);
        dto.setSeasonHolidayDays(currentDays);
        dto.setSeasonHolidayRestDays(remain.getRemainDays());
        dto.setSeasonHolidayRestHours(remain.getRemainHours());
        dto.setSeasonHolidayRestMinutes(remain.getRemainMinutes());
    }

    protected void setHuman(SubordinateFiscalListDtoInterface dto, HumanDtoInterface humanDto) {
        if (humanDto == null) {
            return;
        }
        dto.setPersonalId(humanDto.getPersonalId());
        dto.setEmployeeCode(humanDto.getEmployeeCode());
        dto.setLastName(humanDto.getLastName());
        dto.setFirstName(humanDto.getFirstName());
        dto.setSectionCode(humanDto.getSectionCode());
    }

    public void setDisplayYear(int displayYear) {
        this.displayYear = displayYear;
    }

    public void setTargetYear(int targetYear) {
        this.targetYear = targetYear;
    }

    public void setTargetMonth(int targetMonth) {
        this.targetMonth = targetMonth;
    }
}

