/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.NameUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.platform.utils.WorkflowUtility;
import jp.mosp.time.bean.SubHolidayReferenceBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.dao.settings.AttendanceDaoInterface;
import jp.mosp.time.dao.settings.SubHolidayDaoInterface;
import jp.mosp.time.dao.settings.SubHolidayRequestDaoInterface;
import jp.mosp.time.dto.base.HolidayRangeDtoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.entity.TimeSettingEntityInterface;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeRequestUtility;

public class SubHolidayReferenceBean
extends PlatformBean
implements SubHolidayReferenceBeanInterface {
    protected SubHolidayDaoInterface dao;
    protected SubHolidayRequestDaoInterface subHolidayRequestDao;
    protected AttendanceDaoInterface attendanceDao;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;
    protected TimeMasterBeanInterface timeMaster;

    public void initBean() throws MospException {
        this.dao = (SubHolidayDaoInterface)this.createDaoInstance(SubHolidayDaoInterface.class);
        this.subHolidayRequestDao = (SubHolidayRequestDaoInterface)this.createDaoInstance(SubHolidayRequestDaoInterface.class);
        this.attendanceDao = (AttendanceDaoInterface)this.createDaoInstance(AttendanceDaoInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBeanInstance(WorkflowIntegrateBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class);
    }

    public String[][] getSelectArray(String personalId, Date targetDate, String holidayRange, SubHolidayRequestDtoInterface dto) throws MospException {
        float appliDays = TimeRequestUtility.getDays((int)MospUtility.getInt((Object)holidayRange));
        List subHolidayList = this.getFindForList(personalId, targetDate, targetDate, (double)appliDays);
        ArrayList<SubHolidayDtoInterface> list = new ArrayList<SubHolidayDtoInterface>();
        ArrayList<String> holidayRangeList = new ArrayList<String>();
        for (SubHolidayDtoInterface subHolidayDto : subHolidayList) {
            float count = 0.0f;
            List subHolidayRequestList = this.subHolidayRequestDao.findForList(personalId, subHolidayDto.getWorkDate(), subHolidayDto.getTimesWork(), subHolidayDto.getSubHolidayType());
            for (SubHolidayRequestDtoInterface subHolidayRequestDto : subHolidayRequestList) {
                WorkflowDtoInterface subHolidayRequestWorkflowDto = this.workflowIntegrate.getLatestWorkflowInfo(subHolidayRequestDto.getWorkflow());
                if (!WorkflowUtility.isApplied((WorkflowDtoInterface)subHolidayRequestWorkflowDto) || dto != null && subHolidayRequestDto.getTmdSubHolidayRequestId() == dto.getTmdSubHolidayRequestId()) continue;
                count += TimeRequestUtility.getDays((HolidayRangeDtoInterface)subHolidayRequestDto);
            }
            double notUseDay = subHolidayDto.getSubHolidayDays() - (double)count;
            if (notUseDay < (double)appliDays) continue;
            list.add(subHolidayDto);
            if (notUseDay >= 1.0) {
                holidayRangeList.add(TimeNamingUtility.holidayRangeAllWithCornerParentheses((MospParams)this.mospParams));
                continue;
            }
            if (notUseDay >= 0.5) {
                holidayRangeList.add(TimeNamingUtility.holidayHalfWithCornerParentheses((MospParams)this.mospParams));
                continue;
            }
            return this.getNoObjectDataPulldown();
        }
        if (list.size() != holidayRangeList.size()) {
            return this.getNoObjectDataPulldown();
        }
        String[][] array = this.prepareSelectArray(list.size(), false);
        int i = 0;
        for (SubHolidayDtoInterface subHolidayDto : list) {
            array[i][0] = this.getStringDate(subHolidayDto.getWorkDate()) + "," + subHolidayDto.getSubHolidayType();
            StringBuilder sb = new StringBuilder();
            String typeAbbr = TimeRequestUtility.getSubHolidayTypeAbbr((int)subHolidayDto.getSubHolidayType(), (MospParams)this.mospParams);
            sb.append(NameUtility.cornerParentheses((MospParams)this.mospParams, (String)typeAbbr));
            sb.append(this.getStringDate(subHolidayDto.getWorkDate()));
            sb.append((String)holidayRangeList.get(i));
            array[i][1] = sb.toString();
            ++i;
        }
        return array;
    }

    public List<SubHolidayDtoInterface> getFindForList(String personalId, Date startDate, Date endDate, double subHolidayDays) throws MospException {
        TimeSettingEntityInterface timeSetting = this.timeMaster.getTimeSettingForPersonalId(personalId, startDate);
        Date subHolidayStartDate = DateUtility.addMonthAndDay((Date)startDate, (int)(-timeSetting.getSubHolidayLimitMonth()), (int)(-timeSetting.getSubHolidayLimitDay()));
        List list = this.getSubHolidayList(personalId, subHolidayStartDate, endDate, subHolidayDays);
        ArrayList<SubHolidayDtoInterface> list2 = new ArrayList<SubHolidayDtoInterface>();
        for (SubHolidayDtoInterface subHolidayDto : list) {
            TimeSettingEntityInterface timeSettingEntity = this.timeMaster.getTimeSettingForPersonalId(personalId, subHolidayDto.getWorkDate());
            Date subHolidayLimitDate = timeSettingEntity.getSubHolidayLimitDate(subHolidayDto);
            if (subHolidayLimitDate.compareTo(startDate) < 0) continue;
            list2.add(subHolidayDto);
        }
        ArrayList<SubHolidayDtoInterface> list3 = new ArrayList<SubHolidayDtoInterface>();
        for (SubHolidayDtoInterface subHolidayDto : list2) {
            double count = 0.0;
            List subHolidayRequestList = this.subHolidayRequestDao.findForList(personalId, subHolidayDto.getWorkDate(), subHolidayDto.getTimesWork(), subHolidayDto.getSubHolidayType());
            for (SubHolidayRequestDtoInterface subHolidayRequestDto : subHolidayRequestList) {
                WorkflowDtoInterface subHolidayRequestWorkflowDto = this.workflowIntegrate.getLatestWorkflowInfo(subHolidayRequestDto.getWorkflow());
                if (!WorkflowUtility.isApplied((WorkflowDtoInterface)subHolidayRequestWorkflowDto)) continue;
                count += (double)TimeRequestUtility.getDays((HolidayRangeDtoInterface)subHolidayRequestDto);
            }
            double notUseDay = subHolidayDto.getSubHolidayDays() - count;
            if (notUseDay <= 0.0) continue;
            list3.add(subHolidayDto);
        }
        return list3;
    }

    public List<SubHolidayDtoInterface> getSubHolidayList(String personalId, Date startDate, Date endDate, double subHolidayDays) throws MospException {
        ArrayList<SubHolidayDtoInterface> list = new ArrayList<SubHolidayDtoInterface>();
        for (SubHolidayDtoInterface dto : this.dao.getSubHolidayList(personalId, startDate, endDate, subHolidayDays)) {
            if (!this.isAttendanceCompleted(dto.getPersonalId(), dto.getWorkDate(), dto.getTimesWork())) continue;
            list.add(dto);
        }
        return list;
    }

    public Map<String, Map<Integer, List<SubHolidayDtoInterface>>> getSubHolidays(Collection<String> personalIds, Date workDate) throws MospException {
        TreeMap<String, Map<Integer, List<SubHolidayDtoInterface>>> map = new TreeMap<String, Map<Integer, List<SubHolidayDtoInterface>>>();
        List list = this.dao.findForPersonalIds(personalIds, workDate);
        Map subHolidays = PlatformUtility.getPersonalIdMap((Collection)list);
        for (Map.Entry entry : subHolidays.entrySet()) {
            String personalId = (String)entry.getKey();
            Set dtos = (Set)entry.getValue();
            map.put(personalId, this.getSubHolidayMap((Collection)dtos));
        }
        return map;
    }

    public Map<Integer, List<SubHolidayDtoInterface>> getSubHolidays(String personalId, Date firstDate, Date lastDate) throws MospException {
        List dtos = this.dao.findSubHolidayList(personalId, firstDate, lastDate);
        return this.getSubHolidayMap((Collection)dtos);
    }

    protected Map<Integer, List<SubHolidayDtoInterface>> getSubHolidayMap(Collection<SubHolidayDtoInterface> dtos) throws MospException {
        TreeMap<Integer, List<SubHolidayDtoInterface>> subHolidayMap = new TreeMap<Integer, List<SubHolidayDtoInterface>>();
        for (SubHolidayDtoInterface dto : dtos) {
            List value = MospUtility.getListValue(subHolidayMap, (Object)dto.getSubHolidayType());
            value.add(dto);
        }
        return subHolidayMap;
    }

    public Float[] getBirthSubHolidayTimes(String personalId, Date startDate, Date endDate) throws MospException {
        Float[] days = new Float[]{null, null, null};
        double prescribed = 0.0;
        double legal = 0.0;
        double midnight = 0.0;
        List list = this.dao.findSubHolidayList(personalId, startDate, endDate);
        for (SubHolidayDtoInterface dto : list) {
            if (!this.isAttendanceCompleted(personalId, dto.getWorkDate(), dto.getTimesWork())) continue;
            if (dto.getSubHolidayType() == 1) {
                prescribed += dto.getSubHolidayDays();
                continue;
            }
            if (dto.getSubHolidayType() == 2) {
                legal += dto.getSubHolidayDays();
                continue;
            }
            if (dto.getSubHolidayType() != 3) continue;
            midnight += dto.getSubHolidayDays();
        }
        days[0] = Float.valueOf((float)prescribed);
        days[1] = Float.valueOf((float)legal);
        days[2] = Float.valueOf((float)midnight);
        return days;
    }

    protected boolean isAttendanceCompleted(String personalId, Date targetDate, int timesWork) throws MospException {
        AttendanceDtoInterface attendanceDto = this.attendanceDao.findForKey(personalId, targetDate, timesWork);
        if (MospUtility.isEmpty((Object[])new Object[]{attendanceDto})) {
            return false;
        }
        return this.workflowIntegrate.isCompleted(attendanceDto.getWorkflow());
    }
}

