/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.time.bean.SubHolidayReferenceBeanInterface;
import jp.mosp.time.bean.impl.TimeBaseExportBean;
import jp.mosp.time.dao.settings.SubHolidayRequestDaoInterface;
import jp.mosp.time.dto.base.HolidayRangeDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayDtoInterface;
import jp.mosp.time.dto.settings.SubHolidayRequestDtoInterface;
import jp.mosp.time.utils.TimeRequestUtility;

public class SubHolidayExportBean
extends TimeBaseExportBean {
    protected SubHolidayRequestDaoInterface subHolidayRequestDao;
    protected SubHolidayReferenceBeanInterface subHolidayReference;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;

    public void initBean() throws MospException {
        super.initBean();
        this.subHolidayRequestDao = (SubHolidayRequestDaoInterface)this.createDaoInstance(SubHolidayRequestDaoInterface.class);
        this.subHolidayReference = (SubHolidayReferenceBeanInterface)this.createBeanInstance(SubHolidayReferenceBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBeanInstance(WorkflowIntegrateBeanInterface.class);
    }

    protected List<String[]> makeCsvDataList(List<String> fieldList, Date firstDate, Date lastDate, String cutoffCode, String workPlaceCode, String employmentContractCode, String sectionCode, boolean needLowerSection, String positionCode) throws MospException {
        ArrayList<String[]> csvDataList = new ArrayList<String[]>();
        List humanList = this.getHumanList(lastDate, cutoffCode, workPlaceCode, employmentContractCode, sectionCode, needLowerSection, positionCode);
        for (HumanDtoInterface humanDto : humanList) {
            List dtos = this.subHolidayReference.getSubHolidayList(humanDto.getPersonalId(), firstDate, lastDate, 0.5);
            for (SubHolidayDtoInterface dto : dtos) {
                csvDataList.add(this.makeCsvData(dto, humanDto, fieldList, lastDate));
            }
        }
        return csvDataList;
    }

    protected String[] makeCsvData(SubHolidayDtoInterface dto, HumanDtoInterface humanDto, List<String> fieldList, Date targetDate) throws MospException {
        String[] csvData = this.getHumanCsvData(fieldList, humanDto, targetDate);
        Date workDate = dto.getWorkDate();
        int subHolidayType = dto.getSubHolidayType();
        Date[] requestDates = this.getRequestDateArray(dto.getPersonalId(), workDate, dto.getTimesWork(), subHolidayType);
        String csvWorkDate = DateUtility.getStringDate((Date)workDate);
        String csvSubHolidayType = this.getCsvSubholidayType(subHolidayType, dto.getSubHolidayDays());
        String csvRequestDate1 = DateUtility.getStringDate((Date)requestDates[0]);
        String csvRequestDate2 = DateUtility.getStringDate((Date)requestDates[1]);
        this.setCsvValue(csvData, fieldList, "work_date", (Object)csvWorkDate);
        this.setCsvValue(csvData, fieldList, "sub_holiday_type", (Object)csvSubHolidayType);
        this.setCsvValue(csvData, fieldList, "request_date1", (Object)csvRequestDate1);
        this.setCsvValue(csvData, fieldList, "request_date2", (Object)csvRequestDate2);
        return csvData;
    }

    protected String getCsvSubholidayType(int subHolidayType, double subHolidayDays) {
        StringBuilder sb = new StringBuilder();
        sb.append(TimeRequestUtility.getSubHolidayTypeAbbr((int)subHolidayType, (MospParams)this.mospParams));
        String subHolidayDaysAbbr = TimeRequestUtility.getSubHolidayDaysAbbr((double)subHolidayDays, (MospParams)this.mospParams);
        return sb.append(PfNameUtility.parentheses((MospParams)this.mospParams, (String)subHolidayDaysAbbr)).toString();
    }

    protected Date[] getRequestDateArray(String personalId, Date workDate, int timesWork, int subHolidayType) throws MospException {
        Date[] requestDateArray = new Date[2];
        List subHolidayRequestList = this.subHolidayRequestDao.findForList(personalId, workDate, timesWork, subHolidayType);
        for (SubHolidayRequestDtoInterface subHolidayRequestDto : subHolidayRequestList) {
            if (!this.workflowIntegrate.isCompleted(subHolidayRequestDto.getWorkflow())) continue;
            if (TimeRequestUtility.isHolidayRangeAll((HolidayRangeDtoInterface)subHolidayRequestDto)) {
                requestDateArray[0] = subHolidayRequestDto.getRequestDate();
                requestDateArray[1] = subHolidayRequestDto.getRequestDate();
            }
            if (!TimeRequestUtility.isHolidayRangeHalf((HolidayRangeDtoInterface)subHolidayRequestDto)) continue;
            if (requestDateArray[0] == null) {
                requestDateArray[0] = subHolidayRequestDto.getRequestDate();
                continue;
            }
            requestDateArray[1] = subHolidayRequestDto.getRequestDate();
        }
        return requestDateArray;
    }
}

