/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Date;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.utils.InputCheckUtility;
import jp.mosp.time.bean.StockHolidayDataRegistBeanInterface;
import jp.mosp.time.dao.settings.StockHolidayDataDaoInterface;
import jp.mosp.time.dto.settings.StockHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdStockHolidayDto;
import jp.mosp.time.utils.TimeInputCheckUtility;

public class StockHolidayDataRegistBean
extends PlatformBean
implements StockHolidayDataRegistBeanInterface {
    protected StockHolidayDataDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (StockHolidayDataDaoInterface)this.createDaoInstance(StockHolidayDataDaoInterface.class);
    }

    public StockHolidayDataDtoInterface getInitDto() {
        return new TmdStockHolidayDto();
    }

    public void insert(StockHolidayDataDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        StockHolidayDataDtoInterface stockHolidayDataDto = this.dao.findForKey(dto.getPersonalId(), dto.getActivateDate(), dto.getAcquisitionDate());
        if (stockHolidayDataDto != null) {
            this.validate(stockHolidayDataDto);
            this.checkUpdate(stockHolidayDataDto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, stockHolidayDataDto.getTmdStockHolidayId());
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdStockHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(StockHolidayDataDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdStockHolidayId());
        dto.setTmdStockHolidayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void regist(StockHolidayDataDtoInterface dto, Integer row) throws MospException {
        this.validate(dto, row);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        String personalId = dto.getPersonalId();
        Date activateDate = dto.getActivateDate();
        Date acquisitionDate = dto.getAcquisitionDate();
        StockHolidayDataDtoInterface registeredDto = this.dao.findForKey(personalId, activateDate, acquisitionDate);
        if (MospUtility.isEmpty((Object[])new Object[]{registeredDto})) {
            this.insert(dto);
            return;
        }
        this.update(dto);
    }

    public void delete(StockHolidayDataDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdStockHolidayId());
    }

    protected void checkInsert(StockHolidayDataDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKey(dto.getPersonalId(), dto.getActivateDate(), dto.getAcquisitionDate()));
    }

    protected void checkUpdate(StockHolidayDataDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdStockHolidayId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getTmdStockHolidayId(), true))) {
            return;
        }
    }

    protected void checkDelete(StockHolidayDataDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdStockHolidayId());
    }

    protected void validate(StockHolidayDataDtoInterface dto, Integer row) {
        String codeKey = "import_tmd_stock_holiday";
        String employeeCodeName = this.getCodeName("employee_code", codeKey);
        String activateDateName = this.getCodeName("activate_date", codeKey);
        String acquisitionDateName = this.getCodeName("acquisition_date", codeKey);
        String limitDateName = this.getCodeName("limit_date", codeKey);
        String holdDayName = this.getCodeName("hold_day", codeKey);
        InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)dto.getPersonalId(), (String)employeeCodeName);
        InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)dto.getActivateDate(), (String)activateDateName);
        InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)dto.getAcquisitionDate(), (String)acquisitionDateName);
        InputCheckUtility.checkRequired((MospParams)this.mospParams, (Object)dto.getAcquisitionDate(), (String)limitDateName);
        InputCheckUtility.checDecimal((MospParams)this.mospParams, (double)dto.getHoldDay(), (int)2, (int)1, (String)holdDayName, (Integer)row);
        TimeInputCheckUtility.checHolidayTimes((MospParams)this.mospParams, (double)dto.getHoldDay(), (String)holdDayName, (Integer)row);
    }

    protected void validate(StockHolidayDataDtoInterface dto) {
        this.validate(dto, null);
    }
}

