/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.PaidHolidayRemainBeanInterface;
import jp.mosp.time.bean.StockHolidayDataGrantBeanInterface;
import jp.mosp.time.bean.StockHolidayDataReferenceBeanInterface;
import jp.mosp.time.bean.StockHolidayDataRegistBeanInterface;
import jp.mosp.time.bean.StockHolidayReferenceBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.dto.settings.PaidHolidayDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.StockHolidayDtoInterface;
import jp.mosp.time.dto.settings.impl.HolidayRemainDto;

public class StockHolidayDataGrantBean
extends PlatformBean
implements StockHolidayDataGrantBeanInterface {
    protected StockHolidayReferenceBeanInterface stockHolidayRefer;
    protected StockHolidayDataReferenceBeanInterface stockHolidayDataRefer;
    protected StockHolidayDataRegistBeanInterface stockHolidayDataRegist;
    protected PaidHolidayRemainBeanInterface paidHolidayRemain;
    protected TimeMasterBeanInterface timeMaster;

    public void initBean() throws MospException {
        this.stockHolidayRefer = (StockHolidayReferenceBeanInterface)this.createBeanInstance(StockHolidayReferenceBeanInterface.class);
        this.stockHolidayDataRefer = (StockHolidayDataReferenceBeanInterface)this.createBeanInstance(StockHolidayDataReferenceBeanInterface.class);
        this.stockHolidayDataRegist = (StockHolidayDataRegistBeanInterface)this.createBeanInstance(StockHolidayDataRegistBeanInterface.class);
        this.paidHolidayRemain = (PaidHolidayRemainBeanInterface)this.createBeanInstance(PaidHolidayRemainBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class);
        this.paidHolidayRemain.setTimeMaster(this.timeMaster);
    }

    public void grant(String personalId, Date targetDate) throws MospException {
        this.grant(personalId, targetDate, true);
    }

    public void grant(String personalId, Date targetDate, boolean isUpdate) throws MospException {
        this.grant(this.create(personalId, targetDate, isUpdate));
    }

    protected void grant(StockHolidayDataDtoInterface dto) throws MospException {
        if (dto == null) {
            return;
        }
        StockHolidayDataDtoInterface stockHolidayDataDto = this.stockHolidayDataRefer.findForKey(dto.getPersonalId(), dto.getActivateDate(), dto.getAcquisitionDate());
        if (stockHolidayDataDto != null) {
            this.stockHolidayDataRegist.delete(stockHolidayDataDto);
        }
        this.stockHolidayDataRegist.insert(dto);
    }

    protected StockHolidayDataDtoInterface create(String personalId, Date targetDate, boolean isUpdate) throws MospException {
        PaidHolidayDtoInterface paidHolidayDto = this.timeMaster.getPaidHolidayForPersonalId(personalId, targetDate).orElse(null);
        if (MospUtility.isEmpty((Object[])new Object[]{paidHolidayDto})) {
            return null;
        }
        StockHolidayDtoInterface stockHolidayDto = this.stockHolidayRefer.findForKey(paidHolidayDto.getPaidHolidayCode(), paidHolidayDto.getActivateDate());
        if (MospUtility.isEmpty((Object[])new Object[]{stockHolidayDto})) {
            return null;
        }
        HolidayRemainDto remain = this.paidHolidayRemain.getPaidHolidayRemainForStock(personalId, targetDate).orElse(null);
        if (MospUtility.isEmpty((Object[])new Object[]{remain})) {
            return null;
        }
        Date grantDate = this.getGrantDate(remain.getHolidayLimitDate());
        if (!isUpdate && this.stockHolidayDataRefer.findForKey(personalId, grantDate, grantDate) != null) {
            return null;
        }
        StockHolidayDataDtoInterface dto = this.stockHolidayDataRegist.getInitDto();
        dto.setPersonalId(personalId);
        dto.setAcquisitionDate(grantDate);
        dto.setActivateDate(grantDate);
        dto.setLimitDate(this.getExpirationDate(stockHolidayDto, grantDate));
        dto.setHoldDay(this.getGrantDays(stockHolidayDto, personalId, remain));
        dto.setGivingDay(0.0);
        dto.setCancelDay(0.0);
        dto.setUseDay(0.0);
        return dto;
    }

    protected Date getGrantDate(Date paidHolidayExpirationDate) {
        return this.addDay(paidHolidayExpirationDate, 1);
    }

    protected Date getExpirationDate(StockHolidayDtoInterface dto, Date grantDate) {
        return this.addDay(DateUtility.addMonth((Date)grantDate, (int)dto.getStockLimitDate()), -1);
    }

    protected double getGrantDays(StockHolidayDtoInterface dto, String personalId, HolidayRemainDto remain) throws MospException {
        Date paidHolidayLimitDate = remain.getHolidayLimitDate();
        double remainDays = this.paidHolidayRemain.getStockHolidayRemainDaysForList(personalId, paidHolidayLimitDate);
        double grantDays = remain.getRemainDays();
        if (grantDays > (double)dto.getStockYearAmount()) {
            grantDays = dto.getStockYearAmount();
        }
        if (remainDays >= (double)dto.getStockTotalAmount()) {
            return 0.0;
        }
        if (remainDays + grantDays > (double)dto.getStockTotalAmount()) {
            return (double)dto.getStockTotalAmount() - remainDays;
        }
        return grantDays;
    }
}

