/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.time.bean.RequestUtilBeanInterface;
import jp.mosp.time.bean.ScheduleReferenceBeanInterface;
import jp.mosp.time.bean.ScheduleRegistBeanInterface;
import jp.mosp.time.bean.ScheduleUtilAddonBeanInterface;
import jp.mosp.time.bean.ScheduleUtilBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.bean.impl.ScheduleReferenceBean;
import jp.mosp.time.bean.impl.ScheduleUtilBaseBean;
import jp.mosp.time.dao.settings.ScheduleDateDaoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDateDtoInterface;
import jp.mosp.time.dto.settings.ScheduleDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeUtility;

public class ScheduleUtilBean
extends ScheduleUtilBaseBean
implements ScheduleUtilBeanInterface {
    protected ScheduleDateDaoInterface scheduleDateDao;
    protected ScheduleReferenceBeanInterface scheduleReference;
    protected ScheduleRegistBeanInterface scheduleRegist;
    protected Map<String, Map<Date, ScheduleDateDtoInterface>> scheduleMap;
    protected List<ScheduleUtilAddonBeanInterface> addonBeans;
    protected static final String CODE_KEY_ADDONS = "ScheduleUtilBeanAddons";

    public void initBean() throws MospException {
        super.initBean();
        this.scheduleDateDao = (ScheduleDateDaoInterface)this.createDaoInstance(ScheduleDateDaoInterface.class);
        this.scheduleReference = (ScheduleReferenceBeanInterface)this.createBeanInstance(ScheduleReferenceBean.class);
        this.scheduleRegist = (ScheduleRegistBeanInterface)this.createBeanInstance(ScheduleRegistBeanInterface.class);
        this.scheduleMap = new HashMap();
    }

    public ScheduleDtoInterface getSchedule(String personalId, Date targetDate) throws MospException {
        String scheduleCode = this.getScheduleCode(personalId, targetDate, true);
        ScheduleDtoInterface scheduleDto = this.getAddonScheduleDto(scheduleCode, targetDate);
        if (this.isNormalSchedule(personalId, targetDate)) {
            scheduleDto = this.scheduleReference.getScheduleInfo(scheduleCode, targetDate);
        }
        if (scheduleDto == null) {
            TimeMessageUtility.addErrorScheduleDefect((MospParams)this.mospParams, (Date)targetDate);
            return null;
        }
        for (ScheduleUtilAddonBeanInterface addonBean : this.getAddonBeans()) {
            scheduleDto = addonBean.getSchedule(scheduleDto, personalId, targetDate);
            if (!this.mospParams.hasErrorMessage()) continue;
            return null;
        }
        return scheduleDto;
    }

    public ScheduleDateDtoInterface getScheduleDate(String personalId, Date targetDate) throws MospException {
        return this.getScheduleDate(personalId, targetDate, true);
    }

    public ScheduleDateDtoInterface getScheduleDateNoMessage(String personalId, Date targetDate) throws MospException {
        return this.getScheduleDate(personalId, targetDate, false);
    }

    public Map<Date, ScheduleDateDtoInterface> getScheduleDates(String personalId, Date startDate, Date endDate) throws MospException {
        TreeMap<Date, ScheduleDateDtoInterface> scheduleDates = new TreeMap<Date, ScheduleDateDtoInterface>();
        if (this.isNormalSchedule(personalId, endDate)) {
            scheduleDates.putAll(this.getScheduleDatesNormal(personalId, startDate, endDate));
        }
        for (ScheduleUtilAddonBeanInterface addonBean : this.getAddonBeans()) {
            scheduleDates.putAll(addonBean.getScheduleDates(scheduleDates, personalId, startDate, endDate));
        }
        return scheduleDates;
    }

    public String getScheduledWorkTypeCode(String personalId, Date targetDate) throws MospException {
        return this.getWorkTypeCode(personalId, targetDate, true);
    }

    public String getScheduledWorkTypeCodeNoMessage(String personalId, Date targetDate) throws MospException {
        return this.getWorkTypeCode(personalId, targetDate, false);
    }

    public Map<Date, String> getScheduledWorkTypeCodes(String personalId, Date startDate, Date endDate) throws MospException {
        HashMap<Date, String> scheduleMap = new HashMap<Date, String>();
        this.getScheduleDates(personalId, startDate, endDate);
        for (Date targetDate : TimeUtility.getDateList((Date)startDate, (Date)endDate)) {
            scheduleMap.put(targetDate, this.getWorkTypeCode(personalId, targetDate, false));
        }
        return scheduleMap;
    }

    public String getScheduledWorkTypeCode(String personalId, Date targetDate, RequestUtilBeanInterface requestUtil) throws MospException {
        String workTypeCode = "";
        if (this.isNormalSchedule(personalId, targetDate)) {
            workTypeCode = this.getScheduledWorkTypeCodeNormal(personalId, targetDate, requestUtil);
        }
        for (ScheduleUtilAddonBeanInterface addonBean : this.getAddonBeans()) {
            workTypeCode = addonBean.getScheduledWorkTypeCode(workTypeCode, personalId, targetDate, requestUtil);
            if (!this.mospParams.hasErrorMessage()) continue;
            return "";
        }
        return workTypeCode;
    }

    public String getScheduledWorkTypeCode(String personalId, Date targetDate, boolean useRequest) throws MospException {
        if (!useRequest) {
            return this.getWorkTypeCode(personalId, targetDate, true);
        }
        RequestUtilBeanInterface requestUtil = (RequestUtilBeanInterface)this.createBeanInstance(RequestUtilBeanInterface.class);
        requestUtil.setRequests(personalId, targetDate);
        return this.getScheduledWorkTypeCode(personalId, targetDate, requestUtil);
    }

    public Map<Date, ScheduleDateDtoInterface> getSubstitutedSchedules(String personalId, Map<Date, Date> substituteDates) throws MospException {
        TreeMap<Date, ScheduleDateDtoInterface> substitutedSchedules = new TreeMap<Date, ScheduleDateDtoInterface>();
        for (Map.Entry<Date, Date> entry : substituteDates.entrySet()) {
            Date workDate = entry.getKey();
            Date substituteDate = entry.getValue();
            substitutedSchedules.put(workDate, this.getScheduleDateNoMessage(personalId, substituteDate));
        }
        return substitutedSchedules;
    }

    public String getScheduleName(String scheduleCode, Date targetDate) throws MospException {
        String name = this.scheduleReference.getScheduleName(scheduleCode, targetDate);
        for (ScheduleUtilAddonBeanInterface addonBean : this.getAddonBeans()) {
            name = addonBean.getScheduleName(name, scheduleCode, targetDate);
            if (!this.mospParams.hasErrorMessage()) continue;
            return scheduleCode;
        }
        return name;
    }

    public String getScheduleAbbr(String scheduleCode, Date targetDate) throws MospException {
        String abbr = this.scheduleReference.getScheduleAbbr(scheduleCode, targetDate);
        for (ScheduleUtilAddonBeanInterface addonBean : this.getAddonBeans()) {
            abbr = addonBean.getScheduleAbbr(abbr, scheduleCode, targetDate);
            if (!this.mospParams.hasErrorMessage()) continue;
            return scheduleCode;
        }
        return abbr;
    }

    public String[][] getCodedSelectArray(Date targetDate, boolean needBlank) throws MospException {
        String[][] selecrArrray = this.scheduleReference.getCodedSelectArray(targetDate, needBlank);
        for (ScheduleUtilAddonBeanInterface addonBean : this.getAddonBeans()) {
            selecrArrray = addonBean.getCodedSelectArray(selecrArrray, targetDate, needBlank);
            if (!this.mospParams.hasErrorMessage()) continue;
            return new String[0][];
        }
        return selecrArrray;
    }

    public String[][] getSelectArray(Date targetDate, boolean needBlank) throws MospException {
        String[][] selecrArrray = this.scheduleReference.getSelectArray(targetDate, needBlank);
        for (ScheduleUtilAddonBeanInterface addonBean : this.getAddonBeans()) {
            selecrArrray = addonBean.getSelectArray(selecrArrray, targetDate, needBlank);
            if (!this.mospParams.hasErrorMessage()) continue;
            return new String[0][];
        }
        return selecrArrray;
    }

    protected String getScheduledWorkTypeCodeNormal(String personalId, Date targetDate, RequestUtilBeanInterface requestUtil) throws MospException {
        DifferenceRequestDtoInterface difference = requestUtil.getDifferenceDto(true);
        WorkTypeChangeRequestDtoInterface workTypeChange = requestUtil.getWorkTypeChangeDto(true);
        WorkOnHolidayRequestDtoInterface workOnHoliday = requestUtil.getWorkOnHolidayDto(true);
        List substitutes = requestUtil.getSubstituteList(true);
        String workTypeCode = this.getRequestedWorkTypeCode(difference, workTypeChange, workOnHoliday, substitutes);
        if (!MospUtility.isEmpty((String[])new String[]{workTypeCode})) {
            return workTypeCode;
        }
        Date schedlueTargetDate = this.getScheduleTargetDate(targetDate, workOnHoliday);
        return this.getScheduledWorkTypeCodeNormal(personalId, schedlueTargetDate, false);
    }

    protected ScheduleDateDtoInterface getScheduleDate(String personalId, Date targetDate, boolean isErrorMessageNeeded) throws MospException {
        ScheduleDateDtoInterface dto = null;
        if (this.isNormalSchedule(personalId, targetDate)) {
            dto = this.getScheduleDateNormal(personalId, targetDate, isErrorMessageNeeded);
        }
        for (ScheduleUtilAddonBeanInterface addonBean : this.getAddonBeans()) {
            dto = addonBean.getScheduleDate(dto, personalId, targetDate, isErrorMessageNeeded);
        }
        return dto;
    }

    protected ScheduleDateDtoInterface getScheduleDateNormal(String personalId, Date targetDate, boolean isErrorMessageNeeded) throws MospException {
        String scheduleCode = this.getScheduleCode(personalId, targetDate, isErrorMessageNeeded);
        ScheduleDateDtoInterface dto = this.getStoredScheduleDate(scheduleCode, targetDate);
        if (dto != null) {
            return dto;
        }
        dto = this.scheduleDateDao.findForKey(scheduleCode, targetDate);
        if (dto == null && isErrorMessageNeeded) {
            TimeMessageUtility.addErrorScheduleDefect((MospParams)this.mospParams, (Date)targetDate);
        }
        this.putScheduleDate(dto);
        return dto;
    }

    protected Map<Date, ScheduleDateDtoInterface> getScheduleDatesNormal(String personalId, Date startDate, Date endDate) throws MospException {
        TreeMap<Date, ScheduleDateDtoInterface> scheduleDates = new TreeMap<Date, ScheduleDateDtoInterface>();
        Map applications = this.timeMaster.getApplicationMap(personalId, startDate, endDate);
        for (Date targetDate : TimeUtility.getDateList((Date)startDate, (Date)endDate)) {
            ApplicationDtoInterface application = (ApplicationDtoInterface)applications.get(targetDate);
            if (application == null) continue;
            String scheduleCode = application.getScheduleCode();
            ScheduleDateDtoInterface scheduleDate = this.getStoredScheduleDate(scheduleCode, targetDate);
            if (scheduleDate != null) {
                scheduleDates.put(scheduleDate.getScheduleDate(), scheduleDate);
                continue;
            }
            this.putScheduleDates(scheduleCode, startDate, endDate);
            scheduleDate = this.getStoredScheduleDate(scheduleCode, targetDate);
            if (scheduleDate == null) continue;
            scheduleDates.put(scheduleDate.getScheduleDate(), scheduleDate);
        }
        return scheduleDates;
    }

    protected ScheduleDateDtoInterface getStoredScheduleDate(String scheduleCode, Date targetDate) {
        Map map = (Map)this.scheduleMap.get(scheduleCode);
        if (map == null) {
            return null;
        }
        return (ScheduleDateDtoInterface)map.get(targetDate);
    }

    protected void putScheduleDates(String scheduleCode, Date startDate, Date endDate) throws MospException {
        List list = this.scheduleDateDao.findForList(scheduleCode, startDate, endDate);
        for (ScheduleDateDtoInterface dto : list) {
            this.putScheduleDate(dto);
        }
    }

    protected void putScheduleDate(ScheduleDateDtoInterface dto) {
        if (dto == null) {
            return;
        }
        String scheduleCode = dto.getScheduleCode();
        Date scheduleDate = dto.getScheduleDate();
        TreeMap<Date, ScheduleDateDtoInterface> map = (TreeMap<Date, ScheduleDateDtoInterface>)this.scheduleMap.get(scheduleCode);
        if (map == null) {
            map = new TreeMap<Date, ScheduleDateDtoInterface>();
            this.scheduleMap.put(scheduleCode, map);
        }
        map.put(scheduleDate, dto);
    }

    protected String getWorkTypeCode(String personalId, Date targetDate, boolean isErrorMessageNeeded) throws MospException {
        String workTypeCode = "";
        if (this.isNormalSchedule(personalId, targetDate)) {
            workTypeCode = this.getScheduledWorkTypeCodeNormal(personalId, targetDate, isErrorMessageNeeded);
        }
        for (ScheduleUtilAddonBeanInterface addonBean : this.getAddonBeans()) {
            workTypeCode = addonBean.getScheduledWorkTypeCode(workTypeCode, personalId, targetDate, isErrorMessageNeeded);
        }
        return workTypeCode;
    }

    protected String getScheduledWorkTypeCodeNormal(String personalId, Date targetDate, boolean isErrorMessageNeeded) throws MospException {
        ScheduleDateDtoInterface dto = this.getScheduleDateNormal(personalId, targetDate, isErrorMessageNeeded);
        if (dto == null) {
            return "";
        }
        return dto.getWorkTypeCode();
    }

    protected boolean isNormalSchedule(String personalId, Date targetDate) throws MospException {
        String scheduleCode = this.getScheduleCode(personalId, targetDate, false);
        return MospUtility.isEmpty((String[])new String[]{scheduleCode}) || !scheduleCode.startsWith("@");
    }

    protected ScheduleDtoInterface getAddonScheduleDto(String scheduleCode, Date targetDate) throws MospException {
        int targetYear = MonthUtility.getFiscalYear((Date)targetDate, (MospParams)this.mospParams);
        Date targetYearDate = MonthUtility.getYearDate((int)targetYear, (MospParams)this.mospParams);
        ScheduleDtoInterface scheduleDto = this.scheduleRegist.getInitDto();
        scheduleDto.setScheduleCode(scheduleCode);
        scheduleDto.setActivateDate(targetYearDate);
        scheduleDto.setScheduleName("");
        scheduleDto.setScheduleAbbr("");
        scheduleDto.setFiscalYear(targetYear);
        scheduleDto.setPatternCode("");
        scheduleDto.setWorkTypeChangeFlag(0);
        return scheduleDto;
    }

    protected List<ScheduleUtilAddonBeanInterface> getAddonBeans() throws MospException {
        if (this.addonBeans != null) {
            return this.addonBeans;
        }
        ArrayList<ScheduleUtilAddonBeanInterface> addonBeans = new ArrayList<ScheduleUtilAddonBeanInterface>();
        for (String[] addon : this.mospParams.getProperties().getCodeArray(CODE_KEY_ADDONS, false)) {
            String modelClass = addon[0];
            if (MospUtility.isEmpty((String[])new String[]{modelClass})) continue;
            ScheduleUtilAddonBeanInterface addonBean = (ScheduleUtilAddonBeanInterface)this.createBean(ScheduleUtilAddonBeanInterface.class, modelClass);
            addonBean.setTimeMaster(this.timeMaster);
            addonBeans.add(addonBean);
        }
        this.addonBeans = addonBeans;
        return addonBeans;
    }

    public void setTimeMaster(TimeMasterBeanInterface timeMaster) {
        this.timeMaster = timeMaster;
    }
}

