/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.time.bean.SubstituteReferenceBeanInterface;
import jp.mosp.time.bean.TimeMasterBeanInterface;
import jp.mosp.time.dto.base.HolidayRangeDtoInterface;
import jp.mosp.time.dto.settings.ApplicationDtoInterface;
import jp.mosp.time.dto.settings.DifferenceRequestDtoInterface;
import jp.mosp.time.dto.settings.SubstituteDtoInterface;
import jp.mosp.time.dto.settings.WorkOnHolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.WorkTypeChangeRequestDtoInterface;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeRequestUtility;

public abstract class ScheduleUtilBaseBean
extends PlatformBean {
    protected SubstituteReferenceBeanInterface substituteRefer;
    protected TimeMasterBeanInterface timeMaster;

    public void initBean() throws MospException {
        this.substituteRefer = (SubstituteReferenceBeanInterface)this.createBeanInstance(SubstituteReferenceBeanInterface.class);
        this.timeMaster = (TimeMasterBeanInterface)this.createBeanInstance(TimeMasterBeanInterface.class);
    }

    protected String getScheduleCode(String personalId, Date targetDate, boolean isErrorMessageNeeded) throws MospException {
        ApplicationDtoInterface dto = this.getApplicationDto(personalId, targetDate, isErrorMessageNeeded);
        if (dto == null) {
            return "";
        }
        return dto.getScheduleCode();
    }

    protected ApplicationDtoInterface getApplicationDto(String personalId, Date targetDate, boolean isErrorMessageNeeded) throws MospException {
        ApplicationDtoInterface dto = this.timeMaster.getApplication(personalId, targetDate);
        if (dto == null && isErrorMessageNeeded) {
            TimeMessageUtility.addErrorApplicationDefect((MospParams)this.mospParams, (Date)targetDate);
        }
        return dto;
    }

    protected String getRequestedWorkTypeCode(DifferenceRequestDtoInterface difference, WorkTypeChangeRequestDtoInterface workTypeChange, WorkOnHolidayRequestDtoInterface workOnHoliday, List<SubstituteDtoInterface> substitutes) {
        if (difference != null) {
            return difference.getDifferenceType();
        }
        if (workTypeChange != null) {
            return workTypeChange.getWorkTypeCode();
        }
        if (workOnHoliday != null) {
            int substitute = workOnHoliday.getSubstitute();
            if (substitute == 5) {
                return workOnHoliday.getWorkTypeCode();
            }
            if (substitute == 2) {
                String workOnHolidayType = workOnHoliday.getWorkOnHolidayType();
                if (MospUtility.isEqual((Object)workOnHolidayType, (Object)"legal_holiday")) {
                    return "work_on_legal";
                }
                if (MospUtility.isEqual((Object)workOnHolidayType, (Object)"prescribed_holiday")) {
                    return "work_on_prescribed";
                }
            }
        }
        if (workOnHoliday == null) {
            for (SubstituteDtoInterface substitute : substitutes) {
                if (!TimeRequestUtility.isHolidayRangeAll((HolidayRangeDtoInterface)substitute)) continue;
                return substitute.getSubstituteType();
            }
        }
        return "";
    }

    protected Date getScheduleTargetDate(Date workDate, WorkOnHolidayRequestDtoInterface workOnHoliday) throws MospException {
        if (workOnHoliday == null) {
            return workDate;
        }
        int substitute = workOnHoliday.getSubstitute();
        if (substitute != 1 && substitute != 3 && substitute != 4) {
            return workDate;
        }
        List substitutes = this.substituteRefer.getSubstituteList(workOnHoliday.getWorkflow());
        if (substitutes.isEmpty()) {
            return workDate;
        }
        return ((SubstituteDtoInterface)MospUtility.getFirstValue((Collection)substitutes)).getSubstituteDate();
    }
}

