/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.time.base.TimeBean;
import jp.mosp.time.bean.RestRegistBeanInterface;
import jp.mosp.time.dao.settings.RestDaoInterface;
import jp.mosp.time.dto.settings.AttendanceDtoInterface;
import jp.mosp.time.dto.settings.RestDtoInterface;
import jp.mosp.time.dto.settings.TimeSettingDtoInterface;
import jp.mosp.time.dto.settings.impl.TmdRestDto;
import jp.mosp.time.entity.TimeDuration;
import jp.mosp.time.utils.TimeUtility;

public class RestRegistBean
extends TimeBean
implements RestRegistBeanInterface {
    public static final int MAX_REST_TIMES = 6;
    protected RestDaoInterface dao;

    public void initBean() throws MospException {
        this.dao = (RestDaoInterface)this.createDaoInstance(RestDaoInterface.class);
    }

    public RestDtoInterface getInitDto() {
        return new TmdRestDto();
    }

    public void regist(RestDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getPersonalId(), dto.getWorkDate(), dto.getTimesWork(), dto.getRest()) == null) {
            this.insert(dto);
        } else {
            this.update(dto);
        }
    }

    public void insert(RestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setTmdRestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(RestDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdRestId());
        dto.setTmdRestId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(String personalId, Date workDate, int timesWork) throws MospException {
        List list = this.dao.findForList(personalId, workDate, timesWork);
        for (RestDtoInterface dto : list) {
            this.checkDelete((RestDtoInterface)this.dao.findForKey(dto.getTmdRestId(), true));
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdRestId());
        }
    }

    public void delete(String personalId, Date workDate, int timesWork, int rest) throws MospException {
        RestDtoInterface dto = this.dao.findForKey(personalId, workDate, timesWork, rest);
        this.checkDelete((RestDtoInterface)this.dao.findForKey(dto.getTmdRestId(), true));
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getTmdRestId());
    }

    protected void checkInsert(RestDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getPersonalId(), dto.getWorkDate(), dto.getRest(), dto.getRestStart(), dto.getRestEnd()));
    }

    protected void checkUpdate(RestDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdRestId());
    }

    protected void checkDelete(RestDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getTmdRestId());
    }

    protected void validate(RestDtoInterface dto) {
    }

    public int getCalcRestTime(Date restStartTime, Date restEndTime, TimeSettingDtoInterface timeSettingDto) {
        if (restStartTime == null || restEndTime == null || timeSettingDto == null) {
            return 0;
        }
        Date roundRestStartTime = TimeUtility.getRoundMinute((Date)restStartTime, (int)timeSettingDto.getRoundDailyRestStart(), (int)timeSettingDto.getRoundDailyRestStartUnit());
        Date roundRestEndTime = TimeUtility.getRoundMinute((Date)restEndTime, (int)timeSettingDto.getRoundDailyRestEnd(), (int)timeSettingDto.getRoundDailyRestEndUnit());
        return TimeUtility.getRoundMinute((int)TimeUtility.getDifferenceMinutes((Date)roundRestStartTime, (Date)roundRestEndTime), (int)timeSettingDto.getRoundDailyRestTime(), (int)timeSettingDto.getRoundDailyRestTimeUnit());
    }

    public void setRestStartEndTime(Date restStartTime, Date restEndTime, AttendanceDtoInterface attendanceDto, RestDtoInterface restDto) throws MospException {
        if (this.doAdditionalLogic(new Object[]{"Add_RestRegistBean_SetRestStartEndTime", restStartTime, restEndTime, attendanceDto, restDto})) {
            return;
        }
        if (restStartTime != null && restEndTime != null) {
            if (attendanceDto.getStartTime() != null && attendanceDto.getStartTime().after(restStartTime)) {
                restStartTime = attendanceDto.getStartTime();
            }
            if (attendanceDto.getEndTime() != null && attendanceDto.getEndTime().before(restEndTime)) {
                restEndTime = attendanceDto.getEndTime();
            }
            if (restEndTime.before(restStartTime)) {
                restEndTime = restStartTime;
            }
            if (!restStartTime.equals(restEndTime)) {
                restDto.setRestStart(restStartTime);
                restDto.setRestEnd(restEndTime);
            }
        }
    }

    public void registRests(String personalId, Date workDate, Map<Integer, TimeDuration> rests, TimeSettingDtoInterface timeSetting) throws MospException {
        List currentDtos = this.dao.findForList(personalId, workDate, 1);
        for (int i = 0; i < 6; ++i) {
            int rest = i + 1;
            TimeDuration duration = this.getDuration(rests, rest);
            RestDtoInterface currentDto = this.getRest((Collection)currentDtos, rest);
            if (currentDto == null) {
                this.insertRest(personalId, workDate, rest, duration, timeSetting);
                continue;
            }
            if (!this.isUpdateNeeded(currentDto, duration, timeSetting)) continue;
            this.setRestDuration(currentDto, duration, timeSetting);
            this.update(currentDto);
        }
    }

    protected void insertRest(String personalId, Date workDate, int rest, TimeDuration duration, TimeSettingDtoInterface timeSetting) throws MospException {
        RestDtoInterface dto = this.getInitDto();
        dto.setPersonalId(personalId);
        dto.setWorkDate(workDate);
        dto.setTimesWork(1);
        dto.setRest(rest);
        this.setRestDuration(dto, duration, timeSetting);
        this.insert(dto);
    }

    protected boolean isUpdateNeeded(RestDtoInterface dto, TimeDuration duration, TimeSettingDtoInterface timeSetting) {
        Date workDate = dto.getWorkDate();
        RestDtoInterface newDto = this.getInitDto();
        newDto.setWorkDate(workDate);
        this.setRestDuration(newDto, duration, timeSetting);
        if (!DateUtility.isSame((Date)dto.getRestStart(), (Date)newDto.getRestStart())) {
            return true;
        }
        if (!DateUtility.isSame((Date)dto.getRestEnd(), (Date)newDto.getRestEnd())) {
            return true;
        }
        return dto.getRestTime() != newDto.getRestTime();
    }

    protected void setRestDuration(RestDtoInterface dto, TimeDuration duration, TimeSettingDtoInterface timeSetting) {
        Date workDate = dto.getWorkDate();
        Date restStart = DateUtility.addMinute((Date)workDate, (int)duration.getStartTime());
        Date restEnd = DateUtility.addMinute((Date)workDate, (int)duration.getEndTime());
        int restTime = this.getCalcRestTime(restStart, restEnd, timeSetting);
        dto.setRestStart(restStart);
        dto.setRestEnd(restEnd);
        dto.setRestTime(restTime);
    }

    protected TimeDuration getDuration(Map<Integer, TimeDuration> rests, int rest) {
        if (rests.size() < rest) {
            return TimeDuration.getInvalid();
        }
        return new ArrayList<TimeDuration>(rests.values()).get(rest - 1);
    }

    protected RestDtoInterface getRest(Collection<RestDtoInterface> dtos, int rest) {
        for (RestDtoInterface dto : dtos) {
            if (dto.getRest() != rest) continue;
            return dto;
        }
        return null;
    }
}

