/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.NameUtility;
import jp.mosp.orangesignal.OrangeSignalUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.comparator.base.EmployeeCodeComparator;
import jp.mosp.platform.utils.MonthUtility;
import jp.mosp.platform.utils.PfNameUtility;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.time.bean.PaidHolidayUsageBeanInterface;
import jp.mosp.time.bean.PaidHolidayUsageExportBeanInterface;
import jp.mosp.time.comparator.report.PaidHolidayUsageComparator;
import jp.mosp.time.dto.settings.impl.PaidHolidayUsageDto;
import jp.mosp.time.utils.TimeNamingUtility;
import jp.mosp.time.utils.TimeUtility;

public class PaidHolidayUsageExportBean
extends PlatformBean
implements PaidHolidayUsageExportBeanInterface {
    protected static final String NAM_EXPORT_FILE = "paidHolidayUsage.csv";
    protected PaidHolidayUsageBeanInterface paidHolidayUsage;

    public void initBean() throws MospException {
        this.paidHolidayUsage = (PaidHolidayUsageBeanInterface)this.createBeanInstance(PaidHolidayUsageBeanInterface.class);
    }

    public void export(String[] personalIds, int year, int month) throws MospException {
        Date targetDate = MonthUtility.getYearMonthLastDate((int)year, (int)month);
        this.export(personalIds, targetDate);
    }

    public void export(String[] personalIds, Date targetDate) throws MospException {
        ArrayList paidHolidayUsages = new ArrayList();
        for (String personalId : personalIds) {
            paidHolidayUsages.addAll(this.paidHolidayUsage.makePaidHolidayUsages(personalId, targetDate));
        }
        Collections.sort(paidHolidayUsages, new EmployeeCodeComparator());
        Collections.sort(paidHolidayUsages, new PaidHolidayUsageComparator());
        List csvs = this.makeCsvs(paidHolidayUsages);
        this.mospParams.setFile((Object)OrangeSignalUtility.getOrangeSignalParams((List)csvs));
        this.mospParams.setFileName(PlatformUtility.getExportFileName((MospParams)this.mospParams, (String)NAM_EXPORT_FILE, (Date)targetDate, (boolean)true));
    }

    protected List<String[]> makeCsvs(List<PaidHolidayUsageDto> paidHolidayUsages) {
        ArrayList<String[]> csvs = new ArrayList<String[]>();
        csvs.add(this.makeCsvHeader());
        for (PaidHolidayUsageDto paidHolidayUsage : paidHolidayUsages) {
            csvs.add(this.makeCsv(paidHolidayUsage));
        }
        return csvs;
    }

    protected String getUsageTermString(PaidHolidayUsageDto paidHolidayUsage) {
        StringBuilder sb = new StringBuilder();
        sb.append(DateUtility.getStringDate((Date)paidHolidayUsage.getUsageFromDate()));
        sb.append(NameUtility.wave((MospParams)this.mospParams));
        sb.append(DateUtility.getStringDate((Date)paidHolidayUsage.getUsageToDate()));
        return sb.toString();
    }

    protected String getUseDatesString(PaidHolidayUsageDto paidHolidayUsage) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : paidHolidayUsage.getUseDates().entrySet()) {
            sb.append(this.getStringDate((Date)entry.getKey()));
            sb.append(" ");
            sb.append(TimeUtility.getHolidayRangeAbbr((MospParams)this.mospParams, (int)((Integer)entry.getValue())));
            sb.append(",");
        }
        MospUtility.deleteLastChar((StringBuilder)sb);
        return sb.toString();
    }

    protected String[] makeCsv(PaidHolidayUsageDto paidHolidayUsage) {
        String[] csv = new String[]{paidHolidayUsage.getEmployeeCode(), MospUtility.getHumansName((String)paidHolidayUsage.getFirstName(), (String)paidHolidayUsage.getLastName()), paidHolidayUsage.getSectionName(), this.getUsageTermString(paidHolidayUsage), String.valueOf(paidHolidayUsage.getShortDay()), DateUtility.getStringDate((Date)paidHolidayUsage.getAcquisitionDate()), String.valueOf(paidHolidayUsage.getGivingDay()), String.valueOf(paidHolidayUsage.getUseDay()), this.getUseDatesString(paidHolidayUsage), paidHolidayUsage.getRemark()};
        return csv;
    }

    protected String[] makeCsvHeader() {
        String[] header = new String[]{PfNameUtility.employeeCode((MospParams)this.mospParams), PfNameUtility.fullName((MospParams)this.mospParams), PfNameUtility.sectionName((MospParams)this.mospParams), PfNameUtility.targetTerm((MospParams)this.mospParams), TimeNamingUtility.paidHolidayUsageShortTotal((MospParams)this.mospParams), TimeNamingUtility.acquisitionDate((MospParams)this.mospParams), TimeNamingUtility.givingDays((MospParams)this.mospParams), TimeNamingUtility.appliedDays((MospParams)this.mospParams), TimeNamingUtility.applicationDate((MospParams)this.mospParams), PfNameUtility.remarks((MospParams)this.mospParams)};
        return header;
    }
}

