/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.time.bean.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.PlatformMasterBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.PlatformUtility;
import jp.mosp.time.bean.HolidayRequestReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayDataReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayTransactionReferenceBeanInterface;
import jp.mosp.time.bean.PaidHolidayUsageBeanInterface;
import jp.mosp.time.comparator.settings.PaidHolidayDataAcquisitionDateComparator;
import jp.mosp.time.dto.base.HolidayRangeDtoInterface;
import jp.mosp.time.dto.settings.HolidayRequestDtoInterface;
import jp.mosp.time.dto.settings.PaidHolidayDataDtoInterface;
import jp.mosp.time.dto.settings.impl.PaidHolidayUsageDto;
import jp.mosp.time.utils.TimeMessageUtility;
import jp.mosp.time.utils.TimeRequestUtility;
import jp.mosp.time.utils.TimeUtility;

public class PaidHolidayUsageBean
extends PlatformBean
implements PaidHolidayUsageBeanInterface {
    protected static final String APP_PAID_HOLIDAY_USE_DAY = "PaidHolidayUseDay";
    protected PlatformMasterBeanInterface master;
    protected PaidHolidayDataReferenceBeanInterface paidHolidayRefer;
    protected HolidayRequestReferenceBeanInterface requestRefer;
    protected PaidHolidayTransactionReferenceBeanInterface paidHolidayTransactionRefer;
    protected Map<String, Set<PaidHolidayDataDtoInterface>> paidHolidayMap;

    public void initBean() throws MospException {
        this.master = (PlatformMasterBeanInterface)this.createBeanInstance(PlatformMasterBeanInterface.class);
        this.paidHolidayRefer = (PaidHolidayDataReferenceBeanInterface)this.createBeanInstance(PaidHolidayDataReferenceBeanInterface.class);
        this.requestRefer = (HolidayRequestReferenceBeanInterface)this.createBeanInstance(HolidayRequestReferenceBeanInterface.class);
        this.paidHolidayTransactionRefer = (PaidHolidayTransactionReferenceBeanInterface)this.createBeanInstance(PaidHolidayTransactionReferenceBeanInterface.class);
    }

    public Collection<PaidHolidayUsageDto> makePaidHolidayUsages(String personalId, Date targetDate) throws MospException {
        LinkedHashSet<PaidHolidayUsageDto> paidHolidayUsages = new LinkedHashSet<PaidHolidayUsageDto>();
        HumanDtoInterface humanDto = this.master.getHuman(personalId, targetDate);
        Collection paidHolidays = this.getPaidHolidays(personalId, targetDate);
        if (humanDto == null || MospUtility.isEmpty((Collection)paidHolidays)) {
            return Collections.emptySet();
        }
        Date usageFromDate = this.getUsageFromDate(paidHolidays, targetDate);
        Date usageToDate = this.getUsageToDate(paidHolidays, targetDate);
        for (PaidHolidayDataDtoInterface paidHoliday : paidHolidays) {
            paidHolidayUsages.add(this.makePaidHolidayUsage(humanDto, usageFromDate, usageToDate, paidHoliday));
        }
        String sectionName = this.master.getSectionName(humanDto.getSectionCode(), targetDate);
        float shortDay = this.getShortDay(paidHolidayUsages);
        String remark = this.getRemark(paidHolidayUsages);
        for (PaidHolidayUsageDto dto : paidHolidayUsages) {
            dto.setSectionName(sectionName);
            dto.setShortDay(shortDay);
            dto.setRemark(remark);
        }
        return paidHolidayUsages;
    }

    protected Collection<PaidHolidayDataDtoInterface> getPaidHolidays(String personalId, Date targetDate) throws MospException {
        this.setPaidHolidays(targetDate);
        Set paidHolidayAll = (Set)this.paidHolidayMap.get(personalId);
        if (paidHolidayAll == null) {
            return Collections.emptySet();
        }
        Date usageFromDate = this.getUsageFromDate((Collection)paidHolidayAll, targetDate);
        Date usageToDate = this.getUsageToDate((Collection)paidHolidayAll, targetDate);
        TreeMap<Date, PaidHolidayDataDtoInterface> paidHolidays = new TreeMap<Date, PaidHolidayDataDtoInterface>();
        for (PaidHolidayDataDtoInterface paidHoliday : paidHolidayAll) {
            Date limitDate;
            Date acquisitionDate = paidHoliday.getAcquisitionDate();
            if (!DateUtility.isOnTheTerm((Date)usageFromDate, (Date)usageToDate, (Date)acquisitionDate, (Date)(limitDate = paidHoliday.getLimitDate()))) continue;
            paidHolidays.put(acquisitionDate, paidHoliday);
        }
        return paidHolidays.values();
    }

    protected void setPaidHolidays(Date targetDate) throws MospException {
        if (this.paidHolidayMap != null) {
            return;
        }
        Date startDate = DateUtility.getDefaultTime();
        Date endDate = DateUtility.addYearAndDay((Date)targetDate, (int)1, (int)-1);
        List list = this.paidHolidayRefer.getPaidHolidayDataForTerm(startDate, endDate);
        this.paidHolidayMap = PlatformUtility.getPersonalIdMap((Collection)list);
    }

    protected Date getUsageFromDate(Collection<PaidHolidayDataDtoInterface> paidHolidays, Date targetDate) throws MospException {
        ArrayList<PaidHolidayDataDtoInterface> list = new ArrayList<PaidHolidayDataDtoInterface>(paidHolidays);
        Collections.sort(list, Collections.reverseOrder(new PaidHolidayDataAcquisitionDateComparator()));
        for (PaidHolidayDataDtoInterface dto : list) {
            if (dto.getAcquisitionDate().after(targetDate)) continue;
            return dto.getAcquisitionDate();
        }
        return DateUtility.getDefaultTime();
    }

    protected Date getUsageToDate(Collection<PaidHolidayDataDtoInterface> paidHolidays, Date targetDate) throws MospException {
        return DateUtility.addDay((Date)DateUtility.addYear((Date)this.getUsageFromDate(paidHolidays, targetDate), (int)1), (int)-1);
    }

    protected PaidHolidayUsageDto makePaidHolidayUsage(HumanDtoInterface humanDto, Date usageFromDate, Date usageToDate, PaidHolidayDataDtoInterface paidHoliday) throws MospException {
        PaidHolidayUsageDto dto = new PaidHolidayUsageDto();
        String personalId = humanDto.getPersonalId();
        Date acquisitionDate = paidHoliday.getAcquisitionDate();
        dto.setPersonalId(personalId);
        dto.setEmployeeCode(humanDto.getEmployeeCode());
        dto.setLastName(humanDto.getLastName());
        dto.setFirstName(humanDto.getFirstName());
        dto.setSectionCode(humanDto.getSectionCode());
        dto.setUsageFromDate(usageFromDate);
        dto.setUsageToDate(usageToDate);
        dto.setAcquisitionDate(acquisitionDate);
        double transactionDays = this.getTransactionDays(personalId, acquisitionDate, usageToDate);
        dto.setGivingDay(paidHoliday.getHoldDay() + transactionDays);
        Map useDates = this.getUseDates(personalId, acquisitionDate, usageFromDate, usageToDate);
        dto.setUseDates(useDates);
        dto.setUseDay(this.getUseDay(useDates));
        return dto;
    }

    protected double getTransactionDays(String personalId, Date acquisitionDate, Date targetDate) throws MospException {
        List dtos = this.paidHolidayTransactionRefer.findForList(personalId, acquisitionDate, DateUtility.getDefaultTime(), targetDate);
        return TimeUtility.getPaidHolidayManualDays((Collection)dtos);
    }

    protected Map<Date, Integer> getUseDates(String personalId, Date acquisitionDate, Date usageFromDate, Date usageToDate) throws MospException {
        TreeMap<Date, Integer> useDates = new TreeMap<Date, Integer>();
        List requests = this.requestRefer.getAppliedPaidHolidayRequests(personalId, acquisitionDate, usageFromDate, usageToDate);
        for (HolidayRequestDtoInterface request : requests) {
            Date requestDate = request.getRequestStartDate();
            if (TimeRequestUtility.isHolidayRangeHour((HolidayRangeDtoInterface)request)) continue;
            if (useDates.get(requestDate) != null) {
                useDates.put(requestDate, 1);
                continue;
            }
            useDates.put(requestDate, request.getHolidayRange());
        }
        return useDates;
    }

    protected float getUseDay(Map<Date, Integer> useDates) {
        float useDay = 0.0f;
        for (int holidayRange : useDates.values()) {
            useDay += TimeUtility.getHolidayTimes((int)holidayRange);
        }
        return useDay;
    }

    protected float getShortDay(Set<PaidHolidayUsageDto> paidHolidayUsages) {
        float shortDay = this.mospParams.getApplicationProperty(APP_PAID_HOLIDAY_USE_DAY, 0);
        for (PaidHolidayUsageDto dto : paidHolidayUsages) {
            shortDay -= dto.getUseDay();
        }
        return shortDay < 0.0f ? 0.0f : shortDay;
    }

    protected String getRemark(Set<PaidHolidayUsageDto> paidHolidayUsages) {
        Date lastAcquisitionDate = ((PaidHolidayUsageDto)MospUtility.getLastValue(paidHolidayUsages)).getAcquisitionDate();
        Date doubleTrackStartDate = DateUtility.addYear((Date)lastAcquisitionDate, (int)-1);
        for (PaidHolidayUsageDto dto : paidHolidayUsages) {
            Date acquisitionDate = dto.getAcquisitionDate();
            if (DateUtility.isSame((Date)acquisitionDate, (Date)lastAcquisitionDate) || !acquisitionDate.after(doubleTrackStartDate)) continue;
            return TimeMessageUtility.getPaidHolidaySplit((MospParams)this.mospParams);
        }
        return "";
    }
}

